# Steganossaurus.py

A jurassic python library for steganography techniques.

![Library logo](./docs/logo.png)

## Steganography?

Steganography is the process of hiding a message inside another one, making the hidden message visually undetectable from within shown message. It's not actually a form of cryptography, as it changes the form of the message instead the content.

There are several types of steganography techniques and they differ on the form of the "plain" message. Mainly, we have text, image, videos or audios but you can be creative with other forms of communication.

`Steganossaurus.py` currently focuses on a type of image steganography, specifically encoding text messages within the least significant bits (LSBs) of image files.

## Usage

The library has 2 main functions, encoding and decoding the message. 

### Encode

To encode the message you'll need the message (of course) written in a plain text file and an input image. The image needs to be large enough to contain the whole message written in LSBs. The general rule is: `message_length = width * height * 3` where the `message_length` is eight times the number of characters on the text file.

### Decode

To decode the message you'll just need the output image generated on the encoding phase. You can even use a image that has been generated by another program.