# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['steganossaurus']

package_data = \
{'': ['*']}

install_requires = \
['black>=20.8b1,<21.0',
 'click>=7.1.2,<8.0.0',
 'imageio>=2.9.0,<3.0.0',
 'matplotlib>=3.3.1,<4.0.0',
 'numpy>=1.19.1,<2.0.0',
 'scipy>=1.5.2,<2.0.0']

entry_points = \
{'console_scripts': ['steganossaurus = steganossaurus.__main__:cli']}

setup_kwargs = {
    'name': 'steganossaurus',
    'version': '0.2.0',
    'description': 'A jurassic python library for steganography',
    'long_description': '# Steganossaurus.py\n\nA jurassic python library for steganography techniques.\n\n![Library logo](./docs/logo.png)\n\n## Steganography?\n\nSteganography is the process of hiding a message inside another one, making the hidden message visually undetectable from within shown message. It\'s not actually a form of cryptography, as it changes the form of the message instead the content.\n\nThere are several types of steganography techniques and they differ on the form of the "plain" message. Mainly, we have text, image, videos or audios but you can be creative with other forms of communication.\n\n`Steganossaurus.py` currently focuses on a type of image steganography, specifically encoding text messages within the least significant bits (LSBs) of image files.\n\n## Usage\n\nThe library has 2 main functions, encoding and decoding the message. \n\n### Encode\n\nTo encode the message you\'ll need the message (of course) written in a plain text file and an input image. The image needs to be large enough to contain the whole message written in LSBs. The general rule is: `message_length = width * height * 3` where the `message_length` is eight times the number of characters on the text file.\n\n### Decode\n\nTo decode the message you\'ll just need the output image generated on the encoding phase. You can even use a image that has been generated by another program.',
    'author': 'Joao Vitor Maia',
    'author_email': 'maia.tostring@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/leviosar/steganossaurus',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
