import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataExternalConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of strings, whose first element is the program to run and whose subsequent elements are optional command line arguments to the program.
     *
     * Terraform does not execute the program through a shell, so it is not necessary to escape shell metacharacters nor add quotes around arguments containing spaces.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/external/d/external.html#program DataExternal#program}
     *
     * @stability stable
     */
    readonly program: string[];
    /**
     * A map of string values to pass to the external program as the query arguments.
     *
     * If not supplied, the program will receive an empty object as its input.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/external/d/external.html#query DataExternal#query}
     *
     * @stability stable
     */
    readonly query?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Working directory of the program. If not supplied, the program will run in the current directory.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/external/d/external.html#working_dir DataExternal#working_dir}
     *
     * @stability stable
     */
    readonly workingDir?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/external/d/external.html external}.
 *
 * @stability stable
 */
export declare class DataExternal extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/external/d/external.html external} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataExternalConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _program?;
    /**
     * @stability stable
     */
    get program(): string[];
    /**
     * @stability stable
     */
    set program(value: string[]);
    /**
     * @stability stable
     */
    get programInput(): string[] | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set query(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetQuery(): void;
    /**
     * @stability stable
     */
    get queryInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    result(key: string): string;
    private _workingDir?;
    /**
     * @stability stable
     */
    get workingDir(): string | undefined;
    /**
     * @stability stable
     */
    set workingDir(value: string | undefined);
    /**
     * @stability stable
     */
    resetWorkingDir(): void;
    /**
     * @stability stable
     */
    get workingDirInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
