"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const k3s = require("./");
const core_1 = require("@aws-cdk/core");
const ec2 = require("@aws-cdk/aws-ec2");
class IntegTesting {
    constructor() {
        const app = new core_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new core_1.Stack(app, 'testing-stack', { env });
        const vpc = k3s.VpcProvider.getOrCreate(stack);
        const cluster = new k3s.Cluster(stack, 'Cluster', {
            vpc,
            spotWorkerNodes: true,
            workerMinCapacity: 3,
            workerInstanceType: new ec2.InstanceType('m6g.medium'),
            controlPlaneInstanceType: new ec2.InstanceType('m6g.medium'),
        });
        new core_1.CfnOutput(stack, 'EndpointURI', { value: cluster.endpointUri });
        this.stack = [stack];
    }
    ;
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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