# Generated by Django 3.2.9 on 2021-12-02 01:08

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_oci.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Blob',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_date', models.DateTimeField(auto_now_add=True, verbose_name='date added')),
                ('modify_date', models.DateTimeField(auto_now=True, verbose_name='date modified')),
                ('content_type', models.CharField(max_length=250)),
                ('digest', models.CharField(blank=True, max_length=250, null=True)),
                ('datafile', models.FileField(max_length=255, storage=django_oci.models.OverwriteStorage(), upload_to=django_oci.models.get_upload_folder)),
                ('remotefile', models.CharField(blank=True, max_length=500, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ChunkedUpload',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('session_id', models.CharField(max_length=255)),
                ('file', models.FileField(max_length=255, upload_to='images/sessions')),
                ('offset', models.BigIntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='Image',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_date', models.DateTimeField(auto_now=True, verbose_name='date manifest added')),
                ('manifest', models.BinaryField(default=b'{}')),
                ('version', models.CharField(blank=True, max_length=250, null=True)),
                ('blobs', models.ManyToManyField(to='django_oci.Blob')),
            ],
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250)),
                ('image', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_oci.image')),
            ],
        ),
        migrations.CreateModel(
            name='Repository',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500, unique=True)),
                ('add_date', models.DateTimeField(auto_now_add=True, verbose_name='date added')),
                ('modify_date', models.DateTimeField(auto_now=True, verbose_name='date modified')),
                ('private', models.BooleanField(choices=[(False, 'Public (The collection will be accessible by anyone)'), (True, 'Private (The collection will be not listed.)')], default=django_oci.models.get_privacy_default, verbose_name='Accessibility')),
                ('contributors', models.ManyToManyField(blank=True, help_text='users with edit permission to the collection', related_name='container_collection_contributors', related_query_name='contributor', to=settings.AUTH_USER_MODEL, verbose_name='Contributors')),
                ('owners', models.ManyToManyField(blank=True, default=None, related_name='container_collection_owners', related_query_name='owners', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='image',
            name='repository',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_oci.repository'),
        ),
        migrations.AddField(
            model_name='blob',
            name='repository',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_oci.repository'),
        ),
        migrations.AlterUniqueTogether(
            name='image',
            unique_together={('repository', 'version')},
        ),
        migrations.AlterUniqueTogether(
            name='blob',
            unique_together={('repository', 'digest')},
        ),
        migrations.CreateModel(
            name='Annotation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(max_length=250)),
                ('value', models.CharField(max_length=250)),
                ('image', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_oci.image')),
            ],
            options={
                'unique_together': {('key', 'image')},
            },
        ),
    ]
