# aliro-quantum
This is an api for the Aliro Quantum App

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install
```sh
pip install aliro-quantum
```

Then import the package:
```python
import aliro_quantum
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import aliro_quantum
from aliro_quantum.rest import ApiException
from pprint import pprint


# Set up authentication
from aliro_quantum.utils import StreamingApiClient

configuration.api_key['Authorization'] = 'API_TOKEN'

# Enter a context with an instance of the API client
with aliro_quantum.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    device_rankings_api_instance = aliro_quantum.DeviceRankingsApi(api_client)
    info_api_instance = aliro_quantum.InfoApi(api_client)
    submissions_api_instance = aliro_quantum.SubmissionsApi(api_client)

    devices_list: aliro_quantum.OwnerDetails
    quil_language: str
    simulation_only_execution_type: str
    submission_details: aliro_quantum.Submission

    try:
        # Get device targets/information
        devices_list_response: aliro_quantum.DeviceListResponse = device_rankings_api_instance.devices_list_get()
        devices_list = devices_list_response.data
        pprint(devices_list_response)
    except ApiException as e:
        print("Exception when calling DeviceRankingsApi->devices_list_get: %s\n" % e)
        raise e

    try:
        # Retrieve possible languages
        languages_list: aliro_quantum.InfoGetResponse = info_api_instance.info_languages_get()
        quil_language = next(language_info.value for language_info in languages_list.data if language_info.id == 'quil')
        pprint(languages_list)
    except ApiException as e:
        print("Exception when calling InfoApi->info_languages_get: %s\n" % e)
        raise e

    try:
        # Retrieve possible execution types
        execution_type_info_list: aliro_quantum.InfoGetResponse = info_api_instance.info_execution_types_get()
        simulation_only_execution_type = next(
            execution_type_info.value for execution_type_info in execution_type_info_list.data if
            execution_type_info.id == '2')
        pprint(execution_type_info_list)
    except ApiException as e:
        print("Exception when calling InfoApi->auth_login_post: %s\n" % e)
        raise e

    # Choose owner/device ID from devices_list
    example_owner = list(devices_list.owners.keys())[0]
    exmaple_device_id = list(devices_list.owners[example_owner].devices.keys())[0]
    example_target = aliro_quantum.OwnerDetails(
        owners={
            example_owner: aliro_quantum.OwnerDetailsOwners(
                devices={
                    exmaple_device_id: aliro_quantum.DeviceDetails()
                }
            )
        }
    )

    # Create submission info
    submission_name = 'test_submission'
    submission_post_parameters = aliro_quantum.Submission(
        circuits=[
            aliro_quantum.Circuit(
                body='DECLARE ro BIT[1]\nH 0\nMEASURE 0 ro[0]\n',
                jobs=[
                    aliro_quantum.Job(
                        allocations=aliro_quantum.JobAllocations(
                            input_parameters=aliro_quantum.CompilationParameters(
                                num_allocations=4
                            )
                        ),
                        execution=aliro_quantum.JobExecution(
                            parameters=aliro_quantum.ExecutionParameters(
                                num_shots=200,
                                output_type=simulation_only_execution_type
                            )
                        ),
                        target=example_target
                    )
                ],
                language=quil_language
            )
        ],
        name=submission_name
    )

    try:
        # Submit a new submission
        submission_api_response = submissions_api_instance.submissions_post(submission_post_parameters=submission_post_parameters)
        pprint(submission_api_response)
    except ApiException as e:
        print("Exception when calling SubmissionsApi->submissions_post: %s\n" % e)

    try:
        # Wait for results
        for submission_get_response in submissions_api_instance.submissions_submission_name_stream_get(
            submission_name=submission_name,
            completion_only='true'
        ):
            submission_details = submission_get_response.submission_detail
            break

        first_circuit: aliro_quantum.Circuit = submission_details.circuits[0]
        first_job: aliro_quantum.Job = first_circuit.jobs[0]
        execution: aliro_quantum.JobExecution = first_job.execution
        results: aliro_quantum.ExecutionResults = execution.results
        results_simulated: aliro_quantum.ResultsData = results.simulated
        results_simulated_measurements: aliro_quantum.ResultsDataMeasurements = results_simulated.measurements
        pprint(results_simulated_measurements.raw)
    except ApiException as e:
        print("Exception when calling SubmissionsApi->submissions_submission_name_stream_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://app.aliro.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**auth_login_post**](docs/AuthenticationApi.md#auth_login_post) | **POST** /auth/login | login using username and password
*AuthenticationApi* | [**authentication_password_change_post**](docs/AuthenticationApi.md#authentication_password_change_post) | **POST** /authentication/passwordChange | change user password from known password
*CircuitApi* | [**circuit_qaoa_post**](docs/CircuitApi.md#circuit_qaoa_post) | **POST** /circuit/qaoa | compiles a quantum circuit for use in QAOA
*CircuitApi* | [**circuit_translation_post**](docs/CircuitApi.md#circuit_translation_post) | **POST** /circuit/translation | translates circuits into other quantum languages
*CircuitApi* | [**circuit_visualization_get**](docs/CircuitApi.md#circuit_visualization_get) | **GET** /circuit/visualization | 
*CircuitApi* | [**circuit_visualization_post**](docs/CircuitApi.md#circuit_visualization_post) | **POST** /circuit/visualization | converts a Quil circuit into a PNG image
*DeviceRankingsApi* | [**devices_list_get**](docs/DeviceRankingsApi.md#devices_list_get) | **GET** /devicesList | retrieves list of potential devices to run the circuit on
*DeviceRankingsApi* | [**devices_list_stream_get**](docs/DeviceRankingsApi.md#devices_list_stream_get) | **GET** /devicesList/stream | streams device detail updates
*DeviceRankingsApi* | [**devices_next_available_get**](docs/DeviceRankingsApi.md#devices_next_available_get) | **GET** /devices/nextAvailable | retrieves list of next avaiable times for devices
*DeviceRankingsApi* | [**rankings_list_post**](docs/DeviceRankingsApi.md#rankings_list_post) | **POST** /rankingsList | retrieves predicted device rankings
*InfoApi* | [**info_execution_types_get**](docs/InfoApi.md#info_execution_types_get) | **GET** /info/executionTypes | get list of possible execution types for jobs
*InfoApi* | [**info_languages_get**](docs/InfoApi.md#info_languages_get) | **GET** /info/languages | get list of languages in database
*JobsApi* | [**jobs_cancel_job_id_post**](docs/JobsApi.md#jobs_cancel_job_id_post) | **POST** /jobs/cancel/{jobId} | cancel job
*SubmissionsApi* | [**submissions_delete**](docs/SubmissionsApi.md#submissions_delete) | **DELETE** /submissions | delete submissions
*SubmissionsApi* | [**submissions_get**](docs/SubmissionsApi.md#submissions_get) | **GET** /submissions | get all user&#39;s submissions
*SubmissionsApi* | [**submissions_post**](docs/SubmissionsApi.md#submissions_post) | **POST** /submissions | submit a new submission
*SubmissionsApi* | [**submissions_submission_name_get**](docs/SubmissionsApi.md#submissions_submission_name_get) | **GET** /submissions/{submissionName} | get submissions
*SubmissionsApi* | [**submissions_submission_name_stream_get**](docs/SubmissionsApi.md#submissions_submission_name_stream_get) | **GET** /submissions/{submissionName}/stream | stream submission updates


## Documentation For Models

 - [Allocation](docs/Allocation.md)
 - [BasicSuccess](docs/BasicSuccess.md)
 - [ChangePasswordParams](docs/ChangePasswordParams.md)
 - [Circuit](docs/Circuit.md)
 - [CircuitInput](docs/CircuitInput.md)
 - [CompilationParameters](docs/CompilationParameters.md)
 - [CompiledCircuit](docs/CompiledCircuit.md)
 - [CompiledCircuitResponse](docs/CompiledCircuitResponse.md)
 - [ControlFlowGraphCircuit](docs/ControlFlowGraphCircuit.md)
 - [CredentialsBasic](docs/CredentialsBasic.md)
 - [DeleteSubmissionParameters](docs/DeleteSubmissionParameters.md)
 - [DeviceDetails](docs/DeviceDetails.md)
 - [DeviceListResponse](docs/DeviceListResponse.md)
 - [DeviceRanking](docs/DeviceRanking.md)
 - [DeviceRankingResponse](docs/DeviceRankingResponse.md)
 - [DeviceRankingsParameters](docs/DeviceRankingsParameters.md)
 - [ExecutionParameters](docs/ExecutionParameters.md)
 - [ExecutionResults](docs/ExecutionResults.md)
 - [Gate](docs/Gate.md)
 - [InfoGetResponse](docs/InfoGetResponse.md)
 - [InfoGetResponseData](docs/InfoGetResponseData.md)
 - [Job](docs/Job.md)
 - [JobAllocations](docs/JobAllocations.md)
 - [JobCosts](docs/JobCosts.md)
 - [JobErrors](docs/JobErrors.md)
 - [JobExecution](docs/JobExecution.md)
 - [LoginResponse](docs/LoginResponse.md)
 - [OwnerDetails](docs/OwnerDetails.md)
 - [OwnerDetailsOwners](docs/OwnerDetailsOwners.md)
 - [PidResponse](docs/PidResponse.md)
 - [Qubit](docs/Qubit.md)
 - [Reservation](docs/Reservation.md)
 - [ResultsData](docs/ResultsData.md)
 - [ResultsDataMeasurements](docs/ResultsDataMeasurements.md)
 - [Submission](docs/Submission.md)
 - [SubmissionDetailResponse](docs/SubmissionDetailResponse.md)
 - [SubmissionSummary](docs/SubmissionSummary.md)
 - [SubmissionSummaryJobs](docs/SubmissionSummaryJobs.md)
 - [SubmissionSummaryResponse](docs/SubmissionSummaryResponse.md)
 - [TranslationParameters](docs/TranslationParameters.md)
 - [TranslationResponse](docs/TranslationResponse.md)
 - [UserInfo](docs/UserInfo.md)
 - [VisualizationResponse](docs/VisualizationResponse.md)


## Documentation For Authorization
Aliro users can retrieve their API key in their account page at https://app.aliro.io/


## JwtKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

nick@aliroquantum.com


