import logging
import os

import appdirs

from ...core.utils import APPNAME, APPAUTHOR

TOKEN = None
"""API token"""

LOGGING_LEVEL = logging._levelToName[logging.ERROR]
"""Level that we should log at by default. """

LOG_FILE_PATH = os.path.join(
    appdirs.user_log_dir(APPNAME, APPAUTHOR), ".qalx.log"
)
r"""The path where log files will be stored.

* Windows: C:\\Users\\<User>\\AppData\\Local\\agiletek\\pyqalx\\Logs\\.qalx.log
* Linux: /home/ben/.cache/pyqalx/log/.qalx.log
* Max ~/Library/Logs/qalx/.qalx.log

"""

UNPACK_SET = True
"""
Should the items in a set be de-referenced when doing a `get` or `find_one` query?

.. note::
    Sets are not unpacked when doing a `find` query
"""

UNPACK_BLUEPRINT = True
"""Should the item blueprints in a set blueprint be de-referenced?"""

UNPACK_GROUP = False
"""
Should the sets in a group be de-referenced when doing a `get` or `find_one` query?

.. note::
    Groups are not unpacked when doing a `find` query
"""

MSG_BLACKOUTSECONDS = 30
"""
After this time in seconds the message will be returned to the queue if
it has not been deleted.

.. note::
    Workers automatically issue a heartbeat to the queue while the job is being
    processed to keep extending the blackout during processing
"""

MAX_RETRY_500 = 2
"""How many times should pyqalx retry the request when receiving a 5XX error
back from the API?"""

FACTORY_PACK_DIR = appdirs.user_data_dir(APPNAME, APPAUTHOR)
r"""
The directory where factory bot code will be packed and deployed from.
Defaults to the following:

* Windows: C:\\Users\\<User>\\AppData\\Local\\agiletek\\pyqalx
* Linux: ~/.local/share/pyqalx
* Mac: ~/Library/Application Support/pyqalx
"""

del APPNAME, APPAUTHOR  # These are not config keys
