# ViRelAy &ndash; Visualizing Relevance Analysis

![ViRelAy Logo](docs/images/virelay-logo-with-title.png)

**ViRelAy** is a visualization tool for the analysis of data as generated by **[CoRelAy](https://github.com/virelay/corelay)**. It runs a small website to view and interact with data representations using clusterings and (t-SNE-)embeddings, the corresponding source data and an auxiliary per-sample representation (i.e., the attribution). With this, ViRelAy attempts to simplify the analysis of classifiers and their underlying datasets. Currently, only image data is supported, and the auxiliary representation is expected to be an attribution with the same shape as the input.

![ViRelAy Screenshot](docs/images/virelay-screenshot.png)

For more information about ViRelAy, in-depth getting started guides, and API documentation, please refer to the [documentation](https://virelay.readthedocs.io/en/latest/).

If you find ViRelAy useful for your research, why not cite our related [paper](https://arxiv.org/abs/2106.13200):

```bibtex
@article{anders2021software,
      author  = {Anders, Christopher J. and
                 Neumann, David and
                 Samek, Wojciech and
                 Müller, Klaus-Robert and
                 Lapuschkin, Sebastian},
      title   = {Software for Dataset-wide XAI: From Local Explanations to Global Insights with {Zennit}, {CoRelAy}, and {ViRelAy}},
      journal = {CoRR},
      volume  = {abs/2106.13200},
      year    = {2021},
}
```

## Features

- Visually inspect analyses generated using CoRelAy
- Open multiple projects side-by-side
- Collaborate using export, import, and share functionality
- Easily find outlier classification strategies by visualizing classifications using different clustering methods
- Understand the classification strategies of your model by viewing attribution data as heatmaps
- Easily run ViRelAy locally or on a server

## Getting Started

To get started, you first have to install ViRelAy on your system. The easiest way to install ViRelAy is to use the package available on PyPI, which can be easily installed using your favorite package manager, e.g., `pip`:

```shell
$ pip install virelay
```

ViRelAy uses a custom file format, which usually comprises a project file in [YAML](https://yaml.org/) format, a dataset either in [HDF5](https://www.hdfgroup.org/solutions/hdf5/) format or in a directory structure, one or more attribution databases in HDF5 format, and one or more analyses databases for various analyses methods in HDF5 format. For more information on the project file format, please refer to the [project file format documentation](https://virelay.readthedocs.io/en/latest/contributors-guide/project-file-format.html) and for more information on the formats for the dataset, attribution, and analyses databases, see the [database specifications](https://virelay.readthedocs.io/en/latest/contributors-guide/database-specification.html).

ViRelAy projects can be generated using [CoRelAy](https://github.com/virelay/corelay), but if you want to get a fast first glimpse at ViRelAy, you can also create a randomly generated [example project](https://virelay.readthedocs.io/en/latest/getting-started/example-project.html).

When you have a project ready, you can open it in ViRelAy like so using the following command. Please note that starting ViRelAy using the command line interface, will start a rather slow development server. For improved load times or when running ViRelAy on a server, please run it using the WSGI HTTP server [Gunicorn](https://virelay.readthedocs.io/en/latest/user-guide/using-virelay-with-gunicorn.html).

```shell
$ python -m virelay <project-file> [<project-file> ...]
```

This will start the server at http://localhost:8080 and automatically open your default browser. Optionally, you can specify an alternative host and port using the `--host` and `--port` command line arguments. For more in-depth instructions, please refer to our [getting started guide](https://virelay.readthedocs.io/en/latest/getting-started/index.html).

## Contributing

If you would like to contribute, there are multiple ways you can help out. If you find a bug or have a feature request, please feel free to open an issue on GitHub. If you want to contribute code, please fork the repository and use a feature branch. Pull requests are always welcome. Before forking, please open an issue where you describe what you want to do. This helps to align your ideas with ours and may prevent you from doing work, that we are already planning on doing. If you have contributed to the project, please add yourself to the [contributors list](CONTRIBUTORS.md).

To help speed up the merging of your pull request, please comment and document your code extensively, try to emulate the coding style of the project, and update the documentation if necessary. For more information on how to contribute, please refer to the [developer documentation](https://virelay.readthedocs.io/en/latest/contributors-guide/index.html).

## License

ViRelAy is licensed under the GNU AFFERO GENERAL PUBLIC LICENSE VERSION 3 OR LATER. For more information see the [copying](COPYING) and the [license](LICENSE) files. For licenses of bundled third party software packages please refer to the [3rd party license list](virelay/frontend/distribution/3rdpartylicenses.txt).
