#!/usr/bin/python
#
# Copyright 2018-2020 Polyaxon, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Polyaxon SDKs and REST API specification.

    Polyaxon SDKs and REST API specification.  # noqa: E501

    The version of the OpenAPI document: 1.0.99-rc5
    Contact: contact@polyaxon.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from polyaxon_sdk.api_client import ApiClient
from polyaxon_sdk.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class RunsV1Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def archive_run(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Archive run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_run(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_run_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def archive_run_with_http_info(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Archive run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_run_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `archive_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `archive_run`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `archive_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/archive",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def bookmark_run(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Bookmark run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bookmark_run(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.bookmark_run_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def bookmark_run_with_http_info(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Bookmark run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bookmark_run_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bookmark_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `bookmark_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `bookmark_run`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `bookmark_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/bookmark",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def bookmark_runs(self, owner, project, body, **kwargs):  # noqa: E501
        """Bookmark runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bookmark_runs(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1Uuids body: Uuids of the entities (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.bookmark_runs_with_http_info(
            owner, project, body, **kwargs
        )  # noqa: E501

    def bookmark_runs_with_http_info(
        self, owner, project, body, **kwargs
    ):  # noqa: E501
        """Bookmark runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bookmark_runs_with_http_info(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1Uuids body: Uuids of the entities (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bookmark_runs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `bookmark_runs`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `bookmark_runs`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `bookmark_runs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/bookmark",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def collect_run_logs(self, namespace, owner, project, uuid, **kwargs):  # noqa: E501
        """Collect run logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_run_logs(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.collect_run_logs_with_http_info(
            namespace, owner, project, uuid, **kwargs
        )  # noqa: E501

    def collect_run_logs_with_http_info(
        self, namespace, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Collect run logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_run_logs_with_http_info(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["namespace", "owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method collect_run_logs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'namespace' is set
        if self.api_client.client_side_validation and (
            "namespace" not in local_var_params
            or local_var_params["namespace"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `namespace` when calling `collect_run_logs`"
            )  # noqa: E501
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `collect_run_logs`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `collect_run_logs`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `collect_run_logs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "namespace" in local_var_params:
            path_params["namespace"] = local_var_params["namespace"]  # noqa: E501
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/streams/v1/{namespace}/_internal/{owner}/{project}/runs/{uuid}/logs",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def copy_run(
        self, entity_owner, entity_project, entity_uuid, body, **kwargs
    ):  # noqa: E501
        """Restart run with copy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_run(entity_owner, entity_project, entity_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str entity_owner: Owner of the namespace (required)
        :param str entity_project: Project (required)
        :param str entity_uuid: Uuid identifier of the entity (required)
        :param V1Run body: Run object (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Run
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.copy_run_with_http_info(
            entity_owner, entity_project, entity_uuid, body, **kwargs
        )  # noqa: E501

    def copy_run_with_http_info(
        self, entity_owner, entity_project, entity_uuid, body, **kwargs
    ):  # noqa: E501
        """Restart run with copy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_run_with_http_info(entity_owner, entity_project, entity_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str entity_owner: Owner of the namespace (required)
        :param str entity_project: Project (required)
        :param str entity_uuid: Uuid identifier of the entity (required)
        :param V1Run body: Run object (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Run, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["entity_owner", "entity_project", "entity_uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'entity_owner' is set
        if self.api_client.client_side_validation and (
            "entity_owner" not in local_var_params
            or local_var_params["entity_owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `entity_owner` when calling `copy_run`"
            )  # noqa: E501
        # verify the required parameter 'entity_project' is set
        if self.api_client.client_side_validation and (
            "entity_project" not in local_var_params
            or local_var_params["entity_project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `entity_project` when calling `copy_run`"
            )  # noqa: E501
        # verify the required parameter 'entity_uuid' is set
        if self.api_client.client_side_validation and (
            "entity_uuid" not in local_var_params
            or local_var_params["entity_uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `entity_uuid` when calling `copy_run`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `copy_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "entity_owner" in local_var_params:
            path_params["entity.owner"] = local_var_params["entity_owner"]  # noqa: E501
        if "entity_project" in local_var_params:
            path_params["entity.project"] = local_var_params[
                "entity_project"
            ]  # noqa: E501
        if "entity_uuid" in local_var_params:
            path_params["entity.uuid"] = local_var_params["entity_uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{entity.owner}/{entity.project}/runs/{entity.uuid}/copy",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Run",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_run(self, owner, project, body, **kwargs):  # noqa: E501
        """Create new run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_run(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param V1OperationBody body: operation object (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Run
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_run_with_http_info(
            owner, project, body, **kwargs
        )  # noqa: E501

    def create_run_with_http_info(self, owner, project, body, **kwargs):  # noqa: E501
        """Create new run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_run_with_http_info(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param V1OperationBody body: operation object (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Run, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `create_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `create_run`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `create_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Run",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_run_artifacts_lineage(
        self, owner, project, uuid, body, **kwargs
    ):  # noqa: E501
        """Create bulk run run artifacts lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_run_artifacts_lineage(owner, project, uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param V1RunArtifacts body: Run Artifacts (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_run_artifacts_lineage_with_http_info(
            owner, project, uuid, body, **kwargs
        )  # noqa: E501

    def create_run_artifacts_lineage_with_http_info(
        self, owner, project, uuid, body, **kwargs
    ):  # noqa: E501
        """Create bulk run run artifacts lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_run_artifacts_lineage_with_http_info(owner, project, uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param V1RunArtifacts body: Run Artifacts (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_run_artifacts_lineage" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `create_run_artifacts_lineage`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `create_run_artifacts_lineage`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `create_run_artifacts_lineage`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `create_run_artifacts_lineage`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/artifacts_lineage",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_run_status(self, owner, project, uuid, body, **kwargs):  # noqa: E501
        """Create new run status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_run_status(owner, project, uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param V1EntityStatusBodyRequest body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_run_status_with_http_info(
            owner, project, uuid, body, **kwargs
        )  # noqa: E501

    def create_run_status_with_http_info(
        self, owner, project, uuid, body, **kwargs
    ):  # noqa: E501
        """Create new run status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_run_status_with_http_info(owner, project, uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param V1EntityStatusBodyRequest body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Status, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_run_status" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `create_run_status`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `create_run_status`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `create_run_status`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `create_run_status`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/statuses",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Status",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_run(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Delete run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_run(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_run_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def delete_run_with_http_info(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Delete run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_run_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `delete_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `delete_run`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `delete_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_run_artifact_lineage(
        self, owner, project, uuid, name, **kwargs
    ):  # noqa: E501
        """Delete run artifact lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_run_artifact_lineage(owner, project, uuid, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param str name: Artifact name (required)
        :param str namespace: namespace.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_run_artifact_lineage_with_http_info(
            owner, project, uuid, name, **kwargs
        )  # noqa: E501

    def delete_run_artifact_lineage_with_http_info(
        self, owner, project, uuid, name, **kwargs
    ):  # noqa: E501
        """Delete run artifact lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_run_artifact_lineage_with_http_info(owner, project, uuid, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param str name: Artifact name (required)
        :param str namespace: namespace.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid", "name", "namespace"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_run_artifact_lineage" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `delete_run_artifact_lineage`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `delete_run_artifact_lineage`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `delete_run_artifact_lineage`"
            )  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and (
            "name" not in local_var_params
            or local_var_params["name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `name` when calling `delete_run_artifact_lineage`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501
        if "name" in local_var_params:
            path_params["name"] = local_var_params["name"]  # noqa: E501

        query_params = []
        if (
            "namespace" in local_var_params
            and local_var_params["namespace"] is not None
        ):  # noqa: E501
            query_params.append(
                ("namespace", local_var_params["namespace"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/artifacts_lineage/{name}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_runs(self, owner, project, body, **kwargs):  # noqa: E501
        """Delete runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_runs(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1Uuids body: Uuids of the entities (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_runs_with_http_info(
            owner, project, body, **kwargs
        )  # noqa: E501

    def delete_runs_with_http_info(self, owner, project, body, **kwargs):  # noqa: E501
        """Delete runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_runs_with_http_info(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1Uuids body: Uuids of the entities (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_runs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `delete_runs`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `delete_runs`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `delete_runs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/delete",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_multi_run_events(
        self, namespace, owner, project, kind, **kwargs
    ):  # noqa: E501
        """Get multi runs events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_multi_run_events(namespace, owner, project, kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str kind: The artifact kind (required)
        :param str names: Names query param.
        :param str runs: Runs query param.
        :param str orient: Orient query param.
        :param bool force: Force query param.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_multi_run_events_with_http_info(
            namespace, owner, project, kind, **kwargs
        )  # noqa: E501

    def get_multi_run_events_with_http_info(
        self, namespace, owner, project, kind, **kwargs
    ):  # noqa: E501
        """Get multi runs events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_multi_run_events_with_http_info(namespace, owner, project, kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str kind: The artifact kind (required)
        :param str names: Names query param.
        :param str runs: Runs query param.
        :param str orient: Orient query param.
        :param bool force: Force query param.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1EventsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "namespace",
            "owner",
            "project",
            "kind",
            "names",
            "runs",
            "orient",
            "force",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_multi_run_events" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'namespace' is set
        if self.api_client.client_side_validation and (
            "namespace" not in local_var_params
            or local_var_params["namespace"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `namespace` when calling `get_multi_run_events`"
            )  # noqa: E501
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_multi_run_events`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_multi_run_events`"
            )  # noqa: E501
        # verify the required parameter 'kind' is set
        if self.api_client.client_side_validation and (
            "kind" not in local_var_params
            or local_var_params["kind"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `kind` when calling `get_multi_run_events`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "namespace" in local_var_params:
            path_params["namespace"] = local_var_params["namespace"]  # noqa: E501
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "kind" in local_var_params:
            path_params["kind"] = local_var_params["kind"]  # noqa: E501

        query_params = []
        if (
            "names" in local_var_params and local_var_params["names"] is not None
        ):  # noqa: E501
            query_params.append(("names", local_var_params["names"]))  # noqa: E501
        if (
            "runs" in local_var_params and local_var_params["runs"] is not None
        ):  # noqa: E501
            query_params.append(("runs", local_var_params["runs"]))  # noqa: E501
        if (
            "orient" in local_var_params and local_var_params["orient"] is not None
        ):  # noqa: E501
            query_params.append(("orient", local_var_params["orient"]))  # noqa: E501
        if (
            "force" in local_var_params and local_var_params["force"] is not None
        ):  # noqa: E501
            query_params.append(("force", local_var_params["force"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/streams/v1/{namespace}/{owner}/{project}/runs/multi/events/{kind}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1EventsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Get run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Run
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_with_http_info(owner, project, uuid, **kwargs)  # noqa: E501

    def get_run_with_http_info(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Get run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Run, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method get_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Run",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_artifact(self, namespace, owner, project, uuid, **kwargs):  # noqa: E501
        """Get run artifact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifact(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the experiement will be assigned (required)
        :param str uuid: Unique integer identifier of the entity (required)
        :param str path: Artifact filepath.
        :param bool stream: Whether to stream the file.
        :param bool force: Whether to force reload.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_artifact_with_http_info(
            namespace, owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_run_artifact_with_http_info(
        self, namespace, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run artifact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifact_with_http_info(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the experiement will be assigned (required)
        :param str uuid: Unique integer identifier of the entity (required)
        :param str path: Artifact filepath.
        :param bool stream: Whether to stream the file.
        :param bool force: Whether to force reload.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "namespace",
            "owner",
            "project",
            "uuid",
            "path",
            "stream",
            "force",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_artifact" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'namespace' is set
        if self.api_client.client_side_validation and (
            "namespace" not in local_var_params
            or local_var_params["namespace"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `namespace` when calling `get_run_artifact`"
            )  # noqa: E501
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_artifact`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_artifact`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_artifact`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "namespace" in local_var_params:
            path_params["namespace"] = local_var_params["namespace"]  # noqa: E501
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []
        if (
            "path" in local_var_params and local_var_params["path"] is not None
        ):  # noqa: E501
            query_params.append(("path", local_var_params["path"]))  # noqa: E501
        if (
            "stream" in local_var_params and local_var_params["stream"] is not None
        ):  # noqa: E501
            query_params.append(("stream", local_var_params["stream"]))  # noqa: E501
        if (
            "force" in local_var_params and local_var_params["force"] is not None
        ):  # noqa: E501
            query_params.append(("force", local_var_params["force"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/artifact",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_artifact_lineage(
        self, owner, project, uuid, name, **kwargs
    ):  # noqa: E501
        """Get run artifacts lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifact_lineage(owner, project, uuid, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param str name: Artifact name (required)
        :param str namespace: namespace.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1RunArtifact
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_artifact_lineage_with_http_info(
            owner, project, uuid, name, **kwargs
        )  # noqa: E501

    def get_run_artifact_lineage_with_http_info(
        self, owner, project, uuid, name, **kwargs
    ):  # noqa: E501
        """Get run artifacts lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifact_lineage_with_http_info(owner, project, uuid, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param str name: Artifact name (required)
        :param str namespace: namespace.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1RunArtifact, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid", "name", "namespace"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_artifact_lineage" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_artifact_lineage`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_artifact_lineage`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_artifact_lineage`"
            )  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and (
            "name" not in local_var_params
            or local_var_params["name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `name` when calling `get_run_artifact_lineage`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501
        if "name" in local_var_params:
            path_params["name"] = local_var_params["name"]  # noqa: E501

        query_params = []
        if (
            "namespace" in local_var_params
            and local_var_params["namespace"] is not None
        ):  # noqa: E501
            query_params.append(
                ("namespace", local_var_params["namespace"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/artifacts_lineage/{name}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1RunArtifact",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_artifacts(
        self, namespace, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run artifacts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifacts(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the experiement will be assigned (required)
        :param str uuid: Unique integer identifier of the entity (required)
        :param str path: Artifact filepath.
        :param bool force: Whether to force reload.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_artifacts_with_http_info(
            namespace, owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_run_artifacts_with_http_info(
        self, namespace, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run artifacts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifacts_with_http_info(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the experiement will be assigned (required)
        :param str uuid: Unique integer identifier of the entity (required)
        :param str path: Artifact filepath.
        :param bool force: Whether to force reload.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["namespace", "owner", "project", "uuid", "path", "force"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_artifacts" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'namespace' is set
        if self.api_client.client_side_validation and (
            "namespace" not in local_var_params
            or local_var_params["namespace"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `namespace` when calling `get_run_artifacts`"
            )  # noqa: E501
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_artifacts`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_artifacts`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_artifacts`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "namespace" in local_var_params:
            path_params["namespace"] = local_var_params["namespace"]  # noqa: E501
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []
        if (
            "path" in local_var_params and local_var_params["path"] is not None
        ):  # noqa: E501
            query_params.append(("path", local_var_params["path"]))  # noqa: E501
        if (
            "force" in local_var_params and local_var_params["force"] is not None
        ):  # noqa: E501
            query_params.append(("force", local_var_params["force"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/artifacts",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_artifacts_lineage(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Get run artifacts lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifacts_lineage(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param str uuid: Entity uuid (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1ListRunArtifactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_artifacts_lineage_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_run_artifacts_lineage_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run artifacts lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifacts_lineage_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param str uuid: Entity uuid (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1ListRunArtifactsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid", "offset", "limit", "sort", "query"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_artifacts_lineage" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_artifacts_lineage`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_artifacts_lineage`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_artifacts_lineage`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []
        if (
            "offset" in local_var_params and local_var_params["offset"] is not None
        ):  # noqa: E501
            query_params.append(("offset", local_var_params["offset"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
        if (
            "query" in local_var_params and local_var_params["query"] is not None
        ):  # noqa: E501
            query_params.append(("query", local_var_params["query"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/artifacts_lineage",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1ListRunArtifactsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_artifacts_lineage_names(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run artifacts lineage names  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifacts_lineage_names(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param str uuid: Entity uuid (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1ListRunArtifactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_artifacts_lineage_names_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_run_artifacts_lineage_names_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run artifacts lineage names  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifacts_lineage_names_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param str uuid: Entity uuid (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1ListRunArtifactsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid", "offset", "limit", "sort", "query"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_artifacts_lineage_names" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_artifacts_lineage_names`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_artifacts_lineage_names`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_artifacts_lineage_names`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []
        if (
            "offset" in local_var_params and local_var_params["offset"] is not None
        ):  # noqa: E501
            query_params.append(("offset", local_var_params["offset"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
        if (
            "query" in local_var_params and local_var_params["query"] is not None
        ):  # noqa: E501
            query_params.append(("query", local_var_params["query"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/artifacts_lineage/names",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1ListRunArtifactsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_artifacts_tree(
        self, namespace, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run artifacts tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifacts_tree(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param str path: Path query param.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1ArtifactTree
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_artifacts_tree_with_http_info(
            namespace, owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_run_artifacts_tree_with_http_info(
        self, namespace, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run artifacts tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_artifacts_tree_with_http_info(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param str path: Path query param.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1ArtifactTree, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["namespace", "owner", "project", "uuid", "path"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_artifacts_tree" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'namespace' is set
        if self.api_client.client_side_validation and (
            "namespace" not in local_var_params
            or local_var_params["namespace"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `namespace` when calling `get_run_artifacts_tree`"
            )  # noqa: E501
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_artifacts_tree`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_artifacts_tree`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_artifacts_tree`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "namespace" in local_var_params:
            path_params["namespace"] = local_var_params["namespace"]  # noqa: E501
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []
        if (
            "path" in local_var_params and local_var_params["path"] is not None
        ):  # noqa: E501
            query_params.append(("path", local_var_params["path"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/artifacts/tree",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1ArtifactTree",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_events(
        self, namespace, owner, project, uuid, kind, **kwargs
    ):  # noqa: E501
        """Get run events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_events(namespace, owner, project, uuid, kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param str kind: The artifact kind (required)
        :param str names: Names query param.
        :param str orient: Orient query param.
        :param bool force: Force query param.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_events_with_http_info(
            namespace, owner, project, uuid, kind, **kwargs
        )  # noqa: E501

    def get_run_events_with_http_info(
        self, namespace, owner, project, uuid, kind, **kwargs
    ):  # noqa: E501
        """Get run events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_events_with_http_info(namespace, owner, project, uuid, kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param str kind: The artifact kind (required)
        :param str names: Names query param.
        :param str orient: Orient query param.
        :param bool force: Force query param.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1EventsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "namespace",
            "owner",
            "project",
            "uuid",
            "kind",
            "names",
            "orient",
            "force",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_events" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'namespace' is set
        if self.api_client.client_side_validation and (
            "namespace" not in local_var_params
            or local_var_params["namespace"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `namespace` when calling `get_run_events`"
            )  # noqa: E501
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_events`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_events`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_events`"
            )  # noqa: E501
        # verify the required parameter 'kind' is set
        if self.api_client.client_side_validation and (
            "kind" not in local_var_params
            or local_var_params["kind"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `kind` when calling `get_run_events`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "namespace" in local_var_params:
            path_params["namespace"] = local_var_params["namespace"]  # noqa: E501
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501
        if "kind" in local_var_params:
            path_params["kind"] = local_var_params["kind"]  # noqa: E501

        query_params = []
        if (
            "names" in local_var_params and local_var_params["names"] is not None
        ):  # noqa: E501
            query_params.append(("names", local_var_params["names"]))  # noqa: E501
        if (
            "orient" in local_var_params and local_var_params["orient"] is not None
        ):  # noqa: E501
            query_params.append(("orient", local_var_params["orient"]))  # noqa: E501
        if (
            "force" in local_var_params and local_var_params["force"] is not None
        ):  # noqa: E501
            query_params.append(("force", local_var_params["force"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/events/{kind}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1EventsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_logs(self, namespace, owner, project, uuid, **kwargs):  # noqa: E501
        """Get run logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_logs(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param datetime last_time: last time.
        :param str last_file: last file.
        :param bool force: Force query param.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Logs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_logs_with_http_info(
            namespace, owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_run_logs_with_http_info(
        self, namespace, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_logs_with_http_info(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param datetime last_time: last time.
        :param str last_file: last file.
        :param bool force: Force query param.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Logs, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "namespace",
            "owner",
            "project",
            "uuid",
            "last_time",
            "last_file",
            "force",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_logs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'namespace' is set
        if self.api_client.client_side_validation and (
            "namespace" not in local_var_params
            or local_var_params["namespace"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `namespace` when calling `get_run_logs`"
            )  # noqa: E501
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_logs`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_logs`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_logs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "namespace" in local_var_params:
            path_params["namespace"] = local_var_params["namespace"]  # noqa: E501
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []
        if (
            "last_time" in local_var_params
            and local_var_params["last_time"] is not None
        ):  # noqa: E501
            query_params.append(
                ("last_time", local_var_params["last_time"])
            )  # noqa: E501
        if (
            "last_file" in local_var_params
            and local_var_params["last_file"] is not None
        ):  # noqa: E501
            query_params.append(
                ("last_file", local_var_params["last_file"])
            )  # noqa: E501
        if (
            "force" in local_var_params and local_var_params["force"] is not None
        ):  # noqa: E501
            query_params.append(("force", local_var_params["force"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/logs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Logs",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_namespace(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Get Run namespace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_namespace(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1RunSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_namespace_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_run_namespace_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get Run namespace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_namespace_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1RunSettings, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_namespace" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_namespace`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_namespace`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_namespace`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/namespace",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1RunSettings",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_resources(
        self, namespace, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run resources events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_resources(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param str names: Names query param.
        :param bool tail: Query param flag to tail the values.
        :param bool force: Force query param.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_resources_with_http_info(
            namespace, owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_run_resources_with_http_info(
        self, namespace, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run resources events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_resources_with_http_info(namespace, owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: namespace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param str names: Names query param.
        :param bool tail: Query param flag to tail the values.
        :param bool force: Force query param.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1EventsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["namespace", "owner", "project", "uuid", "names", "tail", "force"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_resources" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'namespace' is set
        if self.api_client.client_side_validation and (
            "namespace" not in local_var_params
            or local_var_params["namespace"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `namespace` when calling `get_run_resources`"
            )  # noqa: E501
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_resources`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_resources`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_resources`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "namespace" in local_var_params:
            path_params["namespace"] = local_var_params["namespace"]  # noqa: E501
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []
        if (
            "names" in local_var_params and local_var_params["names"] is not None
        ):  # noqa: E501
            query_params.append(("names", local_var_params["names"]))  # noqa: E501
        if (
            "tail" in local_var_params and local_var_params["tail"] is not None
        ):  # noqa: E501
            query_params.append(("tail", local_var_params["tail"]))  # noqa: E501
        if (
            "force" in local_var_params and local_var_params["force"] is not None
        ):  # noqa: E501
            query_params.append(("force", local_var_params["force"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/resources",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1EventsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_settings(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Get Run settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_settings(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1RunSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_settings_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_run_settings_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get Run settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_settings_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1RunSettings, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_settings" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_settings`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_settings`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_settings`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/settings",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1RunSettings",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_run_statuses(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Get run statuses  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_statuses(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_run_statuses_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_run_statuses_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get run statuses  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_statuses_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Status, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_statuses" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_run_statuses`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_run_statuses`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_run_statuses`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/statuses",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Status",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_runs_artifacts_lineage(self, owner, project, **kwargs):  # noqa: E501
        """Get runs artifacts lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_runs_artifacts_lineage(owner, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1ListRunArtifactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_runs_artifacts_lineage_with_http_info(
            owner, project, **kwargs
        )  # noqa: E501

    def get_runs_artifacts_lineage_with_http_info(
        self, owner, project, **kwargs
    ):  # noqa: E501
        """Get runs artifacts lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_runs_artifacts_lineage_with_http_info(owner, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1ListRunArtifactsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "offset", "limit", "sort", "query"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_runs_artifacts_lineage" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_runs_artifacts_lineage`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_runs_artifacts_lineage`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []
        if (
            "offset" in local_var_params and local_var_params["offset"] is not None
        ):  # noqa: E501
            query_params.append(("offset", local_var_params["offset"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
        if (
            "query" in local_var_params and local_var_params["query"] is not None
        ):  # noqa: E501
            query_params.append(("query", local_var_params["query"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/artifacts_lineage",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1ListRunArtifactsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def impersonate_token(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Impersonate run token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.impersonate_token(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Auth
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.impersonate_token_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def impersonate_token_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Impersonate run token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.impersonate_token_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Auth, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method impersonate_token" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `impersonate_token`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `impersonate_token`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `impersonate_token`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/impersonate",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Auth",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def invalidate_run(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Invalidate run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invalidate_run(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.invalidate_run_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def invalidate_run_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Invalidate run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invalidate_run_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invalidate_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `invalidate_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `invalidate_run`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `invalidate_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/invalidate",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def invalidate_runs(self, owner, project, body, **kwargs):  # noqa: E501
        """Invalidate runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invalidate_runs(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1Uuids body: Uuids of the entities (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.invalidate_runs_with_http_info(
            owner, project, body, **kwargs
        )  # noqa: E501

    def invalidate_runs_with_http_info(
        self, owner, project, body, **kwargs
    ):  # noqa: E501
        """Invalidate runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invalidate_runs_with_http_info(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1Uuids body: Uuids of the entities (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invalidate_runs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `invalidate_runs`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `invalidate_runs`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `invalidate_runs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/invalidate",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_archived_runs(self, user, **kwargs):  # noqa: E501
        """List archived runs for user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_archived_runs(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user: User (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1ListRunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_archived_runs_with_http_info(user, **kwargs)  # noqa: E501

    def list_archived_runs_with_http_info(self, user, **kwargs):  # noqa: E501
        """List archived runs for user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_archived_runs_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user: User (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1ListRunsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["user", "offset", "limit", "sort", "query"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_archived_runs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and (
            "user" not in local_var_params
            or local_var_params["user"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `user` when calling `list_archived_runs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "user" in local_var_params:
            path_params["user"] = local_var_params["user"]  # noqa: E501

        query_params = []
        if (
            "offset" in local_var_params and local_var_params["offset"] is not None
        ):  # noqa: E501
            query_params.append(("offset", local_var_params["offset"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
        if (
            "query" in local_var_params and local_var_params["query"] is not None
        ):  # noqa: E501
            query_params.append(("query", local_var_params["query"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/archives/{user}/runs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1ListRunsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_bookmarked_runs(self, user, **kwargs):  # noqa: E501
        """List bookmarked runs for user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_bookmarked_runs(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user: User (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1ListRunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_bookmarked_runs_with_http_info(user, **kwargs)  # noqa: E501

    def list_bookmarked_runs_with_http_info(self, user, **kwargs):  # noqa: E501
        """List bookmarked runs for user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_bookmarked_runs_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user: User (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1ListRunsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["user", "offset", "limit", "sort", "query"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_bookmarked_runs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and (
            "user" not in local_var_params
            or local_var_params["user"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `user` when calling `list_bookmarked_runs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "user" in local_var_params:
            path_params["user"] = local_var_params["user"]  # noqa: E501

        query_params = []
        if (
            "offset" in local_var_params and local_var_params["offset"] is not None
        ):  # noqa: E501
            query_params.append(("offset", local_var_params["offset"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
        if (
            "query" in local_var_params and local_var_params["query"] is not None
        ):  # noqa: E501
            query_params.append(("query", local_var_params["query"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/bookmarks/{user}/runs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1ListRunsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_runs(self, owner, project, **kwargs):  # noqa: E501
        """List runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_runs(owner, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1ListRunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_runs_with_http_info(owner, project, **kwargs)  # noqa: E501

    def list_runs_with_http_info(self, owner, project, **kwargs):  # noqa: E501
        """List runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_runs_with_http_info(owner, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1ListRunsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "offset", "limit", "sort", "query"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_runs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `list_runs`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `list_runs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []
        if (
            "offset" in local_var_params and local_var_params["offset"] is not None
        ):  # noqa: E501
            query_params.append(("offset", local_var_params["offset"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
        if (
            "query" in local_var_params and local_var_params["query"] is not None
        ):  # noqa: E501
            query_params.append(("query", local_var_params["query"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1ListRunsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_runs_io(self, owner, project, **kwargs):  # noqa: E501
        """List runs io  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_runs_io(owner, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1ListRunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_runs_io_with_http_info(owner, project, **kwargs)  # noqa: E501

    def list_runs_io_with_http_info(self, owner, project, **kwargs):  # noqa: E501
        """List runs io  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_runs_io_with_http_info(owner, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1ListRunsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "offset", "limit", "sort", "query"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_runs_io" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `list_runs_io`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `list_runs_io`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []
        if (
            "offset" in local_var_params and local_var_params["offset"] is not None
        ):  # noqa: E501
            query_params.append(("offset", local_var_params["offset"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
        if (
            "query" in local_var_params and local_var_params["query"] is not None
        ):  # noqa: E501
            query_params.append(("query", local_var_params["query"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/io",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1ListRunsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def notify_run_status(
        self, namespace, owner, project, uuid, body, **kwargs
    ):  # noqa: E501
        """Notify run status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notify_run_status(namespace, owner, project, uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: Na,espace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param V1EntityNotificationBody body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.notify_run_status_with_http_info(
            namespace, owner, project, uuid, body, **kwargs
        )  # noqa: E501

    def notify_run_status_with_http_info(
        self, namespace, owner, project, uuid, body, **kwargs
    ):  # noqa: E501
        """Notify run status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notify_run_status_with_http_info(namespace, owner, project, uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str namespace: Na,espace (required)
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param V1EntityNotificationBody body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["namespace", "owner", "project", "uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notify_run_status" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'namespace' is set
        if self.api_client.client_side_validation and (
            "namespace" not in local_var_params
            or local_var_params["namespace"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `namespace` when calling `notify_run_status`"
            )  # noqa: E501
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `notify_run_status`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `notify_run_status`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `notify_run_status`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `notify_run_status`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "namespace" in local_var_params:
            path_params["namespace"] = local_var_params["namespace"]  # noqa: E501
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/streams/v1/{namespace}/{owner}/{project}/runs/{uuid}/notify",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def patch_run(self, owner, project, run_uuid, body, **kwargs):  # noqa: E501
        """Patch run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_run(owner, project, run_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str run_uuid: UUID (required)
        :param V1Run body: Run object (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Run
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.patch_run_with_http_info(
            owner, project, run_uuid, body, **kwargs
        )  # noqa: E501

    def patch_run_with_http_info(
        self, owner, project, run_uuid, body, **kwargs
    ):  # noqa: E501
        """Patch run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_run_with_http_info(owner, project, run_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str run_uuid: UUID (required)
        :param V1Run body: Run object (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Run, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "run_uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `patch_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `patch_run`"
            )  # noqa: E501
        # verify the required parameter 'run_uuid' is set
        if self.api_client.client_side_validation and (
            "run_uuid" not in local_var_params
            or local_var_params["run_uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `run_uuid` when calling `patch_run`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `patch_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "run_uuid" in local_var_params:
            path_params["run.uuid"] = local_var_params["run_uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{run.uuid}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Run",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def restart_run(
        self, entity_owner, entity_project, entity_uuid, body, **kwargs
    ):  # noqa: E501
        """Restart run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restart_run(entity_owner, entity_project, entity_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str entity_owner: Owner of the namespace (required)
        :param str entity_project: Project (required)
        :param str entity_uuid: Uuid identifier of the entity (required)
        :param V1Run body: Run object (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Run
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.restart_run_with_http_info(
            entity_owner, entity_project, entity_uuid, body, **kwargs
        )  # noqa: E501

    def restart_run_with_http_info(
        self, entity_owner, entity_project, entity_uuid, body, **kwargs
    ):  # noqa: E501
        """Restart run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restart_run_with_http_info(entity_owner, entity_project, entity_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str entity_owner: Owner of the namespace (required)
        :param str entity_project: Project (required)
        :param str entity_uuid: Uuid identifier of the entity (required)
        :param V1Run body: Run object (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Run, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["entity_owner", "entity_project", "entity_uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restart_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'entity_owner' is set
        if self.api_client.client_side_validation and (
            "entity_owner" not in local_var_params
            or local_var_params["entity_owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `entity_owner` when calling `restart_run`"
            )  # noqa: E501
        # verify the required parameter 'entity_project' is set
        if self.api_client.client_side_validation and (
            "entity_project" not in local_var_params
            or local_var_params["entity_project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `entity_project` when calling `restart_run`"
            )  # noqa: E501
        # verify the required parameter 'entity_uuid' is set
        if self.api_client.client_side_validation and (
            "entity_uuid" not in local_var_params
            or local_var_params["entity_uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `entity_uuid` when calling `restart_run`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `restart_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "entity_owner" in local_var_params:
            path_params["entity.owner"] = local_var_params["entity_owner"]  # noqa: E501
        if "entity_project" in local_var_params:
            path_params["entity.project"] = local_var_params[
                "entity_project"
            ]  # noqa: E501
        if "entity_uuid" in local_var_params:
            path_params["entity.uuid"] = local_var_params["entity_uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{entity.owner}/{entity.project}/runs/{entity.uuid}/restart",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Run",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def restore_run(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Restore run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restore_run(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.restore_run_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def restore_run_with_http_info(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Restore run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restore_run_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restore_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `restore_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `restore_run`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `restore_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/restore",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def resume_run(
        self, entity_owner, entity_project, entity_uuid, body, **kwargs
    ):  # noqa: E501
        """Resume run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resume_run(entity_owner, entity_project, entity_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str entity_owner: Owner of the namespace (required)
        :param str entity_project: Project (required)
        :param str entity_uuid: Uuid identifier of the entity (required)
        :param V1Run body: Run object (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Run
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.resume_run_with_http_info(
            entity_owner, entity_project, entity_uuid, body, **kwargs
        )  # noqa: E501

    def resume_run_with_http_info(
        self, entity_owner, entity_project, entity_uuid, body, **kwargs
    ):  # noqa: E501
        """Resume run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resume_run_with_http_info(entity_owner, entity_project, entity_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str entity_owner: Owner of the namespace (required)
        :param str entity_project: Project (required)
        :param str entity_uuid: Uuid identifier of the entity (required)
        :param V1Run body: Run object (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Run, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["entity_owner", "entity_project", "entity_uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resume_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'entity_owner' is set
        if self.api_client.client_side_validation and (
            "entity_owner" not in local_var_params
            or local_var_params["entity_owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `entity_owner` when calling `resume_run`"
            )  # noqa: E501
        # verify the required parameter 'entity_project' is set
        if self.api_client.client_side_validation and (
            "entity_project" not in local_var_params
            or local_var_params["entity_project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `entity_project` when calling `resume_run`"
            )  # noqa: E501
        # verify the required parameter 'entity_uuid' is set
        if self.api_client.client_side_validation and (
            "entity_uuid" not in local_var_params
            or local_var_params["entity_uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `entity_uuid` when calling `resume_run`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `resume_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "entity_owner" in local_var_params:
            path_params["entity.owner"] = local_var_params["entity_owner"]  # noqa: E501
        if "entity_project" in local_var_params:
            path_params["entity.project"] = local_var_params[
                "entity_project"
            ]  # noqa: E501
        if "entity_uuid" in local_var_params:
            path_params["entity.uuid"] = local_var_params["entity_uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{entity.owner}/{entity.project}/runs/{entity.uuid}/resume",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Run",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def start_run_tensorboard(self, owner, project, uuid, body, **kwargs):  # noqa: E501
        """Start run tensorboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_run_tensorboard(owner, project, uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param V1ProjectEntityResourceRequest body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.start_run_tensorboard_with_http_info(
            owner, project, uuid, body, **kwargs
        )  # noqa: E501

    def start_run_tensorboard_with_http_info(
        self, owner, project, uuid, body, **kwargs
    ):  # noqa: E501
        """Start run tensorboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_run_tensorboard_with_http_info(owner, project, uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param V1ProjectEntityResourceRequest body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_run_tensorboard" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `start_run_tensorboard`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `start_run_tensorboard`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `start_run_tensorboard`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `start_run_tensorboard`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/tensorboard/start",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def stop_run(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Stop run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_run(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.stop_run_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def stop_run_with_http_info(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Stop run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_run_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `stop_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `stop_run`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `stop_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/stop",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def stop_run_tensorboard(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Stop run tensorboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_run_tensorboard(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.stop_run_tensorboard_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def stop_run_tensorboard_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Stop run tensorboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_run_tensorboard_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_run_tensorboard" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `stop_run_tensorboard`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `stop_run_tensorboard`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `stop_run_tensorboard`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/tensorboard/stop",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def stop_runs(self, owner, project, body, **kwargs):  # noqa: E501
        """Stop runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_runs(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1Uuids body: Uuids of the entities (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.stop_runs_with_http_info(
            owner, project, body, **kwargs
        )  # noqa: E501

    def stop_runs_with_http_info(self, owner, project, body, **kwargs):  # noqa: E501
        """Stop runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_runs_with_http_info(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1Uuids body: Uuids of the entities (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_runs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `stop_runs`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `stop_runs`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `stop_runs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/stop",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def tag_runs(self, owner, project, body, **kwargs):  # noqa: E501
        """Tag runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tag_runs(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1EntitiesTags body: Data (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.tag_runs_with_http_info(
            owner, project, body, **kwargs
        )  # noqa: E501

    def tag_runs_with_http_info(self, owner, project, body, **kwargs):  # noqa: E501
        """Tag runs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tag_runs_with_http_info(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1EntitiesTags body: Data (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tag_runs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `tag_runs`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `tag_runs`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `tag_runs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/tag",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def unbookmark_run(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Unbookmark run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unbookmark_run(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.unbookmark_run_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def unbookmark_run_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Unbookmark run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unbookmark_run_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unbookmark_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `unbookmark_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `unbookmark_run`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `unbookmark_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/unbookmark",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_run(self, owner, project, run_uuid, body, **kwargs):  # noqa: E501
        """Update run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_run(owner, project, run_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str run_uuid: UUID (required)
        :param V1Run body: Run object (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Run
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_run_with_http_info(
            owner, project, run_uuid, body, **kwargs
        )  # noqa: E501

    def update_run_with_http_info(
        self, owner, project, run_uuid, body, **kwargs
    ):  # noqa: E501
        """Update run  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_run_with_http_info(owner, project, run_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project where the run will be assigned (required)
        :param str run_uuid: UUID (required)
        :param V1Run body: Run object (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Run, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "run_uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_run" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `update_run`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `update_run`"
            )  # noqa: E501
        # verify the required parameter 'run_uuid' is set
        if self.api_client.client_side_validation and (
            "run_uuid" not in local_var_params
            or local_var_params["run_uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `run_uuid` when calling `update_run`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `update_run`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "run_uuid" in local_var_params:
            path_params["run.uuid"] = local_var_params["run_uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{run.uuid}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Run",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def upload_run_artifact(
        self, owner, project, uuid, uploadfile, **kwargs
    ):  # noqa: E501
        """Upload an artifact file to a store via run access  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_run_artifact(owner, project, uuid, uploadfile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project having access to the store (required)
        :param str uuid: Unique integer identifier of the entity (required)
        :param file uploadfile: The file to upload. (required)
        :param str path: File path query params.
        :param bool overwrite: File path query params.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.upload_run_artifact_with_http_info(
            owner, project, uuid, uploadfile, **kwargs
        )  # noqa: E501

    def upload_run_artifact_with_http_info(
        self, owner, project, uuid, uploadfile, **kwargs
    ):  # noqa: E501
        """Upload an artifact file to a store via run access  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_run_artifact_with_http_info(owner, project, uuid, uploadfile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project having access to the store (required)
        :param str uuid: Unique integer identifier of the entity (required)
        :param file uploadfile: The file to upload. (required)
        :param str path: File path query params.
        :param bool overwrite: File path query params.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid", "uploadfile", "path", "overwrite"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_run_artifact" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `upload_run_artifact`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `upload_run_artifact`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `upload_run_artifact`"
            )  # noqa: E501
        # verify the required parameter 'uploadfile' is set
        if self.api_client.client_side_validation and (
            "uploadfile" not in local_var_params
            or local_var_params["uploadfile"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uploadfile` when calling `upload_run_artifact`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []
        if (
            "path" in local_var_params and local_var_params["path"] is not None
        ):  # noqa: E501
            query_params.append(("path", local_var_params["path"]))  # noqa: E501
        if (
            "overwrite" in local_var_params
            and local_var_params["overwrite"] is not None
        ):  # noqa: E501
            query_params.append(
                ("overwrite", local_var_params["overwrite"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if "uploadfile" in local_var_params:
            local_var_files["uploadfile"] = local_var_params["uploadfile"]  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/artifacts/upload",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def upload_run_logs(self, owner, project, uuid, uploadfile, **kwargs):  # noqa: E501
        """Upload a logs file to a store via run access  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_run_logs(owner, project, uuid, uploadfile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project having access to the store (required)
        :param str uuid: Unique integer identifier of the entity (required)
        :param file uploadfile: The file to upload. (required)
        :param str path: File path query params.
        :param bool overwrite: File path query params.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.upload_run_logs_with_http_info(
            owner, project, uuid, uploadfile, **kwargs
        )  # noqa: E501

    def upload_run_logs_with_http_info(
        self, owner, project, uuid, uploadfile, **kwargs
    ):  # noqa: E501
        """Upload a logs file to a store via run access  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_run_logs_with_http_info(owner, project, uuid, uploadfile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project having access to the store (required)
        :param str uuid: Unique integer identifier of the entity (required)
        :param file uploadfile: The file to upload. (required)
        :param str path: File path query params.
        :param bool overwrite: File path query params.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid", "uploadfile", "path", "overwrite"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_run_logs" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `upload_run_logs`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `upload_run_logs`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `upload_run_logs`"
            )  # noqa: E501
        # verify the required parameter 'uploadfile' is set
        if self.api_client.client_side_validation and (
            "uploadfile" not in local_var_params
            or local_var_params["uploadfile"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uploadfile` when calling `upload_run_logs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []
        if (
            "path" in local_var_params and local_var_params["path"] is not None
        ):  # noqa: E501
            query_params.append(("path", local_var_params["path"]))  # noqa: E501
        if (
            "overwrite" in local_var_params
            and local_var_params["overwrite"] is not None
        ):  # noqa: E501
            query_params.append(
                ("overwrite", local_var_params["overwrite"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if "uploadfile" in local_var_params:
            local_var_files["uploadfile"] = local_var_params["uploadfile"]  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/runs/{uuid}/logs/upload",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
