# Generated by Django 3.1.3 on 2020-11-23 10:46

import django.db.models.deletion
from django.db import migrations, models

import parler


class Migration(migrations.Migration):

    dependencies = [
        ("cms", "0022_auto_20180620_1551"),
        ("courses", "0020_auto_20201118_1153"),
    ]

    operations = [
        # change "on_delete" hook to allow deleting the related CMS pages
        migrations.AlterField(
            model_name="courserun",
            name="extended_object",
            field=models.OneToOneField(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="cms.page",
            ),
        ),
        migrations.AddField(
            model_name="courserun",
            name="draft_course_run",
            field=models.OneToOneField(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="public_course_run",
                to="courses.courserun",
            ),
        ),
        migrations.AddField(
            model_name="courserun",
            name="direct_course",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="runs",
                to="courses.course",
            ),
        ),
        migrations.AlterField(
            model_name="courserun",
            name="resource_link",
            field=models.CharField(
                blank=True, max_length=200, null=True, verbose_name="resource link"
            ),
        ),
        migrations.CreateModel(
            name="CourseRunTranslation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language_code",
                    models.CharField(
                        db_index=True, max_length=15, verbose_name="Language"
                    ),
                ),
                ("title", models.CharField(max_length=255, verbose_name="title")),
                (
                    "master",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="courses.courserun",
                    ),
                ),
            ],
            options={
                "verbose_name": "Course run translation",
                "db_table": "richie_course_run_translation",
                "unique_together": {("language_code", "master")},
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
    ]
