import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [appmesh-preview](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsappmeshpreview.html).
 *
 * @experimental
 */
export declare class AppmeshPreview extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [appmesh-preview](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsappmeshpreview.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a gateway route that is associated with a virtual gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_CreateGatewayRoute.html
     *
     * @experimental
     */
    toCreateGatewayRoute(): this;
    /**
     * (experimental) Grants permission to create a service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_CreateMesh.html
     *
     * @experimental
     */
    toCreateMesh(): this;
    /**
     * (experimental) Grants permission to create a route that is associated with a virtual router.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_CreateRoute.html
     *
     * @experimental
     */
    toCreateRoute(): this;
    /**
     * (experimental) Grants permission to create a virtual gateway within a service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_CreateVirtualGateway.html
     *
     * @experimental
     */
    toCreateVirtualGateway(): this;
    /**
     * (experimental) Grants permission to create a virtual node within a service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_CreateVirtualNode.html
     *
     * @experimental
     */
    toCreateVirtualNode(): this;
    /**
     * (experimental) Grants permission to create a virtual router within a service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_CreateVirtualRouter.html
     *
     * @experimental
     */
    toCreateVirtualRouter(): this;
    /**
     * (experimental) Grants permission to create a virtual service within a service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_CreateVirtualService.html
     *
     * @experimental
     */
    toCreateVirtualService(): this;
    /**
     * (experimental) Grants permission to delete an existing gateway route.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DeleteGatewayRoute.html
     *
     * @experimental
     */
    toDeleteGatewayRoute(): this;
    /**
     * (experimental) Grants permission to delete an existing service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DeleteMesh.html
     *
     * @experimental
     */
    toDeleteMesh(): this;
    /**
     * (experimental) Grants permission to delete an existing route.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DeleteRoute.html
     *
     * @experimental
     */
    toDeleteRoute(): this;
    /**
     * (experimental) Grants permission to delete an existing virtual gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DeleteVirtualGateway.html
     *
     * @experimental
     */
    toDeleteVirtualGateway(): this;
    /**
     * (experimental) Grants permission to delete an existing virtual node.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DeleteVirtualNode.html
     *
     * @experimental
     */
    toDeleteVirtualNode(): this;
    /**
     * (experimental) Grants permission to delete an existing virtual router.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DeleteVirtualRouter.html
     *
     * @experimental
     */
    toDeleteVirtualRouter(): this;
    /**
     * (experimental) Grants permission to delete an existing virtual service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DeleteVirtualService.html
     *
     * @experimental
     */
    toDeleteVirtualService(): this;
    /**
     * (experimental) Grants permission to describe an existing gateway route.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DescribeGatewayRoute.html
     *
     * @experimental
     */
    toDescribeGatewayRoute(): this;
    /**
     * (experimental) Grants permission to describe an existing service mesh.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DescribeMesh.html
     *
     * @experimental
     */
    toDescribeMesh(): this;
    /**
     * (experimental) Grants permission to describe an existing route.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DescribeRoute.html
     *
     * @experimental
     */
    toDescribeRoute(): this;
    /**
     * (experimental) Grants permission to describe an existing virtual gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DescribeVirtualGateway.html
     *
     * @experimental
     */
    toDescribeVirtualGateway(): this;
    /**
     * (experimental) Grants permission to describe an existing virtual node.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DescribeVirtualNode.html
     *
     * @experimental
     */
    toDescribeVirtualNode(): this;
    /**
     * (experimental) Grants permission to describe an existing virtual router.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DescribeVirtualRouter.html
     *
     * @experimental
     */
    toDescribeVirtualRouter(): this;
    /**
     * (experimental) Grants permission to describe an existing virtual service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_DescribeVirtualService.html
     *
     * @experimental
     */
    toDescribeVirtualService(): this;
    /**
     * (experimental) Grants permission to list existing gateway routes in a service mesh.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_ListGatewayRoutes.html
     *
     * @experimental
     */
    toListGatewayRoutes(): this;
    /**
     * (experimental) Grants permission to list existing service meshes.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_ListMeshes.html
     *
     * @experimental
     */
    toListMeshes(): this;
    /**
     * (experimental) Grants permission to list existing routes in a service mesh.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_ListRoutes.html
     *
     * @experimental
     */
    toListRoutes(): this;
    /**
     * (experimental) Grants permission to list existing virtual gateways in a service mesh.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_ListVirtualGateways.html
     *
     * @experimental
     */
    toListVirtualGateways(): this;
    /**
     * (experimental) Grants permission to list existing virtual nodes.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_ListVirtualNodes.html
     *
     * @experimental
     */
    toListVirtualNodes(): this;
    /**
     * (experimental) Grants permission to list existing virtual routers in a service mesh.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_ListVirtualRouters.html
     *
     * @experimental
     */
    toListVirtualRouters(): this;
    /**
     * (experimental) Grants permission to list existing virtual services in a service mesh.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_ListVirtualServices.html
     *
     * @experimental
     */
    toListVirtualServices(): this;
    /**
     * (experimental) Grants permission to receive streamed resources for an App Mesh endpoint (VirtualNode/VirtualGateway).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html
     *
     * @experimental
     */
    toStreamAggregatedResources(): this;
    /**
     * (experimental) Grants permission to update an existing gateway route for a specified service mesh and virtual gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_UpdateGatewayRoute.html
     *
     * @experimental
     */
    toUpdateGatewayRoute(): this;
    /**
     * (experimental) Grants permission to update an existing service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_UpdateMesh.html
     *
     * @experimental
     */
    toUpdateMesh(): this;
    /**
     * (experimental) Grants permission to update an existing route for a specified service mesh and virtual router.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_UpdateRoute.html
     *
     * @experimental
     */
    toUpdateRoute(): this;
    /**
     * (experimental) Grants permission to update an existing virtual gateway in a specified service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_UpdateVirtualGateway.html
     *
     * @experimental
     */
    toUpdateVirtualGateway(): this;
    /**
     * (experimental) Grants permission to update an existing virtual node in a specified service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_UpdateVirtualNode.html
     *
     * @experimental
     */
    toUpdateVirtualNode(): this;
    /**
     * (experimental) Grants permission to update an existing virtual router in a specified service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_UpdateVirtualRouter.html
     *
     * @experimental
     */
    toUpdateVirtualRouter(): this;
    /**
     * (experimental) Grants permission to update an existing virtual service in a specified service mesh.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/app-mesh/latest/APIReference/API_UpdateVirtualService.html
     *
     * @experimental
     */
    toUpdateVirtualService(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type mesh to the statement.
     *
     * https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html
     *
     * @param meshName - Identifier for the meshName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onMesh(meshName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type virtualService to the statement.
     *
     * https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html
     *
     * @param meshName - Identifier for the meshName.
     * @param virtualServiceName - Identifier for the virtualServiceName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onVirtualService(meshName: string, virtualServiceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type virtualNode to the statement.
     *
     * https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html
     *
     * @param meshName - Identifier for the meshName.
     * @param virtualNodeName - Identifier for the virtualNodeName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onVirtualNode(meshName: string, virtualNodeName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type virtualRouter to the statement.
     *
     * https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html
     *
     * @param meshName - Identifier for the meshName.
     * @param virtualRouterName - Identifier for the virtualRouterName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onVirtualRouter(meshName: string, virtualRouterName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type route to the statement.
     *
     * https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html
     *
     * @param meshName - Identifier for the meshName.
     * @param virtualRouterName - Identifier for the virtualRouterName.
     * @param routeName - Identifier for the routeName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onRoute(meshName: string, virtualRouterName: string, routeName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type virtualGateway to the statement.
     *
     * https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html
     *
     * @param meshName - Identifier for the meshName.
     * @param virtualGatewayName - Identifier for the virtualGatewayName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onVirtualGateway(meshName: string, virtualGatewayName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type gatewayRoute to the statement.
     *
     * https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html
     *
     * @param meshName - Identifier for the meshName.
     * @param virtualGatewayName - Identifier for the virtualGatewayName.
     * @param gatewayRouteName - Identifier for the gatewayRouteName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onGatewayRoute(meshName: string, virtualGatewayName: string, gatewayRouteName: string, account?: string, region?: string, partition?: string): this;
}
