import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [rekognition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrekognition.html).
 *
 * @experimental
 */
export declare class Rekognition extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [rekognition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrekognition.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to compare faces in the source input image with each face detected in the target input image.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CompareFaces.html
     *
     * @experimental
     */
    toCompareFaces(): this;
    /**
     * (experimental) Grants permission to create a collection in an AWS Region.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateCollection.html
     *
     * @experimental
     */
    toCreateCollection(): this;
    /**
     * (experimental) Grants permission to create a new Amazon Rekognition Custom Labels dataset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateDataset.html
     *
     * @experimental
     */
    toCreateDataset(): this;
    /**
     * (experimental) Grants permission to create an Amazon Rekognition Custom Labels project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateProject.html
     *
     * @experimental
     */
    toCreateProject(): this;
    /**
     * (experimental) Grants permission to begin training a new version of a model.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateProjectVersion.html
     *
     * @experimental
     */
    toCreateProjectVersion(): this;
    /**
     * (experimental) Grants permission to create an Amazon Rekognition stream processor.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateStreamProcessor.html
     *
     * @experimental
     */
    toCreateStreamProcessor(): this;
    /**
     * (experimental) Grants permission to delete the specified collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteCollection.html
     *
     * @experimental
     */
    toDeleteCollection(): this;
    /**
     * (experimental) Grants permission to delete an existing Amazon Rekognition Custom Labels dataset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteDataset.html
     *
     * @experimental
     */
    toDeleteDataset(): this;
    /**
     * (experimental) Grants permission to delete faces from a collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteFaces.html
     *
     * @experimental
     */
    toDeleteFaces(): this;
    /**
     * (experimental) Grants permission to delete a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteProject.html
     *
     * @experimental
     */
    toDeleteProject(): this;
    /**
     * (experimental) Grants permission to delete a model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteProjectVersion.html
     *
     * @experimental
     */
    toDeleteProjectVersion(): this;
    /**
     * (experimental) Grants permission to delete the specified stream processor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteStreamProcessor.html
     *
     * @experimental
     */
    toDeleteStreamProcessor(): this;
    /**
     * (experimental) Grants permission to read details about a collection.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeCollection.html
     *
     * @experimental
     */
    toDescribeCollection(): this;
    /**
     * (experimental) Grants permission to describe an Amazon Rekognition Custom Labels dataset.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeDataset.html
     *
     * @experimental
     */
    toDescribeDataset(): this;
    /**
     * (experimental) Grants permission to list the versions of a model in an Amazon Rekognition Custom Labels project.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeProjectVersions.html
     *
     * @experimental
     */
    toDescribeProjectVersions(): this;
    /**
     * (experimental) Grants permission to list Amazon Rekognition Custom Labels projects.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeProjects.html
     *
     * @experimental
     */
    toDescribeProjects(): this;
    /**
     * (experimental) Grants permission to get information about the specified stream processor.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeStreamProcessorh.html
     *
     * @experimental
     */
    toDescribeStreamProcessor(): this;
    /**
     * (experimental) Grants permission to detect custom labels in a supplied image.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectCustomLabels.html
     *
     * @experimental
     */
    toDetectCustomLabels(): this;
    /**
     * (experimental) Grants permission to detect human faces within an image provided as input.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectFaces.html
     *
     * @experimental
     */
    toDetectFaces(): this;
    /**
     * (experimental) Grants permission to detect instances of real-world labels within an image provided as input.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectLabels.html
     *
     * @experimental
     */
    toDetectLabels(): this;
    /**
     * (experimental) Grants permission to detect moderation labels within the input image.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectModerationLabels.html
     *
     * @experimental
     */
    toDetectModerationLabels(): this;
    /**
     * (experimental) Grants permission to detect Personal Protective Equipment in the input image.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectProtectiveEquipment.html
     *
     * @experimental
     */
    toDetectProtectiveEquipment(): this;
    /**
     * (experimental) Grants permission to detect text in the input image and convert it into machine-readable text.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectText.html
     *
     * @experimental
     */
    toDetectText(): this;
    /**
     * (experimental) Grants permission to distribute the entries in a training dataset across the training dataset and the test dataset for a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DistributeDatasetEntries.html
     *
     * @experimental
     */
    toDistributeDatasetEntries(): this;
    /**
     * (experimental) Grants permission to read the name, and additional information, of a celebrity.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetCelebrityInfo.html
     *
     * @experimental
     */
    toGetCelebrityInfo(): this;
    /**
     * (experimental) Grants permission to read the celebrity recognition results found in a stored video by an asynchronous celebrity recognition job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetCelebrityRecognition.html
     *
     * @experimental
     */
    toGetCelebrityRecognition(): this;
    /**
     * (experimental) Grants permission to read the content moderation analysis results found in a stored video by an asynchronous content moderation job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetContentModeration.html
     *
     * @experimental
     */
    toGetContentModeration(): this;
    /**
     * (experimental) Grants permission to read the faces detection results found in a stored video by an asynchronous face detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetFaceDetection.html
     *
     * @experimental
     */
    toGetFaceDetection(): this;
    /**
     * (experimental) Grants permission to read the matching collection faces found in a stored video by an asynchronous face search job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetFaceSearch.html
     *
     * @experimental
     */
    toGetFaceSearch(): this;
    /**
     * (experimental) Grants permission to read the label detected resuls found in a stored video by an asynchronous label detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetLabelDetection.html
     *
     * @experimental
     */
    toGetLabelDetection(): this;
    /**
     * (experimental) Grants permission to read the list of persons detected in a stored video by an asynchronous person tracking job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetPersonTracking.html
     *
     * @experimental
     */
    toGetPersonTracking(): this;
    /**
     * (experimental) Grants permission to get the vdeo segments found in a stored video by an asynchronous segment detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetSegmentDetection.html
     *
     * @experimental
     */
    toGetSegmentDetection(): this;
    /**
     * (experimental) Grants permission to get the text found in a stored video by an asynchronous text detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetTextDetection.html
     *
     * @experimental
     */
    toGetTextDetection(): this;
    /**
     * (experimental) Grants permission to update an existing collection with faces detected in the input image.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_IndexFaces.html
     *
     * @experimental
     */
    toIndexFaces(): this;
    /**
     * (experimental) Grants permission to read the collection Id's in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListCollections.html
     *
     * @experimental
     */
    toListCollections(): this;
    /**
     * (experimental) Grants permission to list the dataset entries in an existing Amazon Rekognition Custom Labels dataset.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListDatasetEntries.html
     *
     * @experimental
     */
    toListDatasetEntries(): this;
    /**
     * (experimental) Grants permission to list the labels in a dataset.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListDatasetLabels.html
     *
     * @experimental
     */
    toListDatasetLabels(): this;
    /**
     * (experimental) Grants permission to read metadata for faces in the specificed collection.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListFaces.html
     *
     * @experimental
     */
    toListFaces(): this;
    /**
     * (experimental) Grants permission to get a list of your stream processors.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListStreamProcessors.html
     *
     * @experimental
     */
    toListStreamProcessors(): this;
    /**
     * (experimental) Grants permission to return a list of tags associated with a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to detect celebrities in the input image.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_RecognizeCelebrities.html
     *
     * @experimental
     */
    toRecognizeCelebrities(): this;
    /**
     * (experimental) Grants permission to search the specificed collection for the supplied face ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_SearchFaces.html
     *
     * @experimental
     */
    toSearchFaces(): this;
    /**
     * (experimental) Grants permission to search the specificed collection for the largest face in the input image.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_SearchFacesByImage.html
     *
     * @experimental
     */
    toSearchFacesByImage(): this;
    /**
     * (experimental) Grants permission to start the asynchronous recognition of celebrities in a stored video.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartCelebrityRecognition.html
     *
     * @experimental
     */
    toStartCelebrityRecognition(): this;
    /**
     * (experimental) Grants permission to start asynchronous detection of explicit or suggestive adult content in a stored video.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartContentModeration.html
     *
     * @experimental
     */
    toStartContentModeration(): this;
    /**
     * (experimental) Grants permission to start asynchronous detection of faces in a stored video.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartFaceDetection.html
     *
     * @experimental
     */
    toStartFaceDetection(): this;
    /**
     * (experimental) Grants permission to start an asynchronous search for faces in a collection that match the faces of persons detected in a stored video.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartFaceSearch.html
     *
     * @experimental
     */
    toStartFaceSearch(): this;
    /**
     * (experimental) Grants permission to start asynchronous detection of labels in a stored video.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartLabelDetection.html
     *
     * @experimental
     */
    toStartLabelDetection(): this;
    /**
     * (experimental) Grants permission to start the asynchronous tracking of persons in a stored video.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartPersonTracking.html
     *
     * @experimental
     */
    toStartPersonTracking(): this;
    /**
     * (experimental) Grants permission to start running a model version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartProjectVersion.html
     *
     * @experimental
     */
    toStartProjectVersion(): this;
    /**
     * (experimental) Grants permission to start the asynchronous detection of segments in a stored video.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartSegmentDetection.html
     *
     * @experimental
     */
    toStartSegmentDetection(): this;
    /**
     * (experimental) Grants permission to start running a stream processor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartStreamProcessor.html
     *
     * @experimental
     */
    toStartStreamProcessor(): this;
    /**
     * (experimental) Grants permission to start the asynchronous detection of text in a stored video.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartTextDetection.html
     *
     * @experimental
     */
    toStartTextDetection(): this;
    /**
     * (experimental) Grants permission to stop a running model version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StopProjectVersion.html
     *
     * @experimental
     */
    toStopProjectVersion(): this;
    /**
     * (experimental) Grants permission to stop a running stream processor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StopStreamProcessor.html
     *
     * @experimental
     */
    toStopStreamProcessor(): this;
    /**
     * (experimental) Grants permission to add one or more tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove one or more tags from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to add or update one or more JSON Lines (entries) in a dataset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_UpdateDatasetEntries.html
     *
     * @experimental
     */
    toUpdateDatasetEntries(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type collection to the statement.
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/howitworks-collection.html
     *
     * @param collectionId - Identifier for the collectionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCollection(collectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type streamprocessor to the statement.
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/using-rekognition-video-stream-processor.html
     *
     * @param streamprocessorId - Identifier for the streamprocessorId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onStreamprocessor(streamprocessorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type project to the statement.
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/cp-create-project.html
     *
     * @param projectName - Identifier for the projectName.
     * @param creationTimestamp - Identifier for the creationTimestamp.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onProject(projectName: string, creationTimestamp: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type projectversion to the statement.
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateProjectVersion.html
     *
     * @param projectName - Identifier for the projectName.
     * @param versionName - Identifier for the versionName.
     * @param creationTimestamp - Identifier for the creationTimestamp.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onProjectversion(projectName: string, versionName: string, creationTimestamp: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dataset to the statement.
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/cd-create-dataset.html
     *
     * @param projectName - Identifier for the projectName.
     * @param creationTimestamp - Identifier for the creationTimestamp.
     * @param datasetType - Identifier for the datasetType.
     * @param creationTimestamp2 - Identifier for the creationTimestamp2.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDataset(projectName: string, creationTimestamp: string, datasetType: string, creationTimestamp2: string, account?: string, region?: string, partition?: string): this;
}
