"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Translate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
 *
 * @experimental
 */
class Translate extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'translate';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'CreateParallelData',
                'DeleteParallelData',
                'DeleteTerminology',
                'ImportTerminology',
                'StartTextTranslationJob',
                'StopTextTranslationJob',
                'UpdateParallelData'
            ],
            Read: [
                'DescribeTextTranslationJob',
                'GetParallelData',
                'GetTerminology',
                'TranslateText'
            ],
            List: [
                'ListParallelData',
                'ListTerminologies',
                'ListTextTranslationJobs'
            ]
        };
    }
    /**
     * (experimental) Grants permission to create a Parallel Data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_CreateParallelData.html
     *
     * @experimental
     */
    toCreateParallelData() {
        return this.to('CreateParallelData');
    }
    /**
     * (experimental) Grants permission to delete a Parallel Data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteParallelData.html
     *
     * @experimental
     */
    toDeleteParallelData() {
        return this.to('DeleteParallelData');
    }
    /**
     * (experimental) Grants permission to delete a terminology.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html
     *
     * @experimental
     */
    toDeleteTerminology() {
        return this.to('DeleteTerminology');
    }
    /**
     * (experimental) Grants permission to get the properties associated with an asynchronous batch translation job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html
     *
     * @experimental
     */
    toDescribeTextTranslationJob() {
        return this.to('DescribeTextTranslationJob');
    }
    /**
     * (experimental) Grants permission to get a Parallel Data.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetParallelData.html
     *
     * @experimental
     */
    toGetParallelData() {
        return this.to('GetParallelData');
    }
    /**
     * (experimental) Grants permission to retrieve a terminology.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html
     *
     * @experimental
     */
    toGetTerminology() {
        return this.to('GetTerminology');
    }
    /**
     * (experimental) Grants permission to create or update a terminology, depending on whether or not one already exists for the given terminology name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html
     *
     * @experimental
     */
    toImportTerminology() {
        return this.to('ImportTerminology');
    }
    /**
     * (experimental) Grants permission to list Parallel Data associated with your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListParallelData.html
     *
     * @experimental
     */
    toListParallelData() {
        return this.to('ListParallelData');
    }
    /**
     * (experimental) Grants permission to list terminologies associated with your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html
     *
     * @experimental
     */
    toListTerminologies() {
        return this.to('ListTerminologies');
    }
    /**
     * (experimental) Grants permission to list batch translation jobs that you have submitted.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html
     *
     * @experimental
     */
    toListTextTranslationJobs() {
        return this.to('ListTextTranslationJobs');
    }
    /**
     * (experimental) Grants permission to start an asynchronous batch translation job.
     *
     * Batch translation jobs can be used to translate large volumes of text across multiple documents at once
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html
     *
     * @experimental
     */
    toStartTextTranslationJob() {
        return this.to('StartTextTranslationJob');
    }
    /**
     * (experimental) Grants permission to stop an asynchronous batch translation job that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html
     *
     * @experimental
     */
    toStopTextTranslationJob() {
        return this.to('StopTextTranslationJob');
    }
    /**
     * (experimental) Grants permission to translate text from a source language to a target language.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html
     *
     * @experimental
     */
    toTranslateText() {
        return this.to('TranslateText');
    }
    /**
     * (experimental) Grants permission to update an existing Parallel Data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_UpdateParallelData.html
     *
     * @experimental
     */
    toUpdateParallelData() {
        return this.to('UpdateParallelData');
    }
}
exports.Translate = Translate;
_a = JSII_RTTI_SYMBOL_1;
Translate[_a] = { fqn: "iam-floyd.Translate", version: "0.275.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJhbnNsYXRlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidHJhbnNsYXRlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esc0NBQTRDOzs7Ozs7QUFHNUMsTUFBYSxTQUFVLFNBQVEsd0JBQWU7Ozs7Ozs7SUFJNUMsWUFBWSxHQUFZO1FBQ3RCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQzs7Ozs7O1FBSk4sa0JBQWEsR0FBRyxXQUFXLENBQUM7Ozs7UUE2RXpCLG9CQUFlLEdBQW9CO1lBQzNDLEtBQUssRUFBRTtnQkFDTCxvQkFBb0I7Z0JBQ3BCLG9CQUFvQjtnQkFDcEIsbUJBQW1CO2dCQUNuQixtQkFBbUI7Z0JBQ25CLHlCQUF5QjtnQkFDekIsd0JBQXdCO2dCQUN4QixvQkFBb0I7YUFDckI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osNEJBQTRCO2dCQUM1QixpQkFBaUI7Z0JBQ2pCLGdCQUFnQjtnQkFDaEIsZUFBZTthQUNoQjtZQUNELElBQUksRUFBRTtnQkFDSixrQkFBa0I7Z0JBQ2xCLG1CQUFtQjtnQkFDbkIseUJBQXlCO2FBQzFCO1NBQ0YsQ0FBQztJQTdGRixDQUFDOzs7Ozs7Ozs7O0lBR00sb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQzs7Ozs7Ozs7OztJQUdNLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDOzs7Ozs7Ozs7O0lBR00sNEJBQTRCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO0lBQy9DLENBQUM7Ozs7Ozs7Ozs7SUFHTSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDOzs7Ozs7Ozs7O0lBR00sbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQzs7Ozs7Ozs7OztJQUdNLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDOzs7Ozs7Ozs7O0lBR00seUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7Ozs7Ozs7Ozs7OztJQUdNLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDOzs7Ozs7Ozs7O0lBR00sd0JBQXdCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDOzs7Ozs7Ozs7O0lBR00sb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7O0FBNUVILDhCQW9HQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnLi4vc2hhcmVkJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBUcmFuc2xhdGUgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICd0cmFuc2xhdGUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3Ioc2lkPzogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2lkKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9DcmVhdGVQYXJhbGxlbERhdGEoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVBhcmFsbGVsRGF0YScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZVBhcmFsbGVsRGF0YSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlUGFyYWxsZWxEYXRhJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVsZXRlVGVybWlub2xvZ3koKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVRlcm1pbm9sb2d5Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVzY3JpYmVUZXh0VHJhbnNsYXRpb25Kb2IoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlVGV4dFRyYW5zbGF0aW9uSm9iJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRQYXJhbGxlbERhdGEoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFBhcmFsbGVsRGF0YScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRUZXJtaW5vbG9neSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0VGVybWlub2xvZ3knKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0ltcG9ydFRlcm1pbm9sb2d5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdJbXBvcnRUZXJtaW5vbG9neScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0UGFyYWxsZWxEYXRhKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UGFyYWxsZWxEYXRhJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0VGVybWlub2xvZ2llcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFRlcm1pbm9sb2dpZXMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0VGV4dFRyYW5zbGF0aW9uSm9icygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFRleHRUcmFuc2xhdGlvbkpvYnMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1N0YXJ0VGV4dFRyYW5zbGF0aW9uSm9iKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydFRleHRUcmFuc2xhdGlvbkpvYicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvU3RvcFRleHRUcmFuc2xhdGlvbkpvYigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU3RvcFRleHRUcmFuc2xhdGlvbkpvYicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1RyYW5zbGF0ZVRleHQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1RyYW5zbGF0ZVRleHQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvVXBkYXRlUGFyYWxsZWxEYXRhKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVQYXJhbGxlbERhdGEnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ0NyZWF0ZVBhcmFsbGVsRGF0YScsXG4gICAgICAnRGVsZXRlUGFyYWxsZWxEYXRhJyxcbiAgICAgICdEZWxldGVUZXJtaW5vbG9neScsXG4gICAgICAnSW1wb3J0VGVybWlub2xvZ3knLFxuICAgICAgJ1N0YXJ0VGV4dFRyYW5zbGF0aW9uSm9iJyxcbiAgICAgICdTdG9wVGV4dFRyYW5zbGF0aW9uSm9iJyxcbiAgICAgICdVcGRhdGVQYXJhbGxlbERhdGEnXG4gICAgXSxcbiAgICBSZWFkOiBbXG4gICAgICAnRGVzY3JpYmVUZXh0VHJhbnNsYXRpb25Kb2InLFxuICAgICAgJ0dldFBhcmFsbGVsRGF0YScsXG4gICAgICAnR2V0VGVybWlub2xvZ3knLFxuICAgICAgJ1RyYW5zbGF0ZVRleHQnXG4gICAgXSxcbiAgICBMaXN0OiBbXG4gICAgICAnTGlzdFBhcmFsbGVsRGF0YScsXG4gICAgICAnTGlzdFRlcm1pbm9sb2dpZXMnLFxuICAgICAgJ0xpc3RUZXh0VHJhbnNsYXRpb25Kb2JzJ1xuICAgIF1cbiAgfTtcbn1cbiJdfQ==