<a id="mypy-boto3-networkmanager"></a>

# mypy-boto3-networkmanager

[![PyPI - mypy-boto3-networkmanager](https://img.shields.io/pypi/v/mypy-boto3-networkmanager.svg?color=blue)](https://pypi.org/project/mypy-boto3-networkmanager)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-networkmanager.svg?color=blue)](https://pypi.org/project/mypy-boto3-networkmanager)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-networkmanager?color=blue)](https://pypistats.org/packages/mypy-boto3-networkmanager)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.NetworkManager 1.20.35](https://boto3.amazonaws.com/v1/documentation/api/1.20.35/reference/services/networkmanager.html#NetworkManager)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.3.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-networkmanager docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_networkmanager/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-networkmanager](#mypy-boto3-networkmanager)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `NetworkManager`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `NetworkManager` service.

```bash
python -m pip install boto3-stubs[networkmanager]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[networkmanager]` in your environment:
  `python -m pip install 'boto3-stubs[networkmanager]'`

Both type checking and auto-complete should work for `NetworkManager` service.
No explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[networkmanager]` in your environment:
  `python -m pip install 'boto3-stubs[networkmanager]'`

Both type checking and auto-complete should work for `NetworkManager` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[networkmanager]` in your environment:
  `python -m pip install 'boto3-stubs[networkmanager]'`
- Run `mypy` as usual

Type checking should work for `NetworkManager` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[networkmanager]` in your environment:
  `python -m pip install 'boto3-stubs[networkmanager]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `NetworkManager` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`NetworkManagerClient` provides annotations for
`boto3.client("networkmanager")`.

```python
import boto3

from mypy_boto3_networkmanager import NetworkManagerClient

client: NetworkManagerClient = boto3.client("networkmanager")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: NetworkManagerClient = session.client("networkmanager")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_networkmanager.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_networkmanager import NetworkManagerClient
from mypy_boto3_networkmanager.paginator import (
    DescribeGlobalNetworksPaginator,
    GetConnectPeerAssociationsPaginator,
    GetConnectionsPaginator,
    GetCoreNetworkChangeSetPaginator,
    GetCustomerGatewayAssociationsPaginator,
    GetDevicesPaginator,
    GetLinkAssociationsPaginator,
    GetLinksPaginator,
    GetNetworkResourceCountsPaginator,
    GetNetworkResourceRelationshipsPaginator,
    GetNetworkResourcesPaginator,
    GetNetworkTelemetryPaginator,
    GetSitesPaginator,
    GetTransitGatewayConnectPeerAssociationsPaginator,
    GetTransitGatewayRegistrationsPaginator,
    ListAttachmentsPaginator,
    ListConnectPeersPaginator,
    ListCoreNetworkPolicyVersionsPaginator,
    ListCoreNetworksPaginator,
)

client: NetworkManagerClient = boto3.client("networkmanager")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_global_networks_paginator: DescribeGlobalNetworksPaginator = client.get_paginator("describe_global_networks")
get_connect_peer_associations_paginator: GetConnectPeerAssociationsPaginator = client.get_paginator("get_connect_peer_associations")
get_connections_paginator: GetConnectionsPaginator = client.get_paginator("get_connections")
get_core_network_change_set_paginator: GetCoreNetworkChangeSetPaginator = client.get_paginator("get_core_network_change_set")
get_customer_gateway_associations_paginator: GetCustomerGatewayAssociationsPaginator = client.get_paginator("get_customer_gateway_associations")
get_devices_paginator: GetDevicesPaginator = client.get_paginator("get_devices")
get_link_associations_paginator: GetLinkAssociationsPaginator = client.get_paginator("get_link_associations")
get_links_paginator: GetLinksPaginator = client.get_paginator("get_links")
get_network_resource_counts_paginator: GetNetworkResourceCountsPaginator = client.get_paginator("get_network_resource_counts")
get_network_resource_relationships_paginator: GetNetworkResourceRelationshipsPaginator = client.get_paginator("get_network_resource_relationships")
get_network_resources_paginator: GetNetworkResourcesPaginator = client.get_paginator("get_network_resources")
get_network_telemetry_paginator: GetNetworkTelemetryPaginator = client.get_paginator("get_network_telemetry")
get_sites_paginator: GetSitesPaginator = client.get_paginator("get_sites")
get_transit_gateway_connect_peer_associations_paginator: GetTransitGatewayConnectPeerAssociationsPaginator = client.get_paginator("get_transit_gateway_connect_peer_associations")
get_transit_gateway_registrations_paginator: GetTransitGatewayRegistrationsPaginator = client.get_paginator("get_transit_gateway_registrations")
list_attachments_paginator: ListAttachmentsPaginator = client.get_paginator("list_attachments")
list_connect_peers_paginator: ListConnectPeersPaginator = client.get_paginator("list_connect_peers")
list_core_network_policy_versions_paginator: ListCoreNetworkPolicyVersionsPaginator = client.get_paginator("list_core_network_policy_versions")
list_core_networks_paginator: ListCoreNetworksPaginator = client.get_paginator("list_core_networks")
```

<a id="literals"></a>

### Literals

`mypy_boto3_networkmanager.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_networkmanager.literals import (
    AttachmentStateType,
    AttachmentTypeType,
    ChangeActionType,
    ChangeSetStateType,
    ChangeTypeType,
    ConnectPeerAssociationStateType,
    ConnectPeerStateType,
    ConnectionStateType,
    ConnectionStatusType,
    ConnectionTypeType,
    CoreNetworkPolicyAliasType,
    CoreNetworkStateType,
    CustomerGatewayAssociationStateType,
    DescribeGlobalNetworksPaginatorName,
    DeviceStateType,
    GetConnectPeerAssociationsPaginatorName,
    GetConnectionsPaginatorName,
    GetCoreNetworkChangeSetPaginatorName,
    GetCustomerGatewayAssociationsPaginatorName,
    GetDevicesPaginatorName,
    GetLinkAssociationsPaginatorName,
    GetLinksPaginatorName,
    GetNetworkResourceCountsPaginatorName,
    GetNetworkResourceRelationshipsPaginatorName,
    GetNetworkResourcesPaginatorName,
    GetNetworkTelemetryPaginatorName,
    GetSitesPaginatorName,
    GetTransitGatewayConnectPeerAssociationsPaginatorName,
    GetTransitGatewayRegistrationsPaginatorName,
    GlobalNetworkStateType,
    LinkAssociationStateType,
    LinkStateType,
    ListAttachmentsPaginatorName,
    ListConnectPeersPaginatorName,
    ListCoreNetworkPolicyVersionsPaginatorName,
    ListCoreNetworksPaginatorName,
    RouteAnalysisCompletionReasonCodeType,
    RouteAnalysisCompletionResultCodeType,
    RouteAnalysisStatusType,
    RouteStateType,
    RouteTableTypeType,
    RouteTypeType,
    SiteStateType,
    TransitGatewayConnectPeerAssociationStateType,
    TransitGatewayRegistrationStateType,
    TunnelProtocolType,
    ServiceName,
    PaginatorName,
)

def check_value(value: AttachmentStateType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_networkmanager.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_networkmanager.type_defs import (
    AWSLocationTypeDef,
    AcceptAttachmentRequestRequestTypeDef,
    AcceptAttachmentResponseTypeDef,
    AssociateConnectPeerRequestRequestTypeDef,
    AssociateConnectPeerResponseTypeDef,
    AssociateCustomerGatewayRequestRequestTypeDef,
    AssociateCustomerGatewayResponseTypeDef,
    AssociateLinkRequestRequestTypeDef,
    AssociateLinkResponseTypeDef,
    AssociateTransitGatewayConnectPeerRequestRequestTypeDef,
    AssociateTransitGatewayConnectPeerResponseTypeDef,
    AttachmentTypeDef,
    BandwidthTypeDef,
    BgpOptionsTypeDef,
    ConnectAttachmentOptionsTypeDef,
    ConnectAttachmentTypeDef,
    ConnectPeerAssociationTypeDef,
    ConnectPeerBgpConfigurationTypeDef,
    ConnectPeerConfigurationTypeDef,
    ConnectPeerSummaryTypeDef,
    ConnectPeerTypeDef,
    ConnectionHealthTypeDef,
    ConnectionTypeDef,
    CoreNetworkChangeTypeDef,
    CoreNetworkChangeValuesTypeDef,
    CoreNetworkEdgeTypeDef,
    CoreNetworkPolicyErrorTypeDef,
    CoreNetworkPolicyTypeDef,
    CoreNetworkPolicyVersionTypeDef,
    CoreNetworkSegmentEdgeIdentifierTypeDef,
    CoreNetworkSegmentTypeDef,
    CoreNetworkSummaryTypeDef,
    CoreNetworkTypeDef,
    CreateConnectAttachmentRequestRequestTypeDef,
    CreateConnectAttachmentResponseTypeDef,
    CreateConnectPeerRequestRequestTypeDef,
    CreateConnectPeerResponseTypeDef,
    CreateConnectionRequestRequestTypeDef,
    CreateConnectionResponseTypeDef,
    CreateCoreNetworkRequestRequestTypeDef,
    CreateCoreNetworkResponseTypeDef,
    CreateDeviceRequestRequestTypeDef,
    CreateDeviceResponseTypeDef,
    CreateGlobalNetworkRequestRequestTypeDef,
    CreateGlobalNetworkResponseTypeDef,
    CreateLinkRequestRequestTypeDef,
    CreateLinkResponseTypeDef,
    CreateSiteRequestRequestTypeDef,
    CreateSiteResponseTypeDef,
    CreateSiteToSiteVpnAttachmentRequestRequestTypeDef,
    CreateSiteToSiteVpnAttachmentResponseTypeDef,
    CreateVpcAttachmentRequestRequestTypeDef,
    CreateVpcAttachmentResponseTypeDef,
    CustomerGatewayAssociationTypeDef,
    DeleteAttachmentRequestRequestTypeDef,
    DeleteAttachmentResponseTypeDef,
    DeleteConnectPeerRequestRequestTypeDef,
    DeleteConnectPeerResponseTypeDef,
    DeleteConnectionRequestRequestTypeDef,
    DeleteConnectionResponseTypeDef,
    DeleteCoreNetworkPolicyVersionRequestRequestTypeDef,
    DeleteCoreNetworkPolicyVersionResponseTypeDef,
    DeleteCoreNetworkRequestRequestTypeDef,
    DeleteCoreNetworkResponseTypeDef,
    DeleteDeviceRequestRequestTypeDef,
    DeleteDeviceResponseTypeDef,
    DeleteGlobalNetworkRequestRequestTypeDef,
    DeleteGlobalNetworkResponseTypeDef,
    DeleteLinkRequestRequestTypeDef,
    DeleteLinkResponseTypeDef,
    DeleteResourcePolicyRequestRequestTypeDef,
    DeleteSiteRequestRequestTypeDef,
    DeleteSiteResponseTypeDef,
    DeregisterTransitGatewayRequestRequestTypeDef,
    DeregisterTransitGatewayResponseTypeDef,
    DescribeGlobalNetworksRequestRequestTypeDef,
    DescribeGlobalNetworksResponseTypeDef,
    DeviceTypeDef,
    DisassociateConnectPeerRequestRequestTypeDef,
    DisassociateConnectPeerResponseTypeDef,
    DisassociateCustomerGatewayRequestRequestTypeDef,
    DisassociateCustomerGatewayResponseTypeDef,
    DisassociateLinkRequestRequestTypeDef,
    DisassociateLinkResponseTypeDef,
    DisassociateTransitGatewayConnectPeerRequestRequestTypeDef,
    DisassociateTransitGatewayConnectPeerResponseTypeDef,
    ExecuteCoreNetworkChangeSetRequestRequestTypeDef,
    GetConnectAttachmentRequestRequestTypeDef,
    GetConnectAttachmentResponseTypeDef,
    GetConnectPeerAssociationsRequestRequestTypeDef,
    GetConnectPeerAssociationsResponseTypeDef,
    GetConnectPeerRequestRequestTypeDef,
    GetConnectPeerResponseTypeDef,
    GetConnectionsRequestRequestTypeDef,
    GetConnectionsResponseTypeDef,
    GetCoreNetworkChangeSetRequestRequestTypeDef,
    GetCoreNetworkChangeSetResponseTypeDef,
    GetCoreNetworkPolicyRequestRequestTypeDef,
    GetCoreNetworkPolicyResponseTypeDef,
    GetCoreNetworkRequestRequestTypeDef,
    GetCoreNetworkResponseTypeDef,
    GetCustomerGatewayAssociationsRequestRequestTypeDef,
    GetCustomerGatewayAssociationsResponseTypeDef,
    GetDevicesRequestRequestTypeDef,
    GetDevicesResponseTypeDef,
    GetLinkAssociationsRequestRequestTypeDef,
    GetLinkAssociationsResponseTypeDef,
    GetLinksRequestRequestTypeDef,
    GetLinksResponseTypeDef,
    GetNetworkResourceCountsRequestRequestTypeDef,
    GetNetworkResourceCountsResponseTypeDef,
    GetNetworkResourceRelationshipsRequestRequestTypeDef,
    GetNetworkResourceRelationshipsResponseTypeDef,
    GetNetworkResourcesRequestRequestTypeDef,
    GetNetworkResourcesResponseTypeDef,
    GetNetworkRoutesRequestRequestTypeDef,
    GetNetworkRoutesResponseTypeDef,
    GetNetworkTelemetryRequestRequestTypeDef,
    GetNetworkTelemetryResponseTypeDef,
    GetResourcePolicyRequestRequestTypeDef,
    GetResourcePolicyResponseTypeDef,
    GetRouteAnalysisRequestRequestTypeDef,
    GetRouteAnalysisResponseTypeDef,
    GetSiteToSiteVpnAttachmentRequestRequestTypeDef,
    GetSiteToSiteVpnAttachmentResponseTypeDef,
    GetSitesRequestRequestTypeDef,
    GetSitesResponseTypeDef,
    GetTransitGatewayConnectPeerAssociationsRequestRequestTypeDef,
    GetTransitGatewayConnectPeerAssociationsResponseTypeDef,
    GetTransitGatewayRegistrationsRequestRequestTypeDef,
    GetTransitGatewayRegistrationsResponseTypeDef,
    GetVpcAttachmentRequestRequestTypeDef,
    GetVpcAttachmentResponseTypeDef,
    GlobalNetworkTypeDef,
    LinkAssociationTypeDef,
    LinkTypeDef,
    ListAttachmentsRequestRequestTypeDef,
    ListAttachmentsResponseTypeDef,
    ListConnectPeersRequestRequestTypeDef,
    ListConnectPeersResponseTypeDef,
    ListCoreNetworkPolicyVersionsRequestRequestTypeDef,
    ListCoreNetworkPolicyVersionsResponseTypeDef,
    ListCoreNetworksRequestRequestTypeDef,
    ListCoreNetworksResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    LocationTypeDef,
    NetworkResourceCountTypeDef,
    NetworkResourceSummaryTypeDef,
    NetworkResourceTypeDef,
    NetworkRouteDestinationTypeDef,
    NetworkRouteTypeDef,
    NetworkTelemetryTypeDef,
    PaginatorConfigTypeDef,
    PathComponentTypeDef,
    ProposedSegmentChangeTypeDef,
    PutCoreNetworkPolicyRequestRequestTypeDef,
    PutCoreNetworkPolicyResponseTypeDef,
    PutResourcePolicyRequestRequestTypeDef,
    RegisterTransitGatewayRequestRequestTypeDef,
    RegisterTransitGatewayResponseTypeDef,
    RejectAttachmentRequestRequestTypeDef,
    RejectAttachmentResponseTypeDef,
    RelationshipTypeDef,
    ResponseMetadataTypeDef,
    RestoreCoreNetworkPolicyVersionRequestRequestTypeDef,
    RestoreCoreNetworkPolicyVersionResponseTypeDef,
    RouteAnalysisCompletionTypeDef,
    RouteAnalysisEndpointOptionsSpecificationTypeDef,
    RouteAnalysisEndpointOptionsTypeDef,
    RouteAnalysisPathTypeDef,
    RouteAnalysisTypeDef,
    RouteTableIdentifierTypeDef,
    SiteToSiteVpnAttachmentTypeDef,
    SiteTypeDef,
    StartRouteAnalysisRequestRequestTypeDef,
    StartRouteAnalysisResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    TransitGatewayConnectPeerAssociationTypeDef,
    TransitGatewayRegistrationStateReasonTypeDef,
    TransitGatewayRegistrationTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateConnectionRequestRequestTypeDef,
    UpdateConnectionResponseTypeDef,
    UpdateCoreNetworkRequestRequestTypeDef,
    UpdateCoreNetworkResponseTypeDef,
    UpdateDeviceRequestRequestTypeDef,
    UpdateDeviceResponseTypeDef,
    UpdateGlobalNetworkRequestRequestTypeDef,
    UpdateGlobalNetworkResponseTypeDef,
    UpdateLinkRequestRequestTypeDef,
    UpdateLinkResponseTypeDef,
    UpdateNetworkResourceMetadataRequestRequestTypeDef,
    UpdateNetworkResourceMetadataResponseTypeDef,
    UpdateSiteRequestRequestTypeDef,
    UpdateSiteResponseTypeDef,
    UpdateVpcAttachmentRequestRequestTypeDef,
    UpdateVpcAttachmentResponseTypeDef,
    VpcAttachmentTypeDef,
    VpcOptionsTypeDef,
)

def get_structure() -> AWSLocationTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-networkmanager` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-networkmanager docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_networkmanager/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
