# File generated from our OpenAPI spec by Stainless.

from typing import Dict, List, Optional
from typing_extensions import Literal

from ...types import ledger_entry
from ..._models import BaseModel

__all__ = ["LedgerTransactionVersion"]


class LedgerTransactionVersion(BaseModel):
    created_at: str

    description: Optional[str]
    """An optional description for internal use."""

    effective_date: str
    """
    The date (YYYY-MM-DD) on which the ledger transaction happened for reporting
    purposes.
    """

    external_id: Optional[str]
    """A unique string to represent the ledger transaction.

    Only one pending or posted ledger transaction may have this ID in the ledger.
    """

    id: str

    ledger_entries: List[ledger_entry.LedgerEntry]
    """An array of ledger entry objects."""

    ledger_id: str
    """The ID of the ledger this ledger transaction belongs to."""

    ledger_transaction_id: str
    """The ID of the ledger transaction"""

    ledgerable_id: Optional[str]
    """
    If the ledger transaction can be reconciled to another object in Modern
    Treasury, the id will be populated here, otherwise null.
    """

    ledgerable_type: Optional[
        Literal[
            "counterparty",
            "expected_payment",
            "incoming_payment_detail",
            "internal_account",
            "line_item",
            "paper_item",
            "payment_order",
            "payment_order_attempt",
            "return",
            "reversal",
        ]
    ]
    """
    If the ledger transaction can be reconciled to another object in Modern
    Treasury, the type will be populated here, otherwise null. This can be one of
    payment_order, incoming_payment_detail, expected_payment, return, or reversal.
    """

    live_mode: bool
    """
    This field will be true if this object exists in the live environment or false
    if it exists in the test environment.
    """

    metadata: Dict[str, str]
    """Additional data represented as key-value pairs.

    Both the key and value must be strings.
    """

    object: str

    posted_at: Optional[str]
    """The time on which the ledger transaction posted.

    This is null if the ledger transaction is pending.
    """

    status: Literal["archived", "pending", "posted"]
    """One of `pending`, `posted`, or `archived`"""

    version: int
    """Version number of the ledger transaction."""
