# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['src']

package_data = \
{'': ['*']}

install_requires = \
['rich>=13.3.1,<14.0.0']

entry_points = \
{'console_scripts': ['pytuist = src.main:main']}

setup_kwargs = {
    'name': 'pytuist',
    'version': '0.0.1a3',
    'description': 'A TUI (terminal user interface) for pytest, because testing should be fun.',
    'long_description': '# pytuist\n\nA TUI (terminal user interface) for pytest\n\nI personally love TUI tools - so why not learn how to make my own and create something that would be valuable for my day-to-day work?\n\n## Installation\n\n```\npip install pytuist\n```\n\n**Note** this package is only available for Windows at the moment. I will look to add support for Linux and MacOS in the future.\n\nIf someone could show me how on earth I specify that with Poetry, that would be great.\n\n## Usage\n\nWithin a project with tests conforming to [pytest](https://docs.pytest.org/en/7.2.x/ "pytest homepage") requirements, run `pytuist` to start the UI within the active terminal:\n\n```plaintext\n╭─────────────────────────────────────────────────────────────────────────────────────────── pytuist ───────────────────────────────────────────────────────────────────────────────────────────╮\n│ arrows: navigate | enter: expand/collapse | space: run | q: quit                                                                                                                              │\n╰───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭──────────────────── Tests ────────────────────╮ ╭────────────────────────────────────────────────────────────────── Output ───────────────────────────────────────────────────────────────────╮\n│ test                                      [-] │ │ Run a test to see the output here                                                                                                           │\n│ ├── test_root                             [-] │ ╰─────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n│ │   └── test_in_root                      [-] │\n│ ├── test_root_again                       [-] │\n│ │   └── test_another_in_root              [-] │\n│ ├── child                                 [-] │\n│ │   ├── test_child                        [-] │\n│ │   │   ├── test_child                    [-] │\n│ │   │   └── test_another_in_child         [-] │\n│ │   └── grandchild                        [-] │\n│ │       ├── test_another_grandchild       [-] │\n│ │       │   ├── test_another_grandchild   [-] │\n│ │       │   └── test_that_fails           [-] │\n│ │       └── test_grandchild               [-] │\n│ │           └── test_grandchild           [-] │\n│ └── unit                                  [-] │\n│     └── actual_test                       [-] │\n│         ├── test_construct_test_hierarchy [-] │\n│         └── test_render                   [-] │\n╰───────────────────────────────────────────────╯\n```\n\nNavigate using arrow keys, press enter to expand/collapse folders, and space to run a test. Output generated by pytest will be shown in the output panel.\n\n## Future Work\n\nCurrent functionality is known to be minimal (and Windows-only), and I hope to continue expanding upon it and making the user experience as easy as possible.\n\nI\'m sure there are plenty of configurations where the intended highlighting and functionality doesn\'t work, so feel free to let me know what horrible bugs you encounter if you\'d like to.\n\nThis was largely a project to help me become familiar with [rich](https://github.com/Textualize/rich "rich repo") and create TUI apps, so we\'ll see where it goes from here.\n',
    'author': 'Nic Harvey',
    'author_email': 'nicharvey@protonmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
