import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#autogenerate_revision_name CloudRunService#autogenerate_revision_name}.
     *
     * @stability stable
     */
    readonly autogenerateRevisionName?: boolean | cdktf.IResolvable;
    /**
     * The location of the cloud run instance. eg us-central1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#location CloudRunService#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Name must be unique within a namespace, within a Cloud Run region.
     *
     * Is required when creating resources. Name is primarily intended
     * for creation idempotence and configuration definition. Cannot be updated.
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#project CloudRunService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#metadata CloudRunService#metadata}
     *
     * @stability stable
     */
    readonly metadata?: CloudRunServiceMetadata;
    /**
     * template block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#template CloudRunService#template}
     *
     * @stability stable
     */
    readonly template?: CloudRunServiceTemplate;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#timeouts CloudRunService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudRunServiceTimeouts;
    /**
     * traffic block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#traffic CloudRunService#traffic}
     *
     * @stability stable
     */
    readonly traffic?: CloudRunServiceTraffic[];
}
/**
 * @stability stable
 */
export declare class CloudRunServiceStatusConditions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get reason(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get conditions(): any;
    /**
     * @stability stable
     */
    get latestCreatedRevisionName(): string;
    /**
     * @stability stable
     */
    get latestReadyRevisionName(): string;
    /**
     * @stability stable
     */
    get observedGeneration(): number;
    /**
     * @stability stable
     */
    get url(): string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceMetadata {
    /**
     * Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.
     *
     * More
     * info: http://kubernetes.io/docs/user-guide/annotations
     *
     * *Note**: The Cloud Run API may add additional annotations that were not provided in your config.
     * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
     * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
     *
     * Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
     *
     * - 'run.googleapis.com/ingress' sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
     * for the Service. For example, '"run.googleapis.com/ingress" = "all"'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#annotations CloudRunService#annotations}
     *
     * @stability stable
     */
    readonly annotations?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Map of string keys and values that can be used to organize and categorize (scope and select) objects.
     *
     * May match selectors of replication controllers
     * and routes.
     * More info: http://kubernetes.io/docs/user-guide/labels
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#labels CloudRunService#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * In Cloud Run the namespace must be equal to either the project ID or project number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#namespace CloudRunService#namespace}
     *
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceMetadataOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set annotations(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _namespace?;
    /**
     * @stability stable
     */
    get namespace(): string | undefined;
    /**
     * @stability stable
     */
    set namespace(value: string | undefined);
    /**
     * @stability stable
     */
    resetNamespace(): void;
    /**
     * @stability stable
     */
    get namespaceInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateMetadata {
    /**
     * Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.
     *
     * More
     * info: http://kubernetes.io/docs/user-guide/annotations
     *
     * *Note**: The Cloud Run API may add additional annotations that were not provided in your config.
     * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
     * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#annotations CloudRunService#annotations}
     *
     * @stability stable
     */
    readonly annotations?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Map of string keys and values that can be used to organize and categorize (scope and select) objects.
     *
     * May match selectors of replication controllers
     * and routes.
     * More info: http://kubernetes.io/docs/user-guide/labels
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#labels CloudRunService#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name must be unique within a namespace, within a Cloud Run region.
     *
     * Is required when creating resources. Name is primarily intended
     * for creation idempotence and configuration definition. Cannot be updated.
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * In Cloud Run the namespace must be equal to either the project ID or project number.
     *
     * It will default to the resource's project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#namespace CloudRunService#namespace}
     *
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceTemplateMetadataOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set annotations(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespace?;
    /**
     * @stability stable
     */
    get namespace(): string | undefined;
    /**
     * @stability stable
     */
    set namespace(value: string | undefined);
    /**
     * @stability stable
     */
    resetNamespace(): void;
    /**
     * @stability stable
     */
    get namespaceInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnv {
    /**
     * Name of the environment variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables.
     *
     * If a variable cannot be resolved,
     * the reference in the input string will be unchanged. The $(VAR_NAME)
     * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
     * references will never be expanded, regardless of whether the variable
     * exists or not.
     * Defaults to "".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#value CloudRunService#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef {
    /**
     * Specify whether the ConfigMap must be defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#optional CloudRunService#optional}
     *
     * @stability stable
     */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
     * local_object_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#local_object_reference CloudRunService#local_object_reference}
     *
     * @stability stable
     */
    readonly localObjectReference?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _optional?;
    /**
     * @stability stable
     */
    get optional(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set optional(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetOptional(): void;
    /**
     * @stability stable
     */
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _localObjectReference?;
    private __localObjectReferenceOutput;
    /**
     * @stability stable
     */
    get localObjectReference(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference;
    /**
     * @stability stable
     */
    putLocalObjectReference(value: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined): void;
    /**
     * @stability stable
     */
    resetLocalObjectReference(): void;
    /**
     * @stability stable
     */
    get localObjectReferenceInput(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnvFromSecretRef {
    /**
     * Specify whether the Secret must be defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#optional CloudRunService#optional}
     *
     * @stability stable
     */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
     * local_object_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#local_object_reference CloudRunService#local_object_reference}
     *
     * @stability stable
     */
    readonly localObjectReference?: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _optional?;
    /**
     * @stability stable
     */
    get optional(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set optional(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetOptional(): void;
    /**
     * @stability stable
     */
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _localObjectReference?;
    private __localObjectReferenceOutput;
    /**
     * @stability stable
     */
    get localObjectReference(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference;
    /**
     * @stability stable
     */
    putLocalObjectReference(value: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined): void;
    /**
     * @stability stable
     */
    resetLocalObjectReference(): void;
    /**
     * @stability stable
     */
    get localObjectReferenceInput(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnvFrom {
    /**
     * An optional identifier to prepend to each key in the ConfigMap.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#prefix CloudRunService#prefix}
     *
     * @stability stable
     */
    readonly prefix?: string;
    /**
     * config_map_ref block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#config_map_ref CloudRunService#config_map_ref}
     *
     * @stability stable
     */
    readonly configMapRef?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef;
    /**
     * secret_ref block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#secret_ref CloudRunService#secret_ref}
     *
     * @stability stable
     */
    readonly secretRef?: CloudRunServiceTemplateSpecContainersEnvFromSecretRef;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersPorts {
    /**
     * Port number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#container_port CloudRunService#container_port}
     *
     * @stability stable
     */
    readonly containerPort: number;
    /**
     * Name of the port.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Protocol used on port. Defaults to TCP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#protocol CloudRunService#protocol}
     *
     * @stability stable
     */
    readonly protocol?: string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersResources {
    /**
     * Limits describes the maximum amount of compute resources allowed.
     *
     * The values of the map is string form of the 'quantity' k8s type:
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#limits CloudRunService#limits}
     *
     * @stability stable
     */
    readonly limits?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Requests describes the minimum amount of compute resources required.
     *
     * If Requests is omitted for a container, it defaults to Limits if that is
     * explicitly specified, otherwise to an implementation-defined value.
     * The values of the map is string form of the 'quantity' k8s type:
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#requests CloudRunService#requests}
     *
     * @stability stable
     */
    readonly requests?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceTemplateSpecContainersResourcesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _limits?;
    /**
     * @stability stable
     */
    get limits(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set limits(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLimits(): void;
    /**
     * @stability stable
     */
    get limitsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _requests?;
    /**
     * @stability stable
     */
    get requests(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set requests(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetRequests(): void;
    /**
     * @stability stable
     */
    get requestsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainers {
    /**
     * Arguments to the entrypoint.
     *
     * The docker image's CMD is used if this is not provided.
     * Variable references $(VAR_NAME) are expanded using the container's
     * environment. If a variable cannot be resolved, the reference in the input
     * string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
     * double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
     * regardless of whether the variable exists or not.
     * More info:
     * https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#args CloudRunService#args}
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Entrypoint array.
     *
     * Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * Variable references $(VAR_NAME) are expanded using the container's
     * environment. If a variable cannot be resolved, the reference in the input
     * string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
     * double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
     * regardless of whether the variable exists or not.
     * More info:
     * https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#command CloudRunService#command}
     *
     * @stability stable
     */
    readonly command?: string[];
    /**
     * Docker image name.
     *
     * This is most often a reference to a container located
     * in the container registry, such as gcr.io/cloudrun/hello
     * More info: https://kubernetes.io/docs/concepts/containers/images
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#image CloudRunService#image}
     *
     * @stability stable
     */
    readonly image: string;
    /**
     * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#working_dir CloudRunService#working_dir}
     *
     * @stability stable
     */
    readonly workingDir?: string;
    /**
     * env block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#env CloudRunService#env}
     *
     * @stability stable
     */
    readonly env?: CloudRunServiceTemplateSpecContainersEnv[];
    /**
     * env_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#env_from CloudRunService#env_from}
     *
     * @stability stable
     */
    readonly envFrom?: CloudRunServiceTemplateSpecContainersEnvFrom[];
    /**
     * ports block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#ports CloudRunService#ports}
     *
     * @stability stable
     */
    readonly ports?: CloudRunServiceTemplateSpecContainersPorts[];
    /**
     * resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#resources CloudRunService#resources}
     *
     * @stability stable
     */
    readonly resources?: CloudRunServiceTemplateSpecContainersResources;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpec {
    /**
     * ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container of the Revision.
     *
     * Values are:
     * - '0' thread-safe, the system should manage the max concurrency. This is
     * the default value.
     * - '1' not-thread-safe. Single concurrency
     * - '2-N' thread-safe, max concurrency of N
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#container_concurrency CloudRunService#container_concurrency}
     *
     * @stability stable
     */
    readonly containerConcurrency?: number;
    /**
     * Email address of the IAM service account associated with the revision of the service.
     *
     * The service account represents the identity of the running revision,
     * and determines what permissions the revision has. If not provided, the revision
     * will use the project's default service account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#service_account_name CloudRunService#service_account_name}
     *
     * @stability stable
     */
    readonly serviceAccountName?: string;
    /**
     * TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#timeout_seconds CloudRunService#timeout_seconds}
     *
     * @stability stable
     */
    readonly timeoutSeconds?: number;
    /**
     * containers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#containers CloudRunService#containers}
     *
     * @stability stable
     */
    readonly containers?: CloudRunServiceTemplateSpecContainers[];
}
/**
 * @stability stable
 */
export declare class CloudRunServiceTemplateSpecOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _containerConcurrency?;
    /**
     * @stability stable
     */
    get containerConcurrency(): number | undefined;
    /**
     * @stability stable
     */
    set containerConcurrency(value: number | undefined);
    /**
     * @stability stable
     */
    resetContainerConcurrency(): void;
    /**
     * @stability stable
     */
    get containerConcurrencyInput(): number | undefined;
    private _serviceAccountName?;
    /**
     * @stability stable
     */
    get serviceAccountName(): string | undefined;
    /**
     * @stability stable
     */
    set serviceAccountName(value: string | undefined);
    /**
     * @stability stable
     */
    resetServiceAccountName(): void;
    /**
     * @stability stable
     */
    get serviceAccountNameInput(): string | undefined;
    private _timeoutSeconds?;
    /**
     * @stability stable
     */
    get timeoutSeconds(): number | undefined;
    /**
     * @stability stable
     */
    set timeoutSeconds(value: number | undefined);
    /**
     * @stability stable
     */
    resetTimeoutSeconds(): void;
    /**
     * @stability stable
     */
    get timeoutSecondsInput(): number | undefined;
    private _containers?;
    /**
     * @stability stable
     */
    get containers(): CloudRunServiceTemplateSpecContainers[] | undefined;
    /**
     * @stability stable
     */
    set containers(value: CloudRunServiceTemplateSpecContainers[] | undefined);
    /**
     * @stability stable
     */
    resetContainers(): void;
    /**
     * @stability stable
     */
    get containersInput(): CloudRunServiceTemplateSpecContainers[] | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplate {
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#metadata CloudRunService#metadata}
     *
     * @stability stable
     */
    readonly metadata?: CloudRunServiceTemplateMetadata;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#spec CloudRunService#spec}
     *
     * @stability stable
     */
    readonly spec?: CloudRunServiceTemplateSpec;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceTemplateOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _metadata?;
    private __metadataOutput;
    /**
     * @stability stable
     */
    get metadata(): CloudRunServiceTemplateMetadataOutputReference;
    /**
     * @stability stable
     */
    putMetadata(value: CloudRunServiceTemplateMetadata | undefined): void;
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): CloudRunServiceTemplateMetadata | undefined;
    private _spec?;
    private __specOutput;
    /**
     * @stability stable
     */
    get spec(): CloudRunServiceTemplateSpecOutputReference;
    /**
     * @stability stable
     */
    putSpec(value: CloudRunServiceTemplateSpec | undefined): void;
    /**
     * @stability stable
     */
    resetSpec(): void;
    /**
     * @stability stable
     */
    get specInput(): CloudRunServiceTemplateSpec | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#create CloudRunService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#delete CloudRunService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#update CloudRunService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTraffic {
    /**
     * LatestRevision may be optionally provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target.
     *
     * When
     * provided LatestRevision must be true if RevisionName is empty; it must be
     * false when RevisionName is non-empty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#latest_revision CloudRunService#latest_revision}
     *
     * @stability stable
     */
    readonly latestRevision?: boolean | cdktf.IResolvable;
    /**
     * Percent specifies percent of the traffic to this Revision or Configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#percent CloudRunService#percent}
     *
     * @stability stable
     */
    readonly percent: number;
    /**
     * RevisionName of a specific revision to which to send this portion of traffic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#revision_name CloudRunService#revision_name}
     *
     * @stability stable
     */
    readonly revisionName?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html google_cloud_run_service}.
 *
 * @stability stable
 */
export declare class CloudRunService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html google_cloud_run_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudRunServiceConfig);
    private _autogenerateRevisionName?;
    /**
     * @stability stable
     */
    get autogenerateRevisionName(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set autogenerateRevisionName(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAutogenerateRevisionName(): void;
    /**
     * @stability stable
     */
    get autogenerateRevisionNameInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    status(index: string): CloudRunServiceStatus;
    private _metadata?;
    private __metadataOutput;
    /**
     * @stability stable
     */
    get metadata(): CloudRunServiceMetadataOutputReference;
    /**
     * @stability stable
     */
    putMetadata(value: CloudRunServiceMetadata | undefined): void;
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): CloudRunServiceMetadata | undefined;
    private _template?;
    private __templateOutput;
    /**
     * @stability stable
     */
    get template(): CloudRunServiceTemplateOutputReference;
    /**
     * @stability stable
     */
    putTemplate(value: CloudRunServiceTemplate | undefined): void;
    /**
     * @stability stable
     */
    resetTemplate(): void;
    /**
     * @stability stable
     */
    get templateInput(): CloudRunServiceTemplate | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CloudRunServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CloudRunServiceTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudRunServiceTimeouts | undefined;
    private _traffic?;
    /**
     * @stability stable
     */
    get traffic(): CloudRunServiceTraffic[] | undefined;
    /**
     * @stability stable
     */
    set traffic(value: CloudRunServiceTraffic[] | undefined);
    /**
     * @stability stable
     */
    resetTraffic(): void;
    /**
     * @stability stable
     */
    get trafficInput(): CloudRunServiceTraffic[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
