/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.adapter;

import java.util.ArrayList;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.osgi.EquinoxUtils;
import org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

class AdapterFactoryProxy
implements IAdapterFactory,
IAdapterFactoryExt {
    private IConfigurationElement element;
    private IAdapterFactory factory;
    private boolean factoryLoaded = false;
    private String ownerId;
    private int internalOwnerID = -1;

    AdapterFactoryProxy() {
    }

    public static AdapterFactoryProxy createProxy(IConfigurationElement element) {
        AdapterFactoryProxy result = new AdapterFactoryProxy();
        result.element = element;
        IExtension extension = element.getDeclaringExtension();
        result.ownerId = extension.getUniqueIdentifier();
        if (extension instanceof Handle) {
            result.internalOwnerID = ((Handle)((Object)extension)).getId();
        }
        if ("factory".equals(element.getName())) {
            return result;
        }
        result.logError();
        return null;
    }

    public boolean originatesFrom(IExtension extension) {
        String id = extension.getUniqueIdentifier();
        if (id != null) {
            return id.equals(this.ownerId);
        }
        if (!(extension instanceof Handle)) {
            return false;
        }
        return this.internalOwnerID == ((Handle)((Object)extension)).getId();
    }

    String getAdaptableType() {
        String result = this.element.getAttribute("adaptableType");
        if (result != null) {
            return result;
        }
        this.logError();
        return "";
    }

    @Override
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (!this.factoryLoaded) {
            this.loadFactory(false);
        }
        return this.factory == null ? null : (T)this.factory.getAdapter(adaptableObject, adapterType);
    }

    @Override
    public Class<?>[] getAdapterList() {
        if (!this.factoryLoaded) {
            this.loadFactory(false);
        }
        return this.factory == null ? null : this.factory.getAdapterList();
    }

    @Override
    public String[] getAdapterNames() {
        IConfigurationElement[] children = this.element.getChildren();
        ArrayList<String> adapters = new ArrayList<String>(children.length);
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String type;
            IConfigurationElement child = iConfigurationElementArray[n2];
            if ("adapter".equals(child.getName()) && (type = child.getAttribute("type")) != null) {
                adapters.add(type);
            }
            ++n2;
        }
        if (adapters.isEmpty()) {
            this.logError();
        }
        return adapters.toArray(new String[adapters.size()]);
    }

    IExtension getExtension() {
        return this.element.getDeclaringExtension();
    }

    @Override
    public synchronized IAdapterFactory loadFactory(boolean force) {
        boolean isActive;
        if (this.factory != null || this.factoryLoaded) {
            return this.factory;
        }
        String contributorName = this.element.getContributor().getName();
        try {
            isActive = EquinoxUtils.isActive(contributorName);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            isActive = true;
        }
        if (!force && !isActive) {
            return null;
        }
        try {
            try {
                this.factory = (IAdapterFactory)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                String msg = NLS.bind(RegistryMessages.adapters_cantInstansiate, this.getAdaptableType(), this.element.getContributor().getName());
                RuntimeLog.log(new Status(4, "org.eclipse.equinox.registry", 0, msg, e));
                this.factoryLoaded = true;
            }
        }
        finally {
            this.factoryLoaded = true;
        }
        return this.factory;
    }

    private void logError() {
        String msg = NLS.bind(RegistryMessages.adapters_badAdapterFactory, this.element.getContributor().getName());
        RuntimeLog.log(new Status(4, "org.eclipse.equinox.registry", 0, msg, null));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AdapterFactoryProxy [contributor: ");
        sb.append(this.element.getContributor());
        sb.append(", adaptableType: ");
        sb.append(this.getAdaptableType());
        if (this.factory != null) {
            sb.append(", factory: ");
            sb.append(this.factory);
        }
        sb.append("]");
        return sb.toString();
    }
}

