#!/usr/bin/env python3
# coding=UTF-8
#
# Copyright 2022. quinn.7@foxmail.com All rights reserved.
# Author :: cat7
# Email  :: quinn.7@foxmail.com
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, 
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# =============================================================================
"""
[ 装饰器实现 ]

"""


# ----------------------------------
def singleton_pattern(cls):
    """
    [ 单例模式装饰器 ]

    * 用于装饰类, 被装饰的类在全局引用时只会创建一个实例.

    ---
    示例:
        >>> @singleton_pattern
        >>> class T(object): ...
        >>> t1 = T()
        >>> t2 = T()
        >>> id(t1) == id(t2) :: True

    """

    instances = {}

    def _singleton_pattern(*args, **kwargs):
        if cls not in instances:
            instances[cls] = cls(*args, **kwargs)
        return instances[cls]

    return _singleton_pattern
