"use strict";
const apigateway = require("../lib");
module.exports = {
    'if jsonWithStandardFields method called with no parameter'(test) {
        const testFormat = apigateway.AccessLogFormat.jsonWithStandardFields();
        test.deepEqual(testFormat.toString(), '{"requestId":"$context.requestId","ip":"$context.identity.sourceIp","user":"$context.identity.user","caller":"$context.identity.caller","requestTime":"$context.requestTime","httpMethod":"$context.httpMethod","resourcePath":"$context.resourcePath","status":"$context.status","protocol":"$context.protocol","responseLength":"$context.responseLength"}');
        test.done();
    },
    'if jsonWithStandardFields method called with all parameters false'(test) {
        const testFormat = apigateway.AccessLogFormat.jsonWithStandardFields({
            caller: false,
            httpMethod: false,
            ip: false,
            protocol: false,
            requestTime: false,
            resourcePath: false,
            responseLength: false,
            status: false,
            user: false,
        });
        test.deepEqual(testFormat.toString(), '{"requestId":"$context.requestId"}');
        test.done();
    },
    'if clf method called'(test) {
        const testFormat = apigateway.AccessLogFormat.clf();
        test.deepEqual(testFormat.toString(), '$context.identity.sourceIp $context.identity.caller $context.identity.user [$context.requestTime] "$context.httpMethod $context.resourcePath $context.protocol" $context.status $context.responseLength $context.requestId');
        test.done();
    },
    'if custom method called'(test) {
        const testFormat = apigateway.AccessLogFormat.custom(JSON.stringify({
            requestId: apigateway.AccessLogField.contextRequestId(),
            sourceIp: apigateway.AccessLogField.contextIdentitySourceIp(),
            method: apigateway.AccessLogField.contextHttpMethod(),
            userContext: {
                sub: apigateway.AccessLogField.contextAuthorizerClaims('sub'),
                email: apigateway.AccessLogField.contextAuthorizerClaims('email'),
            },
        }));
        test.deepEqual(testFormat.toString(), '{"requestId":"$context.requestId","sourceIp":"$context.identity.sourceIp","method":"$context.httpMethod","userContext":{"sub":"$context.authorizer.claims.sub","email":"$context.authorizer.claims.email"}}');
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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