# coding: utf-8

"""
    Investoreight Core API

    Investoreight API Documentation:  https://api.investoreight.com/api-docs/index.html  # noqa: E501

    OpenAPI spec version: 1.0.1
    Contact: info@investoreight.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from investor8_sdk.api_client import ApiClient


class FinancialsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_all_latest_financials(self, **kwargs):  # noqa: E501
        """get_all_latest_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_latest_financials(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool refresh_cache:
        :return: dict(str, LatestFinancialsDto)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_latest_financials_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_latest_financials_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_latest_financials_with_http_info(self, **kwargs):  # noqa: E501
        """get_all_latest_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_latest_financials_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool refresh_cache:
        :return: dict(str, LatestFinancialsDto)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['refresh_cache']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_latest_financials" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'refresh_cache' in params:
            query_params.append(('refreshCache', params['refresh_cache']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearerCoreAuth']  # noqa: E501

        return self.api_client.call_api(
            '/Financials/all/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, LatestFinancialsDto)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dict_available_standardized_financials(self, ticker, **kwargs):  # noqa: E501
        """get_dict_available_standardized_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dict_available_standardized_financials(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :return: dict(str, dict(str, dict(str, list[str])))
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dict_available_standardized_financials_with_http_info(ticker, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dict_available_standardized_financials_with_http_info(ticker, **kwargs)  # noqa: E501
            return data

    def get_dict_available_standardized_financials_with_http_info(self, ticker, **kwargs):  # noqa: E501
        """get_dict_available_standardized_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dict_available_standardized_financials_with_http_info(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :return: dict(str, dict(str, dict(str, list[str])))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dict_available_standardized_financials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ticker' is set
        if ('ticker' not in params or
                params['ticker'] is None):
            raise ValueError("Missing the required parameter `ticker` when calling `get_dict_available_standardized_financials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ticker' in params:
            path_params['ticker'] = params['ticker']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearerCoreAuth']  # noqa: E501

        return self.api_client.call_api(
            '/Financials/available/{ticker}/dict', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, dict(str, dict(str, list[str])))',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_financials_by_id(self, id, **kwargs):  # noqa: E501
        """get_financials_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_financials_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: StandardizedFinancial
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_financials_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_financials_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_financials_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_financials_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_financials_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: StandardizedFinancial
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_financials_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_financials_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearerCoreAuth']  # noqa: E501

        return self.api_client.call_api(
            '/Financials/byid/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StandardizedFinancial',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_financials_single(self, **kwargs):  # noqa: E501
        """get_financials_single  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_financials_single(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker:
        :param str stat_code: Valid values are `balance_sheet_statement`, `income_statement`, `calculations`, `cash_flow_statement`
        :param str fiscal_period:
        :param str fiscal_year:
        :param str report_type: Valid values are `reported`, `restated`, `calculated`, null
        :return: StandardizedFinancial
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_financials_single_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_financials_single_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_financials_single_with_http_info(self, **kwargs):  # noqa: E501
        """get_financials_single  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_financials_single_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker:
        :param str stat_code: Valid values are `balance_sheet_statement`, `income_statement`, `calculations`, `cash_flow_statement`
        :param str fiscal_period:
        :param str fiscal_year:
        :param str report_type: Valid values are `reported`, `restated`, `calculated`, null
        :return: StandardizedFinancial
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker', 'stat_code', 'fiscal_period', 'fiscal_year', 'report_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_financials_single" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ticker' in params:
            query_params.append(('ticker', params['ticker']))  # noqa: E501
        if 'stat_code' in params:
            query_params.append(('statCode', params['stat_code']))  # noqa: E501
        if 'fiscal_period' in params:
            query_params.append(('fiscalPeriod', params['fiscal_period']))  # noqa: E501
        if 'fiscal_year' in params:
            query_params.append(('fiscalYear', params['fiscal_year']))  # noqa: E501
        if 'report_type' in params:
            query_params.append(('reportType', params['report_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearerCoreAuth']  # noqa: E501

        return self.api_client.call_api(
            '/Financials/single', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StandardizedFinancial',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historical_financials(self, ticker, size, **kwargs):  # noqa: E501
        """get_historical_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historical_financials(ticker, size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :param int size: (required)
        :param bool refresh_cache:
        :return: list[StockFinancial]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_historical_financials_with_http_info(ticker, size, **kwargs)  # noqa: E501
        else:
            (data) = self.get_historical_financials_with_http_info(ticker, size, **kwargs)  # noqa: E501
            return data

    def get_historical_financials_with_http_info(self, ticker, size, **kwargs):  # noqa: E501
        """get_historical_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historical_financials_with_http_info(ticker, size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :param int size: (required)
        :param bool refresh_cache:
        :return: list[StockFinancial]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker', 'size', 'refresh_cache']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historical_financials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ticker' is set
        if ('ticker' not in params or
                params['ticker'] is None):
            raise ValueError("Missing the required parameter `ticker` when calling `get_historical_financials`")  # noqa: E501
        # verify the required parameter 'size' is set
        if ('size' not in params or
                params['size'] is None):
            raise ValueError("Missing the required parameter `size` when calling `get_historical_financials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ticker' in params:
            path_params['ticker'] = params['ticker']  # noqa: E501
        if 'size' in params:
            path_params['size'] = params['size']  # noqa: E501

        query_params = []
        if 'refresh_cache' in params:
            query_params.append(('refreshCache', params['refresh_cache']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearerCoreAuth']  # noqa: E501

        return self.api_client.call_api(
            '/Financials/historical/{ticker}/{size}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[StockFinancial]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_financials(self, ticker, **kwargs):  # noqa: E501
        """get_latest_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_financials(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :param bool refresh_cache:
        :return: StockFinancial
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_financials_with_http_info(ticker, **kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_financials_with_http_info(ticker, **kwargs)  # noqa: E501
            return data

    def get_latest_financials_with_http_info(self, ticker, **kwargs):  # noqa: E501
        """get_latest_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_financials_with_http_info(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :param bool refresh_cache:
        :return: StockFinancial
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker', 'refresh_cache']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_financials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ticker' is set
        if ('ticker' not in params or
                params['ticker'] is None):
            raise ValueError("Missing the required parameter `ticker` when calling `get_latest_financials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ticker' in params:
            path_params['ticker'] = params['ticker']  # noqa: E501

        query_params = []
        if 'refresh_cache' in params:
            query_params.append(('refreshCache', params['refresh_cache']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearerCoreAuth']  # noqa: E501

        return self.api_client.call_api(
            '/Financials/latest/{ticker}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StockFinancial',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_standardized_financials(self, ticker, **kwargs):  # noqa: E501
        """get_latest_standardized_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_standardized_financials(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :param str stat_code: Valid values are `balance_sheet_statement`, `income_statement`, `calculations`, `cash_flow_statement`
        :return: dict(str, StandardizedFinancial)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_standardized_financials_with_http_info(ticker, **kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_standardized_financials_with_http_info(ticker, **kwargs)  # noqa: E501
            return data

    def get_latest_standardized_financials_with_http_info(self, ticker, **kwargs):  # noqa: E501
        """get_latest_standardized_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_standardized_financials_with_http_info(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :param str stat_code: Valid values are `balance_sheet_statement`, `income_statement`, `calculations`, `cash_flow_statement`
        :return: dict(str, StandardizedFinancial)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker', 'stat_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_standardized_financials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ticker' is set
        if ('ticker' not in params or
                params['ticker'] is None):
            raise ValueError("Missing the required parameter `ticker` when calling `get_latest_standardized_financials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ticker' in params:
            path_params['ticker'] = params['ticker']  # noqa: E501

        query_params = []
        if 'stat_code' in params:
            query_params.append(('statCode', params['stat_code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearerCoreAuth']  # noqa: E501

        return self.api_client.call_api(
            '/Financials/std/latest/{ticker}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, StandardizedFinancial)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_available_standardized_financials(self, ticker, **kwargs):  # noqa: E501
        """get_list_available_standardized_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_available_standardized_financials(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :return: list[FinancialReportDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_available_standardized_financials_with_http_info(ticker, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_available_standardized_financials_with_http_info(ticker, **kwargs)  # noqa: E501
            return data

    def get_list_available_standardized_financials_with_http_info(self, ticker, **kwargs):  # noqa: E501
        """get_list_available_standardized_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_available_standardized_financials_with_http_info(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :return: list[FinancialReportDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_available_standardized_financials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ticker' is set
        if ('ticker' not in params or
                params['ticker'] is None):
            raise ValueError("Missing the required parameter `ticker` when calling `get_list_available_standardized_financials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ticker' in params:
            path_params['ticker'] = params['ticker']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearerCoreAuth']  # noqa: E501

        return self.api_client.call_api(
            '/Financials/available/{ticker}/list', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FinancialReportDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_standardized_financials(self, ticker, **kwargs):  # noqa: E501
        """get_list_standardized_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_standardized_financials(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :param str stat_code: Valid values are `balance_sheet_statement`, `income_statement`, `calculations`, `cash_flow_statement`
        :param str period_type: Valid values for `balance_sheet_statement` are `Q` and `FY` and for others are `Q`, `FY`, `YTD`, `TTM`
        :param str report_type: Valid values are `reported`, `restated`, `calculated`, `restatedFirst`, `reportedFirst`
        :param str end_year:
        :param bool all_history:
        :return: list[StandardizedFinancial]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_standardized_financials_with_http_info(ticker, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_standardized_financials_with_http_info(ticker, **kwargs)  # noqa: E501
            return data

    def get_list_standardized_financials_with_http_info(self, ticker, **kwargs):  # noqa: E501
        """get_list_standardized_financials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_standardized_financials_with_http_info(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: (required)
        :param str stat_code: Valid values are `balance_sheet_statement`, `income_statement`, `calculations`, `cash_flow_statement`
        :param str period_type: Valid values for `balance_sheet_statement` are `Q` and `FY` and for others are `Q`, `FY`, `YTD`, `TTM`
        :param str report_type: Valid values are `reported`, `restated`, `calculated`, `restatedFirst`, `reportedFirst`
        :param str end_year:
        :param bool all_history:
        :return: list[StandardizedFinancial]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker', 'stat_code', 'period_type', 'report_type', 'end_year', 'all_history']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_standardized_financials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ticker' is set
        if ('ticker' not in params or
                params['ticker'] is None):
            raise ValueError("Missing the required parameter `ticker` when calling `get_list_standardized_financials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ticker' in params:
            path_params['ticker'] = params['ticker']  # noqa: E501

        query_params = []
        if 'stat_code' in params:
            query_params.append(('statCode', params['stat_code']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('periodType', params['period_type']))  # noqa: E501
        if 'report_type' in params:
            query_params.append(('reportType', params['report_type']))  # noqa: E501
        if 'end_year' in params:
            query_params.append(('endYear', params['end_year']))  # noqa: E501
        if 'all_history' in params:
            query_params.append(('allHistory', params['all_history']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearerCoreAuth']  # noqa: E501

        return self.api_client.call_api(
            '/Financials/list/{ticker}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[StandardizedFinancial]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
