from fileformats.medimage.nifti import Nifti1
from pathlib import Path
from pydra.engine import ShellCommandTask
from pydra.engine import specs
import typing as ty

input_fields = [
    (
        "xset",
        Nifti1,
        {
            "help_string": "input xset",
            "argstr": "{xset}",
            "copyfile": False,
            "mandatory": True,
            "position": -2,
        },
    ),
    (
        "yset",
        Nifti1,
        {
            "help_string": "input yset",
            "argstr": "{yset}",
            "copyfile": False,
            "mandatory": True,
            "position": -1,
        },
    ),
    (
        "out_file",
        Path,
        {
            "help_string": "output image file name",
            "argstr": "-prefix {out_file}",
            "output_file_template": "{xset}_tcorr",
        },
    ),
    (
        "pearson",
        bool,
        {
            "help_string": "Correlation is the normal Pearson correlation coefficient",
            "argstr": "-pearson",
        },
    ),
    (
        "polort",
        int,
        {
            "help_string": "Remove polynomical trend of order m",
            "argstr": "-polort {polort}",
        },
    ),
    ("num_threads", int, 1, {"help_string": "set number of threads"}),
    ("outputtype", ty.Any, {"help_string": "AFNI output filetype"}),
]
TCorrelate_input_spec = specs.SpecInfo(
    name="Input", fields=input_fields, bases=(specs.ShellSpec,)
)

output_fields = []
TCorrelate_output_spec = specs.SpecInfo(
    name="Output", fields=output_fields, bases=(specs.ShellOutSpec,)
)


class TCorrelate(ShellCommandTask):
    """
    Examples
    -------

    >>> from fileformats.medimage.nifti import Nifti1
    >>> from pydra.tasks.afni.auto.t_correlate import TCorrelate

    >>> task = TCorrelate()
    >>> task.inputs.xset = None
    >>> task.inputs.yset = None
    >>> task.inputs.out_file = ""functional_tcorrelate.nii.gz""
    >>> task.inputs.pearson = "True"
    >>> task.inputs.polort = "-1"
    >>> task.cmdline
    '3dTcorrelate -prefix functional_tcorrelate.nii.gz -pearson -polort -1 u_rc1s1_Template.nii u_rc1s2_Template.nii'


    """

    input_spec = TCorrelate_input_spec
    output_spec = TCorrelate_output_spec
    executable = "3dTcorrelate"
