Export CSV To Influx
====================

**Export CSV To Influx**: 处理CSV中的数据，并且将数据导入到Influx中

## 安装
通过pip命令安装即可。

安装完成后，便可以在命令行中使用**export_csv_to_influx**了。

```
pip install ExportCsvToInflux
```

## 功能

1. **[亮点 :star2::tada::heart_eyes:]** 允许在命令行中使用 **export_csv_to_influx**
2. **[亮点 :star2::tada::heart_eyes:]** 允许处理文件夹中所有的csv
3. **[亮点 :star2::tada::heart_eyes::confetti_ball::four_leaf_clover::balloon:]** 自动将csv中的数据处理为int/float/string类型
4. **[亮点 :star2::tada::heart_eyes:]** 允许通过字符串，正则表达式匹配/过滤csv中的数据
5. **[亮点 :star2::tada::heart_eyes:]** 允许在influx中生成数据统计表
6. 允许设置influx中数据的长度
7. 允许判断csv是否存在更新
8. 允许使用文件最新的修改日期作为influx中的timestamp
9. 自动判断是否创建influx数据库
10. 允许在influx中插入数据前，删除数据库
11. 允许在influx中插入数据前，删除数据表

## 命令细节

通过使用 `export_csv_to_influx -h` 查看命令细节

`-c, --csv`: 输入csv的文件名/文件夹地址. **强制**

`-db, --dbname`: influx数据库名 **强制**

`-m, --measurement`: influx数据表名 **强制**

`-fc, --field_columns`: field列, 如果多列, 使用英文逗号 ',' 作为分隔符. **强制**

`-d, --delimiter`: csv分隔符. 默认英文的逗号: ','

`-lt, --lineterminator`: csv换行符. 默认: '\n'

`-s, --server`: influx数据库地址. 默认: localhost:8086

`-u, --user`: influx用户名, 默认: admin

`-p, --password`: influx密码, 默认: admin

`-t, --time_column`: 时间戳列. 默认列名: timestamp. 
    
如果不存在时间戳列, 自动使用文件最新的修改日期作为时间戳
    
> 注意: 同时也支持纯的timestamp, 比如: 1517587275. 系统自动判断.
    
`-tf, --time_format`: 时间戳格式. 默认: '%Y-%m-%d %H:%M:%S' 比如: 1970-01-01 00:00:00.

`-tz, --time_zone`: 时区. 默认: UTC

`-tc, --tag_columns`: tag列, 如果多列, 使用英文逗号 ',' 作为分隔符, 默认: None

`-b, --batch_size`: 批量插入数据库大小. 默认: 500

`-lslc, --limit_string_length_columns`: 设置某列或多列中数据的长度, 如果多列, 使用英文逗号 ',' 作为分隔符. 默认: None

`-ls, --limit_length`: 长度大小. 默认: 20

`-dd, --drop_database`: 在influx中插入数据前, 删除数据库. 默认: False

`-dm, --drop_measurement`: 在influx中插入数据前, 删除数据表. 默认: False

`-mc, --match_columns`: 用于匹配的列, 使用英文逗号 ',' 作为分隔符. 匹配规则: 所有匹配成功, 才保留该行. 默认: None

`-mbs, --match_by_string`: 用于匹配的字符串, 使用英文逗号 ',' 作为分隔符. 默认: None

`-mbr, --match_by_regex`: 用于匹配的正则表达式, 使用英文逗号 ',' 作为分隔符. 默认: None

`-fic, --filter_columns`: 用于过滤的列, 使用英文逗号 ',' 作为分隔符. 匹配规则: 任意一个过滤成功, 便过滤该行. 默认: None

`-fibs, --filter_by_string`: 用于过滤的字符串, 使用英文逗号 ',' 作为分隔符. 默认: None

`-fibr, --filter_by_regex`: 用于匹配的正则表达式, 使用英文逗号 ',' 作为分隔符. 默认: None

`-ecm, --enable_count_measurement`: 生成统计表. 默认: False

`-fi, --force_insert_even_csv_no_update`: 强制往influx中插入数据, 即使csv不存在更新. 默认: False

`-fsc, --force_string_columns`: 强制将列的类型转换成string类型, 使用英文逗号 ',' 作为分隔符. 默认: None

`-fintc, --force_int_columns`: 强制将列的类型转换成int类型, 使用英文逗号 ',' 作为分隔符. 默认: None

`-ffc, --force_float_columns`: 强制将列的类型转换成float类型, 使用英文逗号 ',' 作为分隔符. 默认: None

> **注意:**
> 1. --field_columns 可以使用通配符 `*`，来匹配所有的列: `--field_columns=*`, `--field_columns '*'`
> 2. 如果检查到csv文件没有更新, 数据不会重复插入到数据库. 可以使用强制插入: `--force_insert_even_csv_no_update=True`, `--force_insert_even_csv_no_update True`
> 3. 如果csv中某些单元格的数据为空, 则自动根据列的数据类型，添加下面数据到Influx: `int: -999`, `float: -999.0`, `string: -`

## 使用代码调用

可以使用代码直接调用

```
from ExportCsvToInflux import ExporterObject

exporter = ExporterObject()
exporter.export_csv_to_influx(...)

# 更多关于export_csv_to_influx的参数细节:
print(exporter.export_csv_to_influx.__doc__)
```

## 示例

下面是操作样本 **demo.csv**.

``` 
timestamp,url,response_time
2019-07-11 02:04:05,https://jmeter.apache.org/,1.434
2019-07-11 02:04:06,https://jmeter.apache.org/,2.434
2019-07-11 02:04:07,https://jmeter.apache.org/,1.200
2019-07-11 02:04:08,https://jmeter.apache.org/,1.675
2019-07-11 02:04:09,https://jmeter.apache.org/,2.265
2019-07-11 02:04:10,https://sample-demo.org/,1.430
2019-07-12 08:54:13,https://sample-show.org/,1.300
2019-07-12 14:06:00,https://sample-7.org/,1.289
2019-07-12 18:45:34,https://sample-8.org/,2.876
```

1. 将样本中所有数据插入到influx

    ``` 
    export_csv_to_influx \
    --csv demo.csv \
    --dbname demo \
    --measurement demo \
    --tag_columns url \
    --field_columns response_time \
    --user admin \
    --password admin \
    --server 127.0.0.1:8086 \
    --force_insert_even_csv_no_update True
    ```

2. 将样本中所有数据插入到influx, **但是: 清除之前的老数据**

    ```
    export_csv_to_influx \
    --csv demo.csv \
    --dbname demo \
    --measurement demo \
    --tag_columns url \
    --field_columns response_time \
    --user admin \
    --password admin \
    --server 127.0.0.1:8086 \
    --force_insert_even_csv_no_update True \
    --drop_database True
    ```

3. 匹配csv中部分数据，并将数据导入到influx: **timestamp 匹配 2019-07-12 and url 匹配 sample-\d+**

    ``` 
    export_csv_to_influx \
    --csv demo.csv \
    --dbname demo \
    --measurement demo \
    --tag_columns url \
    --field_columns response_time \
    --user admin \
    --password admin \
    --server 127.0.0.1:8086 \
    --drop_database True \
    --force_insert_even_csv_no_update True \
    --match_columns timestamp,url \
    --match_by_reg '2019-07-12,sample-\d+'
    ```

4. 过滤csv中部分数据，并将数据导入到influx: **url 过滤 sample**

    ``` 
    export_csv_to_influx \
    --csv demo.csv \
    --dbname demo \
    --measurement demo \
    --tag_columns url \
    --field_columns response_time \
    --user admin \
    --password admin \
    --server 127.0.0.1:8086 \
    --drop_database True \
    --force_insert_even_csv_no_update True \
    --filter_columns timestamp,url \
    --filter_by_reg 'sample'
    ```

5. 激活数据表: **demo.count**, 并且匹配: **timestamp 匹配 2019-07-12 and url 匹配 sample-\d+**

    ```
    export_csv_to_influx \
    --csv demo.csv \
    --dbname demo \
    --measurement demo \
    --tag_columns url \
    --field_columns response_time \
    --user admin \
    --password admin \
    --server 127.0.0.1:8086 \
    --drop_database True \
    --force_insert_even_csv_no_update True \
    --match_columns timestamp,url \
    --match_by_reg '2019-07-12,sample-\d+' \
    --enable_count_measurement True 
    ```
    
    生成的数据表为：
    
    ```text
    select * from "demo.count"
 
    name: demo.count
    time                match_timestamp match_url total
    ----                --------------- --------- -----
    1562957134000000000 3               2         9
    ```
    
## 特殊感谢

灵感来自: [https://github.com/fabio-miranda/csv-to-influxdb](https://github.com/fabio-miranda/csv-to-influxdb)
