# Copyright (c) 2017-2024 Technica Engineering GmbH. All rights reserved.

import clr
clr.AddReference('PrimaITestCaseLibrary')
from PrimaITestCaseLibrary.OutputView import OutputStringType as _type

def tc_return_success(*success_report):
    if len(success_report) > 0:
        outputs.log(str(success_report[0]), _type.Success)
    else:
        outputs.log('*** Success', _type.Success)
    current_script.Success()

def tc_return_failure(*fail_report):
    if len(fail_report) > 0:
        outputs.log(str(fail_report[0]), _type.Error)
    else:
        outputs.log('*** Failure', _type.Error)
    current_script.Fail()

def tc_return_skipped(*fail_report):
    if len(fail_report) > 0:
        outputs.log(str(fail_report[0]), _type.Warning)
    else:
        outputs.log('*** Skipped', _type.Warning)
    current_script.Skip()

def tc_Block(*fail_report):
    tc_return_skipped(*fail_report)

def tc_get_all_ecus():
    return current_script.TestProject.Ecus.nodes

def tc_return_continue():
    current_script.Continue()

def TestState(self):
    return self.TestOK

def tc_wait_for_return(*timeout):
    if len(timeout) > 0:
        current_script.waitResult(timeout[0])
    else:
        current_script.waitResult()

def timed_out():
    return current_script.timed_out()
