"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Activate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [activate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsactivate.html).
 *
 * @experimental
 */
class Activate extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [activate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsactivate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'activate';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CreateForm",
                "PutMemberInfo"
            ],
            "Read": [
                "GetAccountContact",
                "GetContentInfo",
                "GetCosts",
                "GetCredits",
                "GetMemberInfo",
                "GetProgram"
            ]
        };
    }
    /**
     * (experimental) Grants permission to submit an Activate application form.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateForm() {
        return this.to('CreateForm');
    }
    /**
     * (experimental) Grants permission to get the AWSaccount contact information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetAccountContact() {
        return this.to('GetAccountContact');
    }
    /**
     * (experimental) Grants permission to get Activate tech posts and offer information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetContentInfo() {
        return this.to('GetContentInfo');
    }
    /**
     * (experimental) Grants permission to get the AWS cost information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetCosts() {
        return this.to('GetCosts');
    }
    /**
     * (experimental) Grants permission to get the AWS credit information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetCredits() {
        return this.to('GetCredits');
    }
    /**
     * (experimental) Grants permission to get the Activate member information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetMemberInfo() {
        return this.to('GetMemberInfo');
    }
    /**
     * (experimental) Grants permission to get an Activate program.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetProgram() {
        return this.to('GetProgram');
    }
    /**
     * (experimental) Grants permission to create or update the Activate member information.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toPutMemberInfo() {
        return this.to('PutMemberInfo');
    }
}
exports.Activate = Activate;
_a = JSII_RTTI_SYMBOL_1;
Activate[_a] = { fqn: "iam-floyd.Activate", version: "0.213.0" };
//# sourceMappingURL=data:application/json;base64,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