import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [elastic-inference](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticinference.html).
 *
 * @experimental
 */
export declare class ElasticInference extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [elastic-inference](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticinference.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to customer for connecting to Elastic Inference accelerator.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toConnect(): this;
    /**
     * (experimental) Grants permission to describe the locations in which a given accelerator type or set of types is present in a given region.
     *
     * Access Level: List
     *
     * @experimental
     */
    toDescribeAcceleratorOfferings(): this;
    /**
     * (experimental) Grants permission to describe the accelerator types available in a given region, as well as their characteristics, such as memory and throughput.
     *
     * Access Level: List
     *
     * @experimental
     */
    toDescribeAcceleratorTypes(): this;
    /**
     * (experimental) Grants permission to describe information over a provided set of accelerators belonging to an account.
     *
     * Access Level: List
     *
     * @experimental
     */
    toDescribeAccelerators(): this;
    /**
     * (experimental) Grants permission to list all tags on an Amazon RDS resource.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to assign one or more tags (key-value pairs) to the specified QuickSight resource.
     *
     * Access Level: Tagging
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove a tag or tags from a resource.
     *
     * Access Level: Tagging
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type accelerator to the statement.
     *
     * @param acceleratorId - Identifier for the acceleratorId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAccelerator(acceleratorId: string, account?: string, region?: string, partition?: string): this;
}
