import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [mediaconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediaconnect.html).
 *
 * @experimental
 */
export declare class Mediaconnect extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [mediaconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediaconnect.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to add media streams to any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-mediastreams.html
     *
     * @experimental
     */
    toAddFlowMediaStreams(): this;
    /**
     * (experimental) Grants permission to add outputs to any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-outputs.html
     *
     * @experimental
     */
    toAddFlowOutputs(): this;
    /**
     * (experimental) Grants permission to add sources to any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source.html
     *
     * @experimental
     */
    toAddFlowSources(): this;
    /**
     * (experimental) Grants permission to add VPC interfaces to any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-vpcinterfaces.html
     *
     * @experimental
     */
    toAddFlowVpcInterfaces(): this;
    /**
     * (experimental) Grants permission to create flows.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows.html
     *
     * @experimental
     */
    toCreateFlow(): this;
    /**
     * (experimental) Grants permission to delete flows.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn.html
     *
     * @experimental
     */
    toDeleteFlow(): this;
    /**
     * (experimental) Grants permission to display the details of a flow including the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn.html
     *
     * @experimental
     */
    toDescribeFlow(): this;
    /**
     * (experimental) Grants permission to display the details of an offering.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-offerings-offeringarn.html
     *
     * @experimental
     */
    toDescribeOffering(): this;
    /**
     * (experimental) Grants permission to display the details of a reservation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-reservations-reservationarn.html
     *
     * @experimental
     */
    toDescribeReservation(): this;
    /**
     * (experimental) Grants permission to grant entitlements on any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-entitlements.html
     *
     * @experimental
     */
    toGrantFlowEntitlements(): this;
    /**
     * (experimental) Grants permission to display a list of all entitlements that have been granted to the account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-entitlements.html
     *
     * @experimental
     */
    toListEntitlements(): this;
    /**
     * (experimental) Grants permission to display a list of flows that are associated with this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows.html
     *
     * @experimental
     */
    toListFlows(): this;
    /**
     * (experimental) Grants permission to display a list of all offerings that are available to the account in the current AWSRegion.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-offerings.html
     *
     * @experimental
     */
    toListOfferings(): this;
    /**
     * (experimental) Grants permission to display a list of all reservations that have been purchased by the account in the current AWSRegion.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-reservations.html
     *
     * @experimental
     */
    toListReservations(): this;
    /**
     * (experimental) Grants permission to display a list of all tags associated with a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/tags-resourcearn.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to purchase an offering.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-offerings-offeringarn.html
     *
     * @experimental
     */
    toPurchaseOffering(): this;
    /**
     * (experimental) Grants permission to remove media streams from any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-mediastreams-mediastreamname.html
     *
     * @experimental
     */
    toRemoveFlowMediaStream(): this;
    /**
     * (experimental) Grants permission to remove outputs from any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-outputs-outputarn.html
     *
     * @experimental
     */
    toRemoveFlowOutput(): this;
    /**
     * (experimental) Grants permission to remove sources from any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source-sourcearn.html
     *
     * @experimental
     */
    toRemoveFlowSource(): this;
    /**
     * (experimental) Grants permission to remove VPC interfaces from any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-vpcinterfaces-vpcinterfacename.html
     *
     * @experimental
     */
    toRemoveFlowVpcInterface(): this;
    /**
     * (experimental) Grants permission to revoke entitlements on any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-entitlements-entitlementarn.html
     *
     * @experimental
     */
    toRevokeFlowEntitlement(): this;
    /**
     * (experimental) Grants permission to start flows.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-start-flowarn.html
     *
     * @experimental
     */
    toStartFlow(): this;
    /**
     * (experimental) Grants permission to stop flows.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-stop-flowarn.html
     *
     * @experimental
     */
    toStopFlow(): this;
    /**
     * (experimental) Grants permission to associate tags with resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/tags-resourcearn.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/tags-resourcearn.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update flows.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn.html
     *
     * @experimental
     */
    toUpdateFlow(): this;
    /**
     * (experimental) Grants permission to update entitlements on any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-entitlements-entitlementarn.html
     *
     * @experimental
     */
    toUpdateFlowEntitlement(): this;
    /**
     * (experimental) Grants permission to update media streams on any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-mediastreams-mediastreamname.html
     *
     * @experimental
     */
    toUpdateFlowMediaStream(): this;
    /**
     * (experimental) Grants permission to update outputs on any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-outputs-outputarn.html
     *
     * @experimental
     */
    toUpdateFlowOutput(): this;
    /**
     * (experimental) Grants permission to update the source of any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source-sourcearn.html
     *
     * @experimental
     */
    toUpdateFlowSource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Entitlement to the statement.
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/entitlements.html
     *
     * @param flowId - Identifier for the flowId.
     * @param entitlementName - Identifier for the entitlementName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEntitlement(flowId: string, entitlementName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Flow to the statement.
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/flows.html
     *
     * @param flowId - Identifier for the flowId.
     * @param flowName - Identifier for the flowName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFlow(flowId: string, flowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Output to the statement.
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/outputs.html
     *
     * @param outputId - Identifier for the outputId.
     * @param outputName - Identifier for the outputName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onOutput(outputId: string, outputName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Source to the statement.
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/sources.html
     *
     * @param sourceId - Identifier for the sourceId.
     * @param sourceName - Identifier for the sourceName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSource(sourceId: string, sourceName: string, account?: string, region?: string, partition?: string): this;
}
