import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatemarketplace.html).
 *
 * @experimental
 */
export declare class AwsMarketplacePrivate extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatemarketplace.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Adds new approved products to the Private Marketplace.
     *
     * Also allows to approve a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toAssociateProductsWithPrivateMarketplace(): this;
    /**
     * (experimental) Creates a Private Marketplace for the individual account, or for the entire AWS Organization if one exists.
     *
     * This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toCreatePrivateMarketplace(): this;
    /**
     * (experimental) Creates a new request for a product or products to be associated with the Private Marketplace.
     *
     * This action can be performed by any account in an in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toCreatePrivateMarketplaceRequests(): this;
    /**
     * (experimental) Describes requests and associated products in the Private Marketplace.
     *
     * This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toDescribePrivateMarketplaceRequests(): this;
    /**
     * (experimental) Describes the status of the Private Marketplace for administrative purposes.
     *
     * This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toDescribePrivateMarketplaceStatus(): this;
    /**
     * (experimental) Removes approved products from the Private Marketplace.
     *
     * Also allows to decline a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toDisassociateProductsFromPrivateMarketplace(): this;
    /**
     * (experimental) Queryable list for requests and associated products in the Private Marketplace.
     *
     * This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toListPrivateMarketplaceRequests(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
