import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [storagegateway](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonstoragegateway.html).
 *
 * @experimental
 */
export declare class Storagegateway extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [storagegateway](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonstoragegateway.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to activate the gateway you previously deployed on your host.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ActivateGateway.html
     *
     * @experimental
     */
    toActivateGateway(): this;
    /**
     * (experimental) Grants permission to configure one or more gateway local disks as cache for a cached-volume gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddCache.html
     *
     * @experimental
     */
    toAddCache(): this;
    /**
     * (experimental) Grants permission to add one or more tags to the specified resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddTagsToResource.html
     *
     * @experimental
     */
    toAddTagsToResource(): this;
    /**
     * (experimental) Grants permission to configure one or more gateway local disks as upload buffer for a specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddUploadBuffer.html
     *
     * @experimental
     */
    toAddUploadBuffer(): this;
    /**
     * (experimental) Grants permission to configure one or more gateway local disks as working storage for a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddWorkingStorage.html
     *
     * @experimental
     */
    toAddWorkingStorage(): this;
    /**
     * (experimental) Grants permission to move a tape to the target pool specified.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AssignTapePool.html
     *
     * @experimental
     */
    toAssignTapePool(): this;
    /**
     * (experimental) Grants permission to associate an Amazon FSx file system with the Amazon FSx file gateway.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AssociateFileSystem.html
     *
     * @experimental
     */
    toAssociateFileSystem(): this;
    /**
     * (experimental) Grants permission to connect a volume to an iSCSI connection and then attaches the volume to the specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AttachVolume.html
     *
     * @experimental
     */
    toAttachVolume(): this;
    /**
     * (experimental) Grants permission to allow the governance retention lock on a pool to be bypassed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/CreatingCustomTapePool.html#TapeRetentionLock
     *
     * @experimental
     */
    toBypassGovernanceRetention(): this;
    /**
     * (experimental) Grants permission to cancel archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CancelArchival.html
     *
     * @experimental
     */
    toCancelArchival(): this;
    /**
     * (experimental) Grants permission to cancel retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CancelRetrieval.html
     *
     * @experimental
     */
    toCancelRetrieval(): this;
    /**
     * (experimental) Grants permission to create a cached volume on a specified cached gateway.
     *
     * This operation is supported only for the gateway-cached volume architecture
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateCachediSCSIVolume.html
     *
     * @experimental
     */
    toCreateCachediSCSIVolume(): this;
    /**
     * (experimental) Grants permission to create a NFS file share on an existing file gateway.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html
     *
     * @experimental
     */
    toCreateNFSFileShare(): this;
    /**
     * (experimental) Grants permission to create a SMB file share on an existing file gateway.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSMBFileShare.html
     *
     * @experimental
     */
    toCreateSMBFileShare(): this;
    /**
     * (experimental) Grants permission to initiate a snapshot of a volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSnapshot.html
     *
     * @experimental
     */
    toCreateSnapshot(): this;
    /**
     * (experimental) Grants permission to initiate a snapshot of a gateway from a volume recovery point.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSnapshotFromVolumeRecoveryPoint.html
     *
     * @experimental
     */
    toCreateSnapshotFromVolumeRecoveryPoint(): this;
    /**
     * (experimental) Grants permission to create a volume on a specified gateway.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateStorediSCSIVolume.html
     *
     * @experimental
     */
    toCreateStorediSCSIVolume(): this;
    /**
     * (experimental) Grants permission to create a tape pool.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapePool.html
     *
     * @experimental
     */
    toCreateTapePool(): this;
    /**
     * (experimental) Grants permission to create a virtual tape by using your own barcode.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapeWithBarcode.html
     *
     * @experimental
     */
    toCreateTapeWithBarcode(): this;
    /**
     * (experimental) Grants permission to create one or more virtual tapes.
     *
     * You write data to the virtual tapes and then archive the tapes
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapes.html
     *
     * @experimental
     */
    toCreateTapes(): this;
    /**
     * (experimental) Grants permission to delete the automatic tape creation policy configured on a gateway-VTL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteAutomaticTapeCreationPolicy.html
     *
     * @experimental
     */
    toDeleteAutomaticTapeCreationPolicy(): this;
    /**
     * (experimental) Grants permission to delete the bandwidth rate limits of a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteBandwidthRateLimit.html
     *
     * @experimental
     */
    toDeleteBandwidthRateLimit(): this;
    /**
     * (experimental) Grants permission to delete Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteChapCredentials.html
     *
     * @experimental
     */
    toDeleteChapCredentials(): this;
    /**
     * (experimental) Grants permission to delete a file share from a file gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteFileShare.html
     *
     * @experimental
     */
    toDeleteFileShare(): this;
    /**
     * (experimental) Grants permission to delete a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteGateway.html
     *
     * @experimental
     */
    toDeleteGateway(): this;
    /**
     * (experimental) Grants permission to delete a snapshot of a volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteSnapshotSchedule.html
     *
     * @experimental
     */
    toDeleteSnapshotSchedule(): this;
    /**
     * (experimental) Grants permission to delete the specified virtual tape.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTape.html
     *
     * @experimental
     */
    toDeleteTape(): this;
    /**
     * (experimental) Grants permission to delete the specified virtual tape from the virtual tape shelf (VTS).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTapeArchive.html
     *
     * @experimental
     */
    toDeleteTapeArchive(): this;
    /**
     * (experimental) Grants permission to delete the specified tape pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTapePool.html
     *
     * @experimental
     */
    toDeleteTapePool(): this;
    /**
     * (experimental) Grants permission to delete the specified gateway volume that you previously created using the CreateCachediSCSIVolume or CreateStorediSCSIVolume API.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteVolume.html
     *
     * @experimental
     */
    toDeleteVolume(): this;
    /**
     * (experimental) Grants permission to get the information about the most recent high availability monitoring test that was performed on the gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeAvailabilityMonitorTest.html
     *
     * @experimental
     */
    toDescribeAvailabilityMonitorTest(): this;
    /**
     * (experimental) Grants permission to get the bandwidth rate limits of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeBandwidthRateLimit.html
     *
     * @experimental
     */
    toDescribeBandwidthRateLimit(): this;
    /**
     * (experimental) Grants permission to get the bandwidth rate limit schedule of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeBandwidthRateLimitSchedule.html
     *
     * @experimental
     */
    toDescribeBandwidthRateLimitSchedule(): this;
    /**
     * (experimental) Grants permission to get information about the cache of a gateway.
     *
     * This operation is supported only for the gateway-cached volume architecture
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeCache.html
     *
     * @experimental
     */
    toDescribeCache(): this;
    /**
     * (experimental) Grants permission to get a description of the gateway volumes specified in the request.
     *
     * This operation is supported only for the gateway-cached volume architecture
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeCachediSCSIVolumes.html
     *
     * @experimental
     */
    toDescribeCachediSCSIVolumes(): this;
    /**
     * (experimental) Grants permission to get an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeChapCredentials.html
     *
     * @experimental
     */
    toDescribeChapCredentials(): this;
    /**
     * (experimental) Grants permission to get a description for one or more file system associations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeFileSystemAssociations.html
     *
     * @experimental
     */
    toDescribeFileSystemAssociations(): this;
    /**
     * (experimental) Grants permission to get metadata about a gateway such as its name, network interfaces, configured time zone, and the state (whether the gateway is running or not).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeGatewayInformation.html
     *
     * @experimental
     */
    toDescribeGatewayInformation(): this;
    /**
     * (experimental) Grants permission to get your gateway's weekly maintenance start time including the day and time of the week.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeMaintenanceStartTime.html
     *
     * @experimental
     */
    toDescribeMaintenanceStartTime(): this;
    /**
     * (experimental) Grants permission to get a description for one or more file shares from a file gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeNFSFileShares.html
     *
     * @experimental
     */
    toDescribeNFSFileShares(): this;
    /**
     * (experimental) Grants permission to get a description for one or more file shares from a file gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSMBFileShares.html
     *
     * @experimental
     */
    toDescribeSMBFileShares(): this;
    /**
     * (experimental) Grants permission to get a description of a Server Message Block (SMB) file share settings from a file gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSMBSettings.html
     *
     * @experimental
     */
    toDescribeSMBSettings(): this;
    /**
     * (experimental) Grants permission to describe the snapshot schedule for the specified gateway volume.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSnapshotSchedule.html
     *
     * @experimental
     */
    toDescribeSnapshotSchedule(): this;
    /**
     * (experimental) Grants permission to get the description of the gateway volumes specified in the request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeStorediSCSIVolumes.html
     *
     * @experimental
     */
    toDescribeStorediSCSIVolumes(): this;
    /**
     * (experimental) Grants permission to get a description of specified virtual tapes in the virtual tape shelf (VTS).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapeArchives.html
     *
     * @experimental
     */
    toDescribeTapeArchives(): this;
    /**
     * (experimental) Grants permission to get a list of virtual tape recovery points that are available for the specified gateway-VTL.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapeRecoveryPoints.html
     *
     * @experimental
     */
    toDescribeTapeRecoveryPoints(): this;
    /**
     * (experimental) Grants permission to get a description of the specified Amazon Resource Name (ARN) of virtual tapes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapes.html
     *
     * @experimental
     */
    toDescribeTapes(): this;
    /**
     * (experimental) Grants permission to get information about the upload buffer of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeUploadBuffer.html
     *
     * @experimental
     */
    toDescribeUploadBuffer(): this;
    /**
     * (experimental) Grants permission to get a description of virtual tape library (VTL) devices for the specified gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeVTLDevices.html
     *
     * @experimental
     */
    toDescribeVTLDevices(): this;
    /**
     * (experimental) Grants permission to get information about the working storage of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeWorkingStorage.html
     *
     * @experimental
     */
    toDescribeWorkingStorage(): this;
    /**
     * (experimental) Grants permission to disconnect a volume from an iSCSI connection and then detaches the volume from the specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DetachVolume.html
     *
     * @experimental
     */
    toDetachVolume(): this;
    /**
     * (experimental) Grants permission to disable a gateway when the gateway is no longer functioning.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DisableGateway.html
     *
     * @experimental
     */
    toDisableGateway(): this;
    /**
     * (experimental) Grants permission to disassociate an Amazon FSx file system from an Amazon FSx file gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DisassociateFileSystem.html
     *
     * @experimental
     */
    toDisassociateFileSystem(): this;
    /**
     * (experimental) Grants permission to enable you to join an Active Directory Domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_JoinDomain.html
     *
     * @experimental
     */
    toJoinDomain(): this;
    /**
     * (experimental) Grants permission to list the automatic tape creation policies configured on the specified gateway-VTL or all gateway-VTLs owned by your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListAutomaticTapeCreationPolicies.html
     *
     * @experimental
     */
    toListAutomaticTapeCreationPolicies(): this;
    /**
     * (experimental) Grants permission to get a list of the file shares for a specific file gateway, or the list of file shares that belong to the calling user account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListFileShares.html
     *
     * @experimental
     */
    toListFileShares(): this;
    /**
     * (experimental) Grants permission to get a list of the file system associations for the specified gateway.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListFileSystemAssociations.html
     *
     * @experimental
     */
    toListFileSystemAssociations(): this;
    /**
     * (experimental) Grants permission to list gateways owned by an AWSaccount in a region specified in the request.
     *
     * The returned list is ordered by gateway Amazon Resource Name (ARN)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListGateways.html
     *
     * @experimental
     */
    toListGateways(): this;
    /**
     * (experimental) Grants permission to get a list of the gateway's local disks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListLocalDisks.html
     *
     * @experimental
     */
    toListLocalDisks(): this;
    /**
     * (experimental) Grants permission to get the tags that have been added to the specified resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list tape pools owned by your AWSaccount.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTapePools.html
     *
     * @experimental
     */
    toListTapePools(): this;
    /**
     * (experimental) Grants permission to list virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTapes.html
     *
     * @experimental
     */
    toListTapes(): this;
    /**
     * (experimental) Grants permission to list iSCSI initiators that are connected to a volume.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumeInitiators.html
     *
     * @experimental
     */
    toListVolumeInitiators(): this;
    /**
     * (experimental) Grants permission to list the recovery points for a specified gateway.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumeRecoveryPoints.html
     *
     * @experimental
     */
    toListVolumeRecoveryPoints(): this;
    /**
     * (experimental) Grants permission to list the iSCSI stored volumes of a gateway.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumes.html
     *
     * @experimental
     */
    toListVolumes(): this;
    /**
     * (experimental) Grants permission to send you a notification through CloudWatch Events when all files written to your NFS file share have been uploaded to Amazon S3.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_NotifyWhenUploaded.html
     *
     * @experimental
     */
    toNotifyWhenUploaded(): this;
    /**
     * (experimental) Grants permission to refresh the cache for the specified file share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RefreshCache.html
     *
     * @experimental
     */
    toRefreshCache(): this;
    /**
     * (experimental) Grants permission to remove one or more tags from the specified resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RemoveTagsFromResource.html
     *
     * @experimental
     */
    toRemoveTagsFromResource(): this;
    /**
     * (experimental) Grants permission to reset all cache disks that have encountered a error and makes the disks available for reconfiguration as cache storage.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ResetCache.html
     *
     * @experimental
     */
    toResetCache(): this;
    /**
     * (experimental) Grants permission to retrieve an archived virtual tape from the virtual tape shelf (VTS) to a gateway-VTL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RetrieveTapeArchive.html
     *
     * @experimental
     */
    toRetrieveTapeArchive(): this;
    /**
     * (experimental) Grants permission to retrieve the recovery point for the specified virtual tape.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RetrieveTapeRecoveryPoint.html
     *
     * @experimental
     */
    toRetrieveTapeRecoveryPoint(): this;
    /**
     * (experimental) Grants permission to set the password for your VM local console.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_SetLocalConsolePassword.html
     *
     * @experimental
     */
    toSetLocalConsolePassword(): this;
    /**
     * (experimental) Grants permission to set the password for SMB Guest user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_SetSMBGuestPassword.html
     *
     * @experimental
     */
    toSetSMBGuestPassword(): this;
    /**
     * (experimental) Grants permission to shut down a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ShutdownGateway.html
     *
     * @experimental
     */
    toShutdownGateway(): this;
    /**
     * (experimental) Grants permission to start a test that verifies that the specified gateway is configured for High Availability monitoring in your host environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_StartAvailabilityMonitorTest.html
     *
     * @experimental
     */
    toStartAvailabilityMonitorTest(): this;
    /**
     * (experimental) Grants permission to start a gateway that you previously shut down.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_StartGateway.html
     *
     * @experimental
     */
    toStartGateway(): this;
    /**
     * (experimental) Grants permission to update the automatic tape creation policy configured on a gateway-VTL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateAutomaticTapeCreationPolicy.html
     *
     * @experimental
     */
    toUpdateAutomaticTapeCreationPolicy(): this;
    /**
     * (experimental) Grants permission to update the bandwidth rate limits of a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateBandwidthRateLimit.html
     *
     * @experimental
     */
    toUpdateBandwidthRateLimit(): this;
    /**
     * (experimental) Grants permission to update the bandwidth rate limit schedule of a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateBandwidthRateLimitSchedule.html
     *
     * @experimental
     */
    toUpdateBandwidthRateLimitSchedule(): this;
    /**
     * (experimental) Grants permission to update the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateChapCredentials.html
     *
     * @experimental
     */
    toUpdateChapCredentials(): this;
    /**
     * (experimental) Grants permission to update a file system association.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateFileSystemAssociation.html
     *
     * @experimental
     */
    toUpdateFileSystemAssociation(): this;
    /**
     * (experimental) Grants permission to update a gateway's metadata, which includes the gateway's name and time zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateGatewayInformation.html
     *
     * @experimental
     */
    toUpdateGatewayInformation(): this;
    /**
     * (experimental) Grants permission to update the gateway virtual machine (VM) software.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateGatewaySoftwareNow.html
     *
     * @experimental
     */
    toUpdateGatewaySoftwareNow(): this;
    /**
     * (experimental) Grants permission to update a gateway's weekly maintenance start time information, including day and time of the week.
     *
     * The maintenance time is the time in your gateway's time zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateMaintenanceStartTime.html
     *
     * @experimental
     */
    toUpdateMaintenanceStartTime(): this;
    /**
     * (experimental) Grants permission to update a NFS file share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateNFSFileShare.html
     *
     * @experimental
     */
    toUpdateNFSFileShare(): this;
    /**
     * (experimental) Grants permission to update a SMB file share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSMBFileShare.html
     *
     * @experimental
     */
    toUpdateSMBFileShare(): this;
    /**
     * (experimental) Grants permission to update whether the shares on a gateway are visible in a net view or browse list.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSMBFileShareVisibility.html
     *
     * @experimental
     */
    toUpdateSMBFileShareVisibility(): this;
    /**
     * (experimental) Grants permission to update the SMB security strategy on a file gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSMBSecurityStrategy.html
     *
     * @experimental
     */
    toUpdateSMBSecurityStrategy(): this;
    /**
     * (experimental) Grants permission to update a snapshot schedule configured for a gateway volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSnapshotSchedule.html
     *
     * @experimental
     */
    toUpdateSnapshotSchedule(): this;
    /**
     * (experimental) Grants permission to update the type of medium changer in a gateway-VTL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateVTLDeviceType.html
     *
     * @experimental
     */
    toUpdateVTLDeviceType(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type device to the statement.
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/resource_vtl-devices.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param vtldevice - Identifier for the vtldevice.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDevice(gatewayId: string, vtldevice: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type fs-association to the statement.
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/API_AssociateFileSystem.html
     *
     * @param fsaId - Identifier for the fsaId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFsAssociation(fsaId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type gateway to the statement.
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onGateway(gatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type share to the statement.
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateFileShare.html
     *
     * @param shareId - Identifier for the shareId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onShare(shareId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type tape to the statement.
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html#storage-gateway-vtl-concepts
     *
     * @param tapeBarcode - Identifier for the tapeBarcode.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTape(tapeBarcode: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type tapepool to the statement.
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/CreatingCustomTapePool.html
     *
     * @param poolId - Identifier for the poolId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTapepool(poolId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type target to the statement.
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateVolumes.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param iscsiTarget - Identifier for the iscsiTarget.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTarget(gatewayId: string, iscsiTarget: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type volume to the statement.
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html#volume-gateway-concepts
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param volumeId - Identifier for the volumeId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVolume(gatewayId: string, volumeId: string, account?: string, region?: string, partition?: string): this;
}
