# API Reference <a name="API Reference"></a>

## Constructs <a name="Constructs"></a>

### EksSpotCluster <a name="eks-spot-blocks.EksSpotCluster"></a>

#### Initializers <a name="eks-spot-blocks.EksSpotCluster.Initializer"></a>

```typescript
import { EksSpotCluster } from 'eks-spot-blocks'

new EksSpotCluster(scope: Construct, id: string, props: EksSpotClusterProps)
```

##### `scope`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.scope"></a>

- *Type:* [`@aws-cdk/core.Construct`](#@aws-cdk/core.Construct)

---

##### `id`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.id"></a>

- *Type:* `string`

---

##### `props`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.props"></a>

- *Type:* [`eks-spot-blocks.EksSpotClusterProps`](#eks-spot-blocks.EksSpotClusterProps)

---

#### Methods <a name="Methods"></a>

##### `addDays` <a name="eks-spot-blocks.EksSpotCluster.addDays"></a>

```typescript
public addDays(date: Date, days: number)
```

###### `date`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.date"></a>

- *Type:* `Date`

---

###### `days`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.days"></a>

- *Type:* `number`

---

##### `addHours` <a name="eks-spot-blocks.EksSpotCluster.addHours"></a>

```typescript
public addHours(date: Date, hours: number)
```

###### `date`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.date"></a>

- *Type:* `Date`

---

###### `hours`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.hours"></a>

- *Type:* `number`

---

##### `addMinutes` <a name="eks-spot-blocks.EksSpotCluster.addMinutes"></a>

```typescript
public addMinutes(date: Date, minutes: number)
```

###### `date`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.date"></a>

- *Type:* `Date`

---

###### `minutes`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.minutes"></a>

- *Type:* `number`

---

##### `addSpotFleet` <a name="eks-spot-blocks.EksSpotCluster.addSpotFleet"></a>

```typescript
public addSpotFleet(id: string, props: BaseSpotFleetProps)
```

###### `id`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.id"></a>

- *Type:* `string`

---

###### `props`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.parameter.props"></a>

- *Type:* [`eks-spot-blocks.BaseSpotFleetProps`](#eks-spot-blocks.BaseSpotFleetProps)

---


#### Properties <a name="Properties"></a>

##### `cluster`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.property.cluster"></a>

```typescript
public readonly cluster: Cluster;
```

- *Type:* [`@aws-cdk/aws-eks.Cluster`](#@aws-cdk/aws-eks.Cluster)

---

##### `clusterVersion`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.property.clusterVersion"></a>

```typescript
public readonly clusterVersion: KubernetesVersion;
```

- *Type:* [`@aws-cdk/aws-eks.KubernetesVersion`](#@aws-cdk/aws-eks.KubernetesVersion)

---

##### `vpc`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotCluster.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* [`@aws-cdk/aws-ec2.IVpc`](#@aws-cdk/aws-ec2.IVpc)

---


### SpotFleet <a name="eks-spot-blocks.SpotFleet"></a>

#### Initializers <a name="eks-spot-blocks.SpotFleet.Initializer"></a>

```typescript
import { SpotFleet } from 'eks-spot-blocks'

new SpotFleet(scope: Construct, id: string, props: SpotFleetProps)
```

##### `scope`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleet.parameter.scope"></a>

- *Type:* [`@aws-cdk/core.Construct`](#@aws-cdk/core.Construct)

---

##### `id`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleet.parameter.id"></a>

- *Type:* `string`

---

##### `props`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleet.parameter.props"></a>

- *Type:* [`eks-spot-blocks.SpotFleetProps`](#eks-spot-blocks.SpotFleetProps)

---



#### Properties <a name="Properties"></a>

##### `clusterStack`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleet.property.clusterStack"></a>

```typescript
public readonly clusterStack: EksSpotCluster;
```

- *Type:* [`eks-spot-blocks.EksSpotCluster`](#eks-spot-blocks.EksSpotCluster)

---

##### `defaultInstanceType`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleet.property.defaultInstanceType"></a>

```typescript
public readonly defaultInstanceType: InstanceType;
```

- *Type:* [`@aws-cdk/aws-ec2.InstanceType`](#@aws-cdk/aws-ec2.InstanceType)

---

##### `instanceRole`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleet.property.instanceRole"></a>

```typescript
public readonly instanceRole: IRole;
```

- *Type:* [`@aws-cdk/aws-iam.IRole`](#@aws-cdk/aws-iam.IRole)

---

##### `launchTemplate`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleet.property.launchTemplate"></a>

```typescript
public readonly launchTemplate: ILaunchtemplate;
```

- *Type:* [`eks-spot-blocks.ILaunchtemplate`](#eks-spot-blocks.ILaunchtemplate)

---

##### `spotFleetId`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleet.property.spotFleetId"></a>

```typescript
public readonly spotFleetId: string;
```

- *Type:* `string`

---

##### `targetCapacity`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleet.property.targetCapacity"></a>

```typescript
public readonly targetCapacity: number;
```

- *Type:* `number`

---


## Structs <a name="Structs"></a>

### BaseSpotFleetProps <a name="eks-spot-blocks.BaseSpotFleetProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { BaseSpotFleetProps } from 'eks-spot-blocks'

const baseSpotFleetProps: BaseSpotFleetProps = { ... }
```

##### `account`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* `string`
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* `string`
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* `string`
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* `string`
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `blockDuration`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.blockDuration"></a>

```typescript
public readonly blockDuration: BlockDuration;
```

- *Type:* [`eks-spot-blocks.BlockDuration`](#eks-spot-blocks.BlockDuration)

---

##### `bootstrapEnabled`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.bootstrapEnabled"></a>

```typescript
public readonly bootstrapEnabled: boolean;
```

- *Type:* `boolean`

---

##### `customAmiId`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.customAmiId"></a>

```typescript
public readonly customAmiId: string;
```

- *Type:* `string`

---

##### `defaultInstanceType`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.defaultInstanceType"></a>

```typescript
public readonly defaultInstanceType: InstanceType;
```

- *Type:* [`@aws-cdk/aws-ec2.InstanceType`](#@aws-cdk/aws-ec2.InstanceType)

---

##### `instanceInterruptionBehavior`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.instanceInterruptionBehavior"></a>

```typescript
public readonly instanceInterruptionBehavior: InstanceInterruptionBehavior;
```

- *Type:* [`eks-spot-blocks.InstanceInterruptionBehavior`](#eks-spot-blocks.InstanceInterruptionBehavior)

---

##### `instanceRole`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.instanceRole"></a>

```typescript
public readonly instanceRole: Role;
```

- *Type:* [`@aws-cdk/aws-iam.Role`](#@aws-cdk/aws-iam.Role)

---

##### `mapRole`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.mapRole"></a>

```typescript
public readonly mapRole: boolean;
```

- *Type:* `boolean`

---

##### `targetCapacity`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.targetCapacity"></a>

```typescript
public readonly targetCapacity: number;
```

- *Type:* `number`

---

##### `terminateInstancesWithExpiration`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.terminateInstancesWithExpiration"></a>

```typescript
public readonly terminateInstancesWithExpiration: boolean;
```

- *Type:* `boolean`

---

##### `validFrom`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.validFrom"></a>

```typescript
public readonly validFrom: string;
```

- *Type:* `string`

---

##### `validUntil`<sup>Optional</sup> <a name="eks-spot-blocks.BaseSpotFleetProps.property.validUntil"></a>

```typescript
public readonly validUntil: string;
```

- *Type:* `string`

---

### EksSpotClusterProps <a name="eks-spot-blocks.EksSpotClusterProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { EksSpotClusterProps } from 'eks-spot-blocks'

const eksSpotClusterProps: EksSpotClusterProps = { ... }
```

##### `analyticsReporting`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.analyticsReporting"></a>

```typescript
public readonly analyticsReporting: boolean;
```

- *Type:* `boolean`
- *Default:* `analyticsReporting` setting of containing `App`, or value of
'aws:cdk:version-reporting' context key

Include runtime versioning information in this Stack.

---

##### `description`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`
- *Default:* No description.

A description of the stack.

---

##### `env`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.env"></a>

```typescript
public readonly env: Environment;
```

- *Type:* [`@aws-cdk/core.Environment`](#@aws-cdk/core.Environment)
- *Default:* The environment of the containing `Stage` if available,
otherwise create the stack will be environment-agnostic.

The AWS environment (account/region) where this stack will be deployed.

Set the `region`/`account` fields of `env` to either a concrete value to
select the indicated environment (recommended for production stacks), or to
the values of environment variables
`CDK_DEFAULT_REGION`/`CDK_DEFAULT_ACCOUNT` to let the target environment
depend on the AWS credentials/configuration that the CDK CLI is executed
under (recommended for development stacks).

If the `Stack` is instantiated inside a `Stage`, any undefined
`region`/`account` fields from `env` will default to the same field on the
encompassing `Stage`, if configured there.

If either `region` or `account` are not set nor inherited from `Stage`, the
Stack will be considered "*environment-agnostic*"". Environment-agnostic
stacks can be deployed to any environment but may not be able to take
advantage of all features of the CDK. For example, they will not be able to
use environmental context lookups such as `ec2.Vpc.fromLookup` and will not
automatically translate Service Principals to the right format based on the
environment's AWS partition, and other such enhancements.

---

##### `stackName`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.stackName"></a>

```typescript
public readonly stackName: string;
```

- *Type:* `string`
- *Default:* Derived from construct path.

Name to deploy the stack with.

---

##### `synthesizer`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.synthesizer"></a>

```typescript
public readonly synthesizer: IStackSynthesizer;
```

- *Type:* [`@aws-cdk/core.IStackSynthesizer`](#@aws-cdk/core.IStackSynthesizer)
- *Default:* `DefaultStackSynthesizer` if the `@aws-cdk/core:newStyleStackSynthesis` feature flag
is set, `LegacyStackSynthesizer` otherwise.

Synthesis method to use while deploying this stack.

---

##### `tags`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.tags"></a>

```typescript
public readonly tags: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: `string`}
- *Default:* {}

Stack tags that will be applied to all the taggable resources and the stack itself.

---

##### `terminationProtection`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.terminationProtection"></a>

```typescript
public readonly terminationProtection: boolean;
```

- *Type:* `boolean`
- *Default:* false

Whether to enable termination protection for this stack.

---

##### `clusterVersion`<sup>Required</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.clusterVersion"></a>

```typescript
public readonly clusterVersion: KubernetesVersion;
```

- *Type:* [`@aws-cdk/aws-eks.KubernetesVersion`](#@aws-cdk/aws-eks.KubernetesVersion)

---

##### `clusterAttributes`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.clusterAttributes"></a>

```typescript
public readonly clusterAttributes: ClusterAttributes;
```

- *Type:* [`@aws-cdk/aws-eks.ClusterAttributes`](#@aws-cdk/aws-eks.ClusterAttributes)

---

##### `customAmiId`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.customAmiId"></a>

```typescript
public readonly customAmiId: string;
```

- *Type:* `string`
- *Default:* none

Specify a custom AMI ID for your spot fleet.

By default the Amazon EKS-optimized
AMI will be selected.

---

##### `instanceInterruptionBehavior`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.instanceInterruptionBehavior"></a>

```typescript
public readonly instanceInterruptionBehavior: InstanceInterruptionBehavior;
```

- *Type:* [`eks-spot-blocks.InstanceInterruptionBehavior`](#eks-spot-blocks.InstanceInterruptionBehavior)

---

##### `instanceRole`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.instanceRole"></a>

```typescript
public readonly instanceRole: IRole;
```

- *Type:* [`@aws-cdk/aws-iam.IRole`](#@aws-cdk/aws-iam.IRole)

---

##### `kubectlEnabled`<sup>Optional</sup> <a name="eks-spot-blocks.EksSpotClusterProps.property.kubectlEnabled"></a>

```typescript
public readonly kubectlEnabled: boolean;
```

- *Type:* `boolean`

---

### SpotFleetLaunchTemplateConfig <a name="eks-spot-blocks.SpotFleetLaunchTemplateConfig"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { SpotFleetLaunchTemplateConfig } from 'eks-spot-blocks'

const spotFleetLaunchTemplateConfig: SpotFleetLaunchTemplateConfig = { ... }
```

##### `launchTemplate`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleetLaunchTemplateConfig.property.launchTemplate"></a>

```typescript
public readonly launchTemplate: ILaunchtemplate;
```

- *Type:* [`eks-spot-blocks.ILaunchtemplate`](#eks-spot-blocks.ILaunchtemplate)

---

##### `spotfleet`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleetLaunchTemplateConfig.property.spotfleet"></a>

```typescript
public readonly spotfleet: SpotFleet;
```

- *Type:* [`eks-spot-blocks.SpotFleet`](#eks-spot-blocks.SpotFleet)

---

### SpotFleetProps <a name="eks-spot-blocks.SpotFleetProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```typescript
import { SpotFleetProps } from 'eks-spot-blocks'

const spotFleetProps: SpotFleetProps = { ... }
```

##### `account`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* `string`
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* `string`
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* `string`
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* `string`
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `blockDuration`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.blockDuration"></a>

```typescript
public readonly blockDuration: BlockDuration;
```

- *Type:* [`eks-spot-blocks.BlockDuration`](#eks-spot-blocks.BlockDuration)

---

##### `bootstrapEnabled`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.bootstrapEnabled"></a>

```typescript
public readonly bootstrapEnabled: boolean;
```

- *Type:* `boolean`

---

##### `customAmiId`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.customAmiId"></a>

```typescript
public readonly customAmiId: string;
```

- *Type:* `string`

---

##### `defaultInstanceType`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.defaultInstanceType"></a>

```typescript
public readonly defaultInstanceType: InstanceType;
```

- *Type:* [`@aws-cdk/aws-ec2.InstanceType`](#@aws-cdk/aws-ec2.InstanceType)

---

##### `instanceInterruptionBehavior`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.instanceInterruptionBehavior"></a>

```typescript
public readonly instanceInterruptionBehavior: InstanceInterruptionBehavior;
```

- *Type:* [`eks-spot-blocks.InstanceInterruptionBehavior`](#eks-spot-blocks.InstanceInterruptionBehavior)

---

##### `instanceRole`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.instanceRole"></a>

```typescript
public readonly instanceRole: Role;
```

- *Type:* [`@aws-cdk/aws-iam.Role`](#@aws-cdk/aws-iam.Role)

---

##### `mapRole`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.mapRole"></a>

```typescript
public readonly mapRole: boolean;
```

- *Type:* `boolean`

---

##### `targetCapacity`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.targetCapacity"></a>

```typescript
public readonly targetCapacity: number;
```

- *Type:* `number`

---

##### `terminateInstancesWithExpiration`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.terminateInstancesWithExpiration"></a>

```typescript
public readonly terminateInstancesWithExpiration: boolean;
```

- *Type:* `boolean`

---

##### `validFrom`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.validFrom"></a>

```typescript
public readonly validFrom: string;
```

- *Type:* `string`

---

##### `validUntil`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.validUntil"></a>

```typescript
public readonly validUntil: string;
```

- *Type:* `string`

---

##### `cluster`<sup>Required</sup> <a name="eks-spot-blocks.SpotFleetProps.property.cluster"></a>

```typescript
public readonly cluster: EksSpotCluster;
```

- *Type:* [`eks-spot-blocks.EksSpotCluster`](#eks-spot-blocks.EksSpotCluster)

---

##### `launchTemplate`<sup>Optional</sup> <a name="eks-spot-blocks.SpotFleetProps.property.launchTemplate"></a>

```typescript
public readonly launchTemplate: ILaunchtemplate;
```

- *Type:* [`eks-spot-blocks.ILaunchtemplate`](#eks-spot-blocks.ILaunchtemplate)

---

## Classes <a name="Classes"></a>

### LaunchTemplate <a name="eks-spot-blocks.LaunchTemplate"></a>

- *Implements:* [`eks-spot-blocks.ILaunchtemplate`](#eks-spot-blocks.ILaunchtemplate)

#### Initializers <a name="eks-spot-blocks.LaunchTemplate.Initializer"></a>

```typescript
import { LaunchTemplate } from 'eks-spot-blocks'

new LaunchTemplate()
```

#### Methods <a name="Methods"></a>

##### `bind` <a name="eks-spot-blocks.LaunchTemplate.bind"></a>

```typescript
public bind(spotfleet: SpotFleet)
```

###### `spotfleet`<sup>Required</sup> <a name="eks-spot-blocks.LaunchTemplate.parameter.spotfleet"></a>

- *Type:* [`eks-spot-blocks.SpotFleet`](#eks-spot-blocks.SpotFleet)

---




## Protocols <a name="Protocols"></a>

### ILaunchtemplate <a name="eks-spot-blocks.ILaunchtemplate"></a>

- *Implemented By:* [`eks-spot-blocks.LaunchTemplate`](#eks-spot-blocks.LaunchTemplate), [`eks-spot-blocks.ILaunchtemplate`](#eks-spot-blocks.ILaunchtemplate)

#### Methods <a name="Methods"></a>

##### `bind` <a name="eks-spot-blocks.ILaunchtemplate.bind"></a>

```typescript
public bind(spotfleet: SpotFleet)
```

###### `spotfleet`<sup>Required</sup> <a name="eks-spot-blocks.ILaunchtemplate.parameter.spotfleet"></a>

- *Type:* [`eks-spot-blocks.SpotFleet`](#eks-spot-blocks.SpotFleet)

---


## Enums <a name="Enums"></a>

### BlockDuration <a name="BlockDuration"></a>

#### `ONE_HOUR` <a name="eks-spot-blocks.BlockDuration.ONE_HOUR"></a>

---


#### `TWO_HOURS` <a name="eks-spot-blocks.BlockDuration.TWO_HOURS"></a>

---


#### `THREE_HOURS` <a name="eks-spot-blocks.BlockDuration.THREE_HOURS"></a>

---


#### `FOUR_HOURS` <a name="eks-spot-blocks.BlockDuration.FOUR_HOURS"></a>

---


#### `FIVE_HOURS` <a name="eks-spot-blocks.BlockDuration.FIVE_HOURS"></a>

---


#### `SIX_HOURS` <a name="eks-spot-blocks.BlockDuration.SIX_HOURS"></a>

---


### InstanceInterruptionBehavior <a name="InstanceInterruptionBehavior"></a>

#### `HIBERNATE` <a name="eks-spot-blocks.InstanceInterruptionBehavior.HIBERNATE"></a>

---


#### `STOP` <a name="eks-spot-blocks.InstanceInterruptionBehavior.STOP"></a>

---


#### `TERMINATE` <a name="eks-spot-blocks.InstanceInterruptionBehavior.TERMINATE"></a>

---

