from enum import Enum


class EventCode(Enum):
    LEAVE = 1
    JOIN_FINISHED = 2
    MOVE = 3
    TELEPORT = 4
    CHANGE_EQUIPMENT = 5
    HEALTH_UPDATE = 6
    ENERGY_UPDATE = 7
    DAMAGE_SHIELD_UPDATE = 8
    CRAFTING_FOCUS_UPDATE = 9
    ACTIVE_SPELL_EFFECTS_UPDATE = 10
    RESET_COOLDOWNS = 11
    ATTACK = 12
    CAST_START = 13
    CHANNELING_UPDATE = 14
    CAST_CANCEL = 15
    CAST_TIME_UPDATE = 16
    CAST_FINISHED = 17
    CAST_SPELL = 18
    CAST_SPELLS = 19
    CAST_HIT = 20
    CAST_HITS = 21
    STORED_TARGETS_UPDATE = 22
    CHANNELING_ENDED = 23
    ATTACK_BUILDING = 24
    INVENTORY_PUT_ITEM = 25
    INVENTORY_DELETE_ITEM = 26
    INVENTORY_STATE = 27
    NEW_CHARACTER = 28
    NEW_EQUIPMENT_ITEM = 29
    NEW_SIEGE_BANNER_ITEM = 30
    NEW_SIMPLE_ITEM = 31
    NEW_FURNITURE_ITEM = 32
    NEW_KILL_TROPHY_ITEM = 33
    NEW_JOURNAL_ITEM = 34
    NEW_LABORER_ITEM = 35
    NEW_EQUIPMENT_ITEM_LEGENDARY_SOUL = 36
    NEW_SIMPLE_HARVESTABLE_OBJECT = 37
    NEW_SIMPLE_HARVESTABLE_OBJECT_LIST = 38
    NEW_HARVESTABLE_OBJECT = 39
    NEW_TREASURE_DESTINATION_OBJECT = 40
    TREASURE_DESTINATION_OBJECT_STATUS = 41
    CLOSE_TREASURE_DESTINATION_OBJECT = 42
    NEW_SILVER_OBJECT = 43
    NEW_BUILDING = 44
    HARVESTABLE_CHANGE_STATE = 45
    MOB_CHANGE_STATE = 46
    FACTION_BUILDING_INFO = 47
    CRAFT_BUILDING_INFO = 48
    REPAIR_BUILDING_INFO = 49
    MELD_BUILDING_INFO = 50
    CONSTRUCTION_SITE_INFO = 51
    PLAYER_BUILDING_INFO = 52
    FARM_BUILDING_INFO = 53
    TUTORIAL_BUILDING_INFO = 54
    LABORER_OBJECT_INFO = 55
    LABORER_OBJECT_JOB_INFO = 56
    MARKET_PLACE_BUILDING_INFO = 57
    HARVEST_START = 58
    HARVEST_CANCEL = 59
    HARVEST_FINISHED = 60
    TAKE_SILVER = 61
    ACTION_ON_BUILDING_START = 62
    ACTION_ON_BUILDING_CANCEL = 63
    ACTION_ON_BUILDING_FINISHED = 64
    ITEM_REROLL_QUALITY_FINISHED = 65
    INSTALL_RESOURCE_START = 66
    INSTALL_RESOURCE_CANCEL = 67
    INSTALL_RESOURCE_FINISHED = 68
    CRAFT_ITEM_FINISHED = 69
    LOGOUT_CANCEL = 70
    CHAT_MESSAGE = 71
    CHAT_SAY = 72
    CHAT_WHISPER = 73
    CHAT_MUTED = 74
    PLAY_EMOTE = 75
    STOP_EMOTE = 76
    SYSTEM_MESSAGE = 77
    UTILITY_TEXT_MESSAGE = 78
    UPDATE_MONEY = 79
    UPDATE_FAME = 80
    UPDATE_LEARNING_POINTS = 81
    UPDATE_RE_SPEC_POINTS = 82
    UPDATE_CURRENCY = 83
    UPDATE_FACTION_STANDING = 84
    UPDATE_MIST_CITY_STANDING = 85
    RESPAWN = 86
    SERVER_DEBUG_LOG = 87
    CHARACTER_EQUIPMENT_CHANGED = 88
    REGENERATION_HEALTH_CHANGED = 89
    REGENERATION_ENERGY_CHANGED = 90
    REGENERATION_MOUNT_HEALTH_CHANGED = 91
    REGENERATION_CRAFTING_CHANGED = 92
    REGENERATION_HEALTH_ENERGY_COMBO_CHANGED = 93
    REGENERATION_PLAYER_COMBO_CHANGED = 94
    DURABILITY_CHANGED = 95
    NEW_LOOT = 96
    ATTACH_ITEM_CONTAINER = 97
    DETACH_ITEM_CONTAINER = 98
    INVALIDATE_ITEM_CONTAINER = 99
    LOCK_ITEM_CONTAINER = 100
    GUILD_UPDATE = 101
    GUILD_PLAYER_UPDATED = 102
    INVITED_TO_GUILD = 103
    GUILD_MEMBER_WORLD_UPDATE = 104
    UPDATE_MATCH_DETAILS = 105
    OBJECT_EVENT = 106
    NEW_MONOLITH_OBJECT = 107
    MONOLITH_HAS_BANNERS_PLACED_UPDATE = 108
    NEW_ORB_OBJECT = 109
    NEW_CASTLE_OBJECT = 110
    NEW_SPELL_EFFECT_AREA = 111
    UPDATE_SPELL_EFFECT_AREA = 112
    NEW_CHAIN_SPELL = 113
    UPDATE_CHAIN_SPELL = 114
    NEW_TREASURE_CHEST = 115
    START_MATCH = 116
    START_ARENA_MATCH_INFOS = 117
    END_ARENA_MATCH = 118
    MATCH_UPDATE = 119
    ACTIVE_MATCH_UPDATE = 120
    NEW_MOB = 121
    DEBUG_AGGRO_INFO = 122
    DEBUG_VARIABLES_INFO = 123
    DEBUG_REPUTATION_INFO = 124
    DEBUG_DIMINISHING_RETURN_INFO = 125
    DEBUG_SMART_CLUSTER_QUEUE_INFO = 126
    CLAIM_ORB_START = 127
    CLAIM_ORB_FINISHED = 128
    CLAIM_ORB_CANCEL = 129
    ORB_UPDATE = 130
    ORB_CLAIMED = 131
    ORB_RESET = 132
    NEW_WAR_CAMP_OBJECT = 133
    NEW_MATCH_LOOT_CHEST_OBJECT = 134
    NEW_ARENA_EXIT = 135
    GUILD_MEMBER_TERRITORY_UPDATE = 136
    INVITED_MERCENARY_TO_MATCH = 137
    CLUSTER_INFO_UPDATE = 138
    FORCED_MOVEMENT = 139
    FORCED_MOVEMENT_CANCEL = 140
    CHARACTER_STATS = 141
    CHARACTER_STATS_KILL_HISTORY = 142
    CHARACTER_STATS_DEATH_HISTORY = 143
    GUILD_STATS = 144
    KILL_HISTORY_DETAILS = 145
    FULL_ACHIEVEMENT_INFO = 146
    FINISHED_ACHIEVEMENT = 147
    ACHIEVEMENT_PROGRESS_INFO = 148
    FULL_ACHIEVEMENT_PROGRESS_INFO = 149
    FULL_TRACKED_ACHIEVEMENT_INFO = 150
    FULL_AUTO_LEARN_ACHIEVEMENT_INFO = 151
    QUEST_GIVER_QUEST_OFFERED = 152
    QUEST_GIVER_DEBUG_INFO = 153
    CONSOLE_EVENT = 154
    TIME_SYNC = 155
    CHANGE_AVATAR = 156
    CHANGE_MOUNT_SKIN = 157
    GAME_EVENT = 158
    KILLED_PLAYER = 159
    DIED = 160
    KNOCKED_DOWN = 161
    UNCONCIOUS = 162
    MATCH_PLAYER_JOINED_EVENT = 163
    MATCH_PLAYER_STATS_EVENT = 164
    MATCH_PLAYER_STATS_COMPLETE_EVENT = 165
    MATCH_TIME_LINE_EVENT_EVENT = 166
    MATCH_PLAYER_MAIN_GEAR_STATS_EVENT = 167
    MATCH_PLAYER_CHANGED_AVATAR_EVENT = 168
    INVITATION_PLAYER_TRADE = 169
    PLAYER_TRADE_START = 170
    PLAYER_TRADE_CANCEL = 171
    PLAYER_TRADE_UPDATE = 172
    PLAYER_TRADE_FINISHED = 173
    PLAYER_TRADE_ACCEPT_CHANGE = 174
    MINI_MAP_PING = 175
    MARKET_PLACE_NOTIFICATION = 176
    DUELLING_CHALLENGE_PLAYER = 177
    NEW_DUELLING_POST = 178
    DUEL_STARTED = 179
    DUEL_ENDED = 180
    DUEL_DENIED = 181
    DUEL_REQUEST_CANCELED = 182
    DUEL_LEFT_AREA = 183
    DUEL_RE_ENTERED_AREA = 184
    NEW_REAL_ESTATE = 185
    MINI_MAP_OWNED_BUILDINGS_POSITIONS = 186
    REAL_ESTATE_LIST_UPDATE = 187
    GUILD_LOGO_UPDATE = 188
    GUILD_LOGO_CHANGED = 189
    PLACEABLE_OBJECT_PLACE = 190
    PLACEABLE_OBJECT_PLACE_CANCEL = 191
    FURNITURE_OBJECT_BUFF_PROVIDER_INFO = 192
    FURNITURE_OBJECT_CHEAT_PROVIDER_INFO = 193
    FARMABLE_OBJECT_INFO = 194
    NEW_UNREAD_MAILS = 195
    MAIL_OPERATION_POSSIBLE = 196
    GUILD_LOGO_OBJECT_UPDATE = 197
    START_LOGOUT = 198
    NEW_CHAT_CHANNELS = 199
    JOINED_CHAT_CHANNEL = 200
    LEFT_CHAT_CHANNEL = 201
    REMOVED_CHAT_CHANNEL = 202
    ACCESS_STATUS = 203
    MOUNTED = 204
    MOUNT_START = 205
    MOUNT_CANCEL = 206
    NEW_TRAVELPOINT = 207
    NEW_ISLAND_ACCESS_POINT = 208
    NEW_EXIT = 209
    UPDATE_HOME = 210
    UPDATE_CHAT_SETTINGS = 211
    RESURRECTION_OFFER = 212
    RESURRECTION_REPLY = 213
    LOOT_EQUIPMENT_CHANGED = 214
    UPDATE_UNLOCKED_GUILD_LOGOS = 215
    UPDATE_UNLOCKED_AVATARS = 216
    UPDATE_UNLOCKED_AVATAR_RINGS = 217
    UPDATE_UNLOCKED_BUILDINGS = 218
    NEW_ISLAND_MANAGEMENT = 219
    NEW_TELEPORT_STONE = 220
    CLOAK = 221
    PARTY_INVITATION = 222
    PARTY_JOIN_REQUEST = 223
    PARTY_JOINED = 224
    PARTY_DISBANDED = 225
    PARTY_PLAYER_JOINED = 226
    PARTY_CHANGED_ORDER = 227
    PARTY_PLAYER_LEFT = 228
    PARTY_LEADER_CHANGED = 229
    PARTY_LOOT_SETTING_CHANGED_PLAYER = 230
    PARTY_SILVER_GAINED = 231
    PARTY_PLAYER_UPDATED = 232
    PARTY_INVITATION_ANSWER = 233
    PARTY_JOIN_REQUEST_ANSWER = 234
    PARTY_MARKED_OBJECTS_UPDATED = 235
    PARTY_ON_CLUSTER_PARTY_JOINED = 236
    PARTY_SET_ROLE_FLAG = 237
    PARTY_INVITE_OR_JOIN_PLAYER_EQUIPMENT_INFO = 238
    SPELL_COOLDOWN_UPDATE = 239
    NEW_HELLGATE_EXIT_PORTAL = 240
    NEW_EXPEDITION_EXIT = 241
    NEW_EXPEDITION_NARRATOR = 242
    EXIT_ENTER_START = 243
    EXIT_ENTER_CANCEL = 244
    EXIT_ENTER_FINISHED = 245
    NEW_QUEST_GIVER_OBJECT = 246
    FULL_QUEST_INFO = 247
    QUEST_PROGRESS_INFO = 248
    QUEST_GIVER_INFO_FOR_PLAYER = 249
    FULL_EXPEDITION_INFO = 250
    EXPEDITION_QUEST_PROGRESS_INFO = 251
    INVITED_TO_EXPEDITION = 252
    EXPEDITION_REGISTRATION_INFO = 253
    ENTERING_EXPEDITION_START = 254
    ENTERING_EXPEDITION_CANCEL = 255
    REWARD_GRANTED = 256
    ARENA_REGISTRATION_INFO = 257
    ENTERING_ARENA_START = 258
    ENTERING_ARENA_CANCEL = 259
    ENTERING_ARENA_LOCK_START = 260
    ENTERING_ARENA_LOCK_CANCEL = 261
    INVITED_TO_ARENA_MATCH = 262
    USING_HELLGATE_SHRINE = 263
    ENTERING_HELLGATE_LOCK_START = 264
    ENTERING_HELLGATE_LOCK_CANCEL = 265
    PLAYER_COUNTS = 266
    IN_COMBAT_STATE_UPDATE = 267
    OTHER_GRABBED_LOOT = 268
    TREASURE_CHEST_USING_START = 269
    TREASURE_CHEST_USING_FINISHED = 270
    TREASURE_CHEST_USING_CANCEL = 271
    TREASURE_CHEST_USING_OPENING_COMPLETE = 272
    TREASURE_CHEST_FORCE_CLOSE_INVENTORY = 273
    LOCAL_TREASURES_UPDATE = 274
    LOOT_CHEST_SPAWNPOINTS_UPDATE = 275
    PREMIUM_CHANGED = 276
    PREMIUM_EXTENDED = 277
    PREMIUM_LIFE_TIME_REWARD_GAINED = 278
    GOLD_PURCHASED = 279
    LABORER_GOT_UPGRADED = 280
    JOURNAL_GOT_FULL = 281
    JOURNAL_FILL_ERROR = 282
    FRIEND_REQUEST = 283
    FRIEND_REQUEST_INFOS = 284
    FRIEND_INFOS = 285
    FRIEND_REQUEST_ANSWERED = 286
    FRIEND_ONLINE_STATUS = 287
    FRIEND_REQUEST_CANCELED = 288
    FRIEND_REMOVED = 289
    FRIEND_UPDATED = 290
    PARTY_LOOT_ITEMS = 291
    PARTY_LOOT_ITEMS_REMOVED = 292
    REPUTATION_UPDATE = 293
    DEFENSE_UNIT_ATTACK_BEGIN = 294
    DEFENSE_UNIT_ATTACK_END = 295
    DEFENSE_UNIT_ATTACK_DAMAGE = 296
    UNRESTRICTED_PVP_ZONE_UPDATE = 297
    REPUTATION_IMPLICATION_UPDATE = 298
    NEW_MOUNT_OBJECT = 299
    MOUNT_HEALTH_UPDATE = 300
    MOUNT_COOLDOWN_UPDATE = 301
    NEW_EXPEDITION_AGENT = 302
    NEW_EXPEDITION_CHECK_POINT = 303
    EXPEDITION_START_EVENT = 304
    VOTE_EVENT = 305
    RATING_EVENT = 306
    NEW_ARENA_AGENT = 307
    BOOST_FARMABLE = 308
    USE_FUNCTION = 309
    NEW_PORTAL_ENTRANCE = 310
    NEW_PORTAL_EXIT = 311
    NEW_RANDOM_DUNGEON_EXIT = 312
    WAITING_QUEUE_UPDATE = 313
    PLAYER_MOVEMENT_RATE_UPDATE = 314
    OBSERVE_START = 315
    MINIMAP_ZERGS = 316
    MINIMAP_SMART_CLUSTER_ZERGS = 317
    PAYMENT_TRANSACTIONS = 318
    PERFORMANCE_STATS_UPDATE = 319
    OVERLOAD_MODE_UPDATE = 320
    DEBUG_DRAW_EVENT = 321
    RECORD_CAMERA_MOVE = 322
    RECORD_START = 323
    CLAIM_POWER_CRYSTAL_START = 324
    CLAIM_POWER_CRYSTAL_CANCEL = 325
    CLAIM_POWER_CRYSTAL_RESET = 326
    CLAIM_POWER_CRYSTAL_FINISHED = 327
    TERRITORY_CLAIM_START = 328
    TERRITORY_CLAIM_CANCEL = 329
    TERRITORY_CLAIM_FINISHED = 330
    TERRITORY_SCHEDULE_RESULT = 331
    TERRITORY_UPGRADE_WITH_POWER_CRYSTAL_RESULT = 332
    RETURNING_POWER_CRYSTAL_START = 333
    RETURNING_POWER_CRYSTAL_FINISHED = 334
    UPDATE_ACCOUNT_STATE = 335
    START_DETERMINISTIC_ROAM = 336
    GUILD_FULL_ACCESS_TAGS_UPDATED = 337
    GUILD_ACCESS_TAG_UPDATED = 338
    GVG_SEASON_UPDATE = 339
    GVG_SEASON_CHEAT_COMMAND = 340
    SEASON_POINTS_BY_KILLING_BOOSTER = 341
    FISHING_START = 342
    FISHING_CAST = 343
    FISHING_CATCH = 344
    FISHING_FINISHED = 345
    FISHING_CANCEL = 346
    NEW_FLOAT_OBJECT = 347
    NEW_FISHING_ZONE_OBJECT = 348
    FISHING_MINI_GAME = 349
    STEAM_ACHIEVEMENT_COMPLETED = 350
    UPDATE_PUPPET = 351
    CHANGE_FLAGGING_FINISHED = 352
    NEW_OUTPOST_OBJECT = 353
    OUTPOST_UPDATE = 354
    OUTPOST_CLAIMED = 355
    OVER_CHARGE_END = 356
    OVER_CHARGE_STATUS = 357
    PARTY_FINDER_FULL_UPDATE = 358
    PARTY_FINDER_UPDATE = 359
    PARTY_FINDER_APPLICANTS_UPDATE = 360
    PARTY_FINDER_EQUIPMENT_SNAPSHOT = 361
    PARTY_FINDER_JOIN_REQUEST_DECLINED = 362
    NEW_UNLOCKED_PERSONAL_SEASON_REWARDS = 363
    PERSONAL_SEASON_POINTS_GAINED = 364
    PERSONAL_SEASON_PAST_SEASON_DATA_EVENT = 365
    EASY_ANTI_CHEAT_MESSAGE_TO_CLIENT = 366
    MATCH_LOOT_CHEST_OPENING_START = 367
    MATCH_LOOT_CHEST_OPENING_FINISHED = 368
    MATCH_LOOT_CHEST_OPENING_CANCEL = 369
    NOTIFY_CRYSTAL_MATCH_REWARD = 370
    CRYSTAL_REALM_FEEDBACK = 371
    NEW_LOCATION_MARKER = 372
    NEW_TUTORIAL_BLOCKER = 373
    NEW_TILE_SWITCH = 374
    NEW_INFORMATION_PROVIDER = 375
    NEW_DYNAMIC_GUILD_LOGO = 376
    NEW_DECORATION = 377
    TUTORIAL_UPDATE = 378
    TRIGGER_HINT_BOX = 379
    RANDOM_DUNGEON_POSITION_INFO = 380
    NEW_LOOT_CHEST = 381
    UPDATE_LOOT_CHEST = 382
    LOOT_CHEST_OPENED = 383
    UPDATE_LOOT_PROTECTED_BY_MOBS_WITH_MINIMAP_DISPLAY = 384
    NEW_SHRINE = 385
    UPDATE_SHRINE = 386
    UPDATE_ROOM = 387
    NEW_MIST_DUNGEON_ROOM_MOB_SOUL = 388
    NEW_HELLGATE_SHRINE = 389
    UPDATE_HELLGATE_SHRINE = 390
    ACTIVATE_HELLGATE_EXIT = 391
    MUTE_PLAYER_UPDATE = 392
    SHOP_TILE_UPDATE = 393
    SHOP_UPDATE = 394
    EASY_ANTI_CHEAT_KICK = 395
    BATTL_EYE_SERVER_MESSAGE = 396
    UNLOCK_VANITY_UNLOCK = 397
    AVATAR_UNLOCKED = 398
    CUSTOMIZATION_CHANGED = 399
    BASE_VAULT_INFO = 400
    GUILD_VAULT_INFO = 401
    BANK_VAULT_INFO = 402
    RECOVERY_VAULT_PLAYER_INFO = 403
    RECOVERY_VAULT_GUILD_INFO = 404
    UPDATE_WARDROBE = 405
    CASTLE_PHASE_CHANGED = 406
    GUILD_ACCOUNT_LOG_EVENT = 407
    NEW_HIDEOUT_OBJECT = 408
    NEW_HIDEOUT_MANAGEMENT = 409
    NEW_HIDEOUT_EXIT = 410
    INIT_HIDEOUT_ATTACK_START = 411
    INIT_HIDEOUT_ATTACK_CANCEL = 412
    INIT_HIDEOUT_ATTACK_FINISHED = 413
    HIDEOUT_MANAGEMENT_UPDATE = 414
    HIDEOUT_UPGRADE_WITH_POWER_CRYSTAL_RESULT = 415
    IP_CHANGED = 416
    SMART_CLUSTER_QUEUE_UPDATE_INFO = 417
    SMART_CLUSTER_QUEUE_ACTIVE_INFO = 418
    SMART_CLUSTER_QUEUE_KICK_WARNING = 419
    SMART_CLUSTER_QUEUE_INVITE = 420
    RECEIVED_GVG_SEASON_POINTS = 421
    TOWER_POWER_POINT_UPDATE = 422
    OPEN_WORLD_ATTACK_SCHEDULE_START = 423
    OPEN_WORLD_ATTACK_SCHEDULE_FINISHED = 424
    OPEN_WORLD_ATTACK_SCHEDULE_CANCEL = 425
    OPEN_WORLD_ATTACK_CONQUER_START = 426
    OPEN_WORLD_ATTACK_CONQUER_FINISHED = 427
    OPEN_WORLD_ATTACK_CONQUER_CANCEL = 428
    OPEN_WORLD_ATTACK_CONQUER_STATUS = 429
    OPEN_WORLD_ATTACK_START = 430
    OPEN_WORLD_ATTACK_END = 431
    NEW_RANDOM_RESOURCE_BLOCKER = 432
    NEW_HOME_OBJECT = 433
    HIDEOUT_OBJECT_UPDATE = 434
    UPDATE_INFAMY = 435
    MINIMAP_POSITION_MARKERS = 436
    NEW_TUNNEL_EXIT = 437
    CORRUPTED_DUNGEON_UPDATE = 438
    CORRUPTED_DUNGEON_STATUS = 439
    CORRUPTED_DUNGEON_INFAMY = 440
    HELLGATE_RESTRICTED_AREA_UPDATE = 441
    HELLGATE_INFAMY = 442
    HELLGATE_STATUS = 443
    HELLGATE_STATUS_UPDATE = 444
    HELLGATE_SUSPENSE = 445
    REPLACE_SPELL_SLOT_WITH_MULTI_SPELL = 446
    NEW_CORRUPTED_SHRINE = 447
    UPDATE_CORRUPTED_SHRINE = 448
    CORRUPTED_SHRINE_USAGE_START = 449
    CORRUPTED_SHRINE_USAGE_CANCEL = 450
    EXIT_USED = 451
    LINKED_TO_OBJECT = 452
    LINK_TO_OBJECT_BROKEN = 453
    ESTIMATED_MARKET_VALUE_UPDATE = 454
    STUCK_CANCEL = 455
    DUNGON_ESCAPE_READY = 456
    FACTION_WARFARE_CLUSTER_STATE = 457
    FACTION_WARFARE_HAS_UNCLAIMED_WEEKLY_REPORTS_EVENT = 458
    SIMPLE_FEEDBACK = 459
    SMART_CLUSTER_QUEUE_SKIP_CLUSTER_ERROR = 460
    XIGN_CODE_EVENT = 461
    BATCH_USE_ITEM_START = 462
    BATCH_USE_ITEM_END = 463
    RED_ZONE_EVENT_CLUSTER_STATUS = 464
    RED_ZONE_PLAYER_NOTIFICATION = 465
    RED_ZONE_WORLD_EVENT = 466
    FACTION_WARFARE_STATS = 467
    UPDATE_FACTION_BALANCE_FACTORS = 468
    FACTION_ENLISTMENT_CHANGED = 469
    UPDATE_FACTION_RANK = 470
    FACTION_WARFARE_CAMPAIGN_REWARDS_UNLOCKED = 471
    FEATURED_FEATURE_UPDATE = 472
    NEW_POWER_CRYSTAL_OBJECT = 473
    MINIMAP_CRYSTAL_POSITION_MARKER = 474
    CARRY_POWER_CRYSTAL_UPDATE = 475
    PICKUP_POWER_CRYSTAL_START = 476
    PICKUP_POWER_CRYSTAL_CANCEL = 477
    PICKUP_POWER_CRYSTAL_FINISHED = 478
    DO_SIMPLE_ACTION_START = 479
    DO_SIMPLE_ACTION_CANCEL = 480
    DO_SIMPLE_ACTION_FINISHED = 481
    NOTIFY_GUEST_ACCOUNT_VERIFIED = 482
    MIGHT_AND_FAVOR_RECEIVED_EVENT = 483
    WEEKLY_PVP_CHALLENGE_REWARD_STATE_UPDATE = 484
    NEW_UNLOCKED_PVP_SEASON_CHALLENGE_REWARDS = 485
    STATIC_DUNGEON_ENTRANCES_DUNGEON_EVENT_STATUS_UPDATES = 486
    STATIC_DUNGEON_DUNGEON_VALUE_UPDATE = 487
    STATIC_DUNGEON_ENTRANCE_DUNGEON_EVENTS_ABORTED = 488
    IN_APP_PURCHASE_CONFIRMED_GOOGLE_PLAY = 489
    FEATURE_SWITCH_INFO = 490
    PARTY_JOIN_REQUEST_ABORTED = 491
    PARTY_INVITE_ABORTED = 492
    PARTY_START_HUNT_REQUEST = 493
    PARTY_START_HUNT_REQUESTED = 494
    PARTY_START_HUNT_REQUEST_ANSWER = 495
    GUILD_INVITE_DECLINED = 496
    CANCEL_MULTI_SPELL_SLOTS = 497
    NEW_VISUAL_EVENT_OBJECT = 498
    CASTLE_CLAIM_PROGRESS = 499
    CASTLE_CLAIM_PROGRESS_LOGO = 500
    TOWN_PORTAL_UPDATE_STATE = 501
    TOWN_PORTAL_FAILED = 502
    CONSUMABLE_VANITY_CHARGES_ADDED = 503
    FESTIVITIES_UPDATE = 504
    NEW_BANNER_OBJECT = 505
    NEW_MISTS_IMMEDIATE_RETURN_EXIT = 506
    MISTS_PLAYER_JOINED_INFO = 507
    NEW_MISTS_STATIC_ENTRANCE = 508
    NEW_MISTS_OPEN_WORLD_EXIT = 509
    NEW_TUNNEL_EXIT_TEMP = 510
    NEW_MISTS_WISP_SPAWN = 511
    MISTS_WISP_SPAWN_STATE_CHANGE = 512
    NEW_MISTS_CITY_ENTRANCE = 513
    NEW_MISTS_CITY_ROADS_ENTRANCE = 514
    MISTS_CITY_ROADS_ENTRANCE_PARTY_STATE_UPDATE = 515
    MISTS_CITY_ROADS_ENTRANCE_CLEAR_STATE_FOR_PARTY = 516
    MISTS_ENTRANCE_DATA_CHANGED = 517
    NEW_MISTS_CAGED_WISP = 518
    MISTS_WISP_CAGE_OPENED = 519
    MISTS_ENTRANCE_PARTY_BINDING_CREATED = 520
    MISTS_ENTRANCE_PARTY_BINDING_CLEARED = 521
    MISTS_ENTRANCE_PARTY_BINDING_INFOS = 522
    NEW_MISTS_BORDER_EXIT = 523
    NEW_MISTS_DUNGEON_EXIT = 524
    LOCAL_QUEST_INFOS = 525
    LOCAL_QUEST_STARTED = 526
    LOCAL_QUEST_ACTIVE = 527
    LOCAL_QUEST_INACTIVE = 528
    LOCAL_QUEST_PROGRESS_UPDATE = 529
    NEW_UNRESTRICTED_PVP_ZONE = 530
    TEMPORARY_FLAGGING_STATUS_UPDATE = 531
    SPELL_TEST_PERFORMANCE_UPDATE = 532
    TRANSFORMATION = 533
    TRANSFORMATION_END = 534
    UPDATE_TRUSTLEVEL = 535
    REVEAL_HIDDEN_TIME_STAMPS = 536
    MODIFY_ITEM_TRAIT_FINISHED = 537
    REROLL_ITEM_TRAIT_VALUE_FINISHED = 538
    HUNT_QUEST_PROGRESS_INFO = 539
    HUNT_STARTED = 540
    HUNT_FINISHED = 541
    HUNT_ABORTED = 542
    HUNT_MISSION_STEP_STATE_UPDATE = 543
    NEW_HUNT_TRACK = 544
    HUNT_MISSION_UPDATE = 545
    HUNT_QUEST_MISSION_PROGRESS_UPDATE = 546
    HUNT_TRACK_USED = 547
    HUNT_TRACK_USEABLE_AGAIN = 548
    MINIMAP_HUNT_TRACK_MARKERS = 549
    NO_TRACKS_FOUND = 550
    HUNT_QUEST_ABORTED = 551
    INTERACT_WITH_TRACK_START = 552
    INTERACT_WITH_TRACK_CANCEL = 553
    INTERACT_WITH_TRACK_FINISHED = 554
    NEW_DYNAMIC_COMPOUND = 555
    LEGENDARY_ITEM_DESTROYED = 556
    ATTUNEMENT_INFO = 557
    TERRITORY_CLAIM_RAIDED_RAW_ENERGY_CRYSTAL_RESULT = 558
    CARRIED_OBJECT_EXPIRY_WARNING = 559
    CARRIED_OBJECT_EXPIRED = 560
    TERRITORY_RAID_START = 561
    TERRITORY_RAID_CANCEL = 562
    TERRITORY_RAID_FINISHED = 563
    TERRITORY_RAID_RESULT = 564
    TERRITORY_MONOLITH_ACTIVE_RAID_STATUS = 565
    TERRITORY_MONOLITH_ACTIVE_RAID_CANCELLED = 566
    MONOLITH_ENERGY_STORAGE_UPDATE = 567
    MONOLITH_NEXT_SCHEDULED_OPEN_WORLD_ATTACK_UPDATE = 568
    MONOLITH_PROTECTED_BUILDINGS_DAMAGE_REDUCTION_UPDATE = 569
    NEW_BUILDING_BASE_EVENT = 570
    NEW_FORTIFICATION_BUILDING = 571
    NEW_CASTLE_GATE_BUILDING = 572
    BUILDING_DURABILITY_UPDATE = 573
    MONOLITH_FORTIFICATION_POINTS_UPDATE = 574
    FORTIFICATION_BUILDING_UPGRADE_INFO = 575
    FORTIFICATION_BUILDINGS_DAMAGE_STATE_UPDATE = 576
    SIEGE_NOTIFICATION_EVENT = 577
    UPDATE_ENEMY_WAR_BANNER_ACTIVE = 578
    TERRITORY_ANNOUNCE_PLAYER_EJECTION = 579
    CASTLE_GATE_SWITCH_USE_STARTED = 580
    CASTLE_GATE_SWITCH_USE_FINISHED = 581
    FORTIFICATION_BUILDING_WILL_DOWNGRADE = 582
    BOT_COMMAND = 583
