from enum import Enum


class OperationCode(Enum):
    PING = 1
    JOIN = 2
    VERSIONED_OPERATION = 3
    CREATE_ACCOUNT = 4
    LOGIN = 5
    CREATE_GUEST_ACCOUNT = 6
    SEND_CRASH_LOG = 7
    SEND_TRACE_ROUTE = 8
    SEND_VFX_STATS = 9
    SEND_GAME_PING_INFO = 10
    CREATE_CHARACTER = 11
    DELETE_CHARACTER = 12
    SELECT_CHARACTER = 13
    ACCEPT_POPUPS = 14
    REDEEM_KEYCODE = 15
    GET_GAME_SERVER_BY_CLUSTER = 16
    GET_SHOP_PURCHASE_URL = 17
    GET_REFERRAL_SEASON_DETAILS = 18
    GET_REFERRAL_LINK = 19
    GET_SHOP_TILES_FOR_CATEGORY = 20
    MOVE = 21
    ATTACK_START = 22
    CAST_START = 23
    CAST_CANCEL = 24
    TERMINATE_TOGGLE_SPELL = 25
    CHANNELING_CANCEL = 26
    ATTACK_BUILDING_START = 27
    INVENTORY_DESTROY_ITEM = 28
    INVENTORY_MOVE_ITEM = 29
    INVENTORY_RECOVER_ITEM = 30
    INVENTORY_RECOVER_ALL_ITEMS = 31
    INVENTORY_SPLIT_STACK = 32
    INVENTORY_SPLIT_STACK_INTO = 33
    GET_CLUSTER_DATA = 34
    CHANGE_CLUSTER = 35
    CONSOLE_COMMAND = 36
    CHAT_MESSAGE = 37
    REPORT_CLIENT_ERROR = 38
    REGISTER_TO_OBJECT = 39
    UN_REGISTER_FROM_OBJECT = 40
    CRAFT_BUILDING_CHANGE_SETTINGS = 41
    CRAFT_BUILDING_TAKE_MONEY = 42
    REPAIR_BUILDING_CHANGE_SETTINGS = 43
    REPAIR_BUILDING_TAKE_MONEY = 44
    ACTION_BUILDING_CHANGE_SETTINGS = 45
    HARVEST_START = 46
    HARVEST_CANCEL = 47
    TAKE_SILVER = 48
    ACTION_ON_BUILDING_START = 49
    ACTION_ON_BUILDING_CANCEL = 50
    INSTALL_RESOURCE_START = 51
    INSTALL_RESOURCE_CANCEL = 52
    INSTALL_SILVER = 53
    BUILDING_FILL_NUTRITION = 54
    BUILDING_CHANGE_RENOVATION_STATE = 55
    BUILDING_BUY_SKIN = 56
    BUILDING_CLAIM = 57
    BUILDING_GIVEUP = 58
    BUILDING_NUTRITION_SILVER_STORAGE_DEPOSIT = 59
    BUILDING_NUTRITION_SILVER_STORAGE_WITHDRAW = 60
    BUILDING_NUTRITION_SILVER_REWARD_SET = 61
    CONSTRUCTION_SITE_CREATE = 62
    PLACEABLE_OBJECT_PLACE = 63
    PLACEABLE_OBJECT_PLACE_CANCEL = 64
    PLACEABLE_OBJECT_PICKUP = 65
    FURNITURE_OBJECT_USE = 66
    FARMABLE_HARVEST = 67
    FARMABLE_FINISH_GROWN_ITEM = 68
    FARMABLE_DESTROY = 69
    FARMABLE_GET_PRODUCT = 70
    FARMABLE_FILL = 71
    TEAR_DOWN_CONSTRUCTION_SITE = 72
    AUCTION_CREATE_OFFER = 73
    AUCTION_CREATE_REQUEST = 74
    AUCTION_GET_OFFERS = 75
    AUCTION_GET_REQUESTS = 76
    AUCTION_BUY_OFFER = 77
    AUCTION_ABORT_AUCTION = 78
    AUCTION_MODIFY_AUCTION = 79
    AUCTION_ABORT_OFFER = 80
    AUCTION_ABORT_REQUEST = 81
    AUCTION_SELL_REQUEST = 82
    AUCTION_GET_FINISHED_AUCTIONS = 83
    AUCTION_GET_FINISHED_AUCTIONS_COUNT = 84
    AUCTION_FETCH_AUCTION = 85
    AUCTION_GET_MY_OPEN_OFFERS = 86
    AUCTION_GET_MY_OPEN_REQUESTS = 87
    AUCTION_GET_MY_OPEN_AUCTIONS = 88
    AUCTION_GET_ITEM_AVERAGE_STATS = 89
    AUCTION_GET_ITEM_AVERAGE_VALUE = 90
    CONTAINER_OPEN = 91
    CONTAINER_CLOSE = 92
    CONTAINER_MANAGE_SUB_CONTAINER = 93
    RESPAWN = 94
    SUICIDE = 95
    JOIN_GUILD = 96
    LEAVE_GUILD = 97
    CREATE_GUILD = 98
    INVITE_TO_GUILD = 99
    DECLINE_GUILD_INVITATION = 100
    KICK_FROM_GUILD = 101
    INSTANT_JOIN_GUILD = 102
    DUELLING_CHALLENGE_PLAYER = 103
    DUELLING_ACCEPT_CHALLENGE = 104
    DUELLING_DENY_CHALLENGE = 105
    CHANGE_CLUSTER_TAX = 106
    CLAIM_TERRITORY = 107
    GIVE_UP_TERRITORY = 108
    CHANGE_TERRITORY_ACCESS_RIGHTS = 109
    GET_MONOLITH_INFO = 110
    GET_CLAIM_INFO = 111
    GET_ATTACK_INFO = 112
    GET_TERRITORY_SEASON_POINTS = 113
    GET_ATTACK_SCHEDULE = 114
    GET_MATCHES = 115
    GET_MATCH_DETAILS = 116
    JOIN_MATCH = 117
    LEAVE_MATCH = 118
    CHANGE_CHAT_SETTINGS = 119
    LOGOUT_START = 120
    LOGOUT_CANCEL = 121
    CLAIM_ORB_START = 122
    CLAIM_ORB_CANCEL = 123
    MATCH_LOOT_CHEST_OPENING_START = 124
    MATCH_LOOT_CHEST_OPENING_CANCEL = 125
    DEPOSIT_TO_GUILD_ACCOUNT = 126
    WITHDRAWAL_FROM_ACCOUNT = 127
    CHANGE_GUILD_PAY_UPKEEP_FLAG = 128
    CHANGE_GUILD_TAX = 129
    GET_MY_TERRITORIES = 130
    MORGANA_COMMAND = 131
    GET_SERVER_INFO = 132
    SUBSCRIBE_TO_CLUSTER = 133
    ANSWER_MERCENARY_INVITATION = 134
    GET_CHARACTER_EQUIPMENT = 135
    GET_CHARACTER_STEAM_ACHIEVEMENTS = 136
    GET_CHARACTER_STATS = 137
    GET_KILL_HISTORY_DETAILS = 138
    LEARN_MASTERY_LEVEL = 139
    RE_SPEC_ACHIEVEMENT = 140
    CHANGE_AVATAR = 141
    GET_RANKINGS = 142
    GET_RANK = 143
    GET_GVG_SEASON_RANKINGS = 144
    GET_GVG_SEASON_RANK = 145
    GET_GVG_SEASON_HISTORY_RANKINGS = 146
    GET_GVG_SEASON_GUILD_MEMBER_HISTORY = 147
    KICK_FROM_GV_G_MATCH = 148
    GET_CRYSTAL_LEAGUE_DAILY_SEASON_POINTS = 149
    GET_CHEST_LOGS = 150
    GET_ACCESS_RIGHT_LOGS = 151
    GET_GUILD_ACCOUNT_LOGS = 152
    GET_GUILD_ACCOUNT_LOGS_LARGE_AMOUNT = 153
    INVITE_TO_PLAYER_TRADE = 154
    PLAYER_TRADE_CANCEL = 155
    PLAYER_TRADE_INVITATION_ACCEPT = 156
    PLAYER_TRADE_ADD_ITEM = 157
    PLAYER_TRADE_REMOVE_ITEM = 158
    PLAYER_TRADE_ACCEPT_TRADE = 159
    PLAYER_TRADE_SET_SILVER_OR_GOLD = 160
    SEND_MINI_MAP_PING = 161
    STUCK = 162
    BUY_REAL_ESTATE = 163
    CLAIM_REAL_ESTATE = 164
    GIVE_UP_REAL_ESTATE = 165
    CHANGE_REAL_ESTATE_OUTLINE = 166
    GET_MAIL_INFOS = 167
    GET_MAIL_COUNT = 168
    READ_MAIL = 169
    SEND_NEW_MAIL = 170
    DELETE_MAIL = 171
    MARK_MAIL_UNREAD = 172
    CLAIM_ATTACHMENT_FROM_MAIL = 173
    APPLY_TO_GUILD = 174
    ANSWER_GUILD_APPLICATION = 175
    REQUEST_GUILD_FINDER_FILTERED_LIST = 176
    UPDATE_GUILD_RECRUITMENT_INFO = 177
    REQUEST_GUILD_RECRUITMENT_INFO = 178
    REQUEST_GUILD_FINDER_NAME_SEARCH = 179
    REQUEST_GUILD_FINDER_RECOMMENDED_LIST = 180
    REGISTER_CHAT_PEER = 181
    SEND_CHAT_MESSAGE = 182
    SEND_MODERATOR_MESSAGE = 183
    JOIN_CHAT_CHANNEL = 184
    LEAVE_CHAT_CHANNEL = 185
    SEND_WHISPER_MESSAGE = 186
    SAY = 187
    PLAY_EMOTE = 188
    STOP_EMOTE = 189
    GET_CLUSTER_MAP_INFO = 190
    ACCESS_RIGHTS_CHANGE_SETTINGS = 191
    MOUNT = 192
    MOUNT_CANCEL = 193
    BUY_JOURNEY = 194
    SET_SALE_STATUS_FOR_ESTATE = 195
    RESOLVE_GUILD_OR_PLAYER_NAME = 196
    GET_RESPAWN_INFOS = 197
    MAKE_HOME = 198
    LEAVE_HOME = 199
    RESURRECTION_REPLY = 200
    ALLIANCE_CREATE = 201
    ALLIANCE_DISBAND = 202
    ALLIANCE_GET_MEMBER_INFOS = 203
    ALLIANCE_INVITE = 204
    ALLIANCE_ANSWER_INVITATION = 205
    ALLIANCE_CANCEL_INVITATION = 206
    ALLIANCE_KICK_GUILD = 207
    ALLIANCE_LEAVE = 208
    ALLIANCE_CHANGE_GOLD_PAYMENT_FLAG = 209
    ALLIANCE_GET_DETAIL_INFO = 210
    GET_ISLAND_INFOS = 211
    ABANDON_MY_ISLAND = 212
    BUY_MY_ISLAND = 213
    BUY_GUILD_ISLAND = 214
    ABANDON_GUILD_ISLAND = 215
    UPGRADE_MY_ISLAND = 216
    UPGRADE_GUILD_ISLAND = 217
    MOVE_MY_ISLAND = 218
    MOVE_GUILD_ISLAND = 219
    TERRITORY_FILL_NUTRITION = 220
    TELEPORT_BACK = 221
    PARTY_INVITE_PLAYER = 222
    PARTY_REQUEST_JOIN = 223
    PARTY_ANSWER_INVITATION = 224
    PARTY_ANSWER_JOIN_REQUEST = 225
    PARTY_LEAVE = 226
    PARTY_KICK_PLAYER = 227
    PARTY_MAKE_LEADER = 228
    PARTY_CHANGE_LOOT_SETTING = 229
    PARTY_MARK_OBJECT = 230
    PARTY_SET_ROLE = 231
    SET_GUILD_CODEX = 232
    EXIT_ENTER_START = 233
    EXIT_ENTER_CANCEL = 234
    QUEST_GIVER_REQUEST = 235
    GOLD_MARKET_GET_BUY_OFFER = 236
    GOLD_MARKET_GET_BUY_OFFER_FROM_SILVER = 237
    GOLD_MARKET_GET_SELL_OFFER = 238
    GOLD_MARKET_GET_SELL_OFFER_FROM_SILVER = 239
    GOLD_MARKET_BUY_GOLD = 240
    GOLD_MARKET_SELL_GOLD = 241
    GOLD_MARKET_CREATE_SELL_ORDER = 242
    GOLD_MARKET_CREATE_BUY_ORDER = 243
    GOLD_MARKET_GET_INFOS = 244
    GOLD_MARKET_CANCEL_ORDER = 245
    GOLD_MARKET_GET_AVERAGE_INFO = 246
    TREASURE_CHEST_USING_START = 247
    TREASURE_CHEST_USING_CANCEL = 248
    USE_LOOT_CHEST = 249
    USE_SHRINE = 250
    USE_HELLGATE_SHRINE = 251
    GET_SIEGE_BANNER_INFO = 252
    LABORER_START_JOB = 253
    LABORER_TAKE_JOB_LOOT = 254
    LABORER_DISMISS = 255
    LABORER_MOVE = 256
    LABORER_BUY_ITEM = 257
    LABORER_UPGRADE = 258
    BUY_PREMIUM = 259
    REAL_ESTATE_GET_AUCTION_DATA = 260
    REAL_ESTATE_BID_ON_AUCTION = 261
    FRIEND_INVITE = 262
    FRIEND_ANSWER_INVITATION = 263
    FRIEND_CANCELNVITATION = 264
    FRIEND_REMOVE = 265
    INVENTORY_STACK = 266
    INVENTORY_SORT = 267
    INVENTORY_DROP_ALL = 268
    INVENTORY_ADD_TO_STACKS = 269
    EQUIPMENT_ITEM_CHANGE_SPELL = 270
    EXPEDITION_REGISTER = 271
    EXPEDITION_REGISTER_CANCEL = 272
    JOIN_EXPEDITION = 273
    DECLINE_EXPEDITION_INVITATION = 274
    VOTE_START = 275
    VOTE_DO_VOTE = 276
    RATING_DO_RATE = 277
    ENTERING_EXPEDITION_START = 278
    ENTERING_EXPEDITION_CANCEL = 279
    ACTIVATE_EXPEDITION_CHECK_POINT = 280
    ARENA_REGISTER = 281
    ARENA_ADD_INVITE = 282
    ARENA_REGISTER_CANCEL = 283
    ARENA_LEAVE = 284
    JOIN_ARENA_MATCH = 285
    DECLINE_ARENA_INVITATION = 286
    ENTERING_ARENA_START = 287
    ENTERING_ARENA_CANCEL = 288
    ARENA_CUSTOM_MATCH = 289
    UPDATE_CHARACTER_STATEMENT = 290
    BOOST_FARMABLE = 291
    GET_STRIKE_HISTORY = 292
    USE_FUNCTION = 293
    USE_PORTAL_ENTRANCE = 294
    RESET_PORTAL_BINDING = 295
    QUERY_PORTAL_BINDING = 296
    CLAIM_PAYMENT_TRANSACTION = 297
    CHANGE_USE_FLAG = 298
    CLIENT_PERFORMANCE_STATS = 299
    EXTENDED_HARDWARE_STATS = 300
    CLIENT_LOW_MEMORY_WARNING = 301
    TERRITORY_CLAIM_START = 302
    TERRITORY_CLAIM_CANCEL = 303
    DELIVER_CARRIABLE_OBJECT_START = 304
    DELIVER_CARRIABLE_OBJECT_CANCEL = 305
    CLAIM_POWER_CRYSTAL_START = 306
    CLAIM_POWER_CRYSTAL_CANCEL = 307
    TERRITORY_UPGRADE_WITH_POWER_CRYSTAL = 308
    REQUEST_APP_STORE_PRODUCTS = 309
    VERIFY_PRODUCT_PURCHASE = 310
    QUERY_GUILD_PLAYER_STATS = 311
    QUERY_ALLIANCE_GUILD_STATS = 312
    TRACK_ACHIEVEMENTS = 313
    SET_ACHIEVEMENTS_AUTO_LEARN = 314
    AUCTION_SELL_SPECIFIC_ITEM_REQUEST = 315
    FISHING_START = 316
    FISHING_CASTING = 317
    FISHING_CAST = 318
    FISHING_CATCH = 319
    FISHING_PULL = 320
    FISHING_GIVE_LINE = 321
    FISHING_FINISH = 322
    FISHING_CANCEL = 323
    CREATE_GUILD_ACCESS_TAG = 324
    DELETE_GUILD_ACCESS_TAG = 325
    RENAME_GUILD_ACCESS_TAG = 326
    FLAG_GUILD_ACCESS_TAG_GUILD_PERMISSION = 327
    ASSIGN_GUILD_ACCESS_TAG = 328
    REMOVE_GUILD_ACCESS_TAG_FROM_PLAYER = 329
    MODIFY_GUILD_ACCESS_TAG_EDITORS = 330
    REQUEST_PUBLIC_ACCESS_TAGS = 331
    CHANGE_ACCESS_TAG_PUBLIC_FLAG = 332
    UPDATE_GUILD_ACCESS_TAG = 333
    STEAM_START_MICROTRANSACTION = 334
    STEAM_FINISH_MICROTRANSACTION = 335
    STEAM_ID_HAS_ACTIVE_ACCOUNT = 336
    CHECK_EMAIL_ACCOUNT_STATE = 337
    LINK_ACCOUNT_TO_STEAM_ID = 338
    IN_APP_CONFIRM_PAYMENT_GOOGLE_PLAY = 339
    IN_APP_CONFIRM_PAYMENT_APPLE_APP_STORE = 340
    IN_APP_PURCHASE_REQUEST = 341
    IN_APP_PURCHASE_FAILED = 342
    CHARACTER_SUBSCRIPTION_INFO = 343
    ACCOUNT_SUBSCRIPTION_INFO = 344
    BUY_GVG_SEASON_BOOSTER = 345
    CHANGE_FLAGGING_PREPARE = 346
    OVER_CHARGE = 347
    OVER_CHARGE_END = 348
    REQUEST_TRUSTED = 349
    CHANGE_GUILD_LOGO = 350
    PARTY_FINDER_REGISTER_FOR_UPDATES = 351
    PARTY_FINDER_UNREGISTER_FOR_UPDATES = 352
    PARTY_FINDER_ENLIST_NEW_PARTY_SEARCH = 353
    PARTY_FINDER_DELETE_PARTY_SEARCH = 354
    PARTY_FINDER_CHANGE_PARTY_SEARCH = 355
    PARTY_FINDER_CHANGE_ROLE = 356
    PARTY_FINDER_APPLY_FOR_GROUP = 357
    PARTY_FINDER_ACCEPT_OR_DECLINE_APPLY_FOR_GROUP = 358
    PARTY_FINDER_GET_EQUIPMENT_SNAPSHOT = 359
    PARTY_FINDER_REGISTER_APPLICANTS = 360
    PARTY_FINDER_UNREGISTER_APPLICANTS = 361
    PARTY_FINDER_FULLTEXT_SEARCH = 362
    PARTY_FINDER_REQUEST_EQUIPMENT_SNAPSHOT = 363
    GET_PERSONAL_SEASON_TRACKER_DATA = 364
    GET_PERSONAL_SEASON_PAST_REWARD_DATA = 365
    USE_CONSUMABLE_FROM_INVENTORY = 366
    CLAIM_PERSONAL_SEASON_REWARD = 367
    EASY_ANTI_CHEAT_MESSAGE_TO_SERVER = 368
    XIGN_CODE_MESSAGE_TO_SERVER = 369
    BATTL_EYE_MESSAGE_TO_SERVER = 370
    SET_NEXT_TUTORIAL_STATE = 371
    ADD_PLAYER_TO_MUTE_LIST = 372
    REMOVE_PLAYER_FROM_MUTE_LIST = 373
    PRODUCT_SHOP_USER_EVENT = 374
    GET_VANITY_UNLOCKS = 375
    BUY_VANITY_UNLOCKS = 376
    GET_MOUNT_SKINS = 377
    SET_MOUNT_SKIN = 378
    SET_WARDROBE = 379
    CHANGE_CUSTOMIZATION = 380
    CHANGE_PLAYER_ISLAND_DATA = 381
    GET_GUILD_CHALLENGE_POINTS = 382
    SMART_QUEUE_JOIN = 383
    SMART_QUEUE_LEAVE = 384
    SMART_QUEUE_SELECT_SPAWN_CLUSTER = 385
    UPGRADE_HIDEOUT = 386
    INIT_HIDEOUT_ATTACK_START = 387
    INIT_HIDEOUT_ATTACK_CANCEL = 388
    HIDEOUT_FILL_NUTRITION = 389
    HIDEOUT_GET_INFO = 390
    HIDEOUT_GET_OWNER_INFO = 391
    HIDEOUT_SET_TRIBUTE = 392
    HIDEOUT_UPGRADE_WITH_POWER_CRYSTAL = 393
    HIDEOUT_DECLARE_H_Q = 394
    HIDEOUT_UNDECLARE_H_Q = 395
    HIDEOUT_GET_H_Q_REQUIREMENTS = 396
    HIDEOUT_BOOST = 397
    HIDEOUT_BOOST_CONSTRUCTION = 398
    OPEN_WORLD_ATTACK_SCHEDULE_START = 399
    OPEN_WORLD_ATTACK_SCHEDULE_CANCEL = 400
    OPEN_WORLD_ATTACK_CONQUER_START = 401
    OPEN_WORLD_ATTACK_CONQUER_CANCEL = 402
    GET_OPEN_WORLD_ATTACK_DETAILS = 403
    GET_NEXT_OPEN_WORLD_ATTACK_SCHEDULE_TIME = 404
    RECOVER_VAULT_FROM_HIDEOUT = 405
    GET_GUILD_ENERGY_DRAIN_INFO = 406
    CHANNELING_UPDATE = 407
    USE_CORRUPTED_SHRINE = 408
    REQUEST_ESTIMATED_MARKET_VALUE = 409
    LOG_FEEDBACK = 410
    GET_INFAMY_INFO = 411
    GET_PARTY_SMART_CLUSTER_QUEUE_PRIORITY = 412
    SET_PARTY_SMART_CLUSTER_QUEUE_PRIORITY = 413
    CLIENT_ANTI_AUTO_CLICKER_INFO = 414
    CLIENT_BOT_PATTERN_DETECTION_INFO = 415
    CLIENT_ANTI_GATHER_CLICKER_INFO = 416
    LOADOUT_CREATE = 417
    LOADOUT_READ = 418
    LOADOUT_READ_HEADERS = 419
    LOADOUT_UPDATE = 420
    LOADOUT_DELETE = 421
    LOADOUT_ORDER_UPDATE = 422
    LOADOUT_EQUIP = 423
    BATCH_USE_ITEM_CANCEL = 424
    ENLIST_FACTION_WARFARE = 425
    GET_FACTION_WARFARE_WEEKLY_REPORT = 426
    CLAIM_FACTION_WARFARE_WEEKLY_REPORT = 427
    GET_FACTION_WARFARE_CAMPAIGN_DATA = 428
    CLAIM_FACTION_WARFARE_ITEM_REWARD = 429
    SEND_MEMORY_CONSUMPTION = 430
    PICKUP_CARRIABLE_OBJECT_START = 431
    PICKUP_CARRIABLE_OBJECT_CANCEL = 432
    SET_SAVING_CHEST_LOGS_FLAG = 433
    GET_SAVING_CHEST_LOGS_FLAG = 434
    REGISTER_GUEST_ACCOUNT = 435
    RESEND_GUEST_ACCOUNT_VERIFICATION_EMAIL = 436
    DO_SIMPLE_ACTION_START = 437
    DO_SIMPLE_ACTION_CANCEL = 438
    GET_GVG_SEASON_CONTRIBUTION_BY_ACTIVITY = 439
    GET_GVG_SEASON_CONTRIBUTION_BY_CRYSTAL_LEAGUE = 440
    GET_GUILD_MIGHT_CATEGORY_CONTRIBUTION = 441
    GET_GUILD_MIGHT_CATEGORY_OVERVIEW = 442
    GET_PVP_CHALLENGE_DATA = 443
    CLAIM_PVP_CHALLENGE_WEEKLY_REWARD = 444
    GET_PERSONAL_MIGHT_STATS = 445
    AUCTION_GET_LOADOUT_OFFERS = 446
    AUCTION_BUY_LOADOUT_OFFER = 447
    ACCOUNT_DELETION_REQUEST = 448
    ACCOUNT_REACTIVATION_REQUEST = 449
    GET_MODERATION_ESCALATION_DEFINITON = 450
    EVENT_BASED_POPUP_ADD_SEEN = 451
    GET_ITEM_KILL_HISTORY = 452
    GET_VANITY_CONSUMABLES = 453
    EQUIP_KILL_EMOTE = 454
    CHANGE_KILL_EMOTE_PLAY_ON_KNOCKDOWN_SETTING = 455
    BUY_VANITY_CONSUMABLE_CHARGES = 456
    RECLAIM_VANITY_ITEM = 457
    GET_ARENA_RANKINGS = 458
    GET_CRYSTAL_LEAGUE_STATISTICS = 459
    SEND_OPTIONS_LOG = 460
    SEND_CONTROLS_OPTIONS_LOG = 461
    MISTS_USE_IMMEDIATE_RETURN_EXIT = 462
    MISTS_USE_STATIC_ENTRANCE = 463
    MISTS_USE_CITY_ROADS_ENTRANCE = 464
    CHANGE_NEW_GUILD_MEMBER_MAIL = 465
    GET_NEW_GUILD_MEMBER_MAIL = 466
    CHANGE_GUILD_FACTION_ALLEGIANCE = 467
    GET_GUILD_FACTION_ALLEGIANCE = 468
    GUILD_BANNER_CHANGE = 469
    GUILD_GET_OPTIONAL_STATS = 470
    GUILD_SET_OPTIONAL_STATS = 471
    GET_PLAYER_INFO_FOR_STALK = 472
    PAY_GOLD_FOR_CHARACTER_TYPE_CHANGE = 473
    QUICK_SELL_AUCTION_QUERY_ACTION = 474
    QUICK_SELL_AUCTION_SELL_ACTION = 475
    FCM_TOKEN_TO_SERVER = 476
    APNS_TOKEN_TO_SERVER = 477
    DEATH_RECAP = 478
    AUCTION_FETCH_FINISHED_AUCTIONS = 479
    ABORT_AUCTION_FETCH_FINISHED_AUCTIONS = 480
    REQUEST_LEGENDARY_EVEN_HISTORY = 481
    PARTY_ANSWER_START_HUNT_REQUEST = 482
    HUNT_ABORT = 483
    USE_FIND_TRACK_SPELL_FROM_ITEM_PREPARE = 484
    INTERACT_WITH_TRACK_START = 485
    INTERACT_WITH_TRACK_CANCEL = 486
    TERRITORY_RAID_START = 487
    TERRITORY_RAID_CANCEL = 488
    TERRITORY_CLAIM_RAIDED_RAW_ENERGY_CRYSTAL_RESULT = 489
    GV_G_SEASON_PLAYER_GUILD_PARTICIPATION_DETAILS = 490
    DAILY_MIGHT_BONUS = 491
    CLAIM_DAILY_MIGHT_BONUS = 492
    GET_FORTIFICATION_GROUP_INFO = 493
    UPGRADE_FORTIFICATION_GROUP = 494
    GET_CLUSTER_ACTIVITY_CHEST_ESTIMATES = 495
