# Generated by Django 3.2.9 on 2021-11-21 12:45

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Participant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user_id', models.PositiveIntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Skill',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('caption', models.CharField(max_length=30)),
                ('description', models.TextField(blank=True)),
                ('level_max', models.PositiveSmallIntegerField(null=True)),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='subskills', to='django_skillflux.skill')),
            ],
        ),
        migrations.CreateModel(
            name='SkillExperience',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.PositiveSmallIntegerField(null=True)),
                ('experience', models.TextField(blank=True)),
                ('skill', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_skillflux.skill')),
            ],
        ),
        migrations.CreateModel(
            name='SkillSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('caption', models.CharField(blank=True, max_length=30)),
                ('description', models.TextField(blank=True)),
                ('skills', models.ManyToManyField(related_name='skillsets', through='django_skillflux.SkillExperience', to='django_skillflux.Skill')),
                ('subsets', models.ManyToManyField(related_name='_django_skillflux_skillset_subsets_+', to='django_skillflux.SkillSet')),
            ],
        ),
        migrations.CreateModel(
            name='Transition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('caption', models.CharField(max_length=30)),
                ('description', models.TextField(blank=True)),
                ('effort', models.PositiveSmallIntegerField(default=0)),
                ('expected', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='expected_by', to='django_skillflux.skillset')),
                ('promised', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='promised_by', to='django_skillflux.skillset')),
            ],
        ),
        migrations.CreateModel(
            name='TransitionExperience',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('caption', models.CharField(blank=True, max_length=30)),
                ('experience', models.TextField(blank=True)),
                ('participant', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_skillflux.participant')),
                ('transition', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_skillflux.transition')),
            ],
        ),
        migrations.AddField(
            model_name='skillexperience',
            name='skillset',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_skillflux.skillset'),
        ),
        migrations.AddField(
            model_name='participant',
            name='achieved',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='achieved_by', to='django_skillflux.skillset'),
        ),
        migrations.AddField(
            model_name='participant',
            name='aspired',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='aspired_by', to='django_skillflux.skillset'),
        ),
        migrations.AddField(
            model_name='participant',
            name='user_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype'),
        ),
    ]
