"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HugoDeploy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_certificatemanager_1 = require("aws-cdk-lib/aws-certificatemanager");
const aws_cloudfront_1 = require("aws-cdk-lib/aws-cloudfront");
const aws_cloudfront_origins_1 = require("aws-cdk-lib/aws-cloudfront-origins");
const aws_route53_1 = require("aws-cdk-lib/aws-route53");
const aws_route53_targets_1 = require("aws-cdk-lib/aws-route53-targets");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const aws_s3_deployment_1 = require("aws-cdk-lib/aws-s3-deployment");
const constructs_1 = require("constructs");
class HugoDeploy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.publicDir = props.publicDir;
        this.domainName = props.domainName;
        this.region = props.region ? props.region : 'us-east-1';
        const bucket = new aws_s3_1.Bucket(this, 'WebsiteBucket', {
            publicReadAccess: false,
        });
        const zone = props.zone
            ? props.zone
            : aws_route53_1.HostedZone.fromLookup(this, 'HostedZone', {
                domainName: this.domainName,
            });
        const certificate = new aws_certificatemanager_1.DnsValidatedCertificate(this, 'Certificate', {
            hostedZone: zone,
            domainName: this.domainName,
            region: this.region,
        });
        const cfFunction = new aws_cloudfront_1.Function(this, 'HugoPaths', {
            code: aws_cloudfront_1.FunctionCode.fromInline(`function handler(event) {
  var request = event.request;
  var uri = request.uri;
  if (uri.endsWith('/')) {
    request.uri += 'index.html';
  } else if (!uri.includes('.')) {
    request.uri += '/index.html';
  }
  return request;
}
`),
        });
        const distribution = new aws_cloudfront_1.Distribution(this, 'Distribution', {
            defaultBehavior: {
                origin: new aws_cloudfront_origins_1.S3Origin(bucket),
                viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                allowedMethods: aws_cloudfront_1.AllowedMethods.ALLOW_GET_HEAD,
                cachePolicy: aws_cloudfront_1.CachePolicy.CACHING_OPTIMIZED,
                functionAssociations: [
                    {
                        function: cfFunction,
                        eventType: aws_cloudfront_1.FunctionEventType.VIEWER_REQUEST,
                    },
                ],
            },
            domainNames: [this.domainName],
            certificate,
            minimumProtocolVersion: aws_cloudfront_1.SecurityPolicyProtocol.TLS_V1_2_2021,
            errorResponses: [
                {
                    httpStatus: 403,
                    responsePagePath: '/index.html',
                    responseHttpStatus: 200,
                },
                {
                    httpStatus: 404,
                    responsePagePath: '/index.html',
                    responseHttpStatus: 200,
                },
            ],
        });
        // deploy code
        new aws_s3_deployment_1.BucketDeployment(this, 'BucketDeployment', {
            sources: [aws_s3_deployment_1.Source.asset(`${this.publicDir}/`)],
            destinationBucket: bucket,
            distribution,
            distributionPaths: ['/', '/index.html'],
        });
        // Route53
        new aws_route53_1.ARecord(this, 'Alias', {
            zone,
            recordName: this.domainName,
            target: aws_route53_1.RecordTarget.fromAlias(new aws_route53_targets_1.CloudFrontTarget(distribution)),
        });
    }
}
exports.HugoDeploy = HugoDeploy;
_a = JSII_RTTI_SYMBOL_1;
HugoDeploy[_a] = { fqn: "cdk-hugo-deploy.HugoDeploy", version: "0.0.157" };
//# sourceMappingURL=data:application/json;base64,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