<div align="center">

# 犯人在跳舞 0.2.0

祝各位新年快乐~

![PyPI - Python Version](https://img.shields.io/pypi/pyversions/criminal_dance)
![PyPI - Downloads](https://img.shields.io/pypi/dm/criminal_dance)
![PyPI - License](https://img.shields.io/pypi/l/criminal_dance)
![PyPI](https://img.shields.io/pypi/v/criminal_dance)

基于ayaka的文字版桌游！

</div>

得益于[ayaka](https://github.com/bridgeL/ayaka)，本插件可作为如下机器人框架的插件使用

- [nonebot2](https://github.com/nonebot/nonebot2)(使用[onebot11](https://github.com/nonebot/adapter-onebot)适配器，可兼容qq频道)
- [hoshino](https://github.com/Ice-Cirno/HoshinoBot)
- [nonebot1](https://github.com/nonebot/nonebot)

也可将其作为console程序离线运行

## nonebot2 安装本插件

```
pip install criminal_dance
```

## hoshino 安装本插件

- 从github仓库下载
- 安装依赖`pip install -r requirements.txt`
- 将`criminal_dance/criminal_dance`文件夹放入`hoshino/modules`
- 在`hoshino/config/__bot__.py`中的`MODULES_ON`里，写入字符串`criminal_dance`

## 作为console程序离线运行

```py
# run.py
import ayaka.adapters.console as cat
import criminal_dance
if __name__ == "__main__":
    cat.run()
```

```
python run.py
```

## 帮助

```
[犯人在跳舞]
3-8人游玩，游玩前请先加bot好友，否则无法发牌。90s内不出牌会被系统强制弃牌（防止挂机）
- 犯人在跳舞 唤醒猫猫
[*]
- 卡牌帮助 <卡牌名> 获取相应的帮助
- 详细帮助 
- 牌库规则 
- 绑定私聊 <qq uid> 频道用户请使用该命令
- 退出游戏 
- 局势 查看场面局势
- 手牌 展示手牌
[room]
- 加入 加入房间
- 离开 离开房间
- 房间 查看房间信息
- 开始 开始游戏
```

### 使用流程

所有参与者都要提前加bot的qq好友，以便bot通过私聊发消息给你们

- 发送`犯人在跳舞`，启动猫猫并创建游戏房间，发起者自动位于1号位
- 频道用户需要额外发送`绑定私聊 12345678`，绑定自己的qq号
- 随后其他人发送`加入`，根据加入顺序确定座次
- 人数满足要求后，发送`开始`开始游戏，bot将通过私聊告知手牌
- 之后在群里发送卡牌名称即可打出此卡！
- 发送`退出游戏`，关闭猫猫！

### 卡牌帮助

```
[第一发现人] 一切都是由您开始。打出时没有特别效果
[共犯] 打出这张牌成为共犯。当犯人获胜时，您也获得胜利。当犯人输掉游戏时，您也跟着输掉游戏
[犯人] 您是犯人，不能让其他玩家知道。您只能在只剩下这张手牌时才能打出这张牌，如果您要这么做，您获胜
[不在场证明] 只要有了这个，您就不是犯人了。打出时没有特别效果。如果您有犯人和不在场证明，侦探质疑时您可以否认
[侦探] 您的手牌<=2才能打出这张牌。打出时质疑另一位玩家，如果该玩家持有犯人，您获胜
[普通人] 打出时没有特别效果
[谣言] 所有玩家随机抽一张他下家玩家的手牌
[情报交换] 所有玩家把一张牌传给他上家玩家
[目击者] 看另一个玩家的手牌
[交易] 和至少还有1张手牌的玩家交换一张手牌。如果这是您打出的最后一张牌，则没有特别效果
[神犬] 选择一个玩家。该玩家弃掉他其中的一张手牌，并且获得神犬。如果他弃掉一张犯人牌，您获胜
[警部] 手牌<=2时，选定一个玩家放置此牌，若其最终打出犯人牌，您获得游戏胜利
```

### 详细帮助

```
开局每人4张手牌，轮流出牌，整局游戏的第一张牌必须是{R.第一发现人}（类似扑克规则中的红桃3）

游戏分为好人阵营和坏人阵营，默认都是好人，而最终打出{R.犯人}牌的人作为坏人而胜利
但{R.犯人}牌只有在手牌数为1的时候才能打出，此时打出者作为{R.犯人}而胜利
其他人的目标就是在{R.犯人}逃跑成功之前，通过{R.侦探}、{R.神犬}、{R.警部}等牌抓到{R.犯人}，此时好人阵营胜利
当你打出{R.共犯}牌后，你便加入了坏人阵营，需要协助{R.犯人}获胜
当然，你也可以当个二五仔，若{R.共犯}使用{R.侦探}等牌抓到了{R.犯人}，那么他也视为好人阵营一同胜利

根据参与人数的不同，牌库的牌也不同，具体规则请发送 牌库规则 进一步了解

此外，当游戏进行中时，还有如下命令
局势：获得游戏进行情况等信息
手牌：获得你当前的手牌情况（bot私聊告知）
```

### 牌库规则

```
3人局，必须有第一发现人、犯人、侦探、不在场证明，加其他任意8张牌
4人局，必须有第一发现人、犯人、侦探、不在场证明、共犯，加其他任意11张牌
5人局，必须有第一发现人、犯人、侦探、不在场证明*2、共犯，加其他任意14张牌
6人局，必须有第一发现人、犯人、侦探*2、不在场证明*2、共犯*2，加其他任意16张牌
7人局，必须有第一发现人、犯人、侦探*2、不在场证明*3、共犯*2，加其他任意19张牌
8人局，加全部
```

## 配置

`data/ayaka/犯人在跳舞.json`

| 属性           | 意义                                                                              |
| -------------- | --------------------------------------------------------------------------------- |
| overtime       | 超时限制，超时后系统会自动出牌，防止挂机                                          |
| auto_card_help | 自动卡牌帮助，每打出一张牌后bot都会发送帮助，等参与玩家熟悉规则后，可以关闭该配置 |
| rename         | 重命名卡牌，为担心和谐的人准备                                                    |

你可以将犯人改名为大老鼠，共犯改成小老鼠，侦探改成猫猫，警部改成捕鼠笼，谣言改成幸运大转盘，例如：

```json
{
    "第一发现人": "第一发现人",
    "犯人": "大老鼠",
    "神犬": "神犬",
    "警部": "捕鼠笼",
    "共犯": "小老鼠",
    "普通人": "普通人",
    "不在场证明": "不在场证明",
    "目击者": "目击者",
    "侦探": "猫猫",
    "谣言": "幸运大转盘",
    "交易": "交易",
    "情报交换": "情报交换"
}
```

此时，游戏的启动命令将变成 `大老鼠在跳舞`

## 更新记录

### 0.0.1b2

- 原型阶段，勉强可玩

### 0.0.1 

- 重构代码，第一个正式版本，全部功能已实现

### 0.0.2 

- 修复BUG：在交易、情报交换等特殊阶段，无法查询手牌、局势

### 0.0.3

- 重构代码，更精简的逻辑结构
- 修复BUG：在关闭猫猫后依旧可以通过私聊控制群聊的猫猫
- 更新依赖 ayaka 0.0.1.4

### 0.0.4b0

- 更新退出游戏命令
- 修复BUG：使用强制退出时无法关闭超时机制，请使用退出游戏命令
- 更新依赖 ayaka 0.0.1.5b1

### 0.1.0

- 修复BUG：结束游戏后超时机制没有正确关闭
- 修复BUG：神犬、侦探牌打出后没有按预期切换牌权
- 更新依赖 ayaka 0.0.2.0

### 0.1.1

- 更新依赖 ayaka 0.0.3.0
- 新特性：支持qq频道


### 0.1.2

- 更严格的依赖约束
- 新特性：新增命令退出
- 优化游戏帮助

### 0.2.0

- 更新依赖
- 修复BUG：修复了侦探指认犯人时，犯人没有被算入游戏失败方的BUG
