# Documents


```python
from gatenlp import Document

```


```python
# To load a document from a file with the name "file.bdocjs" into gatenlp simply use:
# doc = Document.load("test2a.bdocjs")

# But it is also possible to load from a file that is somewhere on the internet. For this notebook, we use
# an example document that gets loaded from a URL:
doc = Document.load("https://gatenlp.github.io/python-gatenlp/testdocument1.txt")

# We can visualize the document by printing it:
print(doc)
```

    Document(This is a test document.
    
    It contains just a few sentences. 
    Here is a sentence that mentions a few named entities like 
    the persons Barack Obama or Ursula von der Leyen, locations
    like New York City, Vienna or Beijing or companies like 
    Google, UniCredit or Huawei. 
    
    Here we include a URL https://gatenlp.github.io/python-gatenlp/ 
    and a fake email address john.doe@hiscoolserver.com as well 
    as #some #cool #hastags and a bunch of emojis like 😽 (a kissing cat),
    👩‍🏫 (a woman teacher), 🧬 (DNA), 
    🧗 (a person climbing), 
    💩 (a pile of poo). 
    
    Here we test a few different scripts, e.g. Hangul 한글 or 
    simplified Hanzi 汉字 or Farsi فارسی which goes from right to left. 
    
    
    ,features=Features({}),anns=[])


Printing the document shows the document text and indicates that there are no document features and no 
annotations which is to be expected since we just loaded from a plain text file. 

In a Jupyter notebook, a `gatenlp` document can also be visualized graphically by either just using the document 
as the last value of a cell or by using the IPython "display" function:


```python
from IPython.display import display
display(doc)
```


<script type="text/javascript">/*! jQuery v3.5.1 | (c) JS Foundation and other contributors | jquery.org/license */
!function(e,t){"use strict";"object"==typeof module&&"object"==typeof module.exports?module.exports=e.document?t(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return t(e)}:t(e)}("undefined"!=typeof window?window:this,function(C,e){"use strict";var t=[],r=Object.getPrototypeOf,s=t.slice,g=t.flat?function(e){return t.flat.call(e)}:function(e){return t.concat.apply([],e)},u=t.push,i=t.indexOf,n={},o=n.toString,v=n.hasOwnProperty,a=v.toString,l=a.call(Object),y={},m=function(e){return"function"==typeof e&&"number"!=typeof e.nodeType},x=function(e){return null!=e&&e===e.window},E=C.document,c={type:!0,src:!0,nonce:!0,noModule:!0};function b(e,t,n){var r,i,o=(n=n||E).createElement("script");if(o.text=e,t)for(r in c)(i=t[r]||t.getAttribute&&t.getAttribute(r))&&o.setAttribute(r,i);n.head.appendChild(o).parentNode.removeChild(o)}function w(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?n[o.call(e)]||"object":typeof e}var f="3.5.1",S=function(e,t){return new S.fn.init(e,t)};function p(e){var t=!!e&&"length"in e&&e.length,n=w(e);return!m(e)&&!x(e)&&("array"===n||0===t||"number"==typeof t&&0<t&&t-1 in e)}S.fn=S.prototype={jquery:f,constructor:S,length:0,toArray:function(){return s.call(this)},get:function(e){return null==e?s.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=S.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return S.each(this,e)},map:function(n){return this.pushStack(S.map(this,function(e,t){return n.call(e,t,e)}))},slice:function(){return this.pushStack(s.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},even:function(){return this.pushStack(S.grep(this,function(e,t){return(t+1)%2}))},odd:function(){return this.pushStack(S.grep(this,function(e,t){return t%2}))},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(0<=n&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:u,sort:t.sort,splice:t.splice},S.extend=S.fn.extend=function(){var e,t,n,r,i,o,a=arguments[0]||{},s=1,u=arguments.length,l=!1;for("boolean"==typeof a&&(l=a,a=arguments[s]||{},s++),"object"==typeof a||m(a)||(a={}),s===u&&(a=this,s--);s<u;s++)if(null!=(e=arguments[s]))for(t in e)r=e[t],"__proto__"!==t&&a!==r&&(l&&r&&(S.isPlainObject(r)||(i=Array.isArray(r)))?(n=a[t],o=i&&!Array.isArray(n)?[]:i||S.isPlainObject(n)?n:{},i=!1,a[t]=S.extend(l,o,r)):void 0!==r&&(a[t]=r));return a},S.extend({expando:"jQuery"+(f+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==o.call(e))&&(!(t=r(e))||"function"==typeof(n=v.call(t,"constructor")&&t.constructor)&&a.call(n)===l)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},globalEval:function(e,t,n){b(e,{nonce:t&&t.nonce},n)},each:function(e,t){var n,r=0;if(p(e)){for(n=e.length;r<n;r++)if(!1===t.call(e[r],r,e[r]))break}else for(r in e)if(!1===t.call(e[r],r,e[r]))break;return e},makeArray:function(e,t){var n=t||[];return null!=e&&(p(Object(e))?S.merge(n,"string"==typeof e?[e]:e):u.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:i.call(t,e,n)},merge:function(e,t){for(var n=+t.length,r=0,i=e.length;r<n;r++)e[i++]=t[r];return e.length=i,e},grep:function(e,t,n){for(var r=[],i=0,o=e.length,a=!n;i<o;i++)!t(e[i],i)!==a&&r.push(e[i]);return r},map:function(e,t,n){var r,i,o=0,a=[];if(p(e))for(r=e.length;o<r;o++)null!=(i=t(e[o],o,n))&&a.push(i);else for(o in e)null!=(i=t(e[o],o,n))&&a.push(i);return g(a)},guid:1,support:y}),"function"==typeof Symbol&&(S.fn[Symbol.iterator]=t[Symbol.iterator]),S.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){n["[object "+t+"]"]=t.toLowerCase()});var d=function(n){var e,d,b,o,i,h,f,g,w,u,l,T,C,a,E,v,s,c,y,S="sizzle"+1*new Date,p=n.document,k=0,r=0,m=ue(),x=ue(),A=ue(),N=ue(),D=function(e,t){return e===t&&(l=!0),0},j={}.hasOwnProperty,t=[],q=t.pop,L=t.push,H=t.push,O=t.slice,P=function(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1},R="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",M="[\\x20\\t\\r\\n\\f]",I="(?:\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",W="\\["+M+"*("+I+")(?:"+M+"*([*^$|!~]?=)"+M+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+I+"))|)"+M+"*\\]",F=":("+I+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+W+")*)|.*)\\)|)",B=new RegExp(M+"+","g"),$=new RegExp("^"+M+"+|((?:^|[^\\\\])(?:\\\\.)*)"+M+"+$","g"),_=new RegExp("^"+M+"*,"+M+"*"),z=new RegExp("^"+M+"*([>+~]|"+M+")"+M+"*"),U=new RegExp(M+"|>"),X=new RegExp(F),V=new RegExp("^"+I+"$"),G={ID:new RegExp("^#("+I+")"),CLASS:new RegExp("^\\.("+I+")"),TAG:new RegExp("^("+I+"|[*])"),ATTR:new RegExp("^"+W),PSEUDO:new RegExp("^"+F),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+M+"*(even|odd|(([+-]|)(\\d*)n|)"+M+"*(?:([+-]|)"+M+"*(\\d+)|))"+M+"*\\)|)","i"),bool:new RegExp("^(?:"+R+")$","i"),needsContext:new RegExp("^"+M+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+M+"*((?:-\\d)?\\d*)"+M+"*\\)|)(?=[^-]|$)","i")},Y=/HTML$/i,Q=/^(?:input|select|textarea|button)$/i,J=/^h\d$/i,K=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ee=/[+~]/,te=new RegExp("\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\([^\\r\\n\\f])","g"),ne=function(e,t){var n="0x"+e.slice(1)-65536;return t||(n<0?String.fromCharCode(n+65536):String.fromCharCode(n>>10|55296,1023&n|56320))},re=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ie=function(e,t){return t?"\0"===e?"\ufffd":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},oe=function(){T()},ae=be(function(e){return!0===e.disabled&&"fieldset"===e.nodeName.toLowerCase()},{dir:"parentNode",next:"legend"});try{H.apply(t=O.call(p.childNodes),p.childNodes),t[p.childNodes.length].nodeType}catch(e){H={apply:t.length?function(e,t){L.apply(e,O.call(t))}:function(e,t){var n=e.length,r=0;while(e[n++]=t[r++]);e.length=n-1}}}function se(t,e,n,r){var i,o,a,s,u,l,c,f=e&&e.ownerDocument,p=e?e.nodeType:9;if(n=n||[],"string"!=typeof t||!t||1!==p&&9!==p&&11!==p)return n;if(!r&&(T(e),e=e||C,E)){if(11!==p&&(u=Z.exec(t)))if(i=u[1]){if(9===p){if(!(a=e.getElementById(i)))return n;if(a.id===i)return n.push(a),n}else if(f&&(a=f.getElementById(i))&&y(e,a)&&a.id===i)return n.push(a),n}else{if(u[2])return H.apply(n,e.getElementsByTagName(t)),n;if((i=u[3])&&d.getElementsByClassName&&e.getElementsByClassName)return H.apply(n,e.getElementsByClassName(i)),n}if(d.qsa&&!N[t+" "]&&(!v||!v.test(t))&&(1!==p||"object"!==e.nodeName.toLowerCase())){if(c=t,f=e,1===p&&(U.test(t)||z.test(t))){(f=ee.test(t)&&ye(e.parentNode)||e)===e&&d.scope||((s=e.getAttribute("id"))?s=s.replace(re,ie):e.setAttribute("id",s=S)),o=(l=h(t)).length;while(o--)l[o]=(s?"#"+s:":scope")+" "+xe(l[o]);c=l.join(",")}try{return H.apply(n,f.querySelectorAll(c)),n}catch(e){N(t,!0)}finally{s===S&&e.removeAttribute("id")}}}return g(t.replace($,"$1"),e,n,r)}function ue(){var r=[];return function e(t,n){return r.push(t+" ")>b.cacheLength&&delete e[r.shift()],e[t+" "]=n}}function le(e){return e[S]=!0,e}function ce(e){var t=C.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function fe(e,t){var n=e.split("|"),r=n.length;while(r--)b.attrHandle[n[r]]=t}function pe(e,t){var n=t&&e,r=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(r)return r;if(n)while(n=n.nextSibling)if(n===t)return-1;return e?1:-1}function de(t){return function(e){return"input"===e.nodeName.toLowerCase()&&e.type===t}}function he(n){return function(e){var t=e.nodeName.toLowerCase();return("input"===t||"button"===t)&&e.type===n}}function ge(t){return function(e){return"form"in e?e.parentNode&&!1===e.disabled?"label"in e?"label"in e.parentNode?e.parentNode.disabled===t:e.disabled===t:e.isDisabled===t||e.isDisabled!==!t&&ae(e)===t:e.disabled===t:"label"in e&&e.disabled===t}}function ve(a){return le(function(o){return o=+o,le(function(e,t){var n,r=a([],e.length,o),i=r.length;while(i--)e[n=r[i]]&&(e[n]=!(t[n]=e[n]))})})}function ye(e){return e&&"undefined"!=typeof e.getElementsByTagName&&e}for(e in d=se.support={},i=se.isXML=function(e){var t=e.namespaceURI,n=(e.ownerDocument||e).documentElement;return!Y.test(t||n&&n.nodeName||"HTML")},T=se.setDocument=function(e){var t,n,r=e?e.ownerDocument||e:p;return r!=C&&9===r.nodeType&&r.documentElement&&(a=(C=r).documentElement,E=!i(C),p!=C&&(n=C.defaultView)&&n.top!==n&&(n.addEventListener?n.addEventListener("unload",oe,!1):n.attachEvent&&n.attachEvent("onunload",oe)),d.scope=ce(function(e){return a.appendChild(e).appendChild(C.createElement("div")),"undefined"!=typeof e.querySelectorAll&&!e.querySelectorAll(":scope fieldset div").length}),d.attributes=ce(function(e){return e.className="i",!e.getAttribute("className")}),d.getElementsByTagName=ce(function(e){return e.appendChild(C.createComment("")),!e.getElementsByTagName("*").length}),d.getElementsByClassName=K.test(C.getElementsByClassName),d.getById=ce(function(e){return a.appendChild(e).id=S,!C.getElementsByName||!C.getElementsByName(S).length}),d.getById?(b.filter.ID=function(e){var t=e.replace(te,ne);return function(e){return e.getAttribute("id")===t}},b.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&E){var n=t.getElementById(e);return n?[n]:[]}}):(b.filter.ID=function(e){var n=e.replace(te,ne);return function(e){var t="undefined"!=typeof e.getAttributeNode&&e.getAttributeNode("id");return t&&t.value===n}},b.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&E){var n,r,i,o=t.getElementById(e);if(o){if((n=o.getAttributeNode("id"))&&n.value===e)return[o];i=t.getElementsByName(e),r=0;while(o=i[r++])if((n=o.getAttributeNode("id"))&&n.value===e)return[o]}return[]}}),b.find.TAG=d.getElementsByTagName?function(e,t){return"undefined"!=typeof t.getElementsByTagName?t.getElementsByTagName(e):d.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if("*"===e){while(n=o[i++])1===n.nodeType&&r.push(n);return r}return o},b.find.CLASS=d.getElementsByClassName&&function(e,t){if("undefined"!=typeof t.getElementsByClassName&&E)return t.getElementsByClassName(e)},s=[],v=[],(d.qsa=K.test(C.querySelectorAll))&&(ce(function(e){var t;a.appendChild(e).innerHTML="<a id='"+S+"'></a><select id='"+S+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&v.push("[*^$]="+M+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||v.push("\\["+M+"*(?:value|"+R+")"),e.querySelectorAll("[id~="+S+"-]").length||v.push("~="),(t=C.createElement("input")).setAttribute("name",""),e.appendChild(t),e.querySelectorAll("[name='']").length||v.push("\\["+M+"*name"+M+"*="+M+"*(?:''|\"\")"),e.querySelectorAll(":checked").length||v.push(":checked"),e.querySelectorAll("a#"+S+"+*").length||v.push(".#.+[+~]"),e.querySelectorAll("\\\f"),v.push("[\\r\\n\\f]")}),ce(function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=C.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&v.push("name"+M+"*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&v.push(":enabled",":disabled"),a.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&v.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),v.push(",.*:")})),(d.matchesSelector=K.test(c=a.matches||a.webkitMatchesSelector||a.mozMatchesSelector||a.oMatchesSelector||a.msMatchesSelector))&&ce(function(e){d.disconnectedMatch=c.call(e,"*"),c.call(e,"[s!='']:x"),s.push("!=",F)}),v=v.length&&new RegExp(v.join("|")),s=s.length&&new RegExp(s.join("|")),t=K.test(a.compareDocumentPosition),y=t||K.test(a.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)while(t=t.parentNode)if(t===e)return!0;return!1},D=t?function(e,t){if(e===t)return l=!0,0;var n=!e.compareDocumentPosition-!t.compareDocumentPosition;return n||(1&(n=(e.ownerDocument||e)==(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!d.sortDetached&&t.compareDocumentPosition(e)===n?e==C||e.ownerDocument==p&&y(p,e)?-1:t==C||t.ownerDocument==p&&y(p,t)?1:u?P(u,e)-P(u,t):0:4&n?-1:1)}:function(e,t){if(e===t)return l=!0,0;var n,r=0,i=e.parentNode,o=t.parentNode,a=[e],s=[t];if(!i||!o)return e==C?-1:t==C?1:i?-1:o?1:u?P(u,e)-P(u,t):0;if(i===o)return pe(e,t);n=e;while(n=n.parentNode)a.unshift(n);n=t;while(n=n.parentNode)s.unshift(n);while(a[r]===s[r])r++;return r?pe(a[r],s[r]):a[r]==p?-1:s[r]==p?1:0}),C},se.matches=function(e,t){return se(e,null,null,t)},se.matchesSelector=function(e,t){if(T(e),d.matchesSelector&&E&&!N[t+" "]&&(!s||!s.test(t))&&(!v||!v.test(t)))try{var n=c.call(e,t);if(n||d.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(e){N(t,!0)}return 0<se(t,C,null,[e]).length},se.contains=function(e,t){return(e.ownerDocument||e)!=C&&T(e),y(e,t)},se.attr=function(e,t){(e.ownerDocument||e)!=C&&T(e);var n=b.attrHandle[t.toLowerCase()],r=n&&j.call(b.attrHandle,t.toLowerCase())?n(e,t,!E):void 0;return void 0!==r?r:d.attributes||!E?e.getAttribute(t):(r=e.getAttributeNode(t))&&r.specified?r.value:null},se.escape=function(e){return(e+"").replace(re,ie)},se.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},se.uniqueSort=function(e){var t,n=[],r=0,i=0;if(l=!d.detectDuplicates,u=!d.sortStable&&e.slice(0),e.sort(D),l){while(t=e[i++])t===e[i]&&(r=n.push(i));while(r--)e.splice(n[r],1)}return u=null,e},o=se.getText=function(e){var t,n="",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=o(e)}else if(3===i||4===i)return e.nodeValue}else while(t=e[r++])n+=o(t);return n},(b=se.selectors={cacheLength:50,createPseudo:le,match:G,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(te,ne),e[3]=(e[3]||e[4]||e[5]||"").replace(te,ne),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||se.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&se.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return G.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&X.test(n)&&(t=h(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(te,ne).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=m[e+" "];return t||(t=new RegExp("(^|"+M+")"+e+"("+M+"|$)"))&&m(e,function(e){return t.test("string"==typeof e.className&&e.className||"undefined"!=typeof e.getAttribute&&e.getAttribute("class")||"")})},ATTR:function(n,r,i){return function(e){var t=se.attr(e,n);return null==t?"!="===r:!r||(t+="","="===r?t===i:"!="===r?t!==i:"^="===r?i&&0===t.indexOf(i):"*="===r?i&&-1<t.indexOf(i):"$="===r?i&&t.slice(-i.length)===i:"~="===r?-1<(" "+t.replace(B," ")+" ").indexOf(i):"|="===r&&(t===i||t.slice(0,i.length+1)===i+"-"))}},CHILD:function(h,e,t,g,v){var y="nth"!==h.slice(0,3),m="last"!==h.slice(-4),x="of-type"===e;return 1===g&&0===v?function(e){return!!e.parentNode}:function(e,t,n){var r,i,o,a,s,u,l=y!==m?"nextSibling":"previousSibling",c=e.parentNode,f=x&&e.nodeName.toLowerCase(),p=!n&&!x,d=!1;if(c){if(y){while(l){a=e;while(a=a[l])if(x?a.nodeName.toLowerCase()===f:1===a.nodeType)return!1;u=l="only"===h&&!u&&"nextSibling"}return!0}if(u=[m?c.firstChild:c.lastChild],m&&p){d=(s=(r=(i=(o=(a=c)[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]||[])[0]===k&&r[1])&&r[2],a=s&&c.childNodes[s];while(a=++s&&a&&a[l]||(d=s=0)||u.pop())if(1===a.nodeType&&++d&&a===e){i[h]=[k,s,d];break}}else if(p&&(d=s=(r=(i=(o=(a=e)[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]||[])[0]===k&&r[1]),!1===d)while(a=++s&&a&&a[l]||(d=s=0)||u.pop())if((x?a.nodeName.toLowerCase()===f:1===a.nodeType)&&++d&&(p&&((i=(o=a[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]=[k,d]),a===e))break;return(d-=v)===g||d%g==0&&0<=d/g}}},PSEUDO:function(e,o){var t,a=b.pseudos[e]||b.setFilters[e.toLowerCase()]||se.error("unsupported pseudo: "+e);return a[S]?a(o):1<a.length?(t=[e,e,"",o],b.setFilters.hasOwnProperty(e.toLowerCase())?le(function(e,t){var n,r=a(e,o),i=r.length;while(i--)e[n=P(e,r[i])]=!(t[n]=r[i])}):function(e){return a(e,0,t)}):a}},pseudos:{not:le(function(e){var r=[],i=[],s=f(e.replace($,"$1"));return s[S]?le(function(e,t,n,r){var i,o=s(e,null,r,[]),a=e.length;while(a--)(i=o[a])&&(e[a]=!(t[a]=i))}):function(e,t,n){return r[0]=e,s(r,null,n,i),r[0]=null,!i.pop()}}),has:le(function(t){return function(e){return 0<se(t,e).length}}),contains:le(function(t){return t=t.replace(te,ne),function(e){return-1<(e.textContent||o(e)).indexOf(t)}}),lang:le(function(n){return V.test(n||"")||se.error("unsupported lang: "+n),n=n.replace(te,ne).toLowerCase(),function(e){var t;do{if(t=E?e.lang:e.getAttribute("xml:lang")||e.getAttribute("lang"))return(t=t.toLowerCase())===n||0===t.indexOf(n+"-")}while((e=e.parentNode)&&1===e.nodeType);return!1}}),target:function(e){var t=n.location&&n.location.hash;return t&&t.slice(1)===e.id},root:function(e){return e===a},focus:function(e){return e===C.activeElement&&(!C.hasFocus||C.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:ge(!1),disabled:ge(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!b.pseudos.empty(e)},header:function(e){return J.test(e.nodeName)},input:function(e){return Q.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:ve(function(){return[0]}),last:ve(function(e,t){return[t-1]}),eq:ve(function(e,t,n){return[n<0?n+t:n]}),even:ve(function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e}),odd:ve(function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e}),lt:ve(function(e,t,n){for(var r=n<0?n+t:t<n?t:n;0<=--r;)e.push(r);return e}),gt:ve(function(e,t,n){for(var r=n<0?n+t:n;++r<t;)e.push(r);return e})}}).pseudos.nth=b.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})b.pseudos[e]=de(e);for(e in{submit:!0,reset:!0})b.pseudos[e]=he(e);function me(){}function xe(e){for(var t=0,n=e.length,r="";t<n;t++)r+=e[t].value;return r}function be(s,e,t){var u=e.dir,l=e.next,c=l||u,f=t&&"parentNode"===c,p=r++;return e.first?function(e,t,n){while(e=e[u])if(1===e.nodeType||f)return s(e,t,n);return!1}:function(e,t,n){var r,i,o,a=[k,p];if(n){while(e=e[u])if((1===e.nodeType||f)&&s(e,t,n))return!0}else while(e=e[u])if(1===e.nodeType||f)if(i=(o=e[S]||(e[S]={}))[e.uniqueID]||(o[e.uniqueID]={}),l&&l===e.nodeName.toLowerCase())e=e[u]||e;else{if((r=i[c])&&r[0]===k&&r[1]===p)return a[2]=r[2];if((i[c]=a)[2]=s(e,t,n))return!0}return!1}}function we(i){return 1<i.length?function(e,t,n){var r=i.length;while(r--)if(!i[r](e,t,n))return!1;return!0}:i[0]}function Te(e,t,n,r,i){for(var o,a=[],s=0,u=e.length,l=null!=t;s<u;s++)(o=e[s])&&(n&&!n(o,r,i)||(a.push(o),l&&t.push(s)));return a}function Ce(d,h,g,v,y,e){return v&&!v[S]&&(v=Ce(v)),y&&!y[S]&&(y=Ce(y,e)),le(function(e,t,n,r){var i,o,a,s=[],u=[],l=t.length,c=e||function(e,t,n){for(var r=0,i=t.length;r<i;r++)se(e,t[r],n);return n}(h||"*",n.nodeType?[n]:n,[]),f=!d||!e&&h?c:Te(c,s,d,n,r),p=g?y||(e?d:l||v)?[]:t:f;if(g&&g(f,p,n,r),v){i=Te(p,u),v(i,[],n,r),o=i.length;while(o--)(a=i[o])&&(p[u[o]]=!(f[u[o]]=a))}if(e){if(y||d){if(y){i=[],o=p.length;while(o--)(a=p[o])&&i.push(f[o]=a);y(null,p=[],i,r)}o=p.length;while(o--)(a=p[o])&&-1<(i=y?P(e,a):s[o])&&(e[i]=!(t[i]=a))}}else p=Te(p===t?p.splice(l,p.length):p),y?y(null,t,p,r):H.apply(t,p)})}function Ee(e){for(var i,t,n,r=e.length,o=b.relative[e[0].type],a=o||b.relative[" "],s=o?1:0,u=be(function(e){return e===i},a,!0),l=be(function(e){return-1<P(i,e)},a,!0),c=[function(e,t,n){var r=!o&&(n||t!==w)||((i=t).nodeType?u(e,t,n):l(e,t,n));return i=null,r}];s<r;s++)if(t=b.relative[e[s].type])c=[be(we(c),t)];else{if((t=b.filter[e[s].type].apply(null,e[s].matches))[S]){for(n=++s;n<r;n++)if(b.relative[e[n].type])break;return Ce(1<s&&we(c),1<s&&xe(e.slice(0,s-1).concat({value:" "===e[s-2].type?"*":""})).replace($,"$1"),t,s<n&&Ee(e.slice(s,n)),n<r&&Ee(e=e.slice(n)),n<r&&xe(e))}c.push(t)}return we(c)}return me.prototype=b.filters=b.pseudos,b.setFilters=new me,h=se.tokenize=function(e,t){var n,r,i,o,a,s,u,l=x[e+" "];if(l)return t?0:l.slice(0);a=e,s=[],u=b.preFilter;while(a){for(o in n&&!(r=_.exec(a))||(r&&(a=a.slice(r[0].length)||a),s.push(i=[])),n=!1,(r=z.exec(a))&&(n=r.shift(),i.push({value:n,type:r[0].replace($," ")}),a=a.slice(n.length)),b.filter)!(r=G[o].exec(a))||u[o]&&!(r=u[o](r))||(n=r.shift(),i.push({value:n,type:o,matches:r}),a=a.slice(n.length));if(!n)break}return t?a.length:a?se.error(e):x(e,s).slice(0)},f=se.compile=function(e,t){var n,v,y,m,x,r,i=[],o=[],a=A[e+" "];if(!a){t||(t=h(e)),n=t.length;while(n--)(a=Ee(t[n]))[S]?i.push(a):o.push(a);(a=A(e,(v=o,m=0<(y=i).length,x=0<v.length,r=function(e,t,n,r,i){var o,a,s,u=0,l="0",c=e&&[],f=[],p=w,d=e||x&&b.find.TAG("*",i),h=k+=null==p?1:Math.random()||.1,g=d.length;for(i&&(w=t==C||t||i);l!==g&&null!=(o=d[l]);l++){if(x&&o){a=0,t||o.ownerDocument==C||(T(o),n=!E);while(s=v[a++])if(s(o,t||C,n)){r.push(o);break}i&&(k=h)}m&&((o=!s&&o)&&u--,e&&c.push(o))}if(u+=l,m&&l!==u){a=0;while(s=y[a++])s(c,f,t,n);if(e){if(0<u)while(l--)c[l]||f[l]||(f[l]=q.call(r));f=Te(f)}H.apply(r,f),i&&!e&&0<f.length&&1<u+y.length&&se.uniqueSort(r)}return i&&(k=h,w=p),c},m?le(r):r))).selector=e}return a},g=se.select=function(e,t,n,r){var i,o,a,s,u,l="function"==typeof e&&e,c=!r&&h(e=l.selector||e);if(n=n||[],1===c.length){if(2<(o=c[0]=c[0].slice(0)).length&&"ID"===(a=o[0]).type&&9===t.nodeType&&E&&b.relative[o[1].type]){if(!(t=(b.find.ID(a.matches[0].replace(te,ne),t)||[])[0]))return n;l&&(t=t.parentNode),e=e.slice(o.shift().value.length)}i=G.needsContext.test(e)?0:o.length;while(i--){if(a=o[i],b.relative[s=a.type])break;if((u=b.find[s])&&(r=u(a.matches[0].replace(te,ne),ee.test(o[0].type)&&ye(t.parentNode)||t))){if(o.splice(i,1),!(e=r.length&&xe(o)))return H.apply(n,r),n;break}}}return(l||f(e,c))(r,t,!E,n,!t||ee.test(e)&&ye(t.parentNode)||t),n},d.sortStable=S.split("").sort(D).join("")===S,d.detectDuplicates=!!l,T(),d.sortDetached=ce(function(e){return 1&e.compareDocumentPosition(C.createElement("fieldset"))}),ce(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||fe("type|href|height|width",function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)}),d.attributes&&ce(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||fe("value",function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue}),ce(function(e){return null==e.getAttribute("disabled")})||fe(R,function(e,t,n){var r;if(!n)return!0===e[t]?t.toLowerCase():(r=e.getAttributeNode(t))&&r.specified?r.value:null}),se}(C);S.find=d,S.expr=d.selectors,S.expr[":"]=S.expr.pseudos,S.uniqueSort=S.unique=d.uniqueSort,S.text=d.getText,S.isXMLDoc=d.isXML,S.contains=d.contains,S.escapeSelector=d.escape;var h=function(e,t,n){var r=[],i=void 0!==n;while((e=e[t])&&9!==e.nodeType)if(1===e.nodeType){if(i&&S(e).is(n))break;r.push(e)}return r},T=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},k=S.expr.match.needsContext;function A(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var N=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function D(e,n,r){return m(n)?S.grep(e,function(e,t){return!!n.call(e,t,e)!==r}):n.nodeType?S.grep(e,function(e){return e===n!==r}):"string"!=typeof n?S.grep(e,function(e){return-1<i.call(n,e)!==r}):S.filter(n,e,r)}S.filter=function(e,t,n){var r=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===r.nodeType?S.find.matchesSelector(r,e)?[r]:[]:S.find.matches(e,S.grep(t,function(e){return 1===e.nodeType}))},S.fn.extend({find:function(e){var t,n,r=this.length,i=this;if("string"!=typeof e)return this.pushStack(S(e).filter(function(){for(t=0;t<r;t++)if(S.contains(i[t],this))return!0}));for(n=this.pushStack([]),t=0;t<r;t++)S.find(e,i[t],n);return 1<r?S.uniqueSort(n):n},filter:function(e){return this.pushStack(D(this,e||[],!1))},not:function(e){return this.pushStack(D(this,e||[],!0))},is:function(e){return!!D(this,"string"==typeof e&&k.test(e)?S(e):e||[],!1).length}});var j,q=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/;(S.fn.init=function(e,t,n){var r,i;if(!e)return this;if(n=n||j,"string"==typeof e){if(!(r="<"===e[0]&&">"===e[e.length-1]&&3<=e.length?[null,e,null]:q.exec(e))||!r[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(r[1]){if(t=t instanceof S?t[0]:t,S.merge(this,S.parseHTML(r[1],t&&t.nodeType?t.ownerDocument||t:E,!0)),N.test(r[1])&&S.isPlainObject(t))for(r in t)m(this[r])?this[r](t[r]):this.attr(r,t[r]);return this}return(i=E.getElementById(r[2]))&&(this[0]=i,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):m(e)?void 0!==n.ready?n.ready(e):e(S):S.makeArray(e,this)}).prototype=S.fn,j=S(E);var L=/^(?:parents|prev(?:Until|All))/,H={children:!0,contents:!0,next:!0,prev:!0};function O(e,t){while((e=e[t])&&1!==e.nodeType);return e}S.fn.extend({has:function(e){var t=S(e,this),n=t.length;return this.filter(function(){for(var e=0;e<n;e++)if(S.contains(this,t[e]))return!0})},closest:function(e,t){var n,r=0,i=this.length,o=[],a="string"!=typeof e&&S(e);if(!k.test(e))for(;r<i;r++)for(n=this[r];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(a?-1<a.index(n):1===n.nodeType&&S.find.matchesSelector(n,e))){o.push(n);break}return this.pushStack(1<o.length?S.uniqueSort(o):o)},index:function(e){return e?"string"==typeof e?i.call(S(e),this[0]):i.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(S.uniqueSort(S.merge(this.get(),S(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),S.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return h(e,"parentNode")},parentsUntil:function(e,t,n){return h(e,"parentNode",n)},next:function(e){return O(e,"nextSibling")},prev:function(e){return O(e,"previousSibling")},nextAll:function(e){return h(e,"nextSibling")},prevAll:function(e){return h(e,"previousSibling")},nextUntil:function(e,t,n){return h(e,"nextSibling",n)},prevUntil:function(e,t,n){return h(e,"previousSibling",n)},siblings:function(e){return T((e.parentNode||{}).firstChild,e)},children:function(e){return T(e.firstChild)},contents:function(e){return null!=e.contentDocument&&r(e.contentDocument)?e.contentDocument:(A(e,"template")&&(e=e.content||e),S.merge([],e.childNodes))}},function(r,i){S.fn[r]=function(e,t){var n=S.map(this,i,e);return"Until"!==r.slice(-5)&&(t=e),t&&"string"==typeof t&&(n=S.filter(t,n)),1<this.length&&(H[r]||S.uniqueSort(n),L.test(r)&&n.reverse()),this.pushStack(n)}});var P=/[^\x20\t\r\n\f]+/g;function R(e){return e}function M(e){throw e}function I(e,t,n,r){var i;try{e&&m(i=e.promise)?i.call(e).done(t).fail(n):e&&m(i=e.then)?i.call(e,t,n):t.apply(void 0,[e].slice(r))}catch(e){n.apply(void 0,[e])}}S.Callbacks=function(r){var e,n;r="string"==typeof r?(e=r,n={},S.each(e.match(P)||[],function(e,t){n[t]=!0}),n):S.extend({},r);var i,t,o,a,s=[],u=[],l=-1,c=function(){for(a=a||r.once,o=i=!0;u.length;l=-1){t=u.shift();while(++l<s.length)!1===s[l].apply(t[0],t[1])&&r.stopOnFalse&&(l=s.length,t=!1)}r.memory||(t=!1),i=!1,a&&(s=t?[]:"")},f={add:function(){return s&&(t&&!i&&(l=s.length-1,u.push(t)),function n(e){S.each(e,function(e,t){m(t)?r.unique&&f.has(t)||s.push(t):t&&t.length&&"string"!==w(t)&&n(t)})}(arguments),t&&!i&&c()),this},remove:function(){return S.each(arguments,function(e,t){var n;while(-1<(n=S.inArray(t,s,n)))s.splice(n,1),n<=l&&l--}),this},has:function(e){return e?-1<S.inArray(e,s):0<s.length},empty:function(){return s&&(s=[]),this},disable:function(){return a=u=[],s=t="",this},disabled:function(){return!s},lock:function(){return a=u=[],t||i||(s=t=""),this},locked:function(){return!!a},fireWith:function(e,t){return a||(t=[e,(t=t||[]).slice?t.slice():t],u.push(t),i||c()),this},fire:function(){return f.fireWith(this,arguments),this},fired:function(){return!!o}};return f},S.extend({Deferred:function(e){var o=[["notify","progress",S.Callbacks("memory"),S.Callbacks("memory"),2],["resolve","done",S.Callbacks("once memory"),S.Callbacks("once memory"),0,"resolved"],["reject","fail",S.Callbacks("once memory"),S.Callbacks("once memory"),1,"rejected"]],i="pending",a={state:function(){return i},always:function(){return s.done(arguments).fail(arguments),this},"catch":function(e){return a.then(null,e)},pipe:function(){var i=arguments;return S.Deferred(function(r){S.each(o,function(e,t){var n=m(i[t[4]])&&i[t[4]];s[t[1]](function(){var e=n&&n.apply(this,arguments);e&&m(e.promise)?e.promise().progress(r.notify).done(r.resolve).fail(r.reject):r[t[0]+"With"](this,n?[e]:arguments)})}),i=null}).promise()},then:function(t,n,r){var u=0;function l(i,o,a,s){return function(){var n=this,r=arguments,e=function(){var e,t;if(!(i<u)){if((e=a.apply(n,r))===o.promise())throw new TypeError("Thenable self-resolution");t=e&&("object"==typeof e||"function"==typeof e)&&e.then,m(t)?s?t.call(e,l(u,o,R,s),l(u,o,M,s)):(u++,t.call(e,l(u,o,R,s),l(u,o,M,s),l(u,o,R,o.notifyWith))):(a!==R&&(n=void 0,r=[e]),(s||o.resolveWith)(n,r))}},t=s?e:function(){try{e()}catch(e){S.Deferred.exceptionHook&&S.Deferred.exceptionHook(e,t.stackTrace),u<=i+1&&(a!==M&&(n=void 0,r=[e]),o.rejectWith(n,r))}};i?t():(S.Deferred.getStackHook&&(t.stackTrace=S.Deferred.getStackHook()),C.setTimeout(t))}}return S.Deferred(function(e){o[0][3].add(l(0,e,m(r)?r:R,e.notifyWith)),o[1][3].add(l(0,e,m(t)?t:R)),o[2][3].add(l(0,e,m(n)?n:M))}).promise()},promise:function(e){return null!=e?S.extend(e,a):a}},s={};return S.each(o,function(e,t){var n=t[2],r=t[5];a[t[1]]=n.add,r&&n.add(function(){i=r},o[3-e][2].disable,o[3-e][3].disable,o[0][2].lock,o[0][3].lock),n.add(t[3].fire),s[t[0]]=function(){return s[t[0]+"With"](this===s?void 0:this,arguments),this},s[t[0]+"With"]=n.fireWith}),a.promise(s),e&&e.call(s,s),s},when:function(e){var n=arguments.length,t=n,r=Array(t),i=s.call(arguments),o=S.Deferred(),a=function(t){return function(e){r[t]=this,i[t]=1<arguments.length?s.call(arguments):e,--n||o.resolveWith(r,i)}};if(n<=1&&(I(e,o.done(a(t)).resolve,o.reject,!n),"pending"===o.state()||m(i[t]&&i[t].then)))return o.then();while(t--)I(i[t],a(t),o.reject);return o.promise()}});var W=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;S.Deferred.exceptionHook=function(e,t){C.console&&C.console.warn&&e&&W.test(e.name)&&C.console.warn("jQuery.Deferred exception: "+e.message,e.stack,t)},S.readyException=function(e){C.setTimeout(function(){throw e})};var F=S.Deferred();function B(){E.removeEventListener("DOMContentLoaded",B),C.removeEventListener("load",B),S.ready()}S.fn.ready=function(e){return F.then(e)["catch"](function(e){S.readyException(e)}),this},S.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--S.readyWait:S.isReady)||(S.isReady=!0)!==e&&0<--S.readyWait||F.resolveWith(E,[S])}}),S.ready.then=F.then,"complete"===E.readyState||"loading"!==E.readyState&&!E.documentElement.doScroll?C.setTimeout(S.ready):(E.addEventListener("DOMContentLoaded",B),C.addEventListener("load",B));var $=function(e,t,n,r,i,o,a){var s=0,u=e.length,l=null==n;if("object"===w(n))for(s in i=!0,n)$(e,t,s,n[s],!0,o,a);else if(void 0!==r&&(i=!0,m(r)||(a=!0),l&&(a?(t.call(e,r),t=null):(l=t,t=function(e,t,n){return l.call(S(e),n)})),t))for(;s<u;s++)t(e[s],n,a?r:r.call(e[s],s,t(e[s],n)));return i?e:l?t.call(e):u?t(e[0],n):o},_=/^-ms-/,z=/-([a-z])/g;function U(e,t){return t.toUpperCase()}function X(e){return e.replace(_,"ms-").replace(z,U)}var V=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function G(){this.expando=S.expando+G.uid++}G.uid=1,G.prototype={cache:function(e){var t=e[this.expando];return t||(t={},V(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var r,i=this.cache(e);if("string"==typeof t)i[X(t)]=n;else for(r in t)i[X(r)]=t[r];return i},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][X(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,r=e[this.expando];if(void 0!==r){if(void 0!==t){n=(t=Array.isArray(t)?t.map(X):(t=X(t))in r?[t]:t.match(P)||[]).length;while(n--)delete r[t[n]]}(void 0===t||S.isEmptyObject(r))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!S.isEmptyObject(t)}};var Y=new G,Q=new G,J=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,K=/[A-Z]/g;function Z(e,t,n){var r,i;if(void 0===n&&1===e.nodeType)if(r="data-"+t.replace(K,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(r))){try{n="true"===(i=n)||"false"!==i&&("null"===i?null:i===+i+""?+i:J.test(i)?JSON.parse(i):i)}catch(e){}Q.set(e,t,n)}else n=void 0;return n}S.extend({hasData:function(e){return Q.hasData(e)||Y.hasData(e)},data:function(e,t,n){return Q.access(e,t,n)},removeData:function(e,t){Q.remove(e,t)},_data:function(e,t,n){return Y.access(e,t,n)},_removeData:function(e,t){Y.remove(e,t)}}),S.fn.extend({data:function(n,e){var t,r,i,o=this[0],a=o&&o.attributes;if(void 0===n){if(this.length&&(i=Q.get(o),1===o.nodeType&&!Y.get(o,"hasDataAttrs"))){t=a.length;while(t--)a[t]&&0===(r=a[t].name).indexOf("data-")&&(r=X(r.slice(5)),Z(o,r,i[r]));Y.set(o,"hasDataAttrs",!0)}return i}return"object"==typeof n?this.each(function(){Q.set(this,n)}):$(this,function(e){var t;if(o&&void 0===e)return void 0!==(t=Q.get(o,n))?t:void 0!==(t=Z(o,n))?t:void 0;this.each(function(){Q.set(this,n,e)})},null,e,1<arguments.length,null,!0)},removeData:function(e){return this.each(function(){Q.remove(this,e)})}}),S.extend({queue:function(e,t,n){var r;if(e)return t=(t||"fx")+"queue",r=Y.get(e,t),n&&(!r||Array.isArray(n)?r=Y.access(e,t,S.makeArray(n)):r.push(n)),r||[]},dequeue:function(e,t){t=t||"fx";var n=S.queue(e,t),r=n.length,i=n.shift(),o=S._queueHooks(e,t);"inprogress"===i&&(i=n.shift(),r--),i&&("fx"===t&&n.unshift("inprogress"),delete o.stop,i.call(e,function(){S.dequeue(e,t)},o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return Y.get(e,n)||Y.access(e,n,{empty:S.Callbacks("once memory").add(function(){Y.remove(e,[t+"queue",n])})})}}),S.fn.extend({queue:function(t,n){var e=2;return"string"!=typeof t&&(n=t,t="fx",e--),arguments.length<e?S.queue(this[0],t):void 0===n?this:this.each(function(){var e=S.queue(this,t,n);S._queueHooks(this,t),"fx"===t&&"inprogress"!==e[0]&&S.dequeue(this,t)})},dequeue:function(e){return this.each(function(){S.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,r=1,i=S.Deferred(),o=this,a=this.length,s=function(){--r||i.resolveWith(o,[o])};"string"!=typeof e&&(t=e,e=void 0),e=e||"fx";while(a--)(n=Y.get(o[a],e+"queueHooks"))&&n.empty&&(r++,n.empty.add(s));return s(),i.promise(t)}});var ee=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,te=new RegExp("^(?:([+-])=|)("+ee+")([a-z%]*)$","i"),ne=["Top","Right","Bottom","Left"],re=E.documentElement,ie=function(e){return S.contains(e.ownerDocument,e)},oe={composed:!0};re.getRootNode&&(ie=function(e){return S.contains(e.ownerDocument,e)||e.getRootNode(oe)===e.ownerDocument});var ae=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&ie(e)&&"none"===S.css(e,"display")};function se(e,t,n,r){var i,o,a=20,s=r?function(){return r.cur()}:function(){return S.css(e,t,"")},u=s(),l=n&&n[3]||(S.cssNumber[t]?"":"px"),c=e.nodeType&&(S.cssNumber[t]||"px"!==l&&+u)&&te.exec(S.css(e,t));if(c&&c[3]!==l){u/=2,l=l||c[3],c=+u||1;while(a--)S.style(e,t,c+l),(1-o)*(1-(o=s()/u||.5))<=0&&(a=0),c/=o;c*=2,S.style(e,t,c+l),n=n||[]}return n&&(c=+c||+u||0,i=n[1]?c+(n[1]+1)*n[2]:+n[2],r&&(r.unit=l,r.start=c,r.end=i)),i}var ue={};function le(e,t){for(var n,r,i,o,a,s,u,l=[],c=0,f=e.length;c<f;c++)(r=e[c]).style&&(n=r.style.display,t?("none"===n&&(l[c]=Y.get(r,"display")||null,l[c]||(r.style.display="")),""===r.style.display&&ae(r)&&(l[c]=(u=a=o=void 0,a=(i=r).ownerDocument,s=i.nodeName,(u=ue[s])||(o=a.body.appendChild(a.createElement(s)),u=S.css(o,"display"),o.parentNode.removeChild(o),"none"===u&&(u="block"),ue[s]=u)))):"none"!==n&&(l[c]="none",Y.set(r,"display",n)));for(c=0;c<f;c++)null!=l[c]&&(e[c].style.display=l[c]);return e}S.fn.extend({show:function(){return le(this,!0)},hide:function(){return le(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){ae(this)?S(this).show():S(this).hide()})}});var ce,fe,pe=/^(?:checkbox|radio)$/i,de=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i,he=/^$|^module$|\/(?:java|ecma)script/i;ce=E.createDocumentFragment().appendChild(E.createElement("div")),(fe=E.createElement("input")).setAttribute("type","radio"),fe.setAttribute("checked","checked"),fe.setAttribute("name","t"),ce.appendChild(fe),y.checkClone=ce.cloneNode(!0).cloneNode(!0).lastChild.checked,ce.innerHTML="<textarea>x</textarea>",y.noCloneChecked=!!ce.cloneNode(!0).lastChild.defaultValue,ce.innerHTML="<option></option>",y.option=!!ce.lastChild;var ge={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ve(e,t){var n;return n="undefined"!=typeof e.getElementsByTagName?e.getElementsByTagName(t||"*"):"undefined"!=typeof e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&A(e,t)?S.merge([e],n):n}function ye(e,t){for(var n=0,r=e.length;n<r;n++)Y.set(e[n],"globalEval",!t||Y.get(t[n],"globalEval"))}ge.tbody=ge.tfoot=ge.colgroup=ge.caption=ge.thead,ge.th=ge.td,y.option||(ge.optgroup=ge.option=[1,"<select multiple='multiple'>","</select>"]);var me=/<|&#?\w+;/;function xe(e,t,n,r,i){for(var o,a,s,u,l,c,f=t.createDocumentFragment(),p=[],d=0,h=e.length;d<h;d++)if((o=e[d])||0===o)if("object"===w(o))S.merge(p,o.nodeType?[o]:o);else if(me.test(o)){a=a||f.appendChild(t.createElement("div")),s=(de.exec(o)||["",""])[1].toLowerCase(),u=ge[s]||ge._default,a.innerHTML=u[1]+S.htmlPrefilter(o)+u[2],c=u[0];while(c--)a=a.lastChild;S.merge(p,a.childNodes),(a=f.firstChild).textContent=""}else p.push(t.createTextNode(o));f.textContent="",d=0;while(o=p[d++])if(r&&-1<S.inArray(o,r))i&&i.push(o);else if(l=ie(o),a=ve(f.appendChild(o),"script"),l&&ye(a),n){c=0;while(o=a[c++])he.test(o.type||"")&&n.push(o)}return f}var be=/^key/,we=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,Te=/^([^.]*)(?:\.(.+)|)/;function Ce(){return!0}function Ee(){return!1}function Se(e,t){return e===function(){try{return E.activeElement}catch(e){}}()==("focus"===t)}function ke(e,t,n,r,i,o){var a,s;if("object"==typeof t){for(s in"string"!=typeof n&&(r=r||n,n=void 0),t)ke(e,s,n,r,t[s],o);return e}if(null==r&&null==i?(i=n,r=n=void 0):null==i&&("string"==typeof n?(i=r,r=void 0):(i=r,r=n,n=void 0)),!1===i)i=Ee;else if(!i)return e;return 1===o&&(a=i,(i=function(e){return S().off(e),a.apply(this,arguments)}).guid=a.guid||(a.guid=S.guid++)),e.each(function(){S.event.add(this,t,i,r,n)})}function Ae(e,i,o){o?(Y.set(e,i,!1),S.event.add(e,i,{namespace:!1,handler:function(e){var t,n,r=Y.get(this,i);if(1&e.isTrigger&&this[i]){if(r.length)(S.event.special[i]||{}).delegateType&&e.stopPropagation();else if(r=s.call(arguments),Y.set(this,i,r),t=o(this,i),this[i](),r!==(n=Y.get(this,i))||t?Y.set(this,i,!1):n={},r!==n)return e.stopImmediatePropagation(),e.preventDefault(),n.value}else r.length&&(Y.set(this,i,{value:S.event.trigger(S.extend(r[0],S.Event.prototype),r.slice(1),this)}),e.stopImmediatePropagation())}})):void 0===Y.get(e,i)&&S.event.add(e,i,Ce)}S.event={global:{},add:function(t,e,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.get(t);if(V(t)){n.handler&&(n=(o=n).handler,i=o.selector),i&&S.find.matchesSelector(re,i),n.guid||(n.guid=S.guid++),(u=v.events)||(u=v.events=Object.create(null)),(a=v.handle)||(a=v.handle=function(e){return"undefined"!=typeof S&&S.event.triggered!==e.type?S.event.dispatch.apply(t,arguments):void 0}),l=(e=(e||"").match(P)||[""]).length;while(l--)d=g=(s=Te.exec(e[l])||[])[1],h=(s[2]||"").split(".").sort(),d&&(f=S.event.special[d]||{},d=(i?f.delegateType:f.bindType)||d,f=S.event.special[d]||{},c=S.extend({type:d,origType:g,data:r,handler:n,guid:n.guid,selector:i,needsContext:i&&S.expr.match.needsContext.test(i),namespace:h.join(".")},o),(p=u[d])||((p=u[d]=[]).delegateCount=0,f.setup&&!1!==f.setup.call(t,r,h,a)||t.addEventListener&&t.addEventListener(d,a)),f.add&&(f.add.call(t,c),c.handler.guid||(c.handler.guid=n.guid)),i?p.splice(p.delegateCount++,0,c):p.push(c),S.event.global[d]=!0)}},remove:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.hasData(e)&&Y.get(e);if(v&&(u=v.events)){l=(t=(t||"").match(P)||[""]).length;while(l--)if(d=g=(s=Te.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d){f=S.event.special[d]||{},p=u[d=(r?f.delegateType:f.bindType)||d]||[],s=s[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),a=o=p.length;while(o--)c=p[o],!i&&g!==c.origType||n&&n.guid!==c.guid||s&&!s.test(c.namespace)||r&&r!==c.selector&&("**"!==r||!c.selector)||(p.splice(o,1),c.selector&&p.delegateCount--,f.remove&&f.remove.call(e,c));a&&!p.length&&(f.teardown&&!1!==f.teardown.call(e,h,v.handle)||S.removeEvent(e,d,v.handle),delete u[d])}else for(d in u)S.event.remove(e,d+t[l],n,r,!0);S.isEmptyObject(u)&&Y.remove(e,"handle events")}},dispatch:function(e){var t,n,r,i,o,a,s=new Array(arguments.length),u=S.event.fix(e),l=(Y.get(this,"events")||Object.create(null))[u.type]||[],c=S.event.special[u.type]||{};for(s[0]=u,t=1;t<arguments.length;t++)s[t]=arguments[t];if(u.delegateTarget=this,!c.preDispatch||!1!==c.preDispatch.call(this,u)){a=S.event.handlers.call(this,u,l),t=0;while((i=a[t++])&&!u.isPropagationStopped()){u.currentTarget=i.elem,n=0;while((o=i.handlers[n++])&&!u.isImmediatePropagationStopped())u.rnamespace&&!1!==o.namespace&&!u.rnamespace.test(o.namespace)||(u.handleObj=o,u.data=o.data,void 0!==(r=((S.event.special[o.origType]||{}).handle||o.handler).apply(i.elem,s))&&!1===(u.result=r)&&(u.preventDefault(),u.stopPropagation()))}return c.postDispatch&&c.postDispatch.call(this,u),u.result}},handlers:function(e,t){var n,r,i,o,a,s=[],u=t.delegateCount,l=e.target;if(u&&l.nodeType&&!("click"===e.type&&1<=e.button))for(;l!==this;l=l.parentNode||this)if(1===l.nodeType&&("click"!==e.type||!0!==l.disabled)){for(o=[],a={},n=0;n<u;n++)void 0===a[i=(r=t[n]).selector+" "]&&(a[i]=r.needsContext?-1<S(i,this).index(l):S.find(i,this,null,[l]).length),a[i]&&o.push(r);o.length&&s.push({elem:l,handlers:o})}return l=this,u<t.length&&s.push({elem:l,handlers:t.slice(u)}),s},addProp:function(t,e){Object.defineProperty(S.Event.prototype,t,{enumerable:!0,configurable:!0,get:m(e)?function(){if(this.originalEvent)return e(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[t]},set:function(e){Object.defineProperty(this,t,{enumerable:!0,configurable:!0,writable:!0,value:e})}})},fix:function(e){return e[S.expando]?e:new S.Event(e)},special:{load:{noBubble:!0},click:{setup:function(e){var t=this||e;return pe.test(t.type)&&t.click&&A(t,"input")&&Ae(t,"click",Ce),!1},trigger:function(e){var t=this||e;return pe.test(t.type)&&t.click&&A(t,"input")&&Ae(t,"click"),!0},_default:function(e){var t=e.target;return pe.test(t.type)&&t.click&&A(t,"input")&&Y.get(t,"click")||A(t,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},S.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},S.Event=function(e,t){if(!(this instanceof S.Event))return new S.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?Ce:Ee,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&S.extend(this,t),this.timeStamp=e&&e.timeStamp||Date.now(),this[S.expando]=!0},S.Event.prototype={constructor:S.Event,isDefaultPrevented:Ee,isPropagationStopped:Ee,isImmediatePropagationStopped:Ee,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=Ce,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=Ce,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=Ce,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},S.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,"char":!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(e){var t=e.button;return null==e.which&&be.test(e.type)?null!=e.charCode?e.charCode:e.keyCode:!e.which&&void 0!==t&&we.test(e.type)?1&t?1:2&t?3:4&t?2:0:e.which}},S.event.addProp),S.each({focus:"focusin",blur:"focusout"},function(e,t){S.event.special[e]={setup:function(){return Ae(this,e,Se),!1},trigger:function(){return Ae(this,e),!0},delegateType:t}}),S.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,i){S.event.special[e]={delegateType:i,bindType:i,handle:function(e){var t,n=e.relatedTarget,r=e.handleObj;return n&&(n===this||S.contains(this,n))||(e.type=r.origType,t=r.handler.apply(this,arguments),e.type=i),t}}}),S.fn.extend({on:function(e,t,n,r){return ke(this,e,t,n,r)},one:function(e,t,n,r){return ke(this,e,t,n,r,1)},off:function(e,t,n){var r,i;if(e&&e.preventDefault&&e.handleObj)return r=e.handleObj,S(e.delegateTarget).off(r.namespace?r.origType+"."+r.namespace:r.origType,r.selector,r.handler),this;if("object"==typeof e){for(i in e)this.off(i,t,e[i]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=Ee),this.each(function(){S.event.remove(this,e,n,t)})}});var Ne=/<script|<style|<link/i,De=/checked\s*(?:[^=]|=\s*.checked.)/i,je=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function qe(e,t){return A(e,"table")&&A(11!==t.nodeType?t:t.firstChild,"tr")&&S(e).children("tbody")[0]||e}function Le(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function He(e){return"true/"===(e.type||"").slice(0,5)?e.type=e.type.slice(5):e.removeAttribute("type"),e}function Oe(e,t){var n,r,i,o,a,s;if(1===t.nodeType){if(Y.hasData(e)&&(s=Y.get(e).events))for(i in Y.remove(t,"handle events"),s)for(n=0,r=s[i].length;n<r;n++)S.event.add(t,i,s[i][n]);Q.hasData(e)&&(o=Q.access(e),a=S.extend({},o),Q.set(t,a))}}function Pe(n,r,i,o){r=g(r);var e,t,a,s,u,l,c=0,f=n.length,p=f-1,d=r[0],h=m(d);if(h||1<f&&"string"==typeof d&&!y.checkClone&&De.test(d))return n.each(function(e){var t=n.eq(e);h&&(r[0]=d.call(this,e,t.html())),Pe(t,r,i,o)});if(f&&(t=(e=xe(r,n[0].ownerDocument,!1,n,o)).firstChild,1===e.childNodes.length&&(e=t),t||o)){for(s=(a=S.map(ve(e,"script"),Le)).length;c<f;c++)u=e,c!==p&&(u=S.clone(u,!0,!0),s&&S.merge(a,ve(u,"script"))),i.call(n[c],u,c);if(s)for(l=a[a.length-1].ownerDocument,S.map(a,He),c=0;c<s;c++)u=a[c],he.test(u.type||"")&&!Y.access(u,"globalEval")&&S.contains(l,u)&&(u.src&&"module"!==(u.type||"").toLowerCase()?S._evalUrl&&!u.noModule&&S._evalUrl(u.src,{nonce:u.nonce||u.getAttribute("nonce")},l):b(u.textContent.replace(je,""),u,l))}return n}function Re(e,t,n){for(var r,i=t?S.filter(t,e):e,o=0;null!=(r=i[o]);o++)n||1!==r.nodeType||S.cleanData(ve(r)),r.parentNode&&(n&&ie(r)&&ye(ve(r,"script")),r.parentNode.removeChild(r));return e}S.extend({htmlPrefilter:function(e){return e},clone:function(e,t,n){var r,i,o,a,s,u,l,c=e.cloneNode(!0),f=ie(e);if(!(y.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||S.isXMLDoc(e)))for(a=ve(c),r=0,i=(o=ve(e)).length;r<i;r++)s=o[r],u=a[r],void 0,"input"===(l=u.nodeName.toLowerCase())&&pe.test(s.type)?u.checked=s.checked:"input"!==l&&"textarea"!==l||(u.defaultValue=s.defaultValue);if(t)if(n)for(o=o||ve(e),a=a||ve(c),r=0,i=o.length;r<i;r++)Oe(o[r],a[r]);else Oe(e,c);return 0<(a=ve(c,"script")).length&&ye(a,!f&&ve(e,"script")),c},cleanData:function(e){for(var t,n,r,i=S.event.special,o=0;void 0!==(n=e[o]);o++)if(V(n)){if(t=n[Y.expando]){if(t.events)for(r in t.events)i[r]?S.event.remove(n,r):S.removeEvent(n,r,t.handle);n[Y.expando]=void 0}n[Q.expando]&&(n[Q.expando]=void 0)}}}),S.fn.extend({detach:function(e){return Re(this,e,!0)},remove:function(e){return Re(this,e)},text:function(e){return $(this,function(e){return void 0===e?S.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)})},null,e,arguments.length)},append:function(){return Pe(this,arguments,function(e){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||qe(this,e).appendChild(e)})},prepend:function(){return Pe(this,arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=qe(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return Pe(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return Pe(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(S.cleanData(ve(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map(function(){return S.clone(this,e,t)})},html:function(e){return $(this,function(e){var t=this[0]||{},n=0,r=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!Ne.test(e)&&!ge[(de.exec(e)||["",""])[1].toLowerCase()]){e=S.htmlPrefilter(e);try{for(;n<r;n++)1===(t=this[n]||{}).nodeType&&(S.cleanData(ve(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var n=[];return Pe(this,arguments,function(e){var t=this.parentNode;S.inArray(this,n)<0&&(S.cleanData(ve(this)),t&&t.replaceChild(e,this))},n)}}),S.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,a){S.fn[e]=function(e){for(var t,n=[],r=S(e),i=r.length-1,o=0;o<=i;o++)t=o===i?this:this.clone(!0),S(r[o])[a](t),u.apply(n,t.get());return this.pushStack(n)}});var Me=new RegExp("^("+ee+")(?!px)[a-z%]+$","i"),Ie=function(e){var t=e.ownerDocument.defaultView;return t&&t.opener||(t=C),t.getComputedStyle(e)},We=function(e,t,n){var r,i,o={};for(i in t)o[i]=e.style[i],e.style[i]=t[i];for(i in r=n.call(e),t)e.style[i]=o[i];return r},Fe=new RegExp(ne.join("|"),"i");function Be(e,t,n){var r,i,o,a,s=e.style;return(n=n||Ie(e))&&(""!==(a=n.getPropertyValue(t)||n[t])||ie(e)||(a=S.style(e,t)),!y.pixelBoxStyles()&&Me.test(a)&&Fe.test(t)&&(r=s.width,i=s.minWidth,o=s.maxWidth,s.minWidth=s.maxWidth=s.width=a,a=n.width,s.width=r,s.minWidth=i,s.maxWidth=o)),void 0!==a?a+"":a}function $e(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function e(){if(l){u.style.cssText="position:absolute;left:-11111px;width:60px;margin-top:1px;padding:0;border:0",l.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;margin:auto;border:1px;padding:1px;width:60%;top:1%",re.appendChild(u).appendChild(l);var e=C.getComputedStyle(l);n="1%"!==e.top,s=12===t(e.marginLeft),l.style.right="60%",o=36===t(e.right),r=36===t(e.width),l.style.position="absolute",i=12===t(l.offsetWidth/3),re.removeChild(u),l=null}}function t(e){return Math.round(parseFloat(e))}var n,r,i,o,a,s,u=E.createElement("div"),l=E.createElement("div");l.style&&(l.style.backgroundClip="content-box",l.cloneNode(!0).style.backgroundClip="",y.clearCloneStyle="content-box"===l.style.backgroundClip,S.extend(y,{boxSizingReliable:function(){return e(),r},pixelBoxStyles:function(){return e(),o},pixelPosition:function(){return e(),n},reliableMarginLeft:function(){return e(),s},scrollboxSize:function(){return e(),i},reliableTrDimensions:function(){var e,t,n,r;return null==a&&(e=E.createElement("table"),t=E.createElement("tr"),n=E.createElement("div"),e.style.cssText="position:absolute;left:-11111px",t.style.height="1px",n.style.height="9px",re.appendChild(e).appendChild(t).appendChild(n),r=C.getComputedStyle(t),a=3<parseInt(r.height),re.removeChild(e)),a}}))}();var _e=["Webkit","Moz","ms"],ze=E.createElement("div").style,Ue={};function Xe(e){var t=S.cssProps[e]||Ue[e];return t||(e in ze?e:Ue[e]=function(e){var t=e[0].toUpperCase()+e.slice(1),n=_e.length;while(n--)if((e=_e[n]+t)in ze)return e}(e)||e)}var Ve=/^(none|table(?!-c[ea]).+)/,Ge=/^--/,Ye={position:"absolute",visibility:"hidden",display:"block"},Qe={letterSpacing:"0",fontWeight:"400"};function Je(e,t,n){var r=te.exec(t);return r?Math.max(0,r[2]-(n||0))+(r[3]||"px"):t}function Ke(e,t,n,r,i,o){var a="width"===t?1:0,s=0,u=0;if(n===(r?"border":"content"))return 0;for(;a<4;a+=2)"margin"===n&&(u+=S.css(e,n+ne[a],!0,i)),r?("content"===n&&(u-=S.css(e,"padding"+ne[a],!0,i)),"margin"!==n&&(u-=S.css(e,"border"+ne[a]+"Width",!0,i))):(u+=S.css(e,"padding"+ne[a],!0,i),"padding"!==n?u+=S.css(e,"border"+ne[a]+"Width",!0,i):s+=S.css(e,"border"+ne[a]+"Width",!0,i));return!r&&0<=o&&(u+=Math.max(0,Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-o-u-s-.5))||0),u}function Ze(e,t,n){var r=Ie(e),i=(!y.boxSizingReliable()||n)&&"border-box"===S.css(e,"boxSizing",!1,r),o=i,a=Be(e,t,r),s="offset"+t[0].toUpperCase()+t.slice(1);if(Me.test(a)){if(!n)return a;a="auto"}return(!y.boxSizingReliable()&&i||!y.reliableTrDimensions()&&A(e,"tr")||"auto"===a||!parseFloat(a)&&"inline"===S.css(e,"display",!1,r))&&e.getClientRects().length&&(i="border-box"===S.css(e,"boxSizing",!1,r),(o=s in e)&&(a=e[s])),(a=parseFloat(a)||0)+Ke(e,t,n||(i?"border":"content"),o,r,a)+"px"}function et(e,t,n,r,i){return new et.prototype.init(e,t,n,r,i)}S.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Be(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{},style:function(e,t,n,r){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var i,o,a,s=X(t),u=Ge.test(t),l=e.style;if(u||(t=Xe(s)),a=S.cssHooks[t]||S.cssHooks[s],void 0===n)return a&&"get"in a&&void 0!==(i=a.get(e,!1,r))?i:l[t];"string"===(o=typeof n)&&(i=te.exec(n))&&i[1]&&(n=se(e,t,i),o="number"),null!=n&&n==n&&("number"!==o||u||(n+=i&&i[3]||(S.cssNumber[s]?"":"px")),y.clearCloneStyle||""!==n||0!==t.indexOf("background")||(l[t]="inherit"),a&&"set"in a&&void 0===(n=a.set(e,n,r))||(u?l.setProperty(t,n):l[t]=n))}},css:function(e,t,n,r){var i,o,a,s=X(t);return Ge.test(t)||(t=Xe(s)),(a=S.cssHooks[t]||S.cssHooks[s])&&"get"in a&&(i=a.get(e,!0,n)),void 0===i&&(i=Be(e,t,r)),"normal"===i&&t in Qe&&(i=Qe[t]),""===n||n?(o=parseFloat(i),!0===n||isFinite(o)?o||0:i):i}}),S.each(["height","width"],function(e,u){S.cssHooks[u]={get:function(e,t,n){if(t)return!Ve.test(S.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?Ze(e,u,n):We(e,Ye,function(){return Ze(e,u,n)})},set:function(e,t,n){var r,i=Ie(e),o=!y.scrollboxSize()&&"absolute"===i.position,a=(o||n)&&"border-box"===S.css(e,"boxSizing",!1,i),s=n?Ke(e,u,n,a,i):0;return a&&o&&(s-=Math.ceil(e["offset"+u[0].toUpperCase()+u.slice(1)]-parseFloat(i[u])-Ke(e,u,"border",!1,i)-.5)),s&&(r=te.exec(t))&&"px"!==(r[3]||"px")&&(e.style[u]=t,t=S.css(e,u)),Je(0,t,s)}}}),S.cssHooks.marginLeft=$e(y.reliableMarginLeft,function(e,t){if(t)return(parseFloat(Be(e,"marginLeft"))||e.getBoundingClientRect().left-We(e,{marginLeft:0},function(){return e.getBoundingClientRect().left}))+"px"}),S.each({margin:"",padding:"",border:"Width"},function(i,o){S.cssHooks[i+o]={expand:function(e){for(var t=0,n={},r="string"==typeof e?e.split(" "):[e];t<4;t++)n[i+ne[t]+o]=r[t]||r[t-2]||r[0];return n}},"margin"!==i&&(S.cssHooks[i+o].set=Je)}),S.fn.extend({css:function(e,t){return $(this,function(e,t,n){var r,i,o={},a=0;if(Array.isArray(t)){for(r=Ie(e),i=t.length;a<i;a++)o[t[a]]=S.css(e,t[a],!1,r);return o}return void 0!==n?S.style(e,t,n):S.css(e,t)},e,t,1<arguments.length)}}),((S.Tween=et).prototype={constructor:et,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||S.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(S.cssNumber[n]?"":"px")},cur:function(){var e=et.propHooks[this.prop];return e&&e.get?e.get(this):et.propHooks._default.get(this)},run:function(e){var t,n=et.propHooks[this.prop];return this.options.duration?this.pos=t=S.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):et.propHooks._default.set(this),this}}).init.prototype=et.prototype,(et.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=S.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){S.fx.step[e.prop]?S.fx.step[e.prop](e):1!==e.elem.nodeType||!S.cssHooks[e.prop]&&null==e.elem.style[Xe(e.prop)]?e.elem[e.prop]=e.now:S.style(e.elem,e.prop,e.now+e.unit)}}}).scrollTop=et.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},S.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},S.fx=et.prototype.init,S.fx.step={};var tt,nt,rt,it,ot=/^(?:toggle|show|hide)$/,at=/queueHooks$/;function st(){nt&&(!1===E.hidden&&C.requestAnimationFrame?C.requestAnimationFrame(st):C.setTimeout(st,S.fx.interval),S.fx.tick())}function ut(){return C.setTimeout(function(){tt=void 0}),tt=Date.now()}function lt(e,t){var n,r=0,i={height:e};for(t=t?1:0;r<4;r+=2-t)i["margin"+(n=ne[r])]=i["padding"+n]=e;return t&&(i.opacity=i.width=e),i}function ct(e,t,n){for(var r,i=(ft.tweeners[t]||[]).concat(ft.tweeners["*"]),o=0,a=i.length;o<a;o++)if(r=i[o].call(n,t,e))return r}function ft(o,e,t){var n,a,r=0,i=ft.prefilters.length,s=S.Deferred().always(function(){delete u.elem}),u=function(){if(a)return!1;for(var e=tt||ut(),t=Math.max(0,l.startTime+l.duration-e),n=1-(t/l.duration||0),r=0,i=l.tweens.length;r<i;r++)l.tweens[r].run(n);return s.notifyWith(o,[l,n,t]),n<1&&i?t:(i||s.notifyWith(o,[l,1,0]),s.resolveWith(o,[l]),!1)},l=s.promise({elem:o,props:S.extend({},e),opts:S.extend(!0,{specialEasing:{},easing:S.easing._default},t),originalProperties:e,originalOptions:t,startTime:tt||ut(),duration:t.duration,tweens:[],createTween:function(e,t){var n=S.Tween(o,l.opts,e,t,l.opts.specialEasing[e]||l.opts.easing);return l.tweens.push(n),n},stop:function(e){var t=0,n=e?l.tweens.length:0;if(a)return this;for(a=!0;t<n;t++)l.tweens[t].run(1);return e?(s.notifyWith(o,[l,1,0]),s.resolveWith(o,[l,e])):s.rejectWith(o,[l,e]),this}}),c=l.props;for(!function(e,t){var n,r,i,o,a;for(n in e)if(i=t[r=X(n)],o=e[n],Array.isArray(o)&&(i=o[1],o=e[n]=o[0]),n!==r&&(e[r]=o,delete e[n]),(a=S.cssHooks[r])&&"expand"in a)for(n in o=a.expand(o),delete e[r],o)n in e||(e[n]=o[n],t[n]=i);else t[r]=i}(c,l.opts.specialEasing);r<i;r++)if(n=ft.prefilters[r].call(l,o,c,l.opts))return m(n.stop)&&(S._queueHooks(l.elem,l.opts.queue).stop=n.stop.bind(n)),n;return S.map(c,ct,l),m(l.opts.start)&&l.opts.start.call(o,l),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always),S.fx.timer(S.extend(u,{elem:o,anim:l,queue:l.opts.queue})),l}S.Animation=S.extend(ft,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return se(n.elem,e,te.exec(t),n),n}]},tweener:function(e,t){m(e)?(t=e,e=["*"]):e=e.match(P);for(var n,r=0,i=e.length;r<i;r++)n=e[r],ft.tweeners[n]=ft.tweeners[n]||[],ft.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var r,i,o,a,s,u,l,c,f="width"in t||"height"in t,p=this,d={},h=e.style,g=e.nodeType&&ae(e),v=Y.get(e,"fxshow");for(r in n.queue||(null==(a=S._queueHooks(e,"fx")).unqueued&&(a.unqueued=0,s=a.empty.fire,a.empty.fire=function(){a.unqueued||s()}),a.unqueued++,p.always(function(){p.always(function(){a.unqueued--,S.queue(e,"fx").length||a.empty.fire()})})),t)if(i=t[r],ot.test(i)){if(delete t[r],o=o||"toggle"===i,i===(g?"hide":"show")){if("show"!==i||!v||void 0===v[r])continue;g=!0}d[r]=v&&v[r]||S.style(e,r)}if((u=!S.isEmptyObject(t))||!S.isEmptyObject(d))for(r in f&&1===e.nodeType&&(n.overflow=[h.overflow,h.overflowX,h.overflowY],null==(l=v&&v.display)&&(l=Y.get(e,"display")),"none"===(c=S.css(e,"display"))&&(l?c=l:(le([e],!0),l=e.style.display||l,c=S.css(e,"display"),le([e]))),("inline"===c||"inline-block"===c&&null!=l)&&"none"===S.css(e,"float")&&(u||(p.done(function(){h.display=l}),null==l&&(c=h.display,l="none"===c?"":c)),h.display="inline-block")),n.overflow&&(h.overflow="hidden",p.always(function(){h.overflow=n.overflow[0],h.overflowX=n.overflow[1],h.overflowY=n.overflow[2]})),u=!1,d)u||(v?"hidden"in v&&(g=v.hidden):v=Y.access(e,"fxshow",{display:l}),o&&(v.hidden=!g),g&&le([e],!0),p.done(function(){for(r in g||le([e]),Y.remove(e,"fxshow"),d)S.style(e,r,d[r])})),u=ct(g?v[r]:0,r,p),r in v||(v[r]=u.start,g&&(u.end=u.start,u.start=0))}],prefilter:function(e,t){t?ft.prefilters.unshift(e):ft.prefilters.push(e)}}),S.speed=function(e,t,n){var r=e&&"object"==typeof e?S.extend({},e):{complete:n||!n&&t||m(e)&&e,duration:e,easing:n&&t||t&&!m(t)&&t};return S.fx.off?r.duration=0:"number"!=typeof r.duration&&(r.duration in S.fx.speeds?r.duration=S.fx.speeds[r.duration]:r.duration=S.fx.speeds._default),null!=r.queue&&!0!==r.queue||(r.queue="fx"),r.old=r.complete,r.complete=function(){m(r.old)&&r.old.call(this),r.queue&&S.dequeue(this,r.queue)},r},S.fn.extend({fadeTo:function(e,t,n,r){return this.filter(ae).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(t,e,n,r){var i=S.isEmptyObject(t),o=S.speed(e,n,r),a=function(){var e=ft(this,S.extend({},t),o);(i||Y.get(this,"finish"))&&e.stop(!0)};return a.finish=a,i||!1===o.queue?this.each(a):this.queue(o.queue,a)},stop:function(i,e,o){var a=function(e){var t=e.stop;delete e.stop,t(o)};return"string"!=typeof i&&(o=e,e=i,i=void 0),e&&this.queue(i||"fx",[]),this.each(function(){var e=!0,t=null!=i&&i+"queueHooks",n=S.timers,r=Y.get(this);if(t)r[t]&&r[t].stop&&a(r[t]);else for(t in r)r[t]&&r[t].stop&&at.test(t)&&a(r[t]);for(t=n.length;t--;)n[t].elem!==this||null!=i&&n[t].queue!==i||(n[t].anim.stop(o),e=!1,n.splice(t,1));!e&&o||S.dequeue(this,i)})},finish:function(a){return!1!==a&&(a=a||"fx"),this.each(function(){var e,t=Y.get(this),n=t[a+"queue"],r=t[a+"queueHooks"],i=S.timers,o=n?n.length:0;for(t.finish=!0,S.queue(this,a,[]),r&&r.stop&&r.stop.call(this,!0),e=i.length;e--;)i[e].elem===this&&i[e].queue===a&&(i[e].anim.stop(!0),i.splice(e,1));for(e=0;e<o;e++)n[e]&&n[e].finish&&n[e].finish.call(this);delete t.finish})}}),S.each(["toggle","show","hide"],function(e,r){var i=S.fn[r];S.fn[r]=function(e,t,n){return null==e||"boolean"==typeof e?i.apply(this,arguments):this.animate(lt(r,!0),e,t,n)}}),S.each({slideDown:lt("show"),slideUp:lt("hide"),slideToggle:lt("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,r){S.fn[e]=function(e,t,n){return this.animate(r,e,t,n)}}),S.timers=[],S.fx.tick=function(){var e,t=0,n=S.timers;for(tt=Date.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||S.fx.stop(),tt=void 0},S.fx.timer=function(e){S.timers.push(e),S.fx.start()},S.fx.interval=13,S.fx.start=function(){nt||(nt=!0,st())},S.fx.stop=function(){nt=null},S.fx.speeds={slow:600,fast:200,_default:400},S.fn.delay=function(r,e){return r=S.fx&&S.fx.speeds[r]||r,e=e||"fx",this.queue(e,function(e,t){var n=C.setTimeout(e,r);t.stop=function(){C.clearTimeout(n)}})},rt=E.createElement("input"),it=E.createElement("select").appendChild(E.createElement("option")),rt.type="checkbox",y.checkOn=""!==rt.value,y.optSelected=it.selected,(rt=E.createElement("input")).value="t",rt.type="radio",y.radioValue="t"===rt.value;var pt,dt=S.expr.attrHandle;S.fn.extend({attr:function(e,t){return $(this,S.attr,e,t,1<arguments.length)},removeAttr:function(e){return this.each(function(){S.removeAttr(this,e)})}}),S.extend({attr:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return"undefined"==typeof e.getAttribute?S.prop(e,t,n):(1===o&&S.isXMLDoc(e)||(i=S.attrHooks[t.toLowerCase()]||(S.expr.match.bool.test(t)?pt:void 0)),void 0!==n?null===n?void S.removeAttr(e,t):i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:(e.setAttribute(t,n+""),n):i&&"get"in i&&null!==(r=i.get(e,t))?r:null==(r=S.find.attr(e,t))?void 0:r)},attrHooks:{type:{set:function(e,t){if(!y.radioValue&&"radio"===t&&A(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,r=0,i=t&&t.match(P);if(i&&1===e.nodeType)while(n=i[r++])e.removeAttribute(n)}}),pt={set:function(e,t,n){return!1===t?S.removeAttr(e,n):e.setAttribute(n,n),n}},S.each(S.expr.match.bool.source.match(/\w+/g),function(e,t){var a=dt[t]||S.find.attr;dt[t]=function(e,t,n){var r,i,o=t.toLowerCase();return n||(i=dt[o],dt[o]=r,r=null!=a(e,t,n)?o:null,dt[o]=i),r}});var ht=/^(?:input|select|textarea|button)$/i,gt=/^(?:a|area)$/i;function vt(e){return(e.match(P)||[]).join(" ")}function yt(e){return e.getAttribute&&e.getAttribute("class")||""}function mt(e){return Array.isArray(e)?e:"string"==typeof e&&e.match(P)||[]}S.fn.extend({prop:function(e,t){return $(this,S.prop,e,t,1<arguments.length)},removeProp:function(e){return this.each(function(){delete this[S.propFix[e]||e]})}}),S.extend({prop:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return 1===o&&S.isXMLDoc(e)||(t=S.propFix[t]||t,i=S.propHooks[t]),void 0!==n?i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:e[t]=n:i&&"get"in i&&null!==(r=i.get(e,t))?r:e[t]},propHooks:{tabIndex:{get:function(e){var t=S.find.attr(e,"tabindex");return t?parseInt(t,10):ht.test(e.nodeName)||gt.test(e.nodeName)&&e.href?0:-1}}},propFix:{"for":"htmlFor","class":"className"}}),y.optSelected||(S.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),S.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){S.propFix[this.toLowerCase()]=this}),S.fn.extend({addClass:function(t){var e,n,r,i,o,a,s,u=0;if(m(t))return this.each(function(e){S(this).addClass(t.call(this,e,yt(this)))});if((e=mt(t)).length)while(n=this[u++])if(i=yt(n),r=1===n.nodeType&&" "+vt(i)+" "){a=0;while(o=e[a++])r.indexOf(" "+o+" ")<0&&(r+=o+" ");i!==(s=vt(r))&&n.setAttribute("class",s)}return this},removeClass:function(t){var e,n,r,i,o,a,s,u=0;if(m(t))return this.each(function(e){S(this).removeClass(t.call(this,e,yt(this)))});if(!arguments.length)return this.attr("class","");if((e=mt(t)).length)while(n=this[u++])if(i=yt(n),r=1===n.nodeType&&" "+vt(i)+" "){a=0;while(o=e[a++])while(-1<r.indexOf(" "+o+" "))r=r.replace(" "+o+" "," ");i!==(s=vt(r))&&n.setAttribute("class",s)}return this},toggleClass:function(i,t){var o=typeof i,a="string"===o||Array.isArray(i);return"boolean"==typeof t&&a?t?this.addClass(i):this.removeClass(i):m(i)?this.each(function(e){S(this).toggleClass(i.call(this,e,yt(this),t),t)}):this.each(function(){var e,t,n,r;if(a){t=0,n=S(this),r=mt(i);while(e=r[t++])n.hasClass(e)?n.removeClass(e):n.addClass(e)}else void 0!==i&&"boolean"!==o||((e=yt(this))&&Y.set(this,"__className__",e),this.setAttribute&&this.setAttribute("class",e||!1===i?"":Y.get(this,"__className__")||""))})},hasClass:function(e){var t,n,r=0;t=" "+e+" ";while(n=this[r++])if(1===n.nodeType&&-1<(" "+vt(yt(n))+" ").indexOf(t))return!0;return!1}});var xt=/\r/g;S.fn.extend({val:function(n){var r,e,i,t=this[0];return arguments.length?(i=m(n),this.each(function(e){var t;1===this.nodeType&&(null==(t=i?n.call(this,e,S(this).val()):n)?t="":"number"==typeof t?t+="":Array.isArray(t)&&(t=S.map(t,function(e){return null==e?"":e+""})),(r=S.valHooks[this.type]||S.valHooks[this.nodeName.toLowerCase()])&&"set"in r&&void 0!==r.set(this,t,"value")||(this.value=t))})):t?(r=S.valHooks[t.type]||S.valHooks[t.nodeName.toLowerCase()])&&"get"in r&&void 0!==(e=r.get(t,"value"))?e:"string"==typeof(e=t.value)?e.replace(xt,""):null==e?"":e:void 0}}),S.extend({valHooks:{option:{get:function(e){var t=S.find.attr(e,"value");return null!=t?t:vt(S.text(e))}},select:{get:function(e){var t,n,r,i=e.options,o=e.selectedIndex,a="select-one"===e.type,s=a?null:[],u=a?o+1:i.length;for(r=o<0?u:a?o:0;r<u;r++)if(((n=i[r]).selected||r===o)&&!n.disabled&&(!n.parentNode.disabled||!A(n.parentNode,"optgroup"))){if(t=S(n).val(),a)return t;s.push(t)}return s},set:function(e,t){var n,r,i=e.options,o=S.makeArray(t),a=i.length;while(a--)((r=i[a]).selected=-1<S.inArray(S.valHooks.option.get(r),o))&&(n=!0);return n||(e.selectedIndex=-1),o}}}}),S.each(["radio","checkbox"],function(){S.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=-1<S.inArray(S(e).val(),t)}},y.checkOn||(S.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})}),y.focusin="onfocusin"in C;var bt=/^(?:focusinfocus|focusoutblur)$/,wt=function(e){e.stopPropagation()};S.extend(S.event,{trigger:function(e,t,n,r){var i,o,a,s,u,l,c,f,p=[n||E],d=v.call(e,"type")?e.type:e,h=v.call(e,"namespace")?e.namespace.split("."):[];if(o=f=a=n=n||E,3!==n.nodeType&&8!==n.nodeType&&!bt.test(d+S.event.triggered)&&(-1<d.indexOf(".")&&(d=(h=d.split(".")).shift(),h.sort()),u=d.indexOf(":")<0&&"on"+d,(e=e[S.expando]?e:new S.Event(d,"object"==typeof e&&e)).isTrigger=r?2:3,e.namespace=h.join("."),e.rnamespace=e.namespace?new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,e.result=void 0,e.target||(e.target=n),t=null==t?[e]:S.makeArray(t,[e]),c=S.event.special[d]||{},r||!c.trigger||!1!==c.trigger.apply(n,t))){if(!r&&!c.noBubble&&!x(n)){for(s=c.delegateType||d,bt.test(s+d)||(o=o.parentNode);o;o=o.parentNode)p.push(o),a=o;a===(n.ownerDocument||E)&&p.push(a.defaultView||a.parentWindow||C)}i=0;while((o=p[i++])&&!e.isPropagationStopped())f=o,e.type=1<i?s:c.bindType||d,(l=(Y.get(o,"events")||Object.create(null))[e.type]&&Y.get(o,"handle"))&&l.apply(o,t),(l=u&&o[u])&&l.apply&&V(o)&&(e.result=l.apply(o,t),!1===e.result&&e.preventDefault());return e.type=d,r||e.isDefaultPrevented()||c._default&&!1!==c._default.apply(p.pop(),t)||!V(n)||u&&m(n[d])&&!x(n)&&((a=n[u])&&(n[u]=null),S.event.triggered=d,e.isPropagationStopped()&&f.addEventListener(d,wt),n[d](),e.isPropagationStopped()&&f.removeEventListener(d,wt),S.event.triggered=void 0,a&&(n[u]=a)),e.result}},simulate:function(e,t,n){var r=S.extend(new S.Event,n,{type:e,isSimulated:!0});S.event.trigger(r,null,t)}}),S.fn.extend({trigger:function(e,t){return this.each(function(){S.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];if(n)return S.event.trigger(e,t,n,!0)}}),y.focusin||S.each({focus:"focusin",blur:"focusout"},function(n,r){var i=function(e){S.event.simulate(r,e.target,S.event.fix(e))};S.event.special[r]={setup:function(){var e=this.ownerDocument||this.document||this,t=Y.access(e,r);t||e.addEventListener(n,i,!0),Y.access(e,r,(t||0)+1)},teardown:function(){var e=this.ownerDocument||this.document||this,t=Y.access(e,r)-1;t?Y.access(e,r,t):(e.removeEventListener(n,i,!0),Y.remove(e,r))}}});var Tt=C.location,Ct={guid:Date.now()},Et=/\?/;S.parseXML=function(e){var t;if(!e||"string"!=typeof e)return null;try{t=(new C.DOMParser).parseFromString(e,"text/xml")}catch(e){t=void 0}return t&&!t.getElementsByTagName("parsererror").length||S.error("Invalid XML: "+e),t};var St=/\[\]$/,kt=/\r?\n/g,At=/^(?:submit|button|image|reset|file)$/i,Nt=/^(?:input|select|textarea|keygen)/i;function Dt(n,e,r,i){var t;if(Array.isArray(e))S.each(e,function(e,t){r||St.test(n)?i(n,t):Dt(n+"["+("object"==typeof t&&null!=t?e:"")+"]",t,r,i)});else if(r||"object"!==w(e))i(n,e);else for(t in e)Dt(n+"["+t+"]",e[t],r,i)}S.param=function(e,t){var n,r=[],i=function(e,t){var n=m(t)?t():t;r[r.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(null==e)return"";if(Array.isArray(e)||e.jquery&&!S.isPlainObject(e))S.each(e,function(){i(this.name,this.value)});else for(n in e)Dt(n,e[n],t,i);return r.join("&")},S.fn.extend({serialize:function(){return S.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=S.prop(this,"elements");return e?S.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!S(this).is(":disabled")&&Nt.test(this.nodeName)&&!At.test(e)&&(this.checked||!pe.test(e))}).map(function(e,t){var n=S(this).val();return null==n?null:Array.isArray(n)?S.map(n,function(e){return{name:t.name,value:e.replace(kt,"\r\n")}}):{name:t.name,value:n.replace(kt,"\r\n")}}).get()}});var jt=/%20/g,qt=/#.*$/,Lt=/([?&])_=[^&]*/,Ht=/^(.*?):[ \t]*([^\r\n]*)$/gm,Ot=/^(?:GET|HEAD)$/,Pt=/^\/\//,Rt={},Mt={},It="*/".concat("*"),Wt=E.createElement("a");function Ft(o){return function(e,t){"string"!=typeof e&&(t=e,e="*");var n,r=0,i=e.toLowerCase().match(P)||[];if(m(t))while(n=i[r++])"+"===n[0]?(n=n.slice(1)||"*",(o[n]=o[n]||[]).unshift(t)):(o[n]=o[n]||[]).push(t)}}function Bt(t,i,o,a){var s={},u=t===Mt;function l(e){var r;return s[e]=!0,S.each(t[e]||[],function(e,t){var n=t(i,o,a);return"string"!=typeof n||u||s[n]?u?!(r=n):void 0:(i.dataTypes.unshift(n),l(n),!1)}),r}return l(i.dataTypes[0])||!s["*"]&&l("*")}function $t(e,t){var n,r,i=S.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((i[n]?e:r||(r={}))[n]=t[n]);return r&&S.extend(!0,e,r),e}Wt.href=Tt.href,S.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:Tt.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(Tt.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":It,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":S.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?$t($t(e,S.ajaxSettings),t):$t(S.ajaxSettings,e)},ajaxPrefilter:Ft(Rt),ajaxTransport:Ft(Mt),ajax:function(e,t){"object"==typeof e&&(t=e,e=void 0),t=t||{};var c,f,p,n,d,r,h,g,i,o,v=S.ajaxSetup({},t),y=v.context||v,m=v.context&&(y.nodeType||y.jquery)?S(y):S.event,x=S.Deferred(),b=S.Callbacks("once memory"),w=v.statusCode||{},a={},s={},u="canceled",T={readyState:0,getResponseHeader:function(e){var t;if(h){if(!n){n={};while(t=Ht.exec(p))n[t[1].toLowerCase()+" "]=(n[t[1].toLowerCase()+" "]||[]).concat(t[2])}t=n[e.toLowerCase()+" "]}return null==t?null:t.join(", ")},getAllResponseHeaders:function(){return h?p:null},setRequestHeader:function(e,t){return null==h&&(e=s[e.toLowerCase()]=s[e.toLowerCase()]||e,a[e]=t),this},overrideMimeType:function(e){return null==h&&(v.mimeType=e),this},statusCode:function(e){var t;if(e)if(h)T.always(e[T.status]);else for(t in e)w[t]=[w[t],e[t]];return this},abort:function(e){var t=e||u;return c&&c.abort(t),l(0,t),this}};if(x.promise(T),v.url=((e||v.url||Tt.href)+"").replace(Pt,Tt.protocol+"//"),v.type=t.method||t.type||v.method||v.type,v.dataTypes=(v.dataType||"*").toLowerCase().match(P)||[""],null==v.crossDomain){r=E.createElement("a");try{r.href=v.url,r.href=r.href,v.crossDomain=Wt.protocol+"//"+Wt.host!=r.protocol+"//"+r.host}catch(e){v.crossDomain=!0}}if(v.data&&v.processData&&"string"!=typeof v.data&&(v.data=S.param(v.data,v.traditional)),Bt(Rt,v,t,T),h)return T;for(i in(g=S.event&&v.global)&&0==S.active++&&S.event.trigger("ajaxStart"),v.type=v.type.toUpperCase(),v.hasContent=!Ot.test(v.type),f=v.url.replace(qt,""),v.hasContent?v.data&&v.processData&&0===(v.contentType||"").indexOf("application/x-www-form-urlencoded")&&(v.data=v.data.replace(jt,"+")):(o=v.url.slice(f.length),v.data&&(v.processData||"string"==typeof v.data)&&(f+=(Et.test(f)?"&":"?")+v.data,delete v.data),!1===v.cache&&(f=f.replace(Lt,"$1"),o=(Et.test(f)?"&":"?")+"_="+Ct.guid+++o),v.url=f+o),v.ifModified&&(S.lastModified[f]&&T.setRequestHeader("If-Modified-Since",S.lastModified[f]),S.etag[f]&&T.setRequestHeader("If-None-Match",S.etag[f])),(v.data&&v.hasContent&&!1!==v.contentType||t.contentType)&&T.setRequestHeader("Content-Type",v.contentType),T.setRequestHeader("Accept",v.dataTypes[0]&&v.accepts[v.dataTypes[0]]?v.accepts[v.dataTypes[0]]+("*"!==v.dataTypes[0]?", "+It+"; q=0.01":""):v.accepts["*"]),v.headers)T.setRequestHeader(i,v.headers[i]);if(v.beforeSend&&(!1===v.beforeSend.call(y,T,v)||h))return T.abort();if(u="abort",b.add(v.complete),T.done(v.success),T.fail(v.error),c=Bt(Mt,v,t,T)){if(T.readyState=1,g&&m.trigger("ajaxSend",[T,v]),h)return T;v.async&&0<v.timeout&&(d=C.setTimeout(function(){T.abort("timeout")},v.timeout));try{h=!1,c.send(a,l)}catch(e){if(h)throw e;l(-1,e)}}else l(-1,"No Transport");function l(e,t,n,r){var i,o,a,s,u,l=t;h||(h=!0,d&&C.clearTimeout(d),c=void 0,p=r||"",T.readyState=0<e?4:0,i=200<=e&&e<300||304===e,n&&(s=function(e,t,n){var r,i,o,a,s=e.contents,u=e.dataTypes;while("*"===u[0])u.shift(),void 0===r&&(r=e.mimeType||t.getResponseHeader("Content-Type"));if(r)for(i in s)if(s[i]&&s[i].test(r)){u.unshift(i);break}if(u[0]in n)o=u[0];else{for(i in n){if(!u[0]||e.converters[i+" "+u[0]]){o=i;break}a||(a=i)}o=o||a}if(o)return o!==u[0]&&u.unshift(o),n[o]}(v,T,n)),!i&&-1<S.inArray("script",v.dataTypes)&&(v.converters["text script"]=function(){}),s=function(e,t,n,r){var i,o,a,s,u,l={},c=e.dataTypes.slice();if(c[1])for(a in e.converters)l[a.toLowerCase()]=e.converters[a];o=c.shift();while(o)if(e.responseFields[o]&&(n[e.responseFields[o]]=t),!u&&r&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u=o,o=c.shift())if("*"===o)o=u;else if("*"!==u&&u!==o){if(!(a=l[u+" "+o]||l["* "+o]))for(i in l)if((s=i.split(" "))[1]===o&&(a=l[u+" "+s[0]]||l["* "+s[0]])){!0===a?a=l[i]:!0!==l[i]&&(o=s[0],c.unshift(s[1]));break}if(!0!==a)if(a&&e["throws"])t=a(t);else try{t=a(t)}catch(e){return{state:"parsererror",error:a?e:"No conversion from "+u+" to "+o}}}return{state:"success",data:t}}(v,s,T,i),i?(v.ifModified&&((u=T.getResponseHeader("Last-Modified"))&&(S.lastModified[f]=u),(u=T.getResponseHeader("etag"))&&(S.etag[f]=u)),204===e||"HEAD"===v.type?l="nocontent":304===e?l="notmodified":(l=s.state,o=s.data,i=!(a=s.error))):(a=l,!e&&l||(l="error",e<0&&(e=0))),T.status=e,T.statusText=(t||l)+"",i?x.resolveWith(y,[o,l,T]):x.rejectWith(y,[T,l,a]),T.statusCode(w),w=void 0,g&&m.trigger(i?"ajaxSuccess":"ajaxError",[T,v,i?o:a]),b.fireWith(y,[T,l]),g&&(m.trigger("ajaxComplete",[T,v]),--S.active||S.event.trigger("ajaxStop")))}return T},getJSON:function(e,t,n){return S.get(e,t,n,"json")},getScript:function(e,t){return S.get(e,void 0,t,"script")}}),S.each(["get","post"],function(e,i){S[i]=function(e,t,n,r){return m(t)&&(r=r||n,n=t,t=void 0),S.ajax(S.extend({url:e,type:i,dataType:r,data:t,success:n},S.isPlainObject(e)&&e))}}),S.ajaxPrefilter(function(e){var t;for(t in e.headers)"content-type"===t.toLowerCase()&&(e.contentType=e.headers[t]||"")}),S._evalUrl=function(e,t,n){return S.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(e){S.globalEval(e,t,n)}})},S.fn.extend({wrapAll:function(e){var t;return this[0]&&(m(e)&&(e=e.call(this[0])),t=S(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstElementChild)e=e.firstElementChild;return e}).append(this)),this},wrapInner:function(n){return m(n)?this.each(function(e){S(this).wrapInner(n.call(this,e))}):this.each(function(){var e=S(this),t=e.contents();t.length?t.wrapAll(n):e.append(n)})},wrap:function(t){var n=m(t);return this.each(function(e){S(this).wrapAll(n?t.call(this,e):t)})},unwrap:function(e){return this.parent(e).not("body").each(function(){S(this).replaceWith(this.childNodes)}),this}}),S.expr.pseudos.hidden=function(e){return!S.expr.pseudos.visible(e)},S.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},S.ajaxSettings.xhr=function(){try{return new C.XMLHttpRequest}catch(e){}};var _t={0:200,1223:204},zt=S.ajaxSettings.xhr();y.cors=!!zt&&"withCredentials"in zt,y.ajax=zt=!!zt,S.ajaxTransport(function(i){var o,a;if(y.cors||zt&&!i.crossDomain)return{send:function(e,t){var n,r=i.xhr();if(r.open(i.type,i.url,i.async,i.username,i.password),i.xhrFields)for(n in i.xhrFields)r[n]=i.xhrFields[n];for(n in i.mimeType&&r.overrideMimeType&&r.overrideMimeType(i.mimeType),i.crossDomain||e["X-Requested-With"]||(e["X-Requested-With"]="XMLHttpRequest"),e)r.setRequestHeader(n,e[n]);o=function(e){return function(){o&&(o=a=r.onload=r.onerror=r.onabort=r.ontimeout=r.onreadystatechange=null,"abort"===e?r.abort():"error"===e?"number"!=typeof r.status?t(0,"error"):t(r.status,r.statusText):t(_t[r.status]||r.status,r.statusText,"text"!==(r.responseType||"text")||"string"!=typeof r.responseText?{binary:r.response}:{text:r.responseText},r.getAllResponseHeaders()))}},r.onload=o(),a=r.onerror=r.ontimeout=o("error"),void 0!==r.onabort?r.onabort=a:r.onreadystatechange=function(){4===r.readyState&&C.setTimeout(function(){o&&a()})},o=o("abort");try{r.send(i.hasContent&&i.data||null)}catch(e){if(o)throw e}},abort:function(){o&&o()}}}),S.ajaxPrefilter(function(e){e.crossDomain&&(e.contents.script=!1)}),S.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return S.globalEval(e),e}}}),S.ajaxPrefilter("script",function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")}),S.ajaxTransport("script",function(n){var r,i;if(n.crossDomain||n.scriptAttrs)return{send:function(e,t){r=S("<script>").attr(n.scriptAttrs||{}).prop({charset:n.scriptCharset,src:n.url}).on("load error",i=function(e){r.remove(),i=null,e&&t("error"===e.type?404:200,e.type)}),E.head.appendChild(r[0])},abort:function(){i&&i()}}});var Ut,Xt=[],Vt=/(=)\?(?=&|$)|\?\?/;S.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Xt.pop()||S.expando+"_"+Ct.guid++;return this[e]=!0,e}}),S.ajaxPrefilter("json jsonp",function(e,t,n){var r,i,o,a=!1!==e.jsonp&&(Vt.test(e.url)?"url":"string"==typeof e.data&&0===(e.contentType||"").indexOf("application/x-www-form-urlencoded")&&Vt.test(e.data)&&"data");if(a||"jsonp"===e.dataTypes[0])return r=e.jsonpCallback=m(e.jsonpCallback)?e.jsonpCallback():e.jsonpCallback,a?e[a]=e[a].replace(Vt,"$1"+r):!1!==e.jsonp&&(e.url+=(Et.test(e.url)?"&":"?")+e.jsonp+"="+r),e.converters["script json"]=function(){return o||S.error(r+" was not called"),o[0]},e.dataTypes[0]="json",i=C[r],C[r]=function(){o=arguments},n.always(function(){void 0===i?S(C).removeProp(r):C[r]=i,e[r]&&(e.jsonpCallback=t.jsonpCallback,Xt.push(r)),o&&m(i)&&i(o[0]),o=i=void 0}),"script"}),y.createHTMLDocument=((Ut=E.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===Ut.childNodes.length),S.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(y.createHTMLDocument?((r=(t=E.implementation.createHTMLDocument("")).createElement("base")).href=E.location.href,t.head.appendChild(r)):t=E),o=!n&&[],(i=N.exec(e))?[t.createElement(i[1])]:(i=xe([e],t,o),o&&o.length&&S(o).remove(),S.merge([],i.childNodes)));var r,i,o},S.fn.load=function(e,t,n){var r,i,o,a=this,s=e.indexOf(" ");return-1<s&&(r=vt(e.slice(s)),e=e.slice(0,s)),m(t)?(n=t,t=void 0):t&&"object"==typeof t&&(i="POST"),0<a.length&&S.ajax({url:e,type:i||"GET",dataType:"html",data:t}).done(function(e){o=arguments,a.html(r?S("<div>").append(S.parseHTML(e)).find(r):e)}).always(n&&function(e,t){a.each(function(){n.apply(this,o||[e.responseText,t,e])})}),this},S.expr.pseudos.animated=function(t){return S.grep(S.timers,function(e){return t===e.elem}).length},S.offset={setOffset:function(e,t,n){var r,i,o,a,s,u,l=S.css(e,"position"),c=S(e),f={};"static"===l&&(e.style.position="relative"),s=c.offset(),o=S.css(e,"top"),u=S.css(e,"left"),("absolute"===l||"fixed"===l)&&-1<(o+u).indexOf("auto")?(a=(r=c.position()).top,i=r.left):(a=parseFloat(o)||0,i=parseFloat(u)||0),m(t)&&(t=t.call(e,n,S.extend({},s))),null!=t.top&&(f.top=t.top-s.top+a),null!=t.left&&(f.left=t.left-s.left+i),"using"in t?t.using.call(e,f):("number"==typeof f.top&&(f.top+="px"),"number"==typeof f.left&&(f.left+="px"),c.css(f))}},S.fn.extend({offset:function(t){if(arguments.length)return void 0===t?this:this.each(function(e){S.offset.setOffset(this,t,e)});var e,n,r=this[0];return r?r.getClientRects().length?(e=r.getBoundingClientRect(),n=r.ownerDocument.defaultView,{top:e.top+n.pageYOffset,left:e.left+n.pageXOffset}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n,r=this[0],i={top:0,left:0};if("fixed"===S.css(r,"position"))t=r.getBoundingClientRect();else{t=this.offset(),n=r.ownerDocument,e=r.offsetParent||n.documentElement;while(e&&(e===n.body||e===n.documentElement)&&"static"===S.css(e,"position"))e=e.parentNode;e&&e!==r&&1===e.nodeType&&((i=S(e).offset()).top+=S.css(e,"borderTopWidth",!0),i.left+=S.css(e,"borderLeftWidth",!0))}return{top:t.top-i.top-S.css(r,"marginTop",!0),left:t.left-i.left-S.css(r,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){var e=this.offsetParent;while(e&&"static"===S.css(e,"position"))e=e.offsetParent;return e||re})}}),S.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(t,i){var o="pageYOffset"===i;S.fn[t]=function(e){return $(this,function(e,t,n){var r;if(x(e)?r=e:9===e.nodeType&&(r=e.defaultView),void 0===n)return r?r[i]:e[t];r?r.scrollTo(o?r.pageXOffset:n,o?n:r.pageYOffset):e[t]=n},t,e,arguments.length)}}),S.each(["top","left"],function(e,n){S.cssHooks[n]=$e(y.pixelPosition,function(e,t){if(t)return t=Be(e,n),Me.test(t)?S(e).position()[n]+"px":t})}),S.each({Height:"height",Width:"width"},function(a,s){S.each({padding:"inner"+a,content:s,"":"outer"+a},function(r,o){S.fn[o]=function(e,t){var n=arguments.length&&(r||"boolean"!=typeof e),i=r||(!0===e||!0===t?"margin":"border");return $(this,function(e,t,n){var r;return x(e)?0===o.indexOf("outer")?e["inner"+a]:e.document.documentElement["client"+a]:9===e.nodeType?(r=e.documentElement,Math.max(e.body["scroll"+a],r["scroll"+a],e.body["offset"+a],r["offset"+a],r["client"+a])):void 0===n?S.css(e,t,i):S.style(e,t,n,i)},s,n?e:void 0,n)}})}),S.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){S.fn[t]=function(e){return this.on(t,e)}}),S.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)},hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),S.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(e,n){S.fn[n]=function(e,t){return 0<arguments.length?this.on(n,null,e,t):this.trigger(n)}});var Gt=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;S.proxy=function(e,t){var n,r,i;if("string"==typeof t&&(n=e[t],t=e,e=n),m(e))return r=s.call(arguments,2),(i=function(){return e.apply(t||this,r.concat(s.call(arguments)))}).guid=e.guid=e.guid||S.guid++,i},S.holdReady=function(e){e?S.readyWait++:S.ready(!0)},S.isArray=Array.isArray,S.parseJSON=JSON.parse,S.nodeName=A,S.isFunction=m,S.isWindow=x,S.camelCase=X,S.type=w,S.now=Date.now,S.isNumeric=function(e){var t=S.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))},S.trim=function(e){return null==e?"":(e+"").replace(Gt,"")},"function"==typeof define&&define.amd&&define("jquery",[],function(){return S});var Yt=C.jQuery,Qt=C.$;return S.noConflict=function(e){return C.$===S&&(C.$=Qt),e&&C.jQuery===S&&(C.jQuery=Yt),S},"undefined"==typeof e&&(C.jQuery=C.$=S),S});
// class to convert the standard JSON representation of a gatenlp
// document into something we need here and methods to access the data.
var gatenlpDocRep = class {
    constructor(bdoc, parms) {
        this.sep = "║"
        this.sname2types = new Map();
        this.snameid2ann = new Map();
        this.snametype2ids = new Map();
	    this.text = bdoc["text"];
	    this.presel_list = parms["presel_list"]
	    this.presel_set = new Set(parms["presel_set"])
	    this.cols4types = parms["cols4types"]
	    if ("palette" in parms) {
	        this.palette = parms["palette"]
	    }
	    const regex = / +$/;
            this.features = bdoc["features"];
            if (this.text == null) {
                this.text = "[No proper GATENLP document to show]";
                return;
            }
            let annsets = bdoc["annotation_sets"];
            if (annsets == null) {
                return;
            }
            for (let setname in annsets) {
                // console.log("Processing setname: " + setname)
                let annset = annsets[setname];
                let types4annset = new Set();
                let anns4set = annset["annotations"];
                for (let [idx, element] of anns4set.entries()) {
                    // console.log("adding ann: " + idx + " / " + element)
                    let annid = element["id"].toString();
                    let anntype = element["type"];
                    types4annset.add(anntype);
                    // let snametype = setname + DocRep.sep + anntype;
                    let snametype = setname + this.sep + anntype;
                    // console.log("Created key " + snametype)
                    let ids4type = this.snametype2ids.get(snametype);
                    if (ids4type == null) {
                        //console.log("Adding " + [annid])
                        this.snametype2ids.set(snametype, [annid]);
                        // console.log("keys now " + Array.from(this.snametype2ids.keys()))
                    } else {
                        ids4type.push(annid);
                        // console.log("snametype2ids for " + snametype + " is now " + ids4type)
                    }
                    let snameid = setname + this.sep + annid
                    let ann4snameid = this.snameid2ann.get(snameid);
                    if (ann4snameid == null) {
                        this.snameid2ann.set(snameid, element);
                    } else {
                        // how to handle this odd error?
                    }
                }
                this.sname2types.set(setname, Array.from(types4annset).sort());
            }
        } // constructor

    setnames() {
        return Array.from(this.sname2types.keys()).sort();
    }

    types4setname(setname) {
        // return a sorted list of annotation types for a set name
        return Array.from(this.sname2types.get(setname)); // already sorted!
    }

    annids4snametype(setname, anntype) {
        // return a list of annotation ids for a setname and annotation type
        return this.snametype2ids.get(setname + this.sep + anntype);
    }

    ann4setnameannid(setname, annid) {
        // return the annotation object (map) for a set/id
        return this.snameid2ann.get(setname + this.sep + annid)
    }

    anns4settype(setname, type) {
        //console.log("Getting anns for " + setname + " " + type)
        let annids = this.annids4snametype(setname, type);
        let anns = [];
        for (let annid of annids) {
            anns[anns.length] = this.ann4setnameannid(setname, annid);
        }
        //console.log("Found " + annids + " returning " + anns);
        return anns;
    }

};

function docview_annchosen(rep, ev, setname, anntype) {
        let checked = $(ev.target).prop("checked");
        // this gives us the setname, type and checkbox status of what has been clicked, but for now
        // we always get the complete list of selected types here:
        let seltypes = [];
        let inputs = $(rep.id_chooser).find("input");
        inputs.each(function(index) {
            let inputel = $(inputs.get(index));
            if (inputel.prop("checked")) {
                // seltypes.push(([inputel.attr("data-setname"), inputel.attr("data-anntype")]));
                seltypes[seltypes.length] = [inputel.attr("data-setname"), inputel.attr("data-anntype")]
            }
        });
        rep.chosen = seltypes;
        rep.buildAnns4Offset();
        rep.buildContent();
    }

function docview_annsel(obj, ev, anns) {
        if (anns.size > 1) {
            // if there are several annotation, show the popup
            $(obj.id_popup).empty();
            for (let info of anns.values()) {
                let fields = info.split("║")
                let setname = fields[0]
                let annid = fields[2]                
                let ann = obj.docrep.ann4setnameannid(setname, annid);
                // console.log("Looking up setname="+setname+",annid="+annid+" gave: "+ann)
                let feats = ann.features;
                let idpopup = obj.id_popup;
                $("<div class='" + obj.class_selection + "'>" + ann.type + ": id=" + annid + " offsets=" + ann.start + ".." + ann.end + " (" + (ann.end-ann.start) + ")" + "</div>").on("click", function(x) {
                    docview_showAnn(obj, ann);
                    $(idpopup).hide();
                }).appendTo(obj.id_popup);
            }
            $(obj.id_popup).show();            
        } else if (anns.size == 1) {
            // if there is just one annotation, show features immediately, without the popup
            let a = anns.values().next()["value"]
            let fields = a.split("║")            
            let ann = obj.docrep.ann4setnameannid(fields[0], fields[2]);
            docview_showAnn(obj, ann);
        } else {
            console.error("EMPTY ANNS???");
        }
    }

function docview_showFeatures(obj, features) {
        let tbl = $("<table>").attr("class", obj.idprefix+"featuretable");
        for (let fname in features) {
            let fval = JSON.stringify(features[fname]);
            tbl.append("<tr><td class='" + obj.class_fname + "'>" + fname + "</td><td class='" + obj.class_fvalue + "'>" + fval + "</td></tr>");
        }
        $(obj.id_details).append(tbl);
    }

function docview_showAnn(obj, ann) {
        $(obj.id_details).empty();
        $(obj.id_details).append("<div class='" + obj.id_hdr + "'>Annotation: " + ann.type + ", id:" + ann.id + " offsets:" + ann.start + ".." + ann.end + " (" + (ann.end-ann.start) + ")</div>");
        docview_showFeatures(obj, ann.features);
    }

function docview_showDocFeatures(obj, features) {
        $(obj.id_details).empty();
        $(obj.id_details).append("<div class='" + obj.id_hdr + "'>Document features:</div>");
        docview_showFeatures(obj, features);
    }

function hex2rgba(hx) {
    return [
        parseInt(hx.substring(1, 3), 16),
        parseInt(hx.substring(3, 5), 16),
        parseInt(hx.substring(5, 7), 16),
        1.0
    ];
};


// class to build the HTML for viewing the converted document
var gatenlpDocView = class {
    constructor(docrep, idprefix="GATENLPID-", config=undefined) {
        // idprefix: the prefix to add to all ids and classes
        this.sep = "║"
        this.docrep = docrep;
        this.idprefix = idprefix;
        this.id_text = "#" + idprefix + "text";
        this.id_chooser = "#" + idprefix + "chooser";
        this.id_details = "#" + idprefix + "details";
        this.id_popup = "#" + idprefix + "popup";
        this.id_hdr = "#" + idprefix + "hdr";
        this.id_dochdr = "#" + idprefix + "dochdr";
        this.class_selection = idprefix + "selection";
        this.class_fname = idprefix + "fname";
        this.class_fvalue = idprefix + "fvalue";
        this.class_label = idprefix + "label";
        this.class_input = idprefix + "input";
        this.chosen = [];
        this.anns4offset = undefined;
        // create default config here
        this.config = config;
        this.palettex = [
            // modified from R lib pals: alphabet2
            "#AA6DAA", "#3283FE", "#85660D", "#782AB6", "#565656", "#1C8356", "#16FF32", "#F7E1A0", "#E2E2E2", "#1CBE4F", "#C4451C", "#DEA0FD",
            "#FE00FA", "#325A9B", "#FEAF16", "#F8A19F", "#90AD1C", "#F6222E", "#1CFFCE", "#2ED9FF", "#B10DA1", "#C075A6", "#FC1CBF", "#B00068",
            "#FBE426", "#FA0087",
            // modified from R lib pals: polychrome
            "#5A5156", "#E4E1E3", "#F6222E", "#FE00FA", "#16FF32", "#3283FE", "#FEAF16", "#B00068", "#1CFFCE", "#90AD1C",
            "#2ED9FF", "#DEA0FD", "#AA0DFE", "#F8A19F", "#325A9B", "#C4451C", "#1C8356", "#85660D", "#B10DA1", "#FBE426",
            "#1CBE4F", "#FA0087", "#FC1CBF", "#F7E1A0", "#C075A6", "#782AB6", "#AAF400", "#BDCDFF", "#822E1C", "#B5EFB5",
            "#7ED7D1", "#1C7F93", "#D85FF7", "#683B79", "#66B0FF", "#3B00FB"
        ]
        if (typeof this.docrep.palette !== 'undefined') {
            this.palettex = this.docrep.palette
        }
        this.palette = this.palettex.map(hex2rgba)
        this.type2colour = new Map();
    }

    style4color(col) {
        return "background-color: rgba(" + col.join(",") + ");"
    }

    color4types(atypes) {
        // atypes is a list of set┼type┼annid strings
        let r = 0;
        let g = 0;
        let b = 0;
        let a = 0;
        for (let info of atypes.values()) {
            let fields = info.split(this.sep)
            let typ = fields[0] + this.sep + fields[1];
            let col = this.type2colour.get(typ);
            // console.log("Looked up color for "+typ+" got "+col)
            r += col[0];
            g += col[1];
            b += col[2];
            a += col[3];
        }
        r = Math.floor(r / atypes.size);
        g = Math.floor(g / atypes.size);
        b = Math.floor(b / atypes.size);
        a = a / atypes.size;
        // console.log("Final colors for len "+atypes.size+" r="+r+" g="+g)
        return [r, g, b, 1.0];
    }

    init() {
        let divcontent = $(this.id_text);
        $(divcontent).empty();
        let text = this.docrep.text;
        let thehtml = $.parseHTML(this.htmlEntities(text));
        $(divcontent).append(thehtml);

        // First of all, create the annotation chooser
        // create a form which contains:
        // for each annotation set create an a tag. followed by a div that contains all the checkbox fields
        let divchooser = $(this.id_chooser);
        $(divchooser).empty();
        let formchooser = $("<form>");
        let colidx = 0
        for (let setname of this.docrep.setnames()) {
            let setname2show = setname;
            // TODO: add number of annotations in the set in parentheses
            if (setname == "") {
                setname2show = "[Default Set]"
            }
            // TODO: make what we show here configurable?
            $(formchooser).append($(document.createElement('div')).attr("class", this.id_hdr).append(setname2show))
            let div4set = document.createElement("div")
            // $(div4set).attr("id", setname);
            $(div4set).attr("style", "margin-bottom: 10px;");
            for (let anntype of this.docrep.types4setname(setname)) {
                //console.log("Addingsss type " + anntype)
                let setandtype = setname + this.docrep.sep + anntype;
                let col = undefined
                if (setandtype in this.docrep.cols4types) {
                    col = hex2rgba(this.docrep.cols4types[setandtype])
                } else {
                    col = this.palette[colidx];
                }
                this.type2colour.set(setname + this.sep + anntype, col);
                colidx = (colidx + 1) % this.palette.length;
                let lbl = $("<label>").attr({ "style": this.style4color(col), "class": this.class_label });
                let object = this
                let annhandler = function(ev) { docview_annchosen(object, ev, setname, anntype) }
                let inp = $('<input type="checkbox">').attr({ "type": "checkbox", "class": this.class_input, "data-anntype": anntype, "data-setname": setname}).on("click", annhandler)
                if (this.docrep.presel_set.has(setandtype)) {
                    inp.attr("checked", "")
                }
                $(lbl).append(inp);
                $(lbl).append(anntype);
                // append the number of annotations in this set 
                let n = this.docrep.annids4snametype(setname, anntype).length;
                $(lbl).append(" (" + n + ")");
                $(div4set).append(lbl)
                $(div4set).append($("<br>"))
                $(divchooser).append(formchooser)
            }
            $(formchooser).append(div4set)
        }

        let obj = this;
        let feats = this.docrep["features"];
        docview_showDocFeatures(obj, feats);
        $(this.id_dochdr).text("Document:").on("click", function(ev) { docview_showDocFeatures(obj, feats) });
        this.chosen = this.docrep.presel_list
        this.buildAnns4Offset()
        this.buildContent()
    }

        set2list(theset) {
            let arr = new Array()
            for (var el of theset.values()) {
               arr[arr.length] = el
            }
            return arr
        }

        setsequal(set1, set2) {
            if (set1.size !== set2.size) return false;
            for (var el of set1) if (!set2.has(el)) return false;
            return true;
        }

    buildAnns4Offset() {
        // console.log("Running buildAnns4Offset")
        //this.anns4offset = new Array(this.docrep.text.length + 1);
        this.anns4offset = new Array()

        // for all the set/type combinations that have been selected ... 
        for (let [sname, atype] of this.chosen) {
            //console.log("sname/type: " + sname + "/" + atype);
            // get the list of annotations that match the given Setname and annotation type
            let anns = this.docrep.anns4settype(sname, atype);
            for (let ann of anns) {
                // console.log("processing ann: " + ann + " start=" + ann.start + " end=" + ann.end + " type=" + ann.type)
                // store the annotation setname/typename/annid for each offset of each annotation
                // to indicate the end of the annotation also store an empty list for the offset after the annotation 
                // unless we already have something there

                // trick for zero length annotations: show them as length one annotations for now
                var endoff = ann.end
                if (ann.start == ann.end) endoff = endoff+1
                for (let i = ann.start; i < endoff; i++) { // iterate until one beyond the end of the ann
                    let have = this.anns4offset[i]
                    if (have == undefined) {                    
                      have = { "offset": i, "anns": new Set()}
                      this.anns4offset[i] = have
                    }
                    if (i < endoff) {
                        // append a new set/type tuple to the list of set/types at this offset
                        let tmp = this.anns4offset[i]["anns"];
                        let toadd = sname + this.sep + atype + this.sep + ann.id
                        // console.log("Trying to add "+toadd+" to "+this.set2list(tmp))
                        tmp = tmp.add(toadd); 
                        //console.log("is now "+this.set2list(tmp))
                        //console.log("entry for offset "+i+" is now " + this.set2list(this.anns4offset[i]["anns"]));
                    }
                }
            }
        }
        //console.log("initial anns4Offset:")
        //console.log(this.anns4offset)
        // now all offsets have a list of set/type and set/annid tuples
        // compress the list to only contain anything but undefined where it changes 
        let last = this.anns4offset[0]
        for (let i = 1; i < this.anns4offset.length+1; i++) {
            let cur = this.anns4offset[i]
            if (last == undefined && cur == undefined) {
                // console.log("Offset "+i+" both undefined")
                // nothing to do
            } else if (last == undefined && cur != undefined) {
                // we have a new list of annotations, keep it: nothing to do
                //console.log("Offset "+i+" last undefined, this one not")
            } else if (last != undefined && cur == undefined) {
                // we switch from some list of annotations to the empty list: 
                // add an empty entry
                //console.log("Offset "+i+" last one not undefined, this undefined, inserting empty list")
                this.anns4offset[i] = { "anns": new Set(), "offset": i}
            } else {
                // both offsets have annotations, but do the differ? we need to compare the types and annids
                // For now we do this by comparing the stringified representations
                let s1 = last["anns"]
                let s2 = cur["anns"]
                // console.log("Offset "+i+" Cur: "+this.set2list(s2)+" last: "+this.set2list(s1))
                if (this.setsequal(s1,s2)) {
                   // console.log("Detected equal")
                   this.anns4offset[i] = undefined
                }
            } 
            last = cur
        }
	let beyond = this.docrep.text.length
	this.anns4offset[beyond] = { "anns": new Set(), "offset": beyond}

        // console.log("compressed anns4Offset:")
        // console.log(this.anns4offset)

    }

    buildContent() {
        //console.log("Running buildContent");
        // got through all the offsets and check where the annotations change
        // start with the set of annotations in the first offset (empty if undefined) as lastset, calculate color for set
        // go through all subsequent offsets
        // when we find an entry where the annotations change:
        // * get the annotation setname/types 
        // * from the list of setname/types, determine a colour and store it
        // * generate the span from last to here 
        // * process one additional char at the end to include last span
        let spans = []
        let last = this.anns4offset[0];
        if (last == undefined) {
            last = { "anns": new Set(), "offset": 0 };
        }
        for (let i = 1; i < this.anns4offset.length+1; i++) {
            let info = this.anns4offset[i];
            if (info != undefined) {
                let txt = this.docrep.text.substring(last["offset"], info["offset"]);
                txt = txt.replace(/\n/g, "\u2002\n");
                // console.log("Got text: "+txt) 
                let span = undefined;
                if (last["anns"].size != 0) {
                    let col = this.color4types(last.anns);
                    let sty = this.style4color(col)+"white-space:pre-wrap;" 
                    span = $('<span>').attr("style", sty);
                    let object = this;
                    let anns = last.anns;
                    let annhandler = function(ev) { docview_annsel(object, ev, anns) }
                    span.on("click", annhandler);
                    // console.log("Adding styled text for "+col+"/"+sty+" : "+txt)                    
                } else {
                    // console.log("Adding non-styled text "+txt)
                    span = $('<span>');
                }
                span.append($.parseHTML(this.htmlEntities(txt)));
                spans.push(span);
                last = info;
            }
        }
        // Replace the content
        let divcontent = $(this.id_text);
        $(divcontent).empty();
        $(divcontent).append(spans);
    }

    htmlEntities(str) {
        return str.replaceAll('&', '&amp;').replaceAll('<', '&lt;').replaceAll('>', '&gt;').replaceAll('"', '&quot;').replaceAll("\n", '<br>');
    }
};
</script>



<div><style>#PHFWJHAXKU-wrapper { color: black !important; }</style>
<div id="PHFWJHAXKU-wrapper">

<div>
<style>
#PHFWJHAXKU-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.PHFWJHAXKU-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.PHFWJHAXKU-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.PHFWJHAXKU-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.PHFWJHAXKU-label {
    margin-bottom: -15px;
    display: block;
}

.PHFWJHAXKU-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#PHFWJHAXKU-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.PHFWJHAXKU-selection {
    margin-bottom: 5px;
}

.PHFWJHAXKU-featuretable {
    margin-top: 10px;
}

.PHFWJHAXKU-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.PHFWJHAXKU-fvalue {
    text-align: left !important;
}
</style>
  <div id="PHFWJHAXKU-content">
        <div id="PHFWJHAXKU-popup" style="display: none;">
        </div>
        <div class="PHFWJHAXKU-row" id="PHFWJHAXKU-row1" style="min-height:5em;max-height:20em; min-height:5em;">
            <div id="PHFWJHAXKU-text-wrapper" class="PHFWJHAXKU-col" style="width:70%;">
                <div class="PHFWJHAXKU-hdr" id="PHFWJHAXKU-dochdr"></div>
                <div id="PHFWJHAXKU-text" style="">
                </div>
            </div>
            <div id="PHFWJHAXKU-chooser" class="PHFWJHAXKU-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="PHFWJHAXKU-row" id="PHFWJHAXKU-row2" style="min-height:3em;max-height:14em; min-height: 3em;">
            <div id="PHFWJHAXKU-details" class="PHFWJHAXKU-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="text/javascript">
    let PHFWJHAXKU_data = {"annotation_sets": {}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {}, "offset_type": "j", "name": ""} ; 
    let PHFWJHAXKU_parms = {"presel_set": [], "presel_list": [], "cols4types": {}} ;
    new gatenlpDocView(new gatenlpDocRep(PHFWJHAXKU_data, PHFWJHAXKU_parms), "PHFWJHAXKU-").init();
    </script>
  </div>

</div></div>


This shows the document in a layout that has three areas: the document text in the upper left,
the list of annotation set and type names in the upper right and document or annotation features
at the bottom. In the example above only the text is shown because there are no document features or 
annotations. 

## Document features

Lets add some document features:


```python
doc.features["loaded-from"] = "https://gatenlp.github.io/python-gatenlp/testdocument1.txt"
doc.features["purpose"] = "test document for gatenlp"
doc.features["someotherfeature"] = 22
doc.features["andanother"] = {"what": "a dict", "alist": [1,2,3,4,5]}
```

Document features map feature names to feature values and behave a lot like a Python dictionary. Feature names
should always be strings, feature values can be anything, but a document can only be stored or exchanged with Java GATE if feature values are restricted to whatever can be serialized with JSON: dictionaries, lists, numbers, strings and booleans. 

Now that we have create document features the document is shown like this:


```python
doc
```




<div><style>#MZGOPXPYSZ-wrapper { color: black !important; }</style>
<div id="MZGOPXPYSZ-wrapper">

<div>
<style>
#MZGOPXPYSZ-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.MZGOPXPYSZ-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.MZGOPXPYSZ-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.MZGOPXPYSZ-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.MZGOPXPYSZ-label {
    margin-bottom: -15px;
    display: block;
}

.MZGOPXPYSZ-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#MZGOPXPYSZ-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.MZGOPXPYSZ-selection {
    margin-bottom: 5px;
}

.MZGOPXPYSZ-featuretable {
    margin-top: 10px;
}

.MZGOPXPYSZ-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.MZGOPXPYSZ-fvalue {
    text-align: left !important;
}
</style>
  <div id="MZGOPXPYSZ-content">
        <div id="MZGOPXPYSZ-popup" style="display: none;">
        </div>
        <div class="MZGOPXPYSZ-row" id="MZGOPXPYSZ-row1" style="min-height:5em;max-height:20em; min-height:5em;">
            <div id="MZGOPXPYSZ-text-wrapper" class="MZGOPXPYSZ-col" style="width:70%;">
                <div class="MZGOPXPYSZ-hdr" id="MZGOPXPYSZ-dochdr"></div>
                <div id="MZGOPXPYSZ-text" style="">
                </div>
            </div>
            <div id="MZGOPXPYSZ-chooser" class="MZGOPXPYSZ-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="MZGOPXPYSZ-row" id="MZGOPXPYSZ-row2" style="min-height:3em;max-height:14em; min-height: 3em;">
            <div id="MZGOPXPYSZ-details" class="MZGOPXPYSZ-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="text/javascript">
    let MZGOPXPYSZ_data = {"annotation_sets": {}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {"loaded-from": "https://gatenlp.github.io/python-gatenlp/testdocument1.txt", "purpose": "test document for gatenlp", "someotherfeature": 22, "andanother": {"what": "a dict", "alist": [1, 2, 3, 4, 5]}}, "offset_type": "j", "name": ""} ; 
    let MZGOPXPYSZ_parms = {"presel_set": [], "presel_list": [], "cols4types": {}} ;
    new gatenlpDocView(new gatenlpDocRep(MZGOPXPYSZ_data, MZGOPXPYSZ_parms), "MZGOPXPYSZ-").init();
    </script>
  </div>

</div></div>




```python
# to retrieve a feature value we can do:
doc.features["purpose"]
```




    'test document for gatenlp'




```python
# If a feature does not exist, None is returned or a default value if specified:
print(doc.features.get("doesntexist"))
print(doc.features.get("doesntexist", "MV!"))

```

    None
    MV!


## Annotations

Lets add some annotations too. Annotations are items of information for some range of characters within the document. They can be used to represent information about things like tokens, entities, sentences, paragraphs, or 
anything that corresponds to some contiguous range of offsets in the document.

Annotations consist of the following parts:
* The "start" and "end" offset to identify the text the annotation refers to
* A "type" which is an arbitrary name that identifies what kind of thing the annotation describes, e.g. "Token"
* Features: these work in the same way as for the whole document: an arbitrary set of feature name / feature value
  pairs which provide more information, e.g. for a Token the features could include the lemma, the part of speech,
  the stem, the number, etc. 

Annotations can be organized in "annotation sets". Each annotation set has a name and a set of annotations. There can be as many sets as needed. 

Annotation can overlap arbitrarily and there can be as many as needed. 

Let us manually add a few annotations to the document:


```python
# create and get an annotation set with the name "Set1"
annset = doc.annset("Set1")
```

Add an annotation to the set which refers to the first word in the document "This". The range of characters
for this word starts at offset 0 and the length of the annotation is 4, so the "start" offset is 0 and the "end" offset is 0+4=4. Note that the end offset always points to the offset *after* the last character of the range.


```python
annset.add(0,4,"Word",{"what": "our first annotation"})
```




    Annotation(0,4,Word,features=Features({'what': 'our first annotation'}),id=0)




```python
# Add more
annset.add(5,7,"Word",{"what": "our second annotation"})
annset.add(0,24,"Sentence",{"what": "our first sentence annotation"})
```




    Annotation(0,24,Sentence,features=Features({'what': 'our first sentence annotation'}),id=2)



If we visualize the document now, the newly created set "Set" is shown in the right part of
the display. It shows the different annotation types that exist in the set, and how many annotations
for each type are in the set. If you click the check box, the annotation ranges are shown in the 
text with the colour associated with the annotation type. You can then click on a range / annotation in the
text and the features of the annotation are shown in the lower part. 
To show the features for a different annotation click on the coloured range for the annotation in the text.
To show the document features, click on "Document".

If you have selected more than one type, a range can have more than one overlapping annotations. 
This is shown by mixing the colours. If you click at such a location, a dialog appears which lets you
select for which of the overlapping annotations you want to display the features. 


```python
doc
```




<div><style>#XJKSTGPHRT-wrapper { color: black !important; }</style>
<div id="XJKSTGPHRT-wrapper">

<div>
<style>
#XJKSTGPHRT-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.XJKSTGPHRT-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.XJKSTGPHRT-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.XJKSTGPHRT-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.XJKSTGPHRT-label {
    margin-bottom: -15px;
    display: block;
}

.XJKSTGPHRT-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#XJKSTGPHRT-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.XJKSTGPHRT-selection {
    margin-bottom: 5px;
}

.XJKSTGPHRT-featuretable {
    margin-top: 10px;
}

.XJKSTGPHRT-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.XJKSTGPHRT-fvalue {
    text-align: left !important;
}
</style>
  <div id="XJKSTGPHRT-content">
        <div id="XJKSTGPHRT-popup" style="display: none;">
        </div>
        <div class="XJKSTGPHRT-row" id="XJKSTGPHRT-row1" style="min-height:5em;max-height:20em; min-height:5em;">
            <div id="XJKSTGPHRT-text-wrapper" class="XJKSTGPHRT-col" style="width:70%;">
                <div class="XJKSTGPHRT-hdr" id="XJKSTGPHRT-dochdr"></div>
                <div id="XJKSTGPHRT-text" style="">
                </div>
            </div>
            <div id="XJKSTGPHRT-chooser" class="XJKSTGPHRT-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="XJKSTGPHRT-row" id="XJKSTGPHRT-row2" style="min-height:3em;max-height:14em; min-height: 3em;">
            <div id="XJKSTGPHRT-details" class="XJKSTGPHRT-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="text/javascript">
    let XJKSTGPHRT_data = {"annotation_sets": {"Set1": {"name": "detached-from:Set1", "annotations": [{"type": "Word", "start": 0, "end": 4, "id": 0, "features": {"what": "our first annotation"}}, {"type": "Word", "start": 5, "end": 7, "id": 1, "features": {"what": "our second annotation"}}, {"type": "Sentence", "start": 0, "end": 24, "id": 2, "features": {"what": "our first sentence annotation"}}], "next_annid": 3}}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {"loaded-from": "https://gatenlp.github.io/python-gatenlp/testdocument1.txt", "purpose": "test document for gatenlp", "someotherfeature": 22, "andanother": {"what": "a dict", "alist": [1, 2, 3, 4, 5]}}, "offset_type": "j", "name": ""} ; 
    let XJKSTGPHRT_parms = {"presel_set": [], "presel_list": [], "cols4types": {}} ;
    new gatenlpDocView(new gatenlpDocRep(XJKSTGPHRT_data, XJKSTGPHRT_parms), "XJKSTGPHRT-").init();
    </script>
  </div>

</div></div>



# Loading a larger document

Lets load a larger document, and from an HTML file: the Wikipedia page for "Natural Language processing":




```python
doc2 = Document.load("https://en.m.wikipedia.org/wiki/Natural_language_processing", fmt="html", parser="html.parser")
doc2
```




<div><style>#COKHYSJMVA-wrapper { color: black !important; }</style>
<div id="COKHYSJMVA-wrapper">

<div>
<style>
#COKHYSJMVA-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.COKHYSJMVA-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.COKHYSJMVA-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.COKHYSJMVA-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.COKHYSJMVA-label {
    margin-bottom: -15px;
    display: block;
}

.COKHYSJMVA-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#COKHYSJMVA-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.COKHYSJMVA-selection {
    margin-bottom: 5px;
}

.COKHYSJMVA-featuretable {
    margin-top: 10px;
}

.COKHYSJMVA-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.COKHYSJMVA-fvalue {
    text-align: left !important;
}
</style>
  <div id="COKHYSJMVA-content">
        <div id="COKHYSJMVA-popup" style="display: none;">
        </div>
        <div class="COKHYSJMVA-row" id="COKHYSJMVA-row1" style="min-height:5em;max-height:20em; min-height:5em;">
            <div id="COKHYSJMVA-text-wrapper" class="COKHYSJMVA-col" style="width:70%;">
                <div class="COKHYSJMVA-hdr" id="COKHYSJMVA-dochdr"></div>
                <div id="COKHYSJMVA-text" style="">
                </div>
            </div>
            <div id="COKHYSJMVA-chooser" class="COKHYSJMVA-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="COKHYSJMVA-row" id="COKHYSJMVA-row2" style="min-height:3em;max-height:14em; min-height: 3em;">
            <div id="COKHYSJMVA-details" class="COKHYSJMVA-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="text/javascript">
    let COKHYSJMVA_data = {"annotation_sets": {"Original markups": {"name": "detached-from:Original markups", "annotations": [{"type": "[document]", "start": 0, "end": 44640, "id": 0, "features": {}}, {"type": "html", "start": 1, "end": 44640, "id": 1, "features": {"class": "client-nojs", "lang": "en", "dir": "ltr"}}, {"type": "head", "start": 1, "end": 41, "id": 2, "features": {}}, {"type": "meta", "start": 1, "end": 1, "id": 3, "features": {"charset": "UTF-8"}}, {"type": "title", "start": 1, "end": 40, "id": 4, "features": {}}, {"type": "link", "start": 41, "end": 41, "id": 5, "features": {"rel": "stylesheet", "href": "/w/load.php?lang=en&modules=ext.cite.styles%7Cext.math.styles%7Cext.relatedArticles.styles%7Cext.wikimediaBadges%7Cmediawiki.hlist%7Cmediawiki.ui.button%2Cicon%7Cmobile.init.styles%7Cskins.minerva.amc.styles%7Cskins.minerva.base.styles%7Cskins.minerva.content.styles.images%7Cskins.minerva.icons.wikimedia%7Cskins.minerva.mainMenu.icons%2Cstyles&only=styles&skin=minerva"}}, {"type": "meta", "start": 41, "end": 41, "id": 6, "features": {"name": "generator", "content": "MediaWiki 1.40.0-wmf.8"}}, {"type": "meta", "start": 41, "end": 41, "id": 7, "features": {"name": "referrer", "content": "origin"}}, {"type": "meta", "start": 41, "end": 41, "id": 8, "features": {"name": "referrer", "content": "origin-when-crossorigin"}}, {"type": "meta", "start": 41, "end": 41, "id": 9, "features": {"name": "referrer", "content": "origin-when-cross-origin"}}, {"type": "meta", "start": 41, "end": 41, "id": 10, "features": {"name": "robots", "content": "max-image-preview:standard"}}, {"type": "meta", "start": 41, "end": 41, "id": 11, "features": {"name": "format-detection", "content": "telephone=no"}}, {"type": "meta", "start": 41, "end": 41, "id": 12, "features": {"name": "theme-color", "content": "#eaecf0"}}, {"type": "meta", "start": 41, "end": 41, "id": 13, "features": {"property": "og:image", "content": "https://upload.wikimedia.org/wikipedia/commons/8/8b/Automated_online_assistant.png"}}, {"type": "meta", "start": 41, "end": 41, "id": 14, "features": {"property": "og:image:width", "content": "1200"}}, {"type": "meta", "start": 41, "end": 41, "id": 15, "features": {"property": "og:image:height", "content": "1503"}}, {"type": "meta", "start": 41, "end": 41, "id": 16, "features": {"property": "og:image", "content": "https://upload.wikimedia.org/wikipedia/commons/8/8b/Automated_online_assistant.png"}}, {"type": "meta", "start": 41, "end": 41, "id": 17, "features": {"property": "og:image:width", "content": "800"}}, {"type": "meta", "start": 41, "end": 41, "id": 18, "features": {"property": "og:image:height", "content": "1002"}}, {"type": "meta", "start": 41, "end": 41, "id": 19, "features": {"property": "og:image:width", "content": "640"}}, {"type": "meta", "start": 41, "end": 41, "id": 20, "features": {"property": "og:image:height", "content": "802"}}, {"type": "meta", "start": 41, "end": 41, "id": 21, "features": {"name": "viewport", "content": "width=device-width, initial-scale=1.0, user-scalable=yes, minimum-scale=0.25, maximum-scale=5.0"}}, {"type": "meta", "start": 41, "end": 41, "id": 22, "features": {"property": "og:title", "content": "Natural language processing - Wikipedia"}}, {"type": "meta", "start": 41, "end": 41, "id": 23, "features": {"property": "og:type", "content": "website"}}, {"type": "link", "start": 41, "end": 41, "id": 24, "features": {"rel": "preconnect", "href": "//upload.wikimedia.org"}}, {"type": "link", "start": 41, "end": 41, "id": 25, "features": {"rel": "manifest", "href": "/w/api.php?action=webapp-manifest"}}, {"type": "link", "start": 41, "end": 41, "id": 26, "features": {"rel": "alternate", "type": "application/x-wiki", "title": "Edit this page", "href": "/w/index.php?title=Natural_language_processing&action=edit"}}, {"type": "link", "start": 41, "end": 41, "id": 27, "features": {"rel": "apple-touch-icon", "href": "/static/apple-touch/wikipedia.png"}}, {"type": "link", "start": 41, "end": 41, "id": 28, "features": {"rel": "icon", "href": "/static/favicon/wikipedia.ico"}}, {"type": "link", "start": 41, "end": 41, "id": 29, "features": {"rel": "search", "type": "application/opensearchdescription+xml", "href": "/w/opensearch_desc.php", "title": "Wikipedia (en)"}}, {"type": "link", "start": 41, "end": 41, "id": 30, "features": {"rel": "EditURI", "type": "application/rsd+xml", "href": "//en.wikipedia.org/w/api.php?action=rsd"}}, {"type": "link", "start": 41, "end": 41, "id": 31, "features": {"rel": "license", "href": "https://creativecommons.org/licenses/by-sa/3.0/"}}, {"type": "link", "start": 41, "end": 41, "id": 32, "features": {"rel": "canonical", "href": "https://en.wikipedia.org/wiki/Natural_language_processing"}}, {"type": "link", "start": 41, "end": 41, "id": 33, "features": {"rel": "dns-prefetch", "href": "//meta.wikimedia.org"}}, {"type": "link", "start": 41, "end": 41, "id": 34, "features": {"rel": "dns-prefetch", "href": "//login.wikimedia.org"}}, {"type": "body", "start": 41, "end": 44640, "id": 35, "features": {"class": "mediawiki ltr sitedir-ltr mw-hide-empty-elt ns-0 ns-subject mw-editable page-Natural_language_processing rootpage-Natural_language_processing stable issues-group-B skin-minerva action-view skin--responsive mw-mf-amc-disabled mw-mf"}}, {"type": "div", "start": 41, "end": 44640, "id": 36, "features": {"id": "mw-mf-viewport"}}, {"type": "div", "start": 41, "end": 44640, "id": 37, "features": {"id": "mw-mf-page-center"}}, {"type": "a", "start": 41, "end": 41, "id": 38, "features": {"class": "mw-mf-page-center__mask", "href": "#"}}, {"type": "header", "start": 41, "end": 133, "id": 39, "features": {"class": "header-container header-chrome"}}, {"type": "div", "start": 41, "end": 133, "id": 40, "features": {"class": "minerva-header"}}, {"type": "nav", "start": 41, "end": 126, "id": 41, "features": {"class": "navigation-drawer toggle-list view-border-box"}}, {"type": "input", "start": 41, "end": 41, "id": 42, "features": {"type": "checkbox", "id": "main-menu-input", "class": "toggle-list__checkbox", "role": "button", "aria-haspopup": "true", "aria-expanded": "false", "aria-labelledby": "mw-mf-main-menu-button"}}, {"type": "label", "start": 41, "end": 55, "id": 43, "features": {"for": "main-menu-input", "id": "mw-mf-main-menu-button", "aria-hidden": "true", "class": " mw-ui-button mw-ui-quiet mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-menu-base20 mw-ui-icon-flush-left toggle-list__toggle", "title": "Open main menu", "data-event-name": "ui.mainmenu"}}, {"type": "div", "start": 56, "end": 126, "id": 44, "features": {"id": "mw-mf-page-left", "class": "menu toggle-list__list view-border-box"}}, {"type": "ul", "start": 56, "end": 75, "id": 45, "features": {"id": "p-navigation"}}, {"type": "li", "start": 56, "end": 61, "id": 46, "features": {"class": ""}}, {"type": "a", "start": 56, "end": 61, "id": 47, "features": {"href": "/wiki/Main_Page", "class": "menu__item--home", "data-mw": "interface", "data-event-name": ""}}, {"type": "span", "start": 56, "end": 56, "id": 48, "features": {"class": "mw-ui-icon-minerva-home mw-ui-icon"}}, {"type": "span", "start": 56, "end": 60, "id": 49, "features": {}}, {"type": "li", "start": 61, "end": 68, "id": 50, "features": {"class": ""}}, {"type": "a", "start": 61, "end": 68, "id": 51, "features": {"href": "/wiki/Special:Random", "class": "menu__item--random", "data-mw": "interface", "data-event-name": ""}}, {"type": "span", "start": 61, "end": 61, "id": 52, "features": {"class": "mw-ui-icon-minerva-die mw-ui-icon"}}, {"type": "span", "start": 61, "end": 67, "id": 53, "features": {}}, {"type": "li", "start": 68, "end": 75, "id": 54, "features": {"class": "jsonly"}}, {"type": "a", "start": 68, "end": 75, "id": 55, "features": {"href": "/wiki/Special:Nearby", "class": "menu__item--nearby", "data-mw": "interface", "data-event-name": "menu.nearby"}}, {"type": "span", "start": 68, "end": 68, "id": 56, "features": {"class": "mw-ui-icon-minerva-mapPin mw-ui-icon"}}, {"type": "span", "start": 68, "end": 74, "id": 57, "features": {}}, {"type": "ul", "start": 75, "end": 82, "id": 58, "features": {"id": "p-personal"}}, {"type": "li", "start": 75, "end": 82, "id": 59, "features": {"class": ""}}, {"type": "a", "start": 75, "end": 82, "id": 60, "features": {"href": "/w/index.php?title=Special:UserLogin&returnto=Natural+language+processing", "class": "menu__item--login", "data-mw": "interface", "data-event-name": ""}}, {"type": "span", "start": 75, "end": 75, "id": 61, "features": {"class": "mw-ui-icon-minerva-logIn mw-ui-icon"}}, {"type": "span", "start": 75, "end": 81, "id": 62, "features": {}}, {"type": "ul", "start": 82, "end": 91, "id": 63, "features": {"id": "pt-preferences"}}, {"type": "li", "start": 82, "end": 91, "id": 64, "features": {"class": "jsonly"}}, {"type": "a", "start": 82, "end": 91, "id": 65, "features": {"href": "/w/index.php?title=Special:MobileOptions&returnto=Natural+language+processing", "class": "menu__item--settings", "data-mw": "interface", "data-event-name": "menu.settings"}}, {"type": "span", "start": 82, "end": 82, "id": 66, "features": {"class": "mw-ui-icon-minerva-settings mw-ui-icon"}}, {"type": "span", "start": 82, "end": 90, "id": 67, "features": {}}, {"type": "ul", "start": 91, "end": 98, "id": 68, "features": {"id": "p-donation"}}, {"type": "li", "start": 91, "end": 98, "id": 69, "features": {"class": ""}}, {"type": "a", "start": 91, "end": 98, "id": 70, "features": {"href": "https://donate.wikimedia.org/wiki/Special:FundraiserRedirector?utm_source=donate&utm_medium=sidebar&utm_campaign=C13_en.wikipedia.org&uselang=en&utm_key=minerva", "class": "menu__item--donate", "data-mw": "interface", "data-event-name": "menu.donate"}}, {"type": "span", "start": 91, "end": 91, "id": 71, "features": {"class": "mw-ui-icon-minerva-heart mw-ui-icon"}}, {"type": "span", "start": 91, "end": 97, "id": 72, "features": {}}, {"type": "ul", "start": 98, "end": 126, "id": 73, "features": {"class": "hlist"}}, {"type": "li", "start": 98, "end": 114, "id": 74, "features": {"class": ""}}, {"type": "a", "start": 98, "end": 114, "id": 75, "features": {"href": "/wiki/Wikipedia:About", "class": "menu__item--about", "data-mw": "interface", "data-event-name": ""}}, {"type": "span", "start": 98, "end": 98, "id": 76, "features": {"class": "mw-ui-icon-minerva-about mw-ui-icon"}}, {"type": "span", "start": 98, "end": 113, "id": 77, "features": {}}, {"type": "li", "start": 114, "end": 126, "id": 78, "features": {"class": ""}}, {"type": "a", "start": 114, "end": 126, "id": 79, "features": {"href": "/wiki/Wikipedia:General_disclaimer", "class": "menu__item--disclaimers", "data-mw": "interface", "data-event-name": ""}}, {"type": "span", "start": 114, "end": 114, "id": 80, "features": {"class": "mw-ui-icon-minerva-disclaimers mw-ui-icon"}}, {"type": "span", "start": 114, "end": 125, "id": 81, "features": {}}, {"type": "label", "start": 126, "end": 126, "id": 82, "features": {"class": "main-menu-mask", "for": "main-menu-input"}}, {"type": "div", "start": 126, "end": 126, "id": 83, "features": {"class": "branding-box"}}, {"type": "a", "start": 126, "end": 126, "id": 84, "features": {"href": "/wiki/Main_Page"}}, {"type": "span", "start": 126, "end": 126, "id": 85, "features": {}}, {"type": "img", "start": 126, "end": 126, "id": 86, "features": {"src": "/static/images/mobile/copyright/wikipedia-wordmark-en.svg", "alt": "Wikipedia", "width": "120", "height": "18", "style": "width: 7.5em; height: 1.125em;"}}, {"type": "form", "start": 126, "end": 133, "id": 87, "features": {"action": "/w/index.php", "method": "get", "class": "minerva-search-form"}}, {"type": "div", "start": 126, "end": 126, "id": 88, "features": {"class": "search-box"}}, {"type": "input", "start": 126, "end": 126, "id": 89, "features": {"type": "hidden", "name": "title", "value": "Special:Search"}}, {"type": "input", "start": 126, "end": 126, "id": 90, "features": {"class": "search mw-ui-background-icon-search skin-minerva-search-trigger", "type": "search", "name": "search", "id": "searchInput", "placeholder": "Search Wikipedia", "aria-label": "Search Wikipedia", "autocapitalize": "sentences", "title": "Search Wikipedia [f]", "accesskey": "f", "\"": ""}}, {"type": "button", "start": 126, "end": 132, "id": 91, "features": {"id": "searchIcon", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-search-base20 skin-minerva-search-trigger mw-ui-button mw-ui-quiet"}}, {"type": "nav", "start": 133, "end": 133, "id": 92, "features": {"class": "minerva-user-navigation", "aria-label": "User navigation"}}, {"type": "main", "start": 133, "end": 44351, "id": 93, "features": {"id": "content", "class": "mw-body"}}, {"type": "div", "start": 133, "end": 133, "id": 94, "features": {"class": "banner-container"}}, {"type": "div", "start": 133, "end": 133, "id": 95, "features": {"id": "siteNotice"}}, {"type": "div", "start": 133, "end": 194, "id": 96, "features": {"class": "pre-content heading-holder"}}, {"type": "div", "start": 133, "end": 161, "id": 97, "features": {"class": "page-heading"}}, {"type": "h1", "start": 133, "end": 161, "id": 98, "features": {"id": "firstHeading", "class": "firstHeading mw-first-heading"}}, {"type": "span", "start": 133, "end": 160, "id": 99, "features": {"class": "mw-page-title-main"}}, {"type": "div", "start": 161, "end": 161, "id": 100, "features": {"class": "tagline"}}, {"type": "div", "start": 161, "end": 174, "id": 101, "features": {"class": "minerva__tab-container"}}, {"type": "a", "start": 161, "end": 168, "id": 102, "features": {"href": "/wiki/Natural_language_processing", "rel": "", "class": "minerva__tab selected", "data-event-name": "tabs.subject"}}, {"type": "a", "start": 169, "end": 173, "id": 103, "features": {"href": "/wiki/Talk:Natural_language_processing", "rel": "discussion", "class": "minerva__tab ", "data-event-name": "tabs.talk"}}, {"type": "nav", "start": 174, "end": 194, "id": 104, "features": {"class": "page-actions-menu"}}, {"type": "ul", "start": 174, "end": 194, "id": 105, "features": {"id": "page-actions", "class": "page-actions-menu__list"}}, {"type": "li", "start": 174, "end": 183, "id": 106, "features": {"id": "language-selector", "class": "page-actions-menu__list-item"}}, {"type": "a", "start": 174, "end": 182, "id": 107, "features": {"id": "", "href": "/wiki/Special:MobileLanguages/Natural_language_processing", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-language-base20 mw-ui-button mw-ui-quiet mw-ui-icon-with-label-desktop mw-ui-button mw-ui-quiet  language-selector", "data-mw": "interface", "data-event-name": "menu.languages", "role": "button", "title": "Language"}}, {"type": "li", "start": 183, "end": 189, "id": 108, "features": {"id": "page-actions-watch", "class": "page-actions-menu__list-item"}}, {"type": "a", "start": 183, "end": 188, "id": 109, "features": {"id": "ca-watch", "href": "/w/index.php?title=Special:UserLogin&returnto=Natural+language+processing", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-star-base20 mw-ui-icon-with-label-desktop watch-this-article mw-ui-button mw-ui-quiet mw-watchlink menu__item--page-actions-watch", "data-mw": "interface", "data-event-name": "menu.watch", "role": "button", "title": "Watch"}}, {"type": "li", "start": 189, "end": 194, "id": 110, "features": {"id": "page-actions-edit", "class": "page-actions-menu__list-item"}}, {"type": "a", "start": 189, "end": 193, "id": 111, "features": {"id": "ca-edit", "href": "/w/index.php?title=Natural_language_processing&action=edit&section=0", "class": "edit-page menu__item--page-actions-edit mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 mw-ui-icon-with-label-desktop mw-ui-button mw-ui-quiet", "data-mw": "interface", "data-event-name": "menu.edit", "role": "button", "title": "Edit the lead section of this page"}}, {"type": "div", "start": 194, "end": 194, "id": 112, "features": {"class": "minerva__subtitle"}}, {"type": "div", "start": 194, "end": 44351, "id": 113, "features": {"id": "bodyContent", "class": "content"}}, {"type": "div", "start": 194, "end": 44351, "id": 114, "features": {"id": "mw-content-text", "class": "mw-body-content mw-content-ltr", "lang": "en", "dir": "ltr"}}, {"type": "div", "start": 194, "end": 44246, "id": 115, "features": {"class": "mw-parser-output"}}, {"type": "section", "start": 194, "end": 1894, "id": 116, "features": {"class": "mf-section-0", "id": "mf-section-0"}}, {"type": "div", "start": 194, "end": 362, "id": 117, "features": {"role": "note", "class": "hatnote navigation-not-searchable"}}, {"type": "a", "start": 328, "end": 360, "id": 118, "features": {"href": "/wiki/Language_processing_in_the_brain", "title": "Language processing in the brain"}}, {"type": "p", "start": 362, "end": 940, "id": 119, "features": {}}, {"type": "b", "start": 362, "end": 389, "id": 120, "features": {}}, {"type": "b", "start": 391, "end": 394, "id": 121, "features": {}}, {"type": "a", "start": 413, "end": 424, "id": 122, "features": {"href": "/wiki/Linguistics", "title": "Linguistics"}}, {"type": "a", "start": 426, "end": 442, "id": 123, "features": {"href": "/wiki/Computer_science", "title": "Computer science"}}, {"type": "a", "start": 448, "end": 471, "id": 124, "features": {"href": "/wiki/Artificial_intelligence", "title": "Artificial intelligence"}}, {"type": "a", "start": 621, "end": 637, "id": 125, "features": {"href": "/wiki/Natural_language", "title": "Natural language"}}, {"type": "a", "start": 736, "end": 746, "id": 126, "features": {"href": "/wiki/Context_(language_use)", "title": "Context (language use)"}}, {"type": "div", "start": 940, "end": 1102, "id": 127, "features": {"class": "thumb tright"}}, {"type": "div", "start": 940, "end": 1102, "id": 128, "features": {"class": "thumbinner", "style": "width:202px;"}}, {"type": "a", "start": 940, "end": 940, "id": 129, "features": {"href": "/wiki/File:Automated_online_assistant.png", "class": "image"}}, {"type": "img", "start": 940, "end": 940, "id": 130, "features": {"alt": "", "src": "//upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Automated_online_assistant.png/200px-Automated_online_assistant.png", "decoding": "async", "width": "200", "height": "251", "class": "thumbimage", "data-file-width": "400", "data-file-height": "501"}}, {"type": "div", "start": 942, "end": 1102, "id": 131, "features": {"class": "thumbcaption"}}, {"type": "div", "start": 942, "end": 942, "id": 132, "features": {"class": "magnify"}}, {"type": "a", "start": 942, "end": 942, "id": 133, "features": {"href": "/wiki/File:Automated_online_assistant.png", "class": "internal", "title": "Enlarge"}}, {"type": "a", "start": 945, "end": 971, "id": 134, "features": {"href": "/wiki/Automated_online_assistant", "class": "mw-redirect", "title": "Automated online assistant"}}, {"type": "a", "start": 982, "end": 998, "id": 135, "features": {"href": "/wiki/Customer_service", "title": "Customer service"}}, {"type": "sup", "start": 1098, "end": 1101, "id": 136, "features": {"id": "cite_ref-Kongthon_1-0", "class": "reference"}}, {"type": "a", "start": 1098, "end": 1101, "id": 137, "features": {"href": "#cite_note-Kongthon-1"}}, {"type": "p", "start": 1102, "end": 1248, "id": 138, "features": {}}, {"type": "a", "start": 1163, "end": 1181, "id": 139, "features": {"href": "/wiki/Speech_recognition", "title": "Speech recognition"}}, {"type": "a", "start": 1183, "end": 1213, "id": 140, "features": {"href": "/wiki/Natural-language_understanding", "title": "Natural-language understanding"}}, {"type": "a", "start": 1219, "end": 1246, "id": 141, "features": {"href": "/wiki/Natural_language_generation", "title": "Natural language generation"}}, {"type": "div", "start": 1248, "end": 1894, "id": 142, "features": {"id": "toc", "class": "toc", "role": "navigation", "aria-labelledby": "mw-toc-heading"}}, {"type": "input", "start": 1248, "end": 1248, "id": 143, "features": {"type": "checkbox", "role": "button", "id": "toctogglecheckbox", "class": "toctogglecheckbox", "style": "display:none"}}, {"type": "div", "start": 1248, "end": 1257, "id": 144, "features": {"class": "toctitle", "lang": "en", "dir": "ltr"}}, {"type": "h2", "start": 1248, "end": 1257, "id": 145, "features": {"id": "mw-toc-heading"}}, {"type": "span", "start": 1257, "end": 1257, "id": 146, "features": {"class": "toctogglespan"}}, {"type": "label", "start": 1257, "end": 1257, "id": 147, "features": {"class": "toctogglelabel", "for": "toctogglecheckbox"}}, {"type": "ul", "start": 1257, "end": 1894, "id": 148, "features": {}}, {"type": "li", "start": 1257, "end": 1365, "id": 149, "features": {"class": "toclevel-1 tocsection-1"}}, {"type": "a", "start": 1257, "end": 1266, "id": 150, "features": {"href": "#History"}}, {"type": "span", "start": 1257, "end": 1258, "id": 151, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1259, "end": 1266, "id": 152, "features": {"class": "toctext"}}, {"type": "ul", "start": 1267, "end": 1365, "id": 153, "features": {}}, {"type": "li", "start": 1267, "end": 1306, "id": 154, "features": {"class": "toclevel-2 tocsection-2"}}, {"type": "a", "start": 1267, "end": 1305, "id": 155, "features": {"href": "#Symbolic_NLP_(1950s_%E2%80%93_early_1990s)"}}, {"type": "span", "start": 1267, "end": 1270, "id": 156, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1271, "end": 1305, "id": 157, "features": {"class": "toctext"}}, {"type": "li", "start": 1306, "end": 1340, "id": 158, "features": {"class": "toclevel-2 tocsection-3"}}, {"type": "a", "start": 1306, "end": 1339, "id": 159, "features": {"href": "#Statistical_NLP_(1990s%E2%80%932010s)"}}, {"type": "span", "start": 1306, "end": 1309, "id": 160, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1310, "end": 1339, "id": 161, "features": {"class": "toctext"}}, {"type": "li", "start": 1340, "end": 1365, "id": 162, "features": {"class": "toclevel-2 tocsection-4"}}, {"type": "a", "start": 1340, "end": 1364, "id": 163, "features": {"href": "#Neural_NLP_(present)"}}, {"type": "span", "start": 1340, "end": 1343, "id": 164, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1344, "end": 1364, "id": 165, "features": {"class": "toctext"}}, {"type": "li", "start": 1365, "end": 1455, "id": 166, "features": {"class": "toclevel-1 tocsection-5"}}, {"type": "a", "start": 1365, "end": 1410, "id": 167, "features": {"href": "#Methods:_Rules,_statistics,_neural_networks"}}, {"type": "span", "start": 1365, "end": 1366, "id": 168, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1367, "end": 1410, "id": 169, "features": {"class": "toctext"}}, {"type": "ul", "start": 1411, "end": 1455, "id": 170, "features": {}}, {"type": "li", "start": 1411, "end": 1435, "id": 171, "features": {"class": "toclevel-2 tocsection-6"}}, {"type": "a", "start": 1411, "end": 1434, "id": 172, "features": {"href": "#Statistical_methods"}}, {"type": "span", "start": 1411, "end": 1414, "id": 173, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1415, "end": 1434, "id": 174, "features": {"class": "toctext"}}, {"type": "li", "start": 1435, "end": 1455, "id": 175, "features": {"class": "toclevel-2 tocsection-7"}}, {"type": "a", "start": 1435, "end": 1454, "id": 176, "features": {"href": "#Neural_networks"}}, {"type": "span", "start": 1435, "end": 1438, "id": 177, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1439, "end": 1454, "id": 178, "features": {"class": "toctext"}}, {"type": "li", "start": 1455, "end": 1759, "id": 179, "features": {"class": "toclevel-1 tocsection-8"}}, {"type": "a", "start": 1455, "end": 1473, "id": 180, "features": {"href": "#Common_NLP_tasks"}}, {"type": "span", "start": 1455, "end": 1456, "id": 181, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1457, "end": 1473, "id": 182, "features": {"class": "toctext"}}, {"type": "ul", "start": 1474, "end": 1759, "id": 183, "features": {}}, {"type": "li", "start": 1474, "end": 1505, "id": 184, "features": {"class": "toclevel-2 tocsection-9"}}, {"type": "a", "start": 1474, "end": 1504, "id": 185, "features": {"href": "#Text_and_speech_processing"}}, {"type": "span", "start": 1474, "end": 1477, "id": 186, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1478, "end": 1504, "id": 187, "features": {"class": "toctext"}}, {"type": "li", "start": 1505, "end": 1532, "id": 188, "features": {"class": "toclevel-2 tocsection-10"}}, {"type": "a", "start": 1505, "end": 1531, "id": 189, "features": {"href": "#Morphological_analysis"}}, {"type": "span", "start": 1505, "end": 1508, "id": 190, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1509, "end": 1531, "id": 191, "features": {"class": "toctext"}}, {"type": "li", "start": 1532, "end": 1555, "id": 192, "features": {"class": "toclevel-2 tocsection-11"}}, {"type": "a", "start": 1532, "end": 1554, "id": 193, "features": {"href": "#Syntactic_analysis"}}, {"type": "span", "start": 1532, "end": 1535, "id": 194, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1536, "end": 1554, "id": 195, "features": {"class": "toctext"}}, {"type": "li", "start": 1555, "end": 1610, "id": 196, "features": {"class": "toclevel-2 tocsection-12"}}, {"type": "a", "start": 1555, "end": 1609, "id": 197, "features": {"href": "#Lexical_semantics_(of_individual_words_in_context)"}}, {"type": "span", "start": 1555, "end": 1558, "id": 198, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1559, "end": 1609, "id": 199, "features": {"class": "toctext"}}, {"type": "li", "start": 1610, "end": 1671, "id": 200, "features": {"class": "toclevel-2 tocsection-13"}}, {"type": "a", "start": 1610, "end": 1670, "id": 201, "features": {"href": "#Relational_semantics_(semantics_of_individual_sentences)"}}, {"type": "span", "start": 1610, "end": 1613, "id": 202, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1614, "end": 1670, "id": 203, "features": {"class": "toctext"}}, {"type": "li", "start": 1671, "end": 1725, "id": 204, "features": {"class": "toclevel-2 tocsection-14"}}, {"type": "a", "start": 1671, "end": 1724, "id": 205, "features": {"href": "#Discourse_(semantics_beyond_individual_sentences)"}}, {"type": "span", "start": 1671, "end": 1674, "id": 206, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1675, "end": 1724, "id": 207, "features": {"class": "toctext"}}, {"type": "li", "start": 1725, "end": 1759, "id": 208, "features": {"class": "toclevel-2 tocsection-15"}}, {"type": "a", "start": 1725, "end": 1758, "id": 209, "features": {"href": "#Higher-level_NLP_applications"}}, {"type": "span", "start": 1725, "end": 1728, "id": 210, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1729, "end": 1758, "id": 211, "features": {"class": "toctext"}}, {"type": "li", "start": 1759, "end": 1835, "id": 212, "features": {"class": "toclevel-1 tocsection-16"}}, {"type": "a", "start": 1759, "end": 1812, "id": 213, "features": {"href": "#General_tendencies_and_(possible)_future_directions"}}, {"type": "span", "start": 1759, "end": 1760, "id": 214, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1761, "end": 1812, "id": 215, "features": {"class": "toctext"}}, {"type": "ul", "start": 1813, "end": 1835, "id": 216, "features": {}}, {"type": "li", "start": 1813, "end": 1835, "id": 217, "features": {"class": "toclevel-2 tocsection-17"}}, {"type": "a", "start": 1813, "end": 1834, "id": 218, "features": {"href": "#Cognition_and_NLP"}}, {"type": "span", "start": 1813, "end": 1816, "id": 219, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1817, "end": 1834, "id": 220, "features": {"class": "toctext"}}, {"type": "li", "start": 1835, "end": 1846, "id": 221, "features": {"class": "toclevel-1 tocsection-18"}}, {"type": "a", "start": 1835, "end": 1845, "id": 222, "features": {"href": "#See_also"}}, {"type": "span", "start": 1835, "end": 1836, "id": 223, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1837, "end": 1845, "id": 224, "features": {"class": "toctext"}}, {"type": "li", "start": 1846, "end": 1859, "id": 225, "features": {"class": "toclevel-1 tocsection-19"}}, {"type": "a", "start": 1846, "end": 1858, "id": 226, "features": {"href": "#References"}}, {"type": "span", "start": 1846, "end": 1847, "id": 227, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1848, "end": 1858, "id": 228, "features": {"class": "toctext"}}, {"type": "li", "start": 1859, "end": 1877, "id": 229, "features": {"class": "toclevel-1 tocsection-20"}}, {"type": "a", "start": 1859, "end": 1876, "id": 230, "features": {"href": "#Further_reading"}}, {"type": "span", "start": 1859, "end": 1860, "id": 231, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1861, "end": 1876, "id": 232, "features": {"class": "toctext"}}, {"type": "li", "start": 1877, "end": 1894, "id": 233, "features": {"class": "toclevel-1 tocsection-21"}}, {"type": "a", "start": 1877, "end": 1893, "id": 234, "features": {"href": "#External_links"}}, {"type": "span", "start": 1877, "end": 1878, "id": 235, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1879, "end": 1893, "id": 236, "features": {"class": "toctext"}}, {"type": "h2", "start": 1894, "end": 1906, "id": 237, "features": {"class": "section-heading", "onclick": "mfTempOpenSection(1)"}}, {"type": "div", "start": 1894, "end": 1894, "id": 238, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left mw-ui-button mw-ui-quiet"}}, {"type": "span", "start": 1894, "end": 1901, "id": 239, "features": {"class": "mw-headline", "id": "History"}}, {"type": "span", "start": 1901, "end": 1905, "id": 240, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 1901, "end": 1905, "id": 241, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=1", "title": "Edit section: History", "data-section": "1", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "section", "start": 1906, "end": 7929, "id": 242, "features": {"class": "mf-section-1 collapsible-block", "id": "mf-section-1"}}, {"type": "link", "start": 1906, "end": 1906, "id": 243, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1033289096"}}, {"type": "div", "start": 1906, "end": 1966, "id": 244, "features": {"role": "note", "class": "hatnote navigation-not-searchable"}}, {"type": "a", "start": 1927, "end": 1965, "id": 245, "features": {"href": "/wiki/History_of_natural_language_processing", "title": "History of natural language processing"}}, {"type": "p", "start": 1966, "end": 2409, "id": 246, "features": {}}, {"type": "a", "start": 2039, "end": 2050, "id": 247, "features": {"href": "/wiki/Alan_Turing", "title": "Alan Turing"}}, {"type": "a", "start": 2080, "end": 2116, "id": 248, "features": {"href": "/wiki/Computing_Machinery_and_Intelligence", "title": "Computing Machinery and Intelligence"}}, {"type": "a", "start": 2156, "end": 2167, "id": 249, "features": {"href": "/wiki/Turing_test", "title": "Turing test"}}, {"type": "h3", "start": 2409, "end": 2448, "id": 250, "features": {"class": "in-block"}}, {"type": "span", "start": 2409, "end": 2409, "id": 251, "features": {"id": "Symbolic_NLP_.281950s_.E2.80.93_early_1990s.29"}}, {"type": "span", "start": 2409, "end": 2443, "id": 252, "features": {"class": "mw-headline", "id": "Symbolic_NLP_(1950s_\u2013_early_1990s)"}}, {"type": "span", "start": 2443, "end": 2447, "id": 253, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 2443, "end": 2447, "id": 254, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=2", "title": "Edit section: Symbolic NLP (1950s \u2013 early 1990s)", "data-section": "2", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "p", "start": 2448, "end": 2756, "id": 255, "features": {}}, {"type": "a", "start": 2498, "end": 2509, "id": 256, "features": {"href": "/wiki/John_Searle", "title": "John Searle"}}, {"type": "a", "start": 2512, "end": 2524, "id": 257, "features": {"href": "/wiki/Chinese_room", "title": "Chinese room"}}, {"type": "ul", "start": 2756, "end": 5097, "id": 258, "features": {}}, {"type": "li", "start": 2756, "end": 3357, "id": 259, "features": {}}, {"type": "b", "start": 2756, "end": 2761, "id": 260, "features": {}}, {"type": "a", "start": 2767, "end": 2788, "id": 261, "features": {"href": "/wiki/Georgetown-IBM_experiment", "class": "mw-redirect", "title": "Georgetown-IBM experiment"}}, {"type": "a", "start": 2812, "end": 2833, "id": 262, "features": {"href": "/wiki/Automatic_translation", "class": "mw-redirect", "title": "Automatic translation"}}, {"type": "sup", "start": 2984, "end": 2987, "id": 263, "features": {"id": "cite_ref-2", "class": "reference"}}, {"type": "a", "start": 2984, "end": 2987, "id": 264, "features": {"href": "#cite_note-2"}}, {"type": "a", "start": 3043, "end": 3055, "id": 265, "features": {"href": "/wiki/ALPAC", "title": "ALPAC"}}, {"type": "a", "start": 3301, "end": 3332, "id": 266, "features": {"href": "/wiki/Statistical_machine_translation", "title": "Statistical machine translation"}}, {"type": "li", "start": 3357, "end": 3967, "id": 267, "features": {}}, {"type": "b", "start": 3357, "end": 3362, "id": 268, "features": {}}, {"type": "a", "start": 3452, "end": 3458, "id": 269, "features": {"href": "/wiki/SHRDLU", "title": "SHRDLU"}}, {"type": "a", "start": 3509, "end": 3522, "id": 270, "features": {"href": "/wiki/Blocks_world", "title": "Blocks world"}}, {"type": "a", "start": 3558, "end": 3563, "id": 271, "features": {"href": "/wiki/ELIZA", "title": "ELIZA"}}, {"type": "a", "start": 3583, "end": 3607, "id": 272, "features": {"href": "/wiki/Rogerian_psychotherapy", "class": "mw-redirect", "title": "Rogerian psychotherapy"}}, {"type": "a", "start": 3620, "end": 3637, "id": 273, "features": {"href": "/wiki/Joseph_Weizenbaum", "title": "Joseph Weizenbaum"}}, {"type": "li", "start": 3967, "end": 4384, "id": 274, "features": {}}, {"type": "b", "start": 3967, "end": 3972, "id": 275, "features": {}}, {"type": "a", "start": 4036, "end": 4046, "id": 276, "features": {"href": "/wiki/Ontology_(information_science)", "title": "Ontology (information science)"}}, {"type": "a", "start": 4344, "end": 4355, "id": 277, "features": {"href": "/wiki/Chatterbots", "class": "mw-redirect", "title": "Chatterbots"}}, {"type": "a", "start": 4376, "end": 4381, "id": 278, "features": {"href": "/wiki/PARRY", "title": "PARRY"}}, {"type": "li", "start": 4384, "end": 5097, "id": 279, "features": {}}, {"type": "b", "start": 4384, "end": 4389, "id": 280, "features": {}}, {"type": "a", "start": 4551, "end": 4555, "id": 281, "features": {"href": "/wiki/Head-driven_phrase_structure_grammar", "title": "Head-driven phrase structure grammar"}}, {"type": "a", "start": 4597, "end": 4615, "id": 282, "features": {"href": "/wiki/Generative_grammar", "title": "Generative grammar"}}, {"type": "sup", "start": 4656, "end": 4659, "id": 283, "features": {"id": "cite_ref-3", "class": "reference"}}, {"type": "a", "start": 4656, "end": 4659, "id": 284, "features": {"href": "#cite_note-3"}}, {"type": "a", "start": 4679, "end": 4693, "id": 285, "features": {"href": "/wiki/Lesk_algorithm", "title": "Lesk algorithm"}}, {"type": "sup", "start": 4736, "end": 4739, "id": 286, "features": {"id": "cite_ref-4", "class": "reference"}}, {"type": "a", "start": 4736, "end": 4739, "id": 287, "features": {"href": "#cite_note-4"}}, {"type": "a", "start": 4805, "end": 4832, "id": 288, "features": {"href": "/wiki/Rhetorical_structure_theory", "title": "Rhetorical structure theory"}}, {"type": "a", "start": 4917, "end": 4923, "id": 289, "features": {"href": "/wiki/Racter", "title": "Racter"}}, {"type": "a", "start": 4928, "end": 4939, "id": 290, "features": {"href": "/wiki/Jabberwacky", "title": "Jabberwacky"}}, {"type": "sup", "start": 5093, "end": 5096, "id": 291, "features": {"id": "cite_ref-5", "class": "reference"}}, {"type": "a", "start": 5093, "end": 5096, "id": 292, "features": {"href": "#cite_note-5"}}, {"type": "h3", "start": 5097, "end": 5131, "id": 293, "features": {"class": "in-block"}}, {"type": "span", "start": 5097, "end": 5097, "id": 294, "features": {"id": "Statistical_NLP_.281990s.E2.80.932010s.29"}}, {"type": "span", "start": 5097, "end": 5126, "id": 295, "features": {"class": "mw-headline", "id": "Statistical_NLP_(1990s\u20132010s)"}}, {"type": "span", "start": 5126, "end": 5130, "id": 296, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 5126, "end": 5130, "id": 297, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=3", "title": "Edit section: Statistical NLP (1990s\u20132010s)", "data-section": "3", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "p", "start": 5131, "end": 5752, "id": 298, "features": {}}, {"type": "a", "start": 5356, "end": 5372, "id": 299, "features": {"href": "/wiki/Machine_learning", "title": "Machine learning"}}, {"type": "a", "start": 5479, "end": 5490, "id": 300, "features": {"href": "/wiki/Moore%27s_law", "title": "Moore's law"}}, {"type": "a", "start": 5538, "end": 5547, "id": 301, "features": {"href": "/wiki/Noam_Chomsky", "title": "Noam Chomsky"}}, {"type": "a", "start": 5578, "end": 5602, "id": 302, "features": {"href": "/wiki/Transformational_grammar", "title": "Transformational grammar"}}, {"type": "a", "start": 5661, "end": 5679, "id": 303, "features": {"href": "/wiki/Corpus_linguistics", "title": "Corpus linguistics"}}, {"type": "sup", "start": 5748, "end": 5751, "id": 304, "features": {"id": "cite_ref-6", "class": "reference"}}, {"type": "a", "start": 5748, "end": 5751, "id": 305, "features": {"href": "#cite_note-6"}}, {"type": "ul", "start": 5752, "end": 7344, "id": 306, "features": {}}, {"type": "li", "start": 5752, "end": 6546, "id": 307, "features": {}}, {"type": "b", "start": 5752, "end": 5757, "id": 308, "features": {}}, {"type": "a", "start": 5850, "end": 5869, "id": 309, "features": {"href": "/wiki/Machine_translation", "title": "Machine translation"}}, {"type": "a", "start": 5979, "end": 5994, "id": 310, "features": {"href": "/wiki/Text_corpus", "title": "Text corpus"}}, {"type": "a", "start": 6025, "end": 6045, "id": 311, "features": {"href": "/wiki/Parliament_of_Canada", "title": "Parliament of Canada"}}, {"type": "a", "start": 6054, "end": 6068, "id": 312, "features": {"href": "/wiki/European_Union", "title": "European Union"}}, {"type": "li", "start": 6546, "end": 7344, "id": 313, "features": {}}, {"type": "b", "start": 6546, "end": 6551, "id": 314, "features": {}}, {"type": "a", "start": 6719, "end": 6731, "id": 315, "features": {"href": "/wiki/Unsupervised_learning", "title": "Unsupervised learning"}}, {"type": "a", "start": 6736, "end": 6760, "id": 316, "features": {"href": "/wiki/Semi-supervised_learning", "class": "mw-redirect", "title": "Semi-supervised learning"}}, {"type": "a", "start": 6978, "end": 6997, "id": 317, "features": {"href": "/wiki/Supervised_learning", "title": "Supervised learning"}}, {"type": "a", "start": 7206, "end": 7220, "id": 318, "features": {"href": "/wiki/World_Wide_Web", "title": "World Wide Web"}}, {"type": "a", "start": 7311, "end": 7326, "id": 319, "features": {"href": "/wiki/Time_complexity", "title": "Time complexity"}}, {"type": "h3", "start": 7344, "end": 7369, "id": 320, "features": {"class": "in-block"}}, {"type": "span", "start": 7344, "end": 7344, "id": 321, "features": {"id": "Neural_NLP_.28present.29"}}, {"type": "span", "start": 7344, "end": 7364, "id": 322, "features": {"class": "mw-headline", "id": "Neural_NLP_(present)"}}, {"type": "span", "start": 7364, "end": 7368, "id": 323, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 7364, "end": 7368, "id": 324, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=4", "title": "Edit section: Neural NLP (present)", "data-section": "4", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "p", "start": 7369, "end": 7929, "id": 325, "features": {}}, {"type": "a", "start": 7383, "end": 7406, "id": 326, "features": {"href": "/wiki/Representation_learning", "class": "mw-redirect", "title": "Representation learning"}}, {"type": "a", "start": 7411, "end": 7430, "id": 327, "features": {"href": "/wiki/Deep_learning", "title": "Deep learning"}}, {"type": "sup", "start": 7594, "end": 7597, "id": 328, "features": {"id": "cite_ref-goldberg:nnlp17_7-0", "class": "reference"}}, {"type": "a", "start": 7594, "end": 7597, "id": 329, "features": {"href": "#cite_note-goldberg:nnlp17-7"}}, {"type": "sup", "start": 7597, "end": 7600, "id": 330, "features": {"id": "cite_ref-goodfellow:book16_8-0", "class": "reference"}}, {"type": "a", "start": 7597, "end": 7600, "id": 331, "features": {"href": "#cite_note-goodfellow:book16-8"}}, {"type": "a", "start": 7679, "end": 7696, "id": 332, "features": {"href": "/wiki/Language_modeling", "class": "mw-redirect", "title": "Language modeling"}}, {"type": "sup", "start": 7696, "end": 7699, "id": 333, "features": {"id": "cite_ref-jozefowicz:lm16_9-0", "class": "reference"}}, {"type": "a", "start": 7696, "end": 7699, "id": 334, "features": {"href": "#cite_note-jozefowicz:lm16-9"}}, {"type": "sup", "start": 7712, "end": 7716, "id": 335, "features": {"id": "cite_ref-choe:emnlp16_10-0", "class": "reference"}}, {"type": "a", "start": 7712, "end": 7716, "id": 336, "features": {"href": "#cite_note-choe:emnlp16-10"}}, {"type": "sup", "start": 7716, "end": 7720, "id": 337, "features": {"id": "cite_ref-vinyals:nips15_11-0", "class": "reference"}}, {"type": "a", "start": 7716, "end": 7720, "id": 338, "features": {"href": "#cite_note-vinyals:nips15-11"}}, {"type": "a", "start": 7752, "end": 7778, "id": 339, "features": {"href": "/wiki/Artificial_intelligence_in_healthcare", "title": "Artificial intelligence in healthcare"}}, {"type": "a", "start": 7822, "end": 7847, "id": 340, "features": {"href": "/wiki/Electronic_health_record", "title": "Electronic health record"}}, {"type": "sup", "start": 7924, "end": 7928, "id": 341, "features": {"id": "cite_ref-12", "class": "reference"}}, {"type": "a", "start": 7924, "end": 7928, "id": 342, "features": {"href": "#cite_note-12"}}, {"type": "h2", "start": 7929, "end": 7977, "id": 343, "features": {"class": "section-heading", "onclick": "mfTempOpenSection(2)"}}, {"type": "div", "start": 7929, "end": 7929, "id": 344, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left mw-ui-button mw-ui-quiet"}}, {"type": "span", "start": 7929, "end": 7929, "id": 345, "features": {"id": "Methods:_Rules.2C_statistics.2C_neural_networks"}}, {"type": "span", "start": 7929, "end": 7972, "id": 346, "features": {"class": "mw-headline", "id": "Methods:_Rules,_statistics,_neural_networks"}}, {"type": "span", "start": 7972, "end": 7972, "id": 347, "features": {"class": "anchor", "id": "Statistical_natural_language_processing_(SNLP)"}}, {"type": "span", "start": 7972, "end": 7976, "id": 348, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 7972, "end": 7976, "id": 349, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=5", "title": "Edit section: Methods: Rules, statistics, neural networks", "data-section": "5", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "section", "start": 7977, "end": 13514, "id": 350, "features": {"class": "mf-section-2 collapsible-block", "id": "mf-section-2"}}, {"type": "p", "start": 7977, "end": 8217, "id": 351, "features": {}}, {"type": "sup", "start": 8138, "end": 8142, "id": 352, "features": {"id": "cite_ref-winograd:shrdlu71_13-0", "class": "reference"}}, {"type": "a", "start": 8138, "end": 8142, "id": 353, "features": {"href": "#cite_note-winograd:shrdlu71-13"}}, {"type": "sup", "start": 8142, "end": 8146, "id": 354, "features": {"id": "cite_ref-schank77_14-0", "class": "reference"}}, {"type": "a", "start": 8142, "end": 8146, "id": 355, "features": {"href": "#cite_note-schank77-14"}}, {"type": "a", "start": 8207, "end": 8215, "id": 356, "features": {"href": "/wiki/Stemming", "title": "Stemming"}}, {"type": "p", "start": 8217, "end": 8322, "id": 357, "features": {}}, {"type": "a", "start": 8246, "end": 8262, "id": 358, "features": {"href": "/wiki/Machine_learning", "title": "Machine learning"}}, {"type": "ul", "start": 8322, "end": 9658, "id": 359, "features": {}}, {"type": "li", "start": 8322, "end": 8524, "id": 360, "features": {}}, {"type": "li", "start": 8524, "end": 9015, "id": 361, "features": {}}, {"type": "li", "start": 9015, "end": 9658, "id": 362, "features": {}}, {"type": "p", "start": 9658, "end": 9767, "id": 363, "features": {}}, {"type": "ul", "start": 9767, "end": 10143, "id": 364, "features": {}}, {"type": "li", "start": 9767, "end": 9965, "id": 365, "features": {}}, {"type": "a", "start": 9948, "end": 9956, "id": 366, "features": {"href": "/wiki/Apertium", "title": "Apertium"}}, {"type": "li", "start": 9965, "end": 10024, "id": 367, "features": {}}, {"type": "a", "start": 10007, "end": 10019, "id": 368, "features": {"href": "/wiki/Tokenization_(lexical_analysis)", "class": "mw-redirect", "title": "Tokenization (lexical analysis)"}}, {"type": "li", "start": 10024, "end": 10143, "id": 369, "features": {}}, {"type": "a", "start": 10099, "end": 10119, "id": 370, "features": {"href": "/wiki/Knowledge_extraction", "title": "Knowledge extraction"}}, {"type": "h3", "start": 10143, "end": 10167, "id": 371, "features": {"class": "in-block"}}, {"type": "span", "start": 10143, "end": 10162, "id": 372, "features": {"class": "mw-headline", "id": "Statistical_methods"}}, {"type": "span", "start": 10162, "end": 10166, "id": 373, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 10162, "end": 10166, "id": 374, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=6", "title": "Edit section: Statistical methods", "data-section": "6", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "p", "start": 10167, "end": 10611, "id": 375, "features": {}}, {"type": "sup", "start": 10211, "end": 10215, "id": 376, "features": {"id": "cite_ref-johnson:eacl:ilcl09_15-0", "class": "reference"}}, {"type": "a", "start": 10211, "end": 10215, "id": 377, "features": {"href": "#cite_note-johnson:eacl:ilcl09-15"}}, {"type": "sup", "start": 10215, "end": 10219, "id": 378, "features": {"id": "cite_ref-resnik:langlog11_16-0", "class": "reference"}}, {"type": "a", "start": 10215, "end": 10219, "id": 379, "features": {"href": "#cite_note-resnik:langlog11-16"}}, {"type": "a", "start": 10389, "end": 10410, "id": 380, "features": {"href": "/wiki/Statistical_inference", "title": "Statistical inference"}}, {"type": "i", "start": 10475, "end": 10482, "id": 381, "features": {}}, {"type": "a", "start": 10475, "end": 10482, "id": 382, "features": {"href": "/wiki/Text_corpus", "title": "Text corpus"}}, {"type": "i", "start": 10503, "end": 10509, "id": 383, "features": {}}, {"type": "p", "start": 10611, "end": 11327, "id": 384, "features": {}}, {"type": "a", "start": 10865, "end": 10883, "id": 385, "features": {"href": "/wiki/Statistical_models", "class": "mw-redirect", "title": "Statistical models"}}, {"type": "a", "start": 10902, "end": 10915, "id": 386, "features": {"href": "/wiki/Probabilistic", "class": "mw-redirect", "title": "Probabilistic"}}, {"type": "a", "start": 10945, "end": 10956, "id": 387, "features": {"href": "/wiki/Real-valued", "class": "mw-redirect", "title": "Real-valued"}}, {"type": "a", "start": 11003, "end": 11013, "id": 388, "features": {"href": "/wiki/Word_embedding", "title": "Word embedding"}}, {"type": "sup", "start": 11014, "end": 11018, "id": 389, "features": {"id": "cite_ref-17", "class": "reference"}}, {"type": "a", "start": 11014, "end": 11018, "id": 390, "features": {"href": "#cite_note-17"}}, {"type": "sup", "start": 11090, "end": 11094, "id": 391, "features": {"id": "cite_ref-18", "class": "reference"}}, {"type": "a", "start": 11090, "end": 11094, "id": 392, "features": {"href": "#cite_note-18"}}, {"type": "p", "start": 11327, "end": 12144, "id": 393, "features": {}}, {"type": "a", "start": 11390, "end": 11404, "id": 394, "features": {"href": "/wiki/Decision_tree", "title": "Decision tree"}}, {"type": "a", "start": 11495, "end": 11517, "id": 395, "features": {"href": "/wiki/Part_of_speech_tagging", "class": "mw-redirect", "title": "Part of speech tagging"}}, {"type": "a", "start": 11540, "end": 11560, "id": 396, "features": {"href": "/wiki/Hidden_Markov_models", "class": "mw-redirect", "title": "Hidden Markov models"}}, {"type": "a", "start": 11715, "end": 11726, "id": 397, "features": {"href": "/wiki/Real-valued", "class": "mw-redirect", "title": "Real-valued"}}, {"type": "a", "start": 11781, "end": 11802, "id": 398, "features": {"href": "/wiki/Cache_language_model", "title": "Cache language model"}}, {"type": "a", "start": 11819, "end": 11837, "id": 399, "features": {"href": "/wiki/Speech_recognition", "title": "Speech recognition"}}, {"type": "p", "start": 12144, "end": 12369, "id": 400, "features": {}}, {"type": "h3", "start": 12369, "end": 12389, "id": 401, "features": {"class": "in-block"}}, {"type": "span", "start": 12369, "end": 12384, "id": 402, "features": {"class": "mw-headline", "id": "Neural_networks"}}, {"type": "span", "start": 12384, "end": 12388, "id": 403, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 12384, "end": 12388, "id": 404, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=7", "title": "Edit section: Neural networks", "data-section": "7", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "link", "start": 12389, "end": 12389, "id": 405, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1033289096"}}, {"type": "div", "start": 12389, "end": 12436, "id": 406, "features": {"role": "note", "class": "hatnote navigation-not-searchable"}}, {"type": "a", "start": 12410, "end": 12435, "id": 407, "features": {"href": "/wiki/Artificial_neural_network", "title": "Artificial neural network"}}, {"type": "p", "start": 12436, "end": 13514, "id": 408, "features": {}}, {"type": "sup", "start": 12539, "end": 12543, "id": 409, "features": {"id": "cite_ref-19", "class": "reference"}}, {"type": "a", "start": 12539, "end": 12543, "id": 410, "features": {"href": "#cite_note-19"}}, {"type": "a", "start": 12616, "end": 12631, "id": 411, "features": {"href": "/wiki/Neural_network", "title": "Neural network"}}, {"type": "a", "start": 12692, "end": 12707, "id": 412, "features": {"href": "/wiki/Word_embedding", "title": "Word embedding"}}, {"type": "i", "start": 13206, "end": 13232, "id": 413, "features": {}}, {"type": "a", "start": 13206, "end": 13232, "id": 414, "features": {"href": "/wiki/Neural_machine_translation", "title": "Neural machine translation"}}, {"type": "a", "start": 13333, "end": 13353, "id": 415, "features": {"href": "/wiki/Seq2seq", "title": "Seq2seq"}}, {"type": "a", "start": 13475, "end": 13506, "id": 416, "features": {"href": "/wiki/Statistical_machine_translation", "title": "Statistical machine translation"}}, {"type": "h2", "start": 13514, "end": 13535, "id": 417, "features": {"class": "section-heading", "onclick": "mfTempOpenSection(3)"}}, {"type": "div", "start": 13514, "end": 13514, "id": 418, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left mw-ui-button mw-ui-quiet"}}, {"type": "span", "start": 13514, "end": 13530, "id": 419, "features": {"class": "mw-headline", "id": "Common_NLP_tasks"}}, {"type": "span", "start": 13530, "end": 13534, "id": 420, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 13530, "end": 13534, "id": 421, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=8", "title": "Edit section: Common NLP tasks", "data-section": "8", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "section", "start": 13535, "end": 28193, "id": 422, "features": {"class": "mf-section-3 collapsible-block", "id": "mf-section-3"}}, {"type": "p", "start": 13535, "end": 13785, "id": 423, "features": {}}, {"type": "p", "start": 13785, "end": 13941, "id": 424, "features": {}}, {"type": "h3", "start": 13941, "end": 13972, "id": 425, "features": {"class": "in-block"}}, {"type": "span", "start": 13941, "end": 13967, "id": 426, "features": {"class": "mw-headline", "id": "Text_and_speech_processing"}}, {"type": "span", "start": 13967, "end": 13971, "id": 427, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 13967, "end": 13971, "id": 428, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=9", "title": "Edit section: Text and speech processing", "data-section": "9", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "dl", "start": 13972, "end": 14083, "id": 429, "features": {}}, {"type": "dt", "start": 13972, "end": 14007, "id": 430, "features": {}}, {"type": "a", "start": 13972, "end": 14001, "id": 431, "features": {"href": "/wiki/Optical_character_recognition", "title": "Optical character recognition"}}, {"type": "dd", "start": 14008, "end": 14083, "id": 432, "features": {}}, {"type": "dl", "start": 14083, "end": 15121, "id": 433, "features": {}}, {"type": "dt", "start": 14083, "end": 14101, "id": 434, "features": {}}, {"type": "a", "start": 14083, "end": 14101, "id": 435, "features": {"href": "/wiki/Speech_recognition", "title": "Speech recognition"}}, {"type": "dd", "start": 14102, "end": 14962, "id": 436, "features": {}}, {"type": "a", "start": 14230, "end": 14244, "id": 437, "features": {"href": "/wiki/Text_to_speech", "class": "mw-redirect", "title": "Text to speech"}}, {"type": "a", "start": 14313, "end": 14324, "id": 438, "features": {"href": "/wiki/AI-complete", "title": "AI-complete"}}, {"type": "a", "start": 14343, "end": 14357, "id": 439, "features": {"href": "/wiki/Natural_speech", "class": "mw-redirect", "title": "Natural speech"}}, {"type": "a", "start": 14421, "end": 14440, "id": 440, "features": {"href": "/wiki/Speech_segmentation", "title": "Speech segmentation"}}, {"type": "a", "start": 14610, "end": 14624, "id": 441, "features": {"href": "/wiki/Coarticulation", "title": "Coarticulation"}}, {"type": "a", "start": 14651, "end": 14664, "id": 442, "features": {"href": "/wiki/Analog_signal", "title": "Analog signal"}}, {"type": "dt", "start": 14963, "end": 14982, "id": 443, "features": {}}, {"type": "a", "start": 14963, "end": 14982, "id": 444, "features": {"href": "/wiki/Speech_segmentation", "title": "Speech segmentation"}}, {"type": "dd", "start": 14983, "end": 15121, "id": 445, "features": {}}, {"type": "a", "start": 15072, "end": 15090, "id": 446, "features": {"href": "/wiki/Speech_recognition", "title": "Speech recognition"}}, {"type": "dl", "start": 15121, "end": 15269, "id": 447, "features": {}}, {"type": "dt", "start": 15121, "end": 15135, "id": 448, "features": {}}, {"type": "a", "start": 15121, "end": 15135, "id": 449, "features": {"href": "/wiki/Text-to-speech", "class": "mw-redirect", "title": "Text-to-speech"}}, {"type": "dd", "start": 15136, "end": 15269, "id": 450, "features": {}}, {"type": "sup", "start": 15265, "end": 15269, "id": 451, "features": {"id": "cite_ref-20", "class": "reference"}}, {"type": "a", "start": 15265, "end": 15269, "id": 452, "features": {"href": "#cite_note-20"}}, {"type": "dl", "start": 15269, "end": 15803, "id": 453, "features": {}}, {"type": "dt", "start": 15269, "end": 15301, "id": 454, "features": {}}, {"type": "a", "start": 15269, "end": 15286, "id": 455, "features": {"href": "/wiki/Word_segmentation", "class": "mw-redirect", "title": "Word segmentation"}}, {"type": "a", "start": 15288, "end": 15300, "id": 456, "features": {"href": "/wiki/Tokenization_(lexical_analysis)", "class": "mw-redirect", "title": "Tokenization (lexical analysis)"}}, {"type": "dd", "start": 15302, "end": 15803, "id": 457, "features": {}}, {"type": "a", "start": 15379, "end": 15386, "id": 458, "features": {"href": "/wiki/English_language", "title": "English language"}}, {"type": "a", "start": 15494, "end": 15501, "id": 459, "features": {"href": "/wiki/Chinese_language", "title": "Chinese language"}}, {"type": "a", "start": 15503, "end": 15511, "id": 460, "features": {"href": "/wiki/Japanese_language", "title": "Japanese language"}}, {"type": "a", "start": 15516, "end": 15520, "id": 461, "features": {"href": "/wiki/Thai_language", "title": "Thai language"}}, {"type": "a", "start": 15658, "end": 15668, "id": 462, "features": {"href": "/wiki/Vocabulary", "title": "Vocabulary"}}, {"type": "a", "start": 15673, "end": 15683, "id": 463, "features": {"href": "/wiki/Morphology_(linguistics)", "title": "Morphology (linguistics)"}}, {"type": "a", "start": 15760, "end": 15772, "id": 464, "features": {"href": "/wiki/Bag_of_words", "class": "mw-redirect", "title": "Bag of words"}}, {"type": "h3", "start": 15804, "end": 15831, "id": 465, "features": {"class": "in-block"}}, {"type": "span", "start": 15804, "end": 15826, "id": 466, "features": {"class": "mw-headline", "id": "Morphological_analysis"}}, {"type": "span", "start": 15826, "end": 15830, "id": 467, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 15826, "end": 15830, "id": 468, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=10", "title": "Edit section: Morphological analysis", "data-section": "10", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "dl", "start": 15831, "end": 17196, "id": 469, "features": {}}, {"type": "dt", "start": 15831, "end": 15844, "id": 470, "features": {}}, {"type": "a", "start": 15831, "end": 15844, "id": 471, "features": {"href": "/wiki/Lemmatisation", "title": "Lemmatisation"}}, {"type": "dd", "start": 15845, "end": 16155, "id": 472, "features": {}}, {"type": "sup", "start": 16151, "end": 16155, "id": 473, "features": {"id": "cite_ref-21", "class": "reference"}}, {"type": "a", "start": 16151, "end": 16155, "id": 474, "features": {"href": "#cite_note-21"}}, {"type": "dt", "start": 16156, "end": 16182, "id": 475, "features": {}}, {"type": "a", "start": 16156, "end": 16182, "id": 476, "features": {"href": "/wiki/Morphology_(linguistics)", "title": "Morphology (linguistics)"}}, {"type": "dd", "start": 16183, "end": 16835, "id": 477, "features": {}}, {"type": "a", "start": 16214, "end": 16223, "id": 478, "features": {"href": "/wiki/Morpheme", "title": "Morpheme"}}, {"type": "a", "start": 16334, "end": 16344, "id": 479, "features": {"href": "/wiki/Morphology_(linguistics)", "title": "Morphology (linguistics)"}}, {"type": "i", "start": 16346, "end": 16350, "id": 480, "features": {}}, {"type": "a", "start": 16410, "end": 16417, "id": 481, "features": {"href": "/wiki/English_language", "title": "English language"}}, {"type": "a", "start": 16459, "end": 16482, "id": 482, "features": {"href": "/wiki/Inflectional_morphology", "class": "mw-redirect", "title": "Inflectional morphology"}}, {"type": "a", "start": 16668, "end": 16675, "id": 483, "features": {"href": "/wiki/Turkish_language", "title": "Turkish language"}}, {"type": "a", "start": 16679, "end": 16685, "id": 484, "features": {"href": "/wiki/Meitei_language", "title": "Meitei language"}}, {"type": "sup", "start": 16686, "end": 16690, "id": 485, "features": {"id": "cite_ref-22", "class": "reference"}}, {"type": "a", "start": 16686, "end": 16690, "id": 486, "features": {"href": "#cite_note-22"}}, {"type": "a", "start": 16700, "end": 16712, "id": 487, "features": {"href": "/wiki/Agglutination", "title": "Agglutination"}}, {"type": "dt", "start": 16836, "end": 16858, "id": 488, "features": {}}, {"type": "a", "start": 16836, "end": 16858, "id": 489, "features": {"href": "/wiki/Part-of-speech_tagging", "title": "Part-of-speech tagging"}}, {"type": "dd", "start": 16859, "end": 17196, "id": 490, "features": {}}, {"type": "a", "start": 16891, "end": 16905, "id": 491, "features": {"href": "/wiki/Part_of_speech", "title": "Part of speech"}}, {"type": "a", "start": 17031, "end": 17035, "id": 492, "features": {"href": "/wiki/Noun", "title": "Noun"}}, {"type": "a", "start": 17065, "end": 17069, "id": 493, "features": {"href": "/wiki/Verb", "title": "Verb"}}, {"type": "a", "start": 17121, "end": 17130, "id": 494, "features": {"href": "/wiki/Adjective", "title": "Adjective"}}, {"type": "dl", "start": 17196, "end": 17465, "id": 495, "features": {}}, {"type": "dt", "start": 17196, "end": 17204, "id": 496, "features": {}}, {"type": "a", "start": 17196, "end": 17204, "id": 497, "features": {"href": "/wiki/Stemming", "title": "Stemming"}}, {"type": "dd", "start": 17205, "end": 17465, "id": 498, "features": {}}, {"type": "h3", "start": 17466, "end": 17489, "id": 499, "features": {"class": "in-block"}}, {"type": "span", "start": 17466, "end": 17484, "id": 500, "features": {"class": "mw-headline", "id": "Syntactic_analysis"}}, {"type": "span", "start": 17484, "end": 17488, "id": 501, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 17484, "end": 17488, "id": 502, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=11", "title": "Edit section: Syntactic analysis", "data-section": "11", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "dl", "start": 17489, "end": 18544, "id": 503, "features": {}}, {"type": "dt", "start": 17489, "end": 17510, "id": 504, "features": {}}, {"type": "a", "start": 17489, "end": 17506, "id": 505, "features": {"href": "/wiki/Grammar_induction", "title": "Grammar induction"}}, {"type": "sup", "start": 17506, "end": 17510, "id": 506, "features": {"id": "cite_ref-23", "class": "reference"}}, {"type": "a", "start": 17506, "end": 17510, "id": 507, "features": {"href": "#cite_note-23"}}, {"type": "dd", "start": 17511, "end": 17572, "id": 508, "features": {}}, {"type": "a", "start": 17522, "end": 17536, "id": 509, "features": {"href": "/wiki/Formal_grammar", "title": "Formal grammar"}}, {"type": "dt", "start": 17573, "end": 17641, "id": 510, "features": {}}, {"type": "a", "start": 17573, "end": 17590, "id": 511, "features": {"href": "/wiki/Sentence_breaking", "class": "mw-redirect", "title": "Sentence breaking"}}, {"type": "a", "start": 17607, "end": 17639, "id": 512, "features": {"href": "/wiki/Sentence_boundary_disambiguation", "title": "Sentence boundary disambiguation"}}, {"type": "dd", "start": 17642, "end": 17852, "id": 513, "features": {}}, {"type": "a", "start": 17735, "end": 17742, "id": 514, "features": {"href": "/wiki/Full_stop", "title": "Full stop"}}, {"type": "a", "start": 17752, "end": 17769, "id": 515, "features": {"href": "/wiki/Punctuation_mark", "class": "mw-redirect", "title": "Punctuation mark"}}, {"type": "a", "start": 17837, "end": 17850, "id": 516, "features": {"href": "/wiki/Abbreviation", "title": "Abbreviation"}}, {"type": "dt", "start": 17853, "end": 17860, "id": 517, "features": {}}, {"type": "a", "start": 17853, "end": 17860, "id": 518, "features": {"href": "/wiki/Parsing", "title": "Parsing"}}, {"type": "dd", "start": 17861, "end": 18544, "id": 519, "features": {}}, {"type": "a", "start": 17875, "end": 17885, "id": 520, "features": {"href": "/wiki/Parse_tree", "title": "Parse tree"}}, {"type": "a", "start": 17934, "end": 17941, "id": 521, "features": {"href": "/wiki/Grammar", "title": "Grammar"}}, {"type": "a", "start": 17946, "end": 17963, "id": 522, "features": {"href": "/wiki/Natural_language", "title": "Natural language"}}, {"type": "a", "start": 17967, "end": 17976, "id": 523, "features": {"href": "/wiki/Ambiguous", "class": "mw-redirect", "title": "Ambiguous"}}, {"type": "i", "start": 18221, "end": 18239, "id": 524, "features": {}}, {"type": "i", "start": 18244, "end": 18264, "id": 525, "features": {}}, {"type": "a", "start": 18472, "end": 18506, "id": 526, "features": {"href": "/wiki/Probabilistic_context-free_grammar", "title": "Probabilistic context-free grammar"}}, {"type": "i", "start": 18524, "end": 18542, "id": 527, "features": {}}, {"type": "a", "start": 18524, "end": 18542, "id": 528, "features": {"href": "/wiki/Stochastic_grammar", "title": "Stochastic grammar"}}, {"type": "h3", "start": 18545, "end": 18600, "id": 529, "features": {"class": "in-block"}}, {"type": "span", "start": 18545, "end": 18545, "id": 530, "features": {"id": "Lexical_semantics_.28of_individual_words_in_context.29"}}, {"type": "span", "start": 18545, "end": 18595, "id": 531, "features": {"class": "mw-headline", "id": "Lexical_semantics_(of_individual_words_in_context)"}}, {"type": "span", "start": 18595, "end": 18599, "id": 532, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 18595, "end": 18599, "id": 533, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=12", "title": "Edit section: Lexical semantics (of individual words in context)", "data-section": "12", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "dl", "start": 18600, "end": 19702, "id": 534, "features": {}}, {"type": "dt", "start": 18600, "end": 18617, "id": 535, "features": {}}, {"type": "a", "start": 18600, "end": 18617, "id": 536, "features": {"href": "/wiki/Lexical_semantics", "title": "Lexical semantics"}}, {"type": "dd", "start": 18618, "end": 18683, "id": 537, "features": {}}, {"type": "dt", "start": 18684, "end": 18708, "id": 538, "features": {}}, {"type": "a", "start": 18684, "end": 18708, "id": 539, "features": {"href": "/wiki/Distributional_semantics", "title": "Distributional semantics"}}, {"type": "dd", "start": 18709, "end": 18761, "id": 540, "features": {}}, {"type": "dt", "start": 18762, "end": 18792, "id": 541, "features": {}}, {"type": "a", "start": 18762, "end": 18786, "id": 542, "features": {"href": "/wiki/Named_entity_recognition", "class": "mw-redirect", "title": "Named entity recognition"}}, {"type": "dd", "start": 18793, "end": 19702, "id": 543, "features": {}}, {"type": "a", "start": 18985, "end": 18999, "id": 544, "features": {"href": "/wiki/Capitalization", "title": "Capitalization"}}, {"type": "a", "start": 19123, "end": 19135, "id": 545, "features": {"href": "/wiki/Named_entity", "title": "Named entity"}}, {"type": "a", "start": 19402, "end": 19409, "id": 546, "features": {"href": "/wiki/Chinese_language", "title": "Chinese language"}}, {"type": "a", "start": 19413, "end": 19419, "id": 547, "features": {"href": "/wiki/Arabic_language", "class": "mw-redirect", "title": "Arabic language"}}, {"type": "a", "start": 19562, "end": 19568, "id": 548, "features": {"href": "/wiki/German_language", "title": "German language"}}, {"type": "a", "start": 19585, "end": 19590, "id": 549, "features": {"href": "/wiki/Noun", "title": "Noun"}}, {"type": "a", "start": 19634, "end": 19640, "id": 550, "features": {"href": "/wiki/French_language", "title": "French language"}}, {"type": "a", "start": 19645, "end": 19652, "id": 551, "features": {"href": "/wiki/Spanish_language", "title": "Spanish language"}}, {"type": "a", "start": 19691, "end": 19701, "id": 552, "features": {"href": "/wiki/Adjective", "title": "Adjective"}}, {"type": "dl", "start": 19702, "end": 20599, "id": 553, "features": {}}, {"type": "dt", "start": 19702, "end": 19761, "id": 554, "features": {}}, {"type": "a", "start": 19702, "end": 19720, "id": 555, "features": {"href": "/wiki/Sentiment_analysis", "title": "Sentiment analysis"}}, {"type": "a", "start": 19731, "end": 19760, "id": 556, "features": {"href": "/wiki/Multimodal_sentiment_analysis", "title": "Multimodal sentiment analysis"}}, {"type": "dd", "start": 19762, "end": 19997, "id": 557, "features": {}}, {"type": "dt", "start": 19998, "end": 20020, "id": 558, "features": {}}, {"type": "a", "start": 19998, "end": 20020, "id": 559, "features": {"href": "/wiki/Terminology_extraction", "title": "Terminology extraction"}}, {"type": "dd", "start": 20021, "end": 20119, "id": 560, "features": {}}, {"type": "dt", "start": 20120, "end": 20151, "id": 561, "features": {}}, {"type": "a", "start": 20120, "end": 20145, "id": 562, "features": {"href": "/wiki/Word-sense_disambiguation", "title": "Word-sense disambiguation"}}, {"type": "dd", "start": 20152, "end": 20407, "id": 563, "features": {}}, {"type": "a", "start": 20182, "end": 20189, "id": 564, "features": {"href": "/wiki/Meaning_(linguistics)", "class": "mw-redirect", "title": "Meaning (linguistics)"}}, {"type": "a", "start": 20399, "end": 20406, "id": 565, "features": {"href": "/wiki/WordNet", "title": "WordNet"}}, {"type": "dt", "start": 20408, "end": 20422, "id": 566, "features": {}}, {"type": "a", "start": 20408, "end": 20422, "id": 567, "features": {"href": "/wiki/Entity_linking", "title": "Entity linking"}}, {"type": "dd", "start": 20423, "end": 20599, "id": 568, "features": {}}, {"type": "a", "start": 20466, "end": 20480, "id": 569, "features": {"href": "/wiki/Named_entity", "title": "Named entity"}}, {"type": "h3", "start": 20600, "end": 20661, "id": 570, "features": {"class": "in-block"}}, {"type": "span", "start": 20600, "end": 20600, "id": 571, "features": {"id": "Relational_semantics_.28semantics_of_individual_sentences.29"}}, {"type": "span", "start": 20600, "end": 20656, "id": 572, "features": {"class": "mw-headline", "id": "Relational_semantics_(semantics_of_individual_sentences)"}}, {"type": "span", "start": 20656, "end": 20660, "id": 573, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 20656, "end": 20660, "id": 574, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=13", "title": "Edit section: Relational semantics (semantics of individual sentences)", "data-section": "13", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "dl", "start": 20661, "end": 21537, "id": 575, "features": {}}, {"type": "dt", "start": 20661, "end": 20684, "id": 576, "features": {}}, {"type": "a", "start": 20661, "end": 20684, "id": 577, "features": {"href": "/wiki/Relationship_extraction", "title": "Relationship extraction"}}, {"type": "dd", "start": 20685, "end": 20786, "id": 578, "features": {}}, {"type": "dt", "start": 20787, "end": 20803, "id": 579, "features": {}}, {"type": "a", "start": 20787, "end": 20803, "id": 580, "features": {"href": "/wiki/Semantic_parsing", "title": "Semantic parsing"}}, {"type": "dd", "start": 20804, "end": 21305, "id": 581, "features": {}}, {"type": "a", "start": 20928, "end": 20939, "id": 582, "features": {"href": "/wiki/Abstract_Meaning_Representation", "title": "Abstract Meaning Representation"}}, {"type": "a", "start": 20993, "end": 21004, "id": 583, "features": {"href": "/wiki/Discourse_representation_theory", "title": "Discourse representation theory"}}, {"type": "a", "start": 21267, "end": 21297, "id": 584, "features": {"href": "#Natural_language_understanding"}}, {"type": "dt", "start": 21306, "end": 21379, "id": 585, "features": {}}, {"type": "a", "start": 21306, "end": 21329, "id": 586, "features": {"href": "/wiki/Semantic_role_labeling", "title": "Semantic role labeling"}}, {"type": "dd", "start": 21380, "end": 21537, "id": 587, "features": {}}, {"type": "a", "start": 21465, "end": 21471, "id": 588, "features": {"href": "/wiki/Frame_semantics_(linguistics)", "title": "Frame semantics (linguistics)"}}, {"type": "a", "start": 21521, "end": 21535, "id": 589, "features": {"href": "/wiki/Semantic_roles", "class": "mw-redirect", "title": "Semantic roles"}}, {"type": "h3", "start": 21538, "end": 21592, "id": 590, "features": {"class": "in-block"}}, {"type": "span", "start": 21538, "end": 21538, "id": 591, "features": {"id": "Discourse_.28semantics_beyond_individual_sentences.29"}}, {"type": "span", "start": 21538, "end": 21587, "id": 592, "features": {"class": "mw-headline", "id": "Discourse_(semantics_beyond_individual_sentences)"}}, {"type": "span", "start": 21587, "end": 21591, "id": 593, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 21587, "end": 21591, "id": 594, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=14", "title": "Edit section: Discourse (semantics beyond individual sentences)", "data-section": "14", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "dl", "start": 21592, "end": 22778, "id": 595, "features": {}}, {"type": "dt", "start": 21592, "end": 21614, "id": 596, "features": {}}, {"type": "a", "start": 21592, "end": 21614, "id": 597, "features": {"href": "/wiki/Coreference", "title": "Coreference"}}, {"type": "dd", "start": 21615, "end": 22353, "id": 598, "features": {}}, {"type": "a", "start": 21732, "end": 21751, "id": 599, "features": {"href": "/wiki/Anaphora_resolution", "class": "mw-redirect", "title": "Anaphora resolution"}}, {"type": "a", "start": 21835, "end": 21843, "id": 600, "features": {"href": "/wiki/Pronoun", "title": "Pronoun"}}, {"type": "a", "start": 22008, "end": 22029, "id": 601, "features": {"href": "/wiki/Referring_expression", "title": "Referring expression"}}, {"type": "dt", "start": 22354, "end": 22372, "id": 602, "features": {}}, {"type": "a", "start": 22354, "end": 22372, "id": 603, "features": {"href": "/wiki/Discourse_analysis", "title": "Discourse analysis"}}, {"type": "dd", "start": 22373, "end": 22778, "id": 604, "features": {}}, {"type": "a", "start": 22471, "end": 22480, "id": 605, "features": {"href": "/wiki/Discourse", "title": "Discourse"}}, {"type": "a", "start": 22678, "end": 22689, "id": 606, "features": {"href": "/wiki/Speech_act", "title": "Speech act"}}, {"type": "dl", "start": 22778, "end": 23368, "id": 607, "features": {}}, {"type": "dt", "start": 22778, "end": 22810, "id": 608, "features": {}}, {"type": "span", "start": 22778, "end": 22810, "id": 609, "features": {"class": "vanchor"}}, {"type": "span", "start": 22778, "end": 22778, "id": 610, "features": {"id": "Implicit_semantic_role_labelling"}}, {"type": "span", "start": 22778, "end": 22810, "id": 611, "features": {"class": "vanchor-text"}}, {"type": "dd", "start": 22811, "end": 23368, "id": 612, "features": {}}, {"type": "a", "start": 22896, "end": 22902, "id": 613, "features": {"href": "/wiki/Frame_semantics_(linguistics)", "title": "Frame semantics (linguistics)"}}, {"type": "a", "start": 22967, "end": 22990, "id": 614, "features": {"href": "#Semantic_role_labelling"}}, {"type": "a", "start": 23349, "end": 23367, "id": 615, "features": {"href": "/wiki/Pro-drop_language", "title": "Pro-drop language"}}, {"type": "dl", "start": 23368, "end": 23553, "id": 616, "features": {}}, {"type": "dt", "start": 23368, "end": 23398, "id": 617, "features": {}}, {"type": "a", "start": 23368, "end": 23398, "id": 618, "features": {"href": "/wiki/Textual_entailment", "title": "Textual entailment"}}, {"type": "dd", "start": 23399, "end": 23553, "id": 619, "features": {}}, {"type": "sup", "start": 23549, "end": 23553, "id": 620, "features": {"id": "cite_ref-rte:11_24-0", "class": "reference"}}, {"type": "a", "start": 23549, "end": 23553, "id": 621, "features": {"href": "#cite_note-rte:11-24"}}, {"type": "dl", "start": 23553, "end": 23712, "id": 622, "features": {}}, {"type": "dt", "start": 23553, "end": 23587, "id": 623, "features": {}}, {"type": "a", "start": 23553, "end": 23571, "id": 624, "features": {"href": "/wiki/Topic_segmentation", "class": "mw-redirect", "title": "Topic segmentation"}}, {"type": "dd", "start": 23588, "end": 23712, "id": 625, "features": {}}, {"type": "dl", "start": 23712, "end": 24102, "id": 626, "features": {}}, {"type": "dt", "start": 23712, "end": 23727, "id": 627, "features": {}}, {"type": "a", "start": 23712, "end": 23727, "id": 628, "features": {"href": "/wiki/Argument_mining", "title": "Argument mining"}}, {"type": "dd", "start": 23728, "end": 24102, "id": 629, "features": {}}, {"type": "a", "start": 23836, "end": 23852, "id": 630, "features": {"href": "/wiki/Natural_language", "title": "Natural language"}}, {"type": "sup", "start": 23892, "end": 23896, "id": 631, "features": {"id": "cite_ref-25", "class": "reference"}}, {"type": "a", "start": 23892, "end": 23896, "id": 632, "features": {"href": "#cite_note-25"}}, {"type": "a", "start": 23965, "end": 23980, "id": 633, "features": {"href": "/wiki/Argument_scheme", "class": "mw-redirect", "title": "Argument scheme"}}, {"type": "sup", "start": 24094, "end": 24098, "id": 634, "features": {"id": "cite_ref-26", "class": "reference"}}, {"type": "a", "start": 24094, "end": 24098, "id": 635, "features": {"href": "#cite_note-26"}}, {"type": "sup", "start": 24098, "end": 24102, "id": 636, "features": {"id": "cite_ref-27", "class": "reference"}}, {"type": "a", "start": 24098, "end": 24102, "id": 637, "features": {"href": "#cite_note-27"}}, {"type": "h3", "start": 24103, "end": 24137, "id": 638, "features": {"class": "in-block"}}, {"type": "span", "start": 24103, "end": 24132, "id": 639, "features": {"class": "mw-headline", "id": "Higher-level_NLP_applications"}}, {"type": "span", "start": 24132, "end": 24136, "id": 640, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 24132, "end": 24136, "id": 641, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=15", "title": "Edit section: Higher-level NLP applications", "data-section": "15", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "dl", "start": 24137, "end": 28192, "id": 642, "features": {}}, {"type": "dt", "start": 24137, "end": 24181, "id": 643, "features": {}}, {"type": "a", "start": 24137, "end": 24160, "id": 644, "features": {"href": "/wiki/Automatic_summarization", "title": "Automatic summarization"}}, {"type": "dd", "start": 24182, "end": 24365, "id": 645, "features": {}}, {"type": "dt", "start": 24366, "end": 24381, "id": 646, "features": {}}, {"type": "dd", "start": 24382, "end": 25091, "id": 647, "features": {}}, {"type": "i", "start": 24597, "end": 24638, "id": 648, "features": {}}, {"type": "sup", "start": 24640, "end": 24644, "id": 649, "features": {"id": "cite_ref-28", "class": "reference"}}, {"type": "a", "start": 24640, "end": 24644, "id": 650, "features": {"href": "#cite_note-28"}}, {"type": "i", "start": 24713, "end": 24723, "id": 651, "features": {}}, {"type": "a", "start": 24713, "end": 24723, "id": 652, "features": {"href": "/wiki/1_the_Road", "title": "1 the Road"}}, {"type": "a", "start": 24853, "end": 24868, "id": 653, "features": {"href": "/wiki/Language_model", "title": "Language model"}}, {"type": "i", "start": 24947, "end": 24968, "id": 654, "features": {}}, {"type": "sup", "start": 24986, "end": 24990, "id": 655, "features": {"id": "cite_ref-29", "class": "reference"}}, {"type": "a", "start": 24986, "end": 24990, "id": 656, "features": {"href": "#cite_note-29"}}, {"type": "i", "start": 24998, "end": 25004, "id": 657, "features": {}}, {"type": "i", "start": 25009, "end": 25019, "id": 658, "features": {}}, {"type": "dt", "start": 25092, "end": 25111, "id": 659, "features": {}}, {"type": "a", "start": 25092, "end": 25111, "id": 660, "features": {"href": "/wiki/Dialogue_system", "title": "Dialogue system"}}, {"type": "dd", "start": 25112, "end": 25163, "id": 661, "features": {}}, {"type": "dt", "start": 25164, "end": 25175, "id": 662, "features": {}}, {"type": "a", "start": 25164, "end": 25175, "id": 663, "features": {"href": "/wiki/Document_AI", "title": "Document AI"}}, {"type": "dd", "start": 25176, "end": 25586, "id": 664, "features": {}}, {"type": "sup", "start": 25582, "end": 25586, "id": 665, "features": {"id": "cite_ref-30", "class": "reference"}}, {"type": "a", "start": 25582, "end": 25586, "id": 666, "features": {"href": "#cite_note-30"}}, {"type": "dt", "start": 25587, "end": 25615, "id": 667, "features": {}}, {"type": "link", "start": 25587, "end": 25587, "id": 668, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1023754711"}}, {"type": "span", "start": 25587, "end": 25615, "id": 669, "features": {"class": "vanchor"}}, {"type": "span", "start": 25587, "end": 25587, "id": 670, "features": {"id": "Grammatical_error_correction"}}, {"type": "span", "start": 25587, "end": 25615, "id": 671, "features": {"class": "vanchor-text"}}, {"type": "dd", "start": 25616, "end": 26304, "id": 672, "features": {}}, {"type": "sup", "start": 26008, "end": 26012, "id": 673, "features": {"id": "cite_ref-31", "class": "reference"}}, {"type": "a", "start": 26008, "end": 26012, "id": 674, "features": {"href": "#cite_note-31"}}, {"type": "sup", "start": 26012, "end": 26016, "id": 675, "features": {"id": "cite_ref-32", "class": "reference"}}, {"type": "a", "start": 26012, "end": 26016, "id": 676, "features": {"href": "#cite_note-32"}}, {"type": "sup", "start": 26016, "end": 26020, "id": 677, "features": {"id": "cite_ref-33", "class": "reference"}}, {"type": "a", "start": 26016, "end": 26020, "id": 678, "features": {"href": "#cite_note-33"}}, {"type": "a", "start": 26181, "end": 26186, "id": 679, "features": {"href": "/wiki/GPT-2", "title": "GPT-2"}}, {"type": "dt", "start": 26305, "end": 26324, "id": 680, "features": {}}, {"type": "a", "start": 26305, "end": 26324, "id": 681, "features": {"href": "/wiki/Machine_translation", "title": "Machine translation"}}, {"type": "dd", "start": 26325, "end": 26657, "id": 682, "features": {}}, {"type": "a", "start": 26495, "end": 26506, "id": 683, "features": {"href": "/wiki/AI-complete", "title": "AI-complete"}}, {"type": "dt", "start": 26658, "end": 26692, "id": 684, "features": {}}, {"type": "a", "start": 26658, "end": 26685, "id": 685, "features": {"href": "/wiki/Natural_language_generation", "title": "Natural language generation"}}, {"type": "dd", "start": 26693, "end": 26786, "id": 686, "features": {}}, {"type": "dt", "start": 26787, "end": 26823, "id": 687, "features": {}}, {"type": "a", "start": 26787, "end": 26817, "id": 688, "features": {"href": "/wiki/Natural-language_understanding", "title": "Natural-language understanding"}}, {"type": "dd", "start": 26824, "end": 27620, "id": 689, "features": {}}, {"type": "a", "start": 26888, "end": 26905, "id": 690, "features": {"href": "/wiki/First-order_logic", "title": "First-order logic"}}, {"type": "a", "start": 26937, "end": 26945, "id": 691, "features": {"href": "/wiki/Computer", "title": "Computer"}}, {"type": "a", "start": 27442, "end": 27465, "id": 692, "features": {"href": "/wiki/Closed-world_assumption", "title": "Closed-world assumption"}}, {"type": "a", "start": 27476, "end": 27497, "id": 693, "features": {"href": "/wiki/Open-world_assumption", "title": "Open-world assumption"}}, {"type": "sup", "start": 27616, "end": 27620, "id": 694, "features": {"id": "cite_ref-34", "class": "reference"}}, {"type": "a", "start": 27616, "end": 27620, "id": 695, "features": {"href": "#cite_note-34"}}, {"type": "dt", "start": 27621, "end": 27639, "id": 696, "features": {}}, {"type": "a", "start": 27621, "end": 27639, "id": 697, "features": {"href": "/wiki/Question_answering", "title": "Question answering"}}, {"type": "dd", "start": 27640, "end": 27882, "id": 698, "features": {}}, {"type": "dt", "start": 27883, "end": 27907, "id": 699, "features": {}}, {"type": "a", "start": 27883, "end": 27907, "id": 700, "features": {"href": "/wiki/Text-to-image_generation", "class": "mw-redirect", "title": "Text-to-image generation"}}, {"type": "dd", "start": 27908, "end": 27992, "id": 701, "features": {}}, {"type": "sup", "start": 27988, "end": 27992, "id": 702, "features": {"id": "cite_ref-35", "class": "reference"}}, {"type": "a", "start": 27988, "end": 27992, "id": 703, "features": {"href": "#cite_note-35"}}, {"type": "dt", "start": 27993, "end": 28017, "id": 704, "features": {}}, {"type": "dd", "start": 28018, "end": 28091, "id": 705, "features": {}}, {"type": "a", "start": 28061, "end": 28069, "id": 706, "features": {"href": "/wiki/3D_model", "class": "mw-redirect", "title": "3D model"}}, {"type": "sup", "start": 28083, "end": 28087, "id": 707, "features": {"id": "cite_ref-36", "class": "reference"}}, {"type": "a", "start": 28083, "end": 28087, "id": 708, "features": {"href": "#cite_note-36"}}, {"type": "sup", "start": 28087, "end": 28091, "id": 709, "features": {"id": "cite_ref-37", "class": "reference"}}, {"type": "a", "start": 28087, "end": 28091, "id": 710, "features": {"href": "#cite_note-37"}}, {"type": "dt", "start": 28092, "end": 28105, "id": 711, "features": {}}, {"type": "dd", "start": 28106, "end": 28192, "id": 712, "features": {}}, {"type": "sup", "start": 28184, "end": 28188, "id": 713, "features": {"id": "cite_ref-38", "class": "reference"}}, {"type": "a", "start": 28184, "end": 28188, "id": 714, "features": {"href": "#cite_note-38"}}, {"type": "sup", "start": 28188, "end": 28192, "id": 715, "features": {"id": "cite_ref-39", "class": "reference"}}, {"type": "a", "start": 28188, "end": 28192, "id": 716, "features": {"href": "#cite_note-39"}}, {"type": "h2", "start": 28193, "end": 28249, "id": 717, "features": {"class": "section-heading", "onclick": "mfTempOpenSection(4)"}}, {"type": "div", "start": 28193, "end": 28193, "id": 718, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left mw-ui-button mw-ui-quiet"}}, {"type": "span", "start": 28193, "end": 28193, "id": 719, "features": {"id": "General_tendencies_and_.28possible.29_future_directions"}}, {"type": "span", "start": 28193, "end": 28244, "id": 720, "features": {"class": "mw-headline", "id": "General_tendencies_and_(possible)_future_directions"}}, {"type": "span", "start": 28244, "end": 28248, "id": 721, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 28244, "end": 28248, "id": 722, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=16", "title": "Edit section: General tendencies and (possible) future directions", "data-section": "16", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "section", "start": 28249, "end": 32830, "id": 723, "features": {"class": "mf-section-4 collapsible-block", "id": "mf-section-4"}}, {"type": "p", "start": 28249, "end": 28462, "id": 724, "features": {}}, {"type": "sup", "start": 28457, "end": 28461, "id": 725, "features": {"id": "cite_ref-40", "class": "reference"}}, {"type": "a", "start": 28457, "end": 28461, "id": 726, "features": {"href": "#cite_note-40"}}, {"type": "ul", "start": 28462, "end": 29280, "id": 727, "features": {}}, {"type": "li", "start": 28462, "end": 28752, "id": 728, "features": {}}, {"type": "li", "start": 28752, "end": 29129, "id": 729, "features": {}}, {"type": "li", "start": 29129, "end": 29280, "id": 730, "features": {}}, {"type": "h3", "start": 29280, "end": 29302, "id": 731, "features": {"class": "in-block"}}, {"type": "span", "start": 29280, "end": 29297, "id": 732, "features": {"class": "mw-headline", "id": "Cognition_and_NLP"}}, {"type": "span", "start": 29297, "end": 29301, "id": 733, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 29297, "end": 29301, "id": 734, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=17", "title": "Edit section: Cognition and NLP", "data-section": "17", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "p", "start": 29302, "end": 29649, "id": 735, "features": {}}, {"type": "p", "start": 29649, "end": 30158, "id": 736, "features": {}}, {"type": "a", "start": 29649, "end": 29658, "id": 737, "features": {"href": "/wiki/Cognition", "title": "Cognition"}}, {"type": "sup", "start": 29785, "end": 29789, "id": 738, "features": {"id": "cite_ref-41", "class": "reference"}}, {"type": "a", "start": 29785, "end": 29789, "id": 739, "features": {"href": "#cite_note-41"}}, {"type": "a", "start": 29790, "end": 29807, "id": 740, "features": {"href": "/wiki/Cognitive_science", "title": "Cognitive science"}}, {"type": "sup", "start": 29881, "end": 29885, "id": 741, "features": {"id": "cite_ref-42", "class": "reference"}}, {"type": "a", "start": 29881, "end": 29885, "id": 742, "features": {"href": "#cite_note-42"}}, {"type": "a", "start": 29886, "end": 29907, "id": 743, "features": {"href": "/wiki/Cognitive_linguistics", "title": "Cognitive linguistics"}}, {"type": "sup", "start": 30025, "end": 30029, "id": 744, "features": {"id": "cite_ref-43", "class": "reference"}}, {"type": "a", "start": 30025, "end": 30029, "id": 745, "features": {"href": "#cite_note-43"}}, {"type": "a", "start": 30059, "end": 30071, "id": 746, "features": {"href": "#Symbolic_NLP_(1950s_-_early_1990s)"}}, {"type": "p", "start": 30158, "end": 30389, "id": 747, "features": {}}, {"type": "a", "start": 30173, "end": 30186, "id": 748, "features": {"href": "/wiki/George_Lakoff", "title": "George Lakoff"}}, {"type": "a", "start": 30335, "end": 30356, "id": 749, "features": {"href": "/wiki/Cognitive_linguistics", "title": "Cognitive linguistics"}}, {"type": "sup", "start": 30357, "end": 30361, "id": 750, "features": {"id": "cite_ref-44", "class": "reference"}}, {"type": "a", "start": 30357, "end": 30361, "id": 751, "features": {"href": "#cite_note-44"}}, {"type": "ol", "start": 30389, "end": 31354, "id": 752, "features": {}}, {"type": "li", "start": 30389, "end": 31042, "id": 753, "features": {}}, {"type": "a", "start": 30409, "end": 30428, "id": 754, "features": {"href": "/wiki/Conceptual_metaphor", "title": "Conceptual metaphor"}}, {"type": "sup", "start": 30557, "end": 30561, "id": 755, "features": {"id": "cite_ref-45", "class": "reference"}}, {"type": "a", "start": 30557, "end": 30561, "id": 756, "features": {"href": "#cite_note-45"}}, {"type": "i", "start": 30601, "end": 30604, "id": 757, "features": {}}, {"type": "i", "start": 30705, "end": 30721, "id": 758, "features": {}}, {"type": "i", "start": 30855, "end": 30865, "id": 759, "features": {}}, {"type": "li", "start": 31042, "end": 31354, "id": 760, "features": {}}, {"type": "a", "start": 31229, "end": 31263, "id": 761, "features": {"href": "/wiki/Probabilistic_context-free_grammar", "title": "Probabilistic context-free grammar"}}, {"type": "span", "start": 31334, "end": 31351, "id": 762, "features": {"class": "citation patent"}}, {"type": "a", "start": 31334, "end": 31351, "id": 763, "features": {"rel": "nofollow", "class": "external text", "href": "https://worldwide.espacenet.com/textdoc?DB=EPODOC&IDX=US9269353"}}, {"type": "span", "start": 31351, "end": 31352, "id": 764, "features": {"class": "Z3988", "title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Apatent&rft.number=9269353&rft.cc=US&rft.title="}}, {"type": "span", "start": 31351, "end": 31352, "id": 765, "features": {"style": "display: none;"}}, {"type": "dl", "start": 31354, "end": 31659, "id": 766, "features": {}}, {"type": "dd", "start": 31354, "end": 31659, "id": 767, "features": {}}, {"type": "dl", "start": 31354, "end": 31659, "id": 768, "features": {}}, {"type": "dd", "start": 31354, "end": 31659, "id": 769, "features": {}}, {"type": "span", "start": 31354, "end": 31659, "id": 770, "features": {"class": "mwe-math-element"}}, {"type": "span", "start": 31354, "end": 31658, "id": 771, "features": {"class": "mwe-math-mathml-inline mwe-math-mathml-a11y", "style": "display: none;"}}, {"type": "math", "start": 31354, "end": 31658, "id": 772, "features": {"xmlns": "http://www.w3.org/1998/Math/MathML", "alttext": "{\\displaystyle {RMM(token_{N})}={PMM(token_{N})}\\times {\\frac {1}{2d}}\\left(\\sum _{i=-d}^{d}{((PMM(token_{N-1})}\\times {PF(token_{N},token_{N-1}))_{i}}\\right)}"}}, {"type": "semantics", "start": 31354, "end": 31658, "id": 773, "features": {}}, {"type": "mrow", "start": 31354, "end": 31498, "id": 774, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mstyle", "start": 31354, "end": 31498, "id": 775, "features": {"displaystyle": "true", "scriptlevel": "0"}}, {"type": "mrow", "start": 31354, "end": 31376, "id": 776, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31354, "end": 31355, "id": 777, "features": {}}, {"type": "mi", "start": 31356, "end": 31357, "id": 778, "features": {}}, {"type": "mi", "start": 31358, "end": 31359, "id": 779, "features": {}}, {"type": "mo", "start": 31360, "end": 31361, "id": 780, "features": {"stretchy": "false"}}, {"type": "mi", "start": 31362, "end": 31363, "id": 781, "features": {}}, {"type": "mi", "start": 31364, "end": 31365, "id": 782, "features": {}}, {"type": "mi", "start": 31366, "end": 31367, "id": 783, "features": {}}, {"type": "mi", "start": 31368, "end": 31369, "id": 784, "features": {}}, {"type": "msub", "start": 31370, "end": 31374, "id": 785, "features": {}}, {"type": "mi", "start": 31370, "end": 31371, "id": 786, "features": {}}, {"type": "mrow", "start": 31372, "end": 31374, "id": 787, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31372, "end": 31373, "id": 788, "features": {}}, {"type": "mo", "start": 31374, "end": 31375, "id": 789, "features": {"stretchy": "false"}}, {"type": "mo", "start": 31376, "end": 31377, "id": 790, "features": {}}, {"type": "mrow", "start": 31378, "end": 31400, "id": 791, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31378, "end": 31379, "id": 792, "features": {}}, {"type": "mi", "start": 31380, "end": 31381, "id": 793, "features": {}}, {"type": "mi", "start": 31382, "end": 31383, "id": 794, "features": {}}, {"type": "mo", "start": 31384, "end": 31385, "id": 795, "features": {"stretchy": "false"}}, {"type": "mi", "start": 31386, "end": 31387, "id": 796, "features": {}}, {"type": "mi", "start": 31388, "end": 31389, "id": 797, "features": {}}, {"type": "mi", "start": 31390, "end": 31391, "id": 798, "features": {}}, {"type": "mi", "start": 31392, "end": 31393, "id": 799, "features": {}}, {"type": "msub", "start": 31394, "end": 31398, "id": 800, "features": {}}, {"type": "mi", "start": 31394, "end": 31395, "id": 801, "features": {}}, {"type": "mrow", "start": 31396, "end": 31398, "id": 802, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31396, "end": 31397, "id": 803, "features": {}}, {"type": "mo", "start": 31398, "end": 31399, "id": 804, "features": {"stretchy": "false"}}, {"type": "mo", "start": 31400, "end": 31401, "id": 805, "features": {}}, {"type": "mrow", "start": 31402, "end": 31408, "id": 806, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mfrac", "start": 31402, "end": 31408, "id": 807, "features": {}}, {"type": "mn", "start": 31402, "end": 31403, "id": 808, "features": {}}, {"type": "mrow", "start": 31404, "end": 31408, "id": 809, "features": {}}, {"type": "mn", "start": 31404, "end": 31405, "id": 810, "features": {}}, {"type": "mi", "start": 31406, "end": 31407, "id": 811, "features": {}}, {"type": "mrow", "start": 31408, "end": 31498, "id": 812, "features": {}}, {"type": "mo", "start": 31408, "end": 31409, "id": 813, "features": {}}, {"type": "mrow", "start": 31410, "end": 31496, "id": 814, "features": {}}, {"type": "munderover", "start": 31410, "end": 31422, "id": 815, "features": {}}, {"type": "mo", "start": 31410, "end": 31411, "id": 816, "features": {}}, {"type": "mrow", "start": 31412, "end": 31420, "id": 817, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31412, "end": 31413, "id": 818, "features": {}}, {"type": "mo", "start": 31414, "end": 31415, "id": 819, "features": {}}, {"type": "mo", "start": 31416, "end": 31417, "id": 820, "features": {}}, {"type": "mi", "start": 31418, "end": 31419, "id": 821, "features": {}}, {"type": "mrow", "start": 31420, "end": 31422, "id": 822, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31420, "end": 31421, "id": 823, "features": {}}, {"type": "mrow", "start": 31422, "end": 31452, "id": 824, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mo", "start": 31422, "end": 31423, "id": 825, "features": {"stretchy": "false"}}, {"type": "mo", "start": 31424, "end": 31425, "id": 826, "features": {"stretchy": "false"}}, {"type": "mi", "start": 31426, "end": 31427, "id": 827, "features": {}}, {"type": "mi", "start": 31428, "end": 31429, "id": 828, "features": {}}, {"type": "mi", "start": 31430, "end": 31431, "id": 829, "features": {}}, {"type": "mo", "start": 31432, "end": 31433, "id": 830, "features": {"stretchy": "false"}}, {"type": "mi", "start": 31434, "end": 31435, "id": 831, "features": {}}, {"type": "mi", "start": 31436, "end": 31437, "id": 832, "features": {}}, {"type": "mi", "start": 31438, "end": 31439, "id": 833, "features": {}}, {"type": "mi", "start": 31440, "end": 31441, "id": 834, "features": {}}, {"type": "msub", "start": 31442, "end": 31450, "id": 835, "features": {}}, {"type": "mi", "start": 31442, "end": 31443, "id": 836, "features": {}}, {"type": "mrow", "start": 31444, "end": 31450, "id": 837, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31444, "end": 31445, "id": 838, "features": {}}, {"type": "mo", "start": 31446, "end": 31447, "id": 839, "features": {}}, {"type": "mn", "start": 31448, "end": 31449, "id": 840, "features": {}}, {"type": "mo", "start": 31450, "end": 31451, "id": 841, "features": {"stretchy": "false"}}, {"type": "mo", "start": 31452, "end": 31453, "id": 842, "features": {}}, {"type": "mrow", "start": 31454, "end": 31496, "id": 843, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31454, "end": 31455, "id": 844, "features": {}}, {"type": "mi", "start": 31456, "end": 31457, "id": 845, "features": {}}, {"type": "mo", "start": 31458, "end": 31459, "id": 846, "features": {"stretchy": "false"}}, {"type": "mi", "start": 31460, "end": 31461, "id": 847, "features": {}}, {"type": "mi", "start": 31462, "end": 31463, "id": 848, "features": {}}, {"type": "mi", "start": 31464, "end": 31465, "id": 849, "features": {}}, {"type": "mi", "start": 31466, "end": 31467, "id": 850, "features": {}}, {"type": "msub", "start": 31468, "end": 31472, "id": 851, "features": {}}, {"type": "mi", "start": 31468, "end": 31469, "id": 852, "features": {}}, {"type": "mrow", "start": 31470, "end": 31472, "id": 853, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31470, "end": 31471, "id": 854, "features": {}}, {"type": "mo", "start": 31472, "end": 31473, "id": 855, "features": {}}, {"type": "mi", "start": 31474, "end": 31475, "id": 856, "features": {}}, {"type": "mi", "start": 31476, "end": 31477, "id": 857, "features": {}}, {"type": "mi", "start": 31478, "end": 31479, "id": 858, "features": {}}, {"type": "mi", "start": 31480, "end": 31481, "id": 859, "features": {}}, {"type": "msub", "start": 31482, "end": 31490, "id": 860, "features": {}}, {"type": "mi", "start": 31482, "end": 31483, "id": 861, "features": {}}, {"type": "mrow", "start": 31484, "end": 31490, "id": 862, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31484, "end": 31485, "id": 863, "features": {}}, {"type": "mo", "start": 31486, "end": 31487, "id": 864, "features": {}}, {"type": "mn", "start": 31488, "end": 31489, "id": 865, "features": {}}, {"type": "mo", "start": 31490, "end": 31491, "id": 866, "features": {"stretchy": "false"}}, {"type": "msub", "start": 31492, "end": 31496, "id": 867, "features": {}}, {"type": "mo", "start": 31492, "end": 31493, "id": 868, "features": {"stretchy": "false"}}, {"type": "mrow", "start": 31494, "end": 31496, "id": 869, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 31494, "end": 31495, "id": 870, "features": {}}, {"type": "mo", "start": 31496, "end": 31497, "id": 871, "features": {}}, {"type": "annotation", "start": 31498, "end": 31657, "id": 872, "features": {"encoding": "application/x-tex"}}, {"type": "noscript", "start": 31658, "end": 31658, "id": 873, "features": {}}, {"type": "img", "start": 31658, "end": 31658, "id": 874, "features": {"src": "https://wikimedia.org/api/rest_v1/media/math/render/svg/145bdbd62e463df3e65c94db2e17224ecbcb2c40", "class": "mwe-math-fallback-image-inline", "aria-hidden": "true", "style": "vertical-align: -3.171ex; width:96.554ex; height:7.509ex;", "alt": "{\\displaystyle {RMM(token_{N})}={PMM(token_{N})}\\times {\\frac {1}{2d}}\\left(\\sum _{i=-d}^{d}{((PMM(token_{N-1})}\\times {PF(token_{N},token_{N-1}))_{i}}\\right)}"}}, {"type": "span", "start": 31658, "end": 31659, "id": 875, "features": {"class": "lazy-image-placeholder", "style": "width: 96.554ex;height: 7.509ex;vertical-align: -3.171ex;", "data-src": "https://wikimedia.org/api/rest_v1/media/math/render/svg/145bdbd62e463df3e65c94db2e17224ecbcb2c40", "data-alt": "{\\displaystyle {RMM(token_{N})}={PMM(token_{N})}\\times {\\frac {1}{2d}}\\left(\\sum _{i=-d}^{d}{((PMM(token_{N-1})}\\times {PF(token_{N},token_{N-1}))_{i}}\\right)}", "data-class": "mwe-math-fallback-image-inline"}}, {"type": "dl", "start": 31659, "end": 31980, "id": 876, "features": {}}, {"type": "dd", "start": 31659, "end": 31980, "id": 877, "features": {}}, {"type": "dl", "start": 31659, "end": 31980, "id": 878, "features": {}}, {"type": "dd", "start": 31659, "end": 31980, "id": 879, "features": {}}, {"type": "i", "start": 31659, "end": 31665, "id": 880, "features": {}}, {"type": "dl", "start": 31666, "end": 31980, "id": 881, "features": {}}, {"type": "dd", "start": 31666, "end": 31705, "id": 882, "features": {}}, {"type": "b", "start": 31666, "end": 31669, "id": 883, "features": {}}, {"type": "dd", "start": 31706, "end": 31759, "id": 884, "features": {}}, {"type": "b", "start": 31706, "end": 31711, "id": 885, "features": {}}, {"type": "dd", "start": 31760, "end": 31801, "id": 886, "features": {}}, {"type": "b", "start": 31760, "end": 31761, "id": 887, "features": {}}, {"type": "dd", "start": 31802, "end": 31860, "id": 888, "features": {}}, {"type": "b", "start": 31802, "end": 31805, "id": 889, "features": {}}, {"type": "dd", "start": 31861, "end": 31925, "id": 890, "features": {}}, {"type": "b", "start": 31861, "end": 31862, "id": 891, "features": {}}, {"type": "b", "start": 31915, "end": 31918, "id": 892, "features": {}}, {"type": "dd", "start": 31926, "end": 31980, "id": 893, "features": {}}, {"type": "b", "start": 31926, "end": 31928, "id": 894, "features": {}}, {"type": "p", "start": 31981, "end": 32830, "id": 895, "features": {}}, {"type": "sup", "start": 32332, "end": 32336, "id": 896, "features": {"id": "cite_ref-46", "class": "reference"}}, {"type": "a", "start": 32332, "end": 32336, "id": 897, "features": {"href": "#cite_note-46"}}, {"type": "sup", "start": 32356, "end": 32360, "id": 898, "features": {"id": "cite_ref-47", "class": "reference"}}, {"type": "a", "start": 32356, "end": 32360, "id": 899, "features": {"href": "#cite_note-47"}}, {"type": "sup", "start": 32382, "end": 32386, "id": 900, "features": {"id": "cite_ref-48", "class": "reference"}}, {"type": "a", "start": 32382, "end": 32386, "id": 901, "features": {"href": "#cite_note-48"}}, {"type": "a", "start": 32453, "end": 32458, "id": 902, "features": {"href": "/wiki/ACT-R", "title": "ACT-R"}}, {"type": "sup", "start": 32553, "end": 32557, "id": 903, "features": {"id": "cite_ref-49", "class": "reference"}}, {"type": "a", "start": 32553, "end": 32557, "id": 904, "features": {"href": "#cite_note-49"}}, {"type": "a", "start": 32565, "end": 32568, "id": 905, "features": {"href": "/wiki/Association_for_Computational_Linguistics", "title": "Association for Computational Linguistics"}}, {"type": "a", "start": 32653, "end": 32667, "id": 906, "features": {"href": "/wiki/Explainable_artificial_intelligence", "title": "Explainable artificial intelligence"}}, {"type": "sup", "start": 32710, "end": 32714, "id": 907, "features": {"id": "cite_ref-50", "class": "reference"}}, {"type": "a", "start": 32710, "end": 32714, "id": 908, "features": {"href": "#cite_note-50"}}, {"type": "a", "start": 32778, "end": 32788, "id": 909, "features": {"href": "/wiki/Multimodal_interaction", "title": "Multimodal interaction"}}, {"type": "sup", "start": 32825, "end": 32829, "id": 910, "features": {"id": "cite_ref-51", "class": "reference"}}, {"type": "a", "start": 32825, "end": 32829, "id": 911, "features": {"href": "#cite_note-51"}}, {"type": "h2", "start": 32830, "end": 32843, "id": 912, "features": {"class": "section-heading", "onclick": "mfTempOpenSection(5)"}}, {"type": "div", "start": 32830, "end": 32830, "id": 913, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left mw-ui-button mw-ui-quiet"}}, {"type": "span", "start": 32830, "end": 32838, "id": 914, "features": {"class": "mw-headline", "id": "See_also"}}, {"type": "span", "start": 32838, "end": 32842, "id": 915, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 32838, "end": 32842, "id": 916, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=18", "title": "Edit section: See also", "data-section": "18", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "section", "start": 32843, "end": 33630, "id": 917, "features": {"class": "mf-section-5 collapsible-block", "id": "mf-section-5"}}, {"type": "div", "start": 32843, "end": 33630, "id": 918, "features": {"class": "div-col", "style": "column-width: 22em;"}}, {"type": "ul", "start": 32843, "end": 33630, "id": 919, "features": {}}, {"type": "li", "start": 32843, "end": 32854, "id": 920, "features": {}}, {"type": "i", "start": 32843, "end": 32853, "id": 921, "features": {}}, {"type": "a", "start": 32843, "end": 32853, "id": 922, "features": {"href": "/wiki/1_the_Road", "title": "1 the Road"}}, {"type": "li", "start": 32854, "end": 32878, "id": 923, "features": {}}, {"type": "a", "start": 32854, "end": 32877, "id": 924, "features": {"href": "/wiki/Automated_essay_scoring", "title": "Automated essay scoring"}}, {"type": "li", "start": 32878, "end": 32901, "id": 925, "features": {}}, {"type": "a", "start": 32878, "end": 32900, "id": 926, "features": {"href": "/wiki/Biomedical_text_mining", "title": "Biomedical text mining"}}, {"type": "li", "start": 32901, "end": 32926, "id": 927, "features": {}}, {"type": "a", "start": 32901, "end": 32925, "id": 928, "features": {"href": "/wiki/Compound_term_processing", "class": "mw-redirect", "title": "Compound term processing"}}, {"type": "li", "start": 32926, "end": 32952, "id": 929, "features": {}}, {"type": "a", "start": 32926, "end": 32951, "id": 930, "features": {"href": "/wiki/Computational_linguistics", "title": "Computational linguistics"}}, {"type": "li", "start": 32952, "end": 32980, "id": 931, "features": {}}, {"type": "a", "start": 32952, "end": 32979, "id": 932, "features": {"href": "/wiki/Computer-assisted_reviewing", "title": "Computer-assisted reviewing"}}, {"type": "li", "start": 32980, "end": 33008, "id": 933, "features": {}}, {"type": "a", "start": 32980, "end": 33007, "id": 934, "features": {"href": "/wiki/Controlled_natural_language", "title": "Controlled natural language"}}, {"type": "li", "start": 33008, "end": 33022, "id": 935, "features": {}}, {"type": "a", "start": 33008, "end": 33021, "id": 936, "features": {"href": "/wiki/Deep_learning", "title": "Deep learning"}}, {"type": "li", "start": 33022, "end": 33049, "id": 937, "features": {}}, {"type": "a", "start": 33022, "end": 33048, "id": 938, "features": {"href": "/wiki/Deep_linguistic_processing", "title": "Deep linguistic processing"}}, {"type": "li", "start": 33049, "end": 33074, "id": 939, "features": {}}, {"type": "a", "start": 33049, "end": 33073, "id": 940, "features": {"href": "/wiki/Distributional_semantics", "title": "Distributional semantics"}}, {"type": "li", "start": 33074, "end": 33103, "id": 941, "features": {}}, {"type": "a", "start": 33074, "end": 33102, "id": 942, "features": {"href": "/wiki/Foreign_language_reading_aid", "class": "mw-redirect", "title": "Foreign language reading aid"}}, {"type": "li", "start": 33103, "end": 33132, "id": 943, "features": {}}, {"type": "a", "start": 33103, "end": 33131, "id": 944, "features": {"href": "/wiki/Foreign_language_writing_aid", "class": "mw-redirect", "title": "Foreign language writing aid"}}, {"type": "li", "start": 33132, "end": 33155, "id": 945, "features": {}}, {"type": "a", "start": 33132, "end": 33154, "id": 946, "features": {"href": "/wiki/Information_extraction", "title": "Information extraction"}}, {"type": "li", "start": 33155, "end": 33177, "id": 947, "features": {}}, {"type": "a", "start": 33155, "end": 33176, "id": 948, "features": {"href": "/wiki/Information_retrieval", "title": "Information retrieval"}}, {"type": "li", "start": 33177, "end": 33217, "id": 949, "features": {}}, {"type": "a", "start": 33177, "end": 33216, "id": 950, "features": {"href": "/wiki/Language_and_Communication_Technologies", "title": "Language and Communication Technologies"}}, {"type": "li", "start": 33217, "end": 33237, "id": 951, "features": {}}, {"type": "a", "start": 33217, "end": 33236, "id": 952, "features": {"href": "/wiki/Language_technology", "title": "Language technology"}}, {"type": "li", "start": 33237, "end": 33262, "id": 953, "features": {}}, {"type": "a", "start": 33237, "end": 33261, "id": 954, "features": {"href": "/wiki/Latent_semantic_indexing", "class": "mw-redirect", "title": "Latent semantic indexing"}}, {"type": "li", "start": 33262, "end": 33293, "id": 955, "features": {}}, {"type": "a", "start": 33262, "end": 33292, "id": 956, "features": {"href": "/wiki/Native-language_identification", "title": "Native-language identification"}}, {"type": "li", "start": 33293, "end": 33322, "id": 957, "features": {}}, {"type": "a", "start": 33293, "end": 33321, "id": 958, "features": {"href": "/wiki/Natural-language_programming", "title": "Natural-language programming"}}, {"type": "li", "start": 33322, "end": 33353, "id": 959, "features": {}}, {"type": "a", "start": 33322, "end": 33352, "id": 960, "features": {"href": "/wiki/Natural-language_understanding", "title": "Natural-language understanding"}}, {"type": "li", "start": 33353, "end": 33377, "id": 961, "features": {}}, {"type": "a", "start": 33353, "end": 33376, "id": 962, "features": {"href": "/wiki/Natural-language_user_interface", "title": "Natural-language user interface"}}, {"type": "li", "start": 33377, "end": 33416, "id": 963, "features": {}}, {"type": "a", "start": 33377, "end": 33415, "id": 964, "features": {"href": "/wiki/Outline_of_natural_language_processing", "title": "Outline of natural language processing"}}, {"type": "li", "start": 33416, "end": 33432, "id": 965, "features": {}}, {"type": "a", "start": 33416, "end": 33431, "id": 966, "features": {"href": "/wiki/Query_expansion", "title": "Query expansion"}}, {"type": "li", "start": 33432, "end": 33452, "id": 967, "features": {}}, {"type": "a", "start": 33432, "end": 33451, "id": 968, "features": {"href": "/wiki/Query_understanding", "title": "Query understanding"}}, {"type": "li", "start": 33452, "end": 33478, "id": 969, "features": {}}, {"type": "a", "start": 33452, "end": 33477, "id": 970, "features": {"href": "/wiki/Reification_(linguistics)", "title": "Reification (linguistics)"}}, {"type": "li", "start": 33478, "end": 33496, "id": 971, "features": {}}, {"type": "a", "start": 33478, "end": 33495, "id": 972, "features": {"href": "/wiki/Speech_processing", "title": "Speech processing"}}, {"type": "li", "start": 33496, "end": 33520, "id": 973, "features": {}}, {"type": "a", "start": 33496, "end": 33519, "id": 974, "features": {"href": "/wiki/Spoken_dialogue_systems", "class": "mw-redirect", "title": "Spoken dialogue systems"}}, {"type": "li", "start": 33520, "end": 33534, "id": 975, "features": {}}, {"type": "a", "start": 33520, "end": 33533, "id": 976, "features": {"href": "/wiki/Text-proofing", "class": "mw-redirect", "title": "Text-proofing"}}, {"type": "li", "start": 33534, "end": 33554, "id": 977, "features": {}}, {"type": "a", "start": 33534, "end": 33553, "id": 978, "features": {"href": "/wiki/Text_simplification", "title": "Text simplification"}}, {"type": "li", "start": 33554, "end": 33591, "id": 979, "features": {}}, {"type": "a", "start": 33554, "end": 33590, "id": 980, "features": {"href": "/wiki/Transformer_(machine_learning_model)", "title": "Transformer (machine learning model)"}}, {"type": "li", "start": 33591, "end": 33602, "id": 981, "features": {}}, {"type": "a", "start": 33591, "end": 33601, "id": 982, "features": {"href": "/wiki/Truecasing", "title": "Truecasing"}}, {"type": "li", "start": 33602, "end": 33621, "id": 983, "features": {}}, {"type": "a", "start": 33602, "end": 33620, "id": 984, "features": {"href": "/wiki/Question_answering", "title": "Question answering"}}, {"type": "li", "start": 33621, "end": 33630, "id": 985, "features": {}}, {"type": "a", "start": 33621, "end": 33629, "id": 986, "features": {"href": "/wiki/Word2vec", "title": "Word2vec"}}, {"type": "h2", "start": 33630, "end": 33645, "id": 987, "features": {"class": "section-heading", "onclick": "mfTempOpenSection(6)"}}, {"type": "div", "start": 33630, "end": 33630, "id": 988, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left mw-ui-button mw-ui-quiet"}}, {"type": "span", "start": 33630, "end": 33640, "id": 989, "features": {"class": "mw-headline", "id": "References"}}, {"type": "span", "start": 33640, "end": 33644, "id": 990, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 33640, "end": 33644, "id": 991, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=19", "title": "Edit section: References", "data-section": "19", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "section", "start": 33645, "end": 42773, "id": 992, "features": {"class": "mf-section-6 collapsible-block", "id": "mf-section-6"}}, {"type": "div", "start": 33645, "end": 42773, "id": 993, "features": {"class": "reflist reflist-columns references-column-width", "style": "column-width: 30em;"}}, {"type": "ol", "start": 33645, "end": 42773, "id": 994, "features": {"class": "references"}}, {"type": "li", "start": 33645, "end": 34097, "id": 995, "features": {"id": "cite_note-Kongthon-1"}}, {"type": "span", "start": 33645, "end": 33646, "id": 996, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 33645, "end": 33646, "id": 997, "features": {}}, {"type": "a", "start": 33645, "end": 33646, "id": 998, "features": {"href": "#cite_ref-Kongthon_1-0"}}, {"type": "span", "start": 33647, "end": 34096, "id": 999, "features": {"class": "reference-text"}}, {"type": "cite", "start": 33647, "end": 34096, "id": 1000, "features": {"id": "CITEREFKongthonSangkeettrakarnKongyoungHaruechaiyasak2009", "class": "citation conference cs1"}}, {"type": "i", "start": 33836, "end": 33918, "id": 1001, "features": {}}, {"type": "i", "start": 33925, "end": 33937, "id": 1002, "features": {}}, {"type": "a", "start": 34046, "end": 34049, "id": 1003, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 34050, "end": 34073, "id": 1004, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1145%2F1643823.1643908"}}, {"type": "a", "start": 34075, "end": 34079, "id": 1005, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 34080, "end": 34095, "id": 1006, "features": {"href": "/wiki/Special:BookSources/9781605588292", "title": "Special:BookSources/9781605588292"}}, {"type": "bdi", "start": 34081, "end": 34095, "id": 1007, "features": {}}, {"type": "span", "start": 34096, "end": 34096, "id": 1008, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=conference&rft.atitle=Implementing+an+online+help+desk+system+based+on+conversational+agent&rft.btitle=Proceedings+of+the+International+Conference+on+Management+of+Emergent+Digital+Eco+Systems+-+MEDES+%2709&rft.place=France&rft.pages=450&rft.pub=ACM&rft.date=2009-10-27%2F2009-10-30&rft_id=info%3Adoi%2F10.1145%2F1643823.1643908&rft.isbn=9781605588292&rft.aulast=Kongthon&rft.aufirst=Alisa&rft.au=Sangkeettrakarn%2C+Chatchawal&rft.au=Kongyoung%2C+Sarawoot&rft.au=Haruechaiyasak%2C+Choochart&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 34097, "end": 34201, "id": 1009, "features": {"id": "cite_note-2"}}, {"type": "span", "start": 34097, "end": 34098, "id": 1010, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 34097, "end": 34098, "id": 1011, "features": {}}, {"type": "a", "start": 34097, "end": 34098, "id": 1012, "features": {"href": "#cite_ref-2"}}, {"type": "span", "start": 34099, "end": 34200, "id": 1013, "features": {"class": "reference-text"}}, {"type": "link", "start": 34099, "end": 34099, "id": 1014, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 34099, "end": 34177, "id": 1015, "features": {"id": "CITEREFHutchins,_J.2005", "class": "citation web cs1"}}, {"type": "a", "start": 34120, "end": 34170, "id": 1016, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.hutchinsweb.me.uk/Nutshell-2005.pdf"}}, {"type": "span", "start": 34171, "end": 34176, "id": 1017, "features": {"class": "cs1-format"}}, {"type": "span", "start": 34177, "end": 34177, "id": 1018, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=unknown&rft.btitle=The+history+of+machine+translation+in+a+nutshell&rft.date=2005&rft.au=Hutchins%2C+J.&rft_id=http%3A%2F%2Fwww.hutchinsweb.me.uk%2FNutshell-2005.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "sup", "start": 34177, "end": 34200, "id": 1019, "features": {"class": "noprint Inline-Template", "style": "white-space:nowrap;"}}, {"type": "i", "start": 34178, "end": 34199, "id": 1020, "features": {}}, {"type": "a", "start": 34178, "end": 34199, "id": 1021, "features": {"href": "/wiki/Wikipedia:Verifiability#Self-published_sources", "title": "Wikipedia:Verifiability"}}, {"type": "span", "start": 34178, "end": 34199, "id": 1022, "features": {"title": "This reference citation appears to be to a self-published source. (December 2013)"}}, {"type": "li", "start": 34201, "end": 34387, "id": 1023, "features": {"id": "cite_note-3"}}, {"type": "span", "start": 34201, "end": 34202, "id": 1024, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 34201, "end": 34202, "id": 1025, "features": {}}, {"type": "a", "start": 34201, "end": 34202, "id": 1026, "features": {"href": "#cite_ref-3"}}, {"type": "span", "start": 34203, "end": 34386, "id": 1027, "features": {"class": "reference-text"}}, {"type": "link", "start": 34203, "end": 34203, "id": 1028, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 34203, "end": 34386, "id": 1029, "features": {"id": "CITEREFKoskenniemi1983", "class": "citation cs2"}}, {"type": "a", "start": 34203, "end": 34221, "id": 1030, "features": {"href": "/wiki/Kimmo_Koskenniemi", "title": "Kimmo Koskenniemi"}}, {"type": "a", "start": 34230, "end": 34321, "id": 1031, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.ling.helsinki.fi/~koskenni/doc/Two-LevelMorphology.pdf"}}, {"type": "i", "start": 34230, "end": 34321, "id": 1032, "features": {}}, {"type": "span", "start": 34322, "end": 34327, "id": 1033, "features": {"class": "cs1-format"}}, {"type": "a", "start": 34364, "end": 34386, "id": 1034, "features": {"href": "/wiki/University_of_Helsinki", "title": "University of Helsinki"}}, {"type": "span", "start": 34386, "end": 34386, "id": 1035, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Two-level+morphology%3A+A+general+computational+model+of+word-form+recognition+and+production&rft.pub=Department+of+General+Linguistics%2C+University+of+Helsinki&rft.date=1983&rft.aulast=Koskenniemi&rft.aufirst=Kimmo&rft_id=http%3A%2F%2Fwww.ling.helsinki.fi%2F~koskenni%2Fdoc%2FTwo-LevelMorphology.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 34387, "end": 34536, "id": 1036, "features": {"id": "cite_note-4"}}, {"type": "span", "start": 34387, "end": 34388, "id": 1037, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 34387, "end": 34388, "id": 1038, "features": {}}, {"type": "a", "start": 34387, "end": 34388, "id": 1039, "features": {"href": "#cite_ref-4"}}, {"type": "span", "start": 34389, "end": 34535, "id": 1040, "features": {"class": "reference-text"}}, {"type": "a", "start": 34435, "end": 34510, "id": 1041, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.ijcai.org/Proceedings/81-1/Papers/071.pdf"}}, {"type": "i", "start": 34515, "end": 34520, "id": 1042, "features": {}}, {"type": "li", "start": 34536, "end": 34753, "id": 1043, "features": {"id": "cite_note-5"}}, {"type": "span", "start": 34536, "end": 34537, "id": 1044, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 34536, "end": 34537, "id": 1045, "features": {}}, {"type": "a", "start": 34536, "end": 34537, "id": 1046, "features": {"href": "#cite_ref-5"}}, {"type": "span", "start": 34538, "end": 34752, "id": 1047, "features": {"class": "reference-text"}}, {"type": "link", "start": 34538, "end": 34538, "id": 1048, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 34538, "end": 34752, "id": 1049, "features": {"id": "CITEREFGuidaMauri1986", "class": "citation journal cs1"}}, {"type": "i", "start": 34648, "end": 34671, "id": 1050, "features": {}}, {"type": "b", "start": 34673, "end": 34675, "id": 1051, "features": {}}, {"type": "a", "start": 34692, "end": 34695, "id": 1052, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 34696, "end": 34719, "id": 1053, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1109%2FPROC.1986.13580"}}, {"type": "a", "start": 34721, "end": 34725, "id": 1054, "features": {"href": "/wiki/ISSN_(identifier)", "class": "mw-redirect", "title": "ISSN (identifier)"}}, {"type": "a", "start": 34726, "end": 34735, "id": 1055, "features": {"rel": "nofollow", "class": "external text", "href": "//www.worldcat.org/issn/1558-2256"}}, {"type": "a", "start": 34737, "end": 34742, "id": 1056, "features": {"href": "/wiki/S2CID_(identifier)", "class": "mw-redirect", "title": "S2CID (identifier)"}}, {"type": "a", "start": 34743, "end": 34751, "id": 1057, "features": {"rel": "nofollow", "class": "external text", "href": "https://api.semanticscholar.org/CorpusID:30688575"}}, {"type": "span", "start": 34752, "end": 34752, "id": 1058, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Proceedings+of+the+IEEE&rft.atitle=Evaluation+of+natural+language+processing+systems%3A+Issues+and+approaches&rft.volume=74&rft.issue=7&rft.pages=1026-1035&rft.date=1986-07&rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A30688575%23id-name%3DS2CID&rft.issn=1558-2256&rft_id=info%3Adoi%2F10.1109%2FPROC.1986.13580&rft.aulast=Guida&rft.aufirst=G.&rft.au=Mauri%2C+G.&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 34753, "end": 35602, "id": 1059, "features": {"id": "cite_note-6"}}, {"type": "span", "start": 34753, "end": 34754, "id": 1060, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 34753, "end": 34754, "id": 1061, "features": {}}, {"type": "a", "start": 34753, "end": 34754, "id": 1062, "features": {"href": "#cite_ref-6"}}, {"type": "span", "start": 34755, "end": 35601, "id": 1063, "features": {"class": "reference-text"}}, {"type": "a", "start": 34810, "end": 34822, "id": 1064, "features": {"href": "/wiki/Corner_case", "title": "Corner case"}}, {"type": "a", "start": 34888, "end": 34900, "id": 1065, "features": {"href": "/wiki/Pathological_(mathematics)", "title": "Pathological (mathematics)"}}, {"type": "a", "start": 34952, "end": 34971, "id": 1066, "features": {"href": "/wiki/Thought_experiment", "title": "Thought experiment"}}, {"type": "a", "start": 35084, "end": 35102, "id": 1067, "features": {"href": "/wiki/Corpus_linguistics", "title": "Corpus linguistics"}}, {"type": "a", "start": 35134, "end": 35141, "id": 1068, "features": {"href": "/wiki/Text_corpus", "title": "Text corpus"}}, {"type": "a", "start": 35335, "end": 35358, "id": 1069, "features": {"href": "/wiki/Poverty_of_the_stimulus", "title": "Poverty of the stimulus"}}, {"type": "li", "start": 35602, "end": 35810, "id": 1070, "features": {"id": "cite_note-goldberg:nnlp17-7"}}, {"type": "span", "start": 35602, "end": 35603, "id": 1071, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 35602, "end": 35603, "id": 1072, "features": {}}, {"type": "a", "start": 35602, "end": 35603, "id": 1073, "features": {"href": "#cite_ref-goldberg:nnlp17_7-0"}}, {"type": "span", "start": 35604, "end": 35809, "id": 1074, "features": {"class": "reference-text"}}, {"type": "link", "start": 35604, "end": 35604, "id": 1075, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 35604, "end": 35809, "id": 1076, "features": {"id": "CITEREFGoldberg2016", "class": "citation journal cs1"}}, {"type": "i", "start": 35696, "end": 35739, "id": 1077, "features": {}}, {"type": "b", "start": 35741, "end": 35743, "id": 1078, "features": {}}, {"type": "a", "start": 35754, "end": 35759, "id": 1079, "features": {"href": "/wiki/ArXiv_(identifier)", "class": "mw-redirect", "title": "ArXiv (identifier)"}}, {"type": "span", "start": 35760, "end": 35770, "id": 1080, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 35760, "end": 35770, "id": 1081, "features": {"rel": "nofollow", "class": "external text", "href": "//arxiv.org/abs/1807.10854"}}, {"type": "a", "start": 35772, "end": 35775, "id": 1082, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 35776, "end": 35793, "id": 1083, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1613%2Fjair.4992"}}, {"type": "a", "start": 35795, "end": 35800, "id": 1084, "features": {"href": "/wiki/S2CID_(identifier)", "class": "mw-redirect", "title": "S2CID (identifier)"}}, {"type": "a", "start": 35801, "end": 35808, "id": 1085, "features": {"rel": "nofollow", "class": "external text", "href": "https://api.semanticscholar.org/CorpusID:8273530"}}, {"type": "span", "start": 35809, "end": 35809, "id": 1086, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Journal+of+Artificial+Intelligence+Research&rft.atitle=A+Primer+on+Neural+Network+Models+for+Natural+Language+Processing&rft.volume=57&rft.pages=345-420&rft.date=2016&rft_id=info%3Aarxiv%2F1807.10854&rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A8273530%23id-name%3DS2CID&rft_id=info%3Adoi%2F10.1613%2Fjair.4992&rft.aulast=Goldberg&rft.aufirst=Yoav&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 35810, "end": 35896, "id": 1087, "features": {"id": "cite_note-goodfellow:book16-8"}}, {"type": "span", "start": 35810, "end": 35811, "id": 1088, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 35810, "end": 35811, "id": 1089, "features": {}}, {"type": "a", "start": 35810, "end": 35811, "id": 1090, "features": {"href": "#cite_ref-goodfellow:book16_8-0"}}, {"type": "span", "start": 35812, "end": 35895, "id": 1091, "features": {"class": "reference-text"}}, {"type": "link", "start": 35812, "end": 35812, "id": 1092, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 35812, "end": 35895, "id": 1093, "features": {"id": "CITEREFGoodfellowBengioCourville2016", "class": "citation book cs1"}}, {"type": "a", "start": 35870, "end": 35883, "id": 1094, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.deeplearningbook.org/"}}, {"type": "i", "start": 35870, "end": 35883, "id": 1095, "features": {}}, {"type": "span", "start": 35895, "end": 35895, "id": 1096, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Deep+Learning&rft.pub=MIT+Press&rft.date=2016&rft.aulast=Goodfellow&rft.aufirst=Ian&rft.au=Bengio%2C+Yoshua&rft.au=Courville%2C+Aaron&rft_id=http%3A%2F%2Fwww.deeplearningbook.org%2F&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 35896, "end": 36074, "id": 1097, "features": {"id": "cite_note-jozefowicz:lm16-9"}}, {"type": "span", "start": 35896, "end": 35897, "id": 1098, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 35896, "end": 35897, "id": 1099, "features": {}}, {"type": "a", "start": 35896, "end": 35897, "id": 1100, "features": {"href": "#cite_ref-jozefowicz:lm16_9-0"}}, {"type": "span", "start": 35898, "end": 36073, "id": 1101, "features": {"class": "reference-text"}}, {"type": "link", "start": 35898, "end": 35898, "id": 1102, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 35898, "end": 36073, "id": 1103, "features": {"id": "CITEREFJozefowiczVinyalsSchusterShazeer2016", "class": "citation book cs1"}}, {"type": "i", "start": 35984, "end": 36025, "id": 1104, "features": {}}, {"type": "a", "start": 36027, "end": 36032, "id": 1105, "features": {"href": "/wiki/ArXiv_(identifier)", "class": "mw-redirect", "title": "ArXiv (identifier)"}}, {"type": "span", "start": 36033, "end": 36043, "id": 1106, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 36033, "end": 36043, "id": 1107, "features": {"rel": "nofollow", "class": "external text", "href": "//arxiv.org/abs/1602.02410"}}, {"type": "a", "start": 36045, "end": 36052, "id": 1108, "features": {"href": "/wiki/Bibcode_(identifier)", "class": "mw-redirect", "title": "Bibcode (identifier)"}}, {"type": "a", "start": 36053, "end": 36072, "id": 1109, "features": {"rel": "nofollow", "class": "external text", "href": "https://ui.adsabs.harvard.edu/abs/2016arXiv160202410J"}}, {"type": "span", "start": 36073, "end": 36073, "id": 1110, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Exploring+the+Limits+of+Language+Modeling&rft.date=2016&rft_id=info%3Aarxiv%2F1602.02410&rft_id=info%3Abibcode%2F2016arXiv160202410J&rft.aulast=Jozefowicz&rft.aufirst=Rafal&rft.au=Vinyals%2C+Oriol&rft.au=Schuster%2C+Mike&rft.au=Shazeer%2C+Noam&rft.au=Wu%2C+Yonghui&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 36074, "end": 36217, "id": 1111, "features": {"id": "cite_note-choe:emnlp16-10"}}, {"type": "span", "start": 36074, "end": 36075, "id": 1112, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 36074, "end": 36075, "id": 1113, "features": {}}, {"type": "a", "start": 36074, "end": 36075, "id": 1114, "features": {"href": "#cite_ref-choe:emnlp16_10-0"}}, {"type": "span", "start": 36076, "end": 36216, "id": 1115, "features": {"class": "reference-text"}}, {"type": "link", "start": 36076, "end": 36076, "id": 1116, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 36076, "end": 36216, "id": 1117, "features": {"id": "CITEREFChoeCharniak", "class": "citation journal cs1"}}, {"type": "a", "start": 36109, "end": 36139, "id": 1118, "features": {"rel": "nofollow", "class": "external text", "href": "https://web.archive.org/web/20181023034804/https://aclanthology.coli.uni-saarland.de/papers/D16-1257/d16-1257"}}, {"type": "i", "start": 36141, "end": 36151, "id": 1119, "features": {}}, {"type": "a", "start": 36167, "end": 36179, "id": 1120, "features": {"rel": "nofollow", "class": "external text", "href": "https://aclanthology.coli.uni-saarland.de/papers/D16-1257/d16-1257"}}, {"type": "span", "start": 36193, "end": 36215, "id": 1121, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 36205, "end": 36215, "id": 1122, "features": {"class": "nowrap"}}, {"type": "span", "start": 36216, "end": 36216, "id": 1123, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Emnlp+2016&rft.atitle=Parsing+as+Language+Modeling&rft.aulast=Choe&rft.aufirst=Do+Kook&rft.au=Charniak%2C+Eugene&rft_id=https%3A%2F%2Faclanthology.coli.uni-saarland.de%2Fpapers%2FD16-1257%2Fd16-1257&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 36217, "end": 36346, "id": 1124, "features": {"id": "cite_note-vinyals:nips15-11"}}, {"type": "span", "start": 36217, "end": 36218, "id": 1125, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 36217, "end": 36218, "id": 1126, "features": {}}, {"type": "a", "start": 36217, "end": 36218, "id": 1127, "features": {"href": "#cite_ref-vinyals:nips15_11-0"}}, {"type": "span", "start": 36219, "end": 36345, "id": 1128, "features": {"class": "reference-text"}}, {"type": "link", "start": 36219, "end": 36219, "id": 1129, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 36219, "end": 36345, "id": 1130, "features": {"id": "CITEREFVinyalsKaiser2014", "class": "citation journal cs1"}}, {"type": "a", "start": 36251, "end": 36282, "id": 1131, "features": {"rel": "nofollow", "class": "external text", "href": "https://papers.nips.cc/paper/5635-grammar-as-a-foreign-language.pdf"}}, {"type": "span", "start": 36283, "end": 36288, "id": 1132, "features": {"class": "cs1-format"}}, {"type": "i", "start": 36290, "end": 36298, "id": 1133, "features": {}}, {"type": "a", "start": 36300, "end": 36305, "id": 1134, "features": {"href": "/wiki/ArXiv_(identifier)", "class": "mw-redirect", "title": "ArXiv (identifier)"}}, {"type": "span", "start": 36306, "end": 36315, "id": 1135, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 36306, "end": 36315, "id": 1136, "features": {"rel": "nofollow", "class": "external text", "href": "//arxiv.org/abs/1412.7449"}}, {"type": "a", "start": 36317, "end": 36324, "id": 1137, "features": {"href": "/wiki/Bibcode_(identifier)", "class": "mw-redirect", "title": "Bibcode (identifier)"}}, {"type": "a", "start": 36325, "end": 36344, "id": 1138, "features": {"rel": "nofollow", "class": "external text", "href": "https://ui.adsabs.harvard.edu/abs/2014arXiv1412.7449V"}}, {"type": "span", "start": 36345, "end": 36345, "id": 1139, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Nips2015&rft.atitle=Grammar+as+a+Foreign+Language&rft.date=2014&rft_id=info%3Aarxiv%2F1412.7449&rft_id=info%3Abibcode%2F2014arXiv1412.7449V&rft.aulast=Vinyals&rft.aufirst=Oriol&rft.au=Kaiser%2C+Lukasz&rft_id=https%3A%2F%2Fpapers.nips.cc%2Fpaper%2F5635-grammar-as-a-foreign-language.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 36346, "end": 36648, "id": 1140, "features": {"id": "cite_note-12"}}, {"type": "span", "start": 36346, "end": 36347, "id": 1141, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 36346, "end": 36347, "id": 1142, "features": {}}, {"type": "a", "start": 36346, "end": 36347, "id": 1143, "features": {"href": "#cite_ref-12"}}, {"type": "span", "start": 36348, "end": 36647, "id": 1144, "features": {"class": "reference-text"}}, {"type": "link", "start": 36348, "end": 36348, "id": 1145, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 36348, "end": 36647, "id": 1146, "features": {"id": "CITEREFTurchinFlorez_Builes2021", "class": "citation journal cs1"}}, {"type": "a", "start": 36406, "end": 36510, "id": 1147, "features": {"rel": "nofollow", "class": "external text", "href": "//www.ncbi.nlm.nih.gov/pmc/articles/PMC8120048"}}, {"type": "i", "start": 36512, "end": 36554, "id": 1148, "features": {}}, {"type": "b", "start": 36556, "end": 36558, "id": 1149, "features": {}}, {"type": "a", "start": 36573, "end": 36576, "id": 1150, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 36577, "end": 36602, "id": 1151, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1177%2F19322968211000831"}}, {"type": "a", "start": 36604, "end": 36608, "id": 1152, "features": {"href": "/wiki/ISSN_(identifier)", "class": "mw-redirect", "title": "ISSN (identifier)"}}, {"type": "a", "start": 36609, "end": 36618, "id": 1153, "features": {"rel": "nofollow", "class": "external text", "href": "//www.worldcat.org/issn/1932-2968"}}, {"type": "a", "start": 36620, "end": 36623, "id": 1154, "features": {"href": "/wiki/PMC_(identifier)", "class": "mw-redirect", "title": "PMC (identifier)"}}, {"type": "span", "start": 36624, "end": 36631, "id": 1155, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 36624, "end": 36631, "id": 1156, "features": {"rel": "nofollow", "class": "external text", "href": "//www.ncbi.nlm.nih.gov/pmc/articles/PMC8120048"}}, {"type": "a", "start": 36633, "end": 36637, "id": 1157, "features": {"href": "/wiki/PMID_(identifier)", "class": "mw-redirect", "title": "PMID (identifier)"}}, {"type": "a", "start": 36638, "end": 36646, "id": 1158, "features": {"rel": "nofollow", "class": "external text", "href": "//pubmed.ncbi.nlm.nih.gov/33736486"}}, {"type": "span", "start": 36647, "end": 36647, "id": 1159, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Journal+of+Diabetes+Science+and+Technology&rft.atitle=Using+Natural+Language+Processing+to+Measure+and+Improve+Quality+of+Diabetes+Care%3A+A+Systematic+Review&rft.volume=15&rft.issue=3&rft.pages=553-560&rft.date=2021-03-19&rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC8120048%23id-name%3DPMC&rft.issn=1932-2968&rft_id=info%3Apmid%2F33736486&rft_id=info%3Adoi%2F10.1177%2F19322968211000831&rft.aulast=Turchin&rft.aufirst=Alexander&rft.au=Florez+Builes%2C+Luisa+F.&rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC8120048&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 36648, "end": 36781, "id": 1160, "features": {"id": "cite_note-winograd:shrdlu71-13"}}, {"type": "span", "start": 36648, "end": 36649, "id": 1161, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 36648, "end": 36649, "id": 1162, "features": {}}, {"type": "a", "start": 36648, "end": 36649, "id": 1163, "features": {"href": "#cite_ref-winograd:shrdlu71_13-0"}}, {"type": "span", "start": 36650, "end": 36780, "id": 1164, "features": {"class": "reference-text"}}, {"type": "link", "start": 36650, "end": 36650, "id": 1165, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 36650, "end": 36780, "id": 1166, "features": {"id": "CITEREFWinograd1971", "class": "citation thesis cs1"}}, {"type": "a", "start": 36674, "end": 36770, "id": 1167, "features": {"rel": "nofollow", "class": "external text", "href": "http://hci.stanford.edu/winograd/shrdlu/"}}, {"type": "i", "start": 36674, "end": 36770, "id": 1168, "features": {}}, {"type": "span", "start": 36780, "end": 36780, "id": 1169, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Adissertation&rft.title=Procedures+as+a+Representation+for+Data+in+a+Computer+Program+for+Understanding+Natural+Language&rft.date=1971&rft.aulast=Winograd&rft.aufirst=Terry&rft_id=http%3A%2F%2Fhci.stanford.edu%2Fwinograd%2Fshrdlu%2F&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 36781, "end": 36956, "id": 1170, "features": {"id": "cite_note-schank77-14"}}, {"type": "span", "start": 36781, "end": 36782, "id": 1171, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 36781, "end": 36782, "id": 1172, "features": {}}, {"type": "a", "start": 36781, "end": 36782, "id": 1173, "features": {"href": "#cite_ref-schank77_14-0"}}, {"type": "span", "start": 36783, "end": 36955, "id": 1174, "features": {"class": "reference-text"}}, {"type": "link", "start": 36783, "end": 36783, "id": 1175, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 36783, "end": 36955, "id": 1176, "features": {"id": "CITEREFSchankAbelson1977", "class": "citation book cs1"}}, {"type": "i", "start": 36828, "end": 36912, "id": 1177, "features": {}}, {"type": "a", "start": 36934, "end": 36938, "id": 1178, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 36939, "end": 36954, "id": 1179, "features": {"href": "/wiki/Special:BookSources/0-470-99033-3", "title": "Special:BookSources/0-470-99033-3"}}, {"type": "bdi", "start": 36940, "end": 36954, "id": 1180, "features": {}}, {"type": "span", "start": 36955, "end": 36955, "id": 1181, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Scripts%2C+Plans%2C+Goals%2C+and+Understanding%3A+An+Inquiry+Into+Human+Knowledge+Structures&rft.place=Hillsdale&rft.pub=Erlbaum&rft.date=1977&rft.isbn=0-470-99033-3&rft.aulast=Schank&rft.aufirst=Roger+C.&rft.au=Abelson%2C+Robert+P.&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 36956, "end": 37148, "id": 1182, "features": {"id": "cite_note-johnson:eacl:ilcl09-15"}}, {"type": "span", "start": 36956, "end": 36957, "id": 1183, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 36956, "end": 36957, "id": 1184, "features": {}}, {"type": "a", "start": 36956, "end": 36957, "id": 1185, "features": {"href": "#cite_ref-johnson:eacl:ilcl09_15-0"}}, {"type": "span", "start": 36958, "end": 37147, "id": 1186, "features": {"class": "reference-text"}}, {"type": "a", "start": 36958, "end": 37039, "id": 1187, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.aclweb.org/anthology/W09-0103"}}, {"type": "li", "start": 37148, "end": 37215, "id": 1188, "features": {"id": "cite_note-resnik:langlog11-16"}}, {"type": "span", "start": 37148, "end": 37149, "id": 1189, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 37148, "end": 37149, "id": 1190, "features": {}}, {"type": "a", "start": 37148, "end": 37149, "id": 1191, "features": {"href": "#cite_ref-resnik:langlog11_16-0"}}, {"type": "span", "start": 37150, "end": 37214, "id": 1192, "features": {"class": "reference-text"}}, {"type": "a", "start": 37150, "end": 37182, "id": 1193, "features": {"rel": "nofollow", "class": "external text", "href": "http://languagelog.ldc.upenn.edu/nll/?p=2946"}}, {"type": "li", "start": 37215, "end": 37277, "id": 1194, "features": {"id": "cite_note-17"}}, {"type": "span", "start": 37215, "end": 37216, "id": 1195, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 37215, "end": 37216, "id": 1196, "features": {}}, {"type": "a", "start": 37215, "end": 37216, "id": 1197, "features": {"href": "#cite_ref-17"}}, {"type": "span", "start": 37217, "end": 37276, "id": 1198, "features": {"class": "reference-text"}}, {"type": "link", "start": 37217, "end": 37217, "id": 1199, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 37217, "end": 37276, "id": 1200, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 37217, "end": 37269, "id": 1201, "features": {"rel": "nofollow", "class": "external text", "href": "https://wabyking.github.io/talks/mila-talk.pdf"}}, {"type": "span", "start": 37270, "end": 37275, "id": 1202, "features": {"class": "cs1-format"}}, {"type": "span", "start": 37276, "end": 37276, "id": 1203, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=unknown&rft.btitle=Investigating+complex-valued+representation+in+NLP&rft_id=https%3A%2F%2Fwabyking.github.io%2Ftalks%2Fmila-talk.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 37277, "end": 37525, "id": 1204, "features": {"id": "cite_note-18"}}, {"type": "span", "start": 37277, "end": 37278, "id": 1205, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 37277, "end": 37278, "id": 1206, "features": {}}, {"type": "a", "start": 37277, "end": 37278, "id": 1207, "features": {"href": "#cite_ref-18"}}, {"type": "span", "start": 37279, "end": 37524, "id": 1208, "features": {"class": "reference-text"}}, {"type": "link", "start": 37279, "end": 37279, "id": 1209, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 37279, "end": 37524, "id": 1210, "features": {"id": "CITEREFTrabelsiBilaniukZhangSerdyuk2018", "class": "citation arxiv cs1"}}, {"type": "a", "start": 37499, "end": 37504, "id": 1211, "features": {"href": "/wiki/ArXiv_(identifier)", "class": "mw-redirect", "title": "ArXiv (identifier)"}}, {"type": "span", "start": 37505, "end": 37515, "id": 1212, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 37505, "end": 37515, "id": 1213, "features": {"rel": "nofollow", "class": "external text", "href": "//arxiv.org/abs/1705.09792"}}, {"type": "a", "start": 37517, "end": 37522, "id": 1214, "features": {"rel": "nofollow", "class": "external text", "href": "//arxiv.org/archive/cs.NE"}}, {"type": "span", "start": 37524, "end": 37524, "id": 1215, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=preprint&rft.jtitle=arXiv&rft.atitle=Deep+Complex+Networks&rft.date=2018-02-25&rft_id=info%3Aarxiv%2F1705.09792&rft.aulast=Trabelsi&rft.aufirst=Chiheb&rft.au=Bilaniuk%2C+Olexa&rft.au=Zhang%2C+Ying&rft.au=Serdyuk%2C+Dmitriy&rft.au=Subramanian%2C+Sandeep&rft.au=Santos%2C+Jo%C3%A3o+Felipe&rft.au=Mehri%2C+Soroush&rft.au=Rostamzadeh%2C+Negar&rft.au=Bengio%2C+Yoshua&rft.au=Pal%2C+Christopher+J.&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 37525, "end": 37935, "id": 1216, "features": {"id": "cite_note-19"}}, {"type": "span", "start": 37525, "end": 37526, "id": 1217, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 37525, "end": 37526, "id": 1218, "features": {}}, {"type": "a", "start": 37525, "end": 37526, "id": 1219, "features": {"href": "#cite_ref-19"}}, {"type": "span", "start": 37527, "end": 37934, "id": 1220, "features": {"class": "reference-text"}}, {"type": "link", "start": 37527, "end": 37527, "id": 1221, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 37527, "end": 37624, "id": 1222, "features": {"id": "CITEREFSocher", "class": "citation web cs1"}}, {"type": "a", "start": 37544, "end": 37585, "id": 1223, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.socher.org/index.php/Main/DeepLearningForNLP-ACL2012Tutorial"}}, {"type": "i", "start": 37587, "end": 37601, "id": 1224, "features": {}}, {"type": "span", "start": 37601, "end": 37623, "id": 1225, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 37613, "end": 37623, "id": 1226, "features": {"class": "nowrap"}}, {"type": "span", "start": 37624, "end": 37624, "id": 1227, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.socher.org&rft.atitle=Deep+Learning+For+NLP-ACL+2012+Tutorial&rft.aulast=Socher&rft.aufirst=Richard&rft_id=https%3A%2F%2Fwww.socher.org%2Findex.php%2FMain%2FDeepLearningForNLP-ACL2012Tutorial&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 37935, "end": 38204, "id": 1228, "features": {"id": "cite_note-20"}}, {"type": "span", "start": 37935, "end": 37936, "id": 1229, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 37935, "end": 37936, "id": 1230, "features": {}}, {"type": "a", "start": 37935, "end": 37936, "id": 1231, "features": {"href": "#cite_ref-20"}}, {"type": "span", "start": 37937, "end": 38204, "id": 1232, "features": {"class": "reference-text"}}, {"type": "link", "start": 37937, "end": 37937, "id": 1233, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 37937, "end": 38204, "id": 1234, "features": {"id": "CITEREFYiTian2012", "class": "citation cs2"}}, {"type": "i", "start": 38038, "end": 38084, "id": 1235, "features": {}}, {"type": "a", "start": 38125, "end": 38134, "id": 1236, "features": {"href": "/wiki/CiteSeerX_(identifier)", "class": "mw-redirect", "title": "CiteSeerX (identifier)"}}, {"type": "span", "start": 38135, "end": 38149, "id": 1237, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 38135, "end": 38149, "id": 1238, "features": {"rel": "nofollow", "class": "external text", "href": "//citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.668.869"}}, {"type": "a", "start": 38151, "end": 38154, "id": 1239, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 38155, "end": 38182, "id": 1240, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1007%2F978-3-642-29364-1_2"}}, {"type": "a", "start": 38184, "end": 38188, "id": 1241, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 38189, "end": 38204, "id": 1242, "features": {"href": "/wiki/Special:BookSources/9783642293634", "title": "Special:BookSources/9783642293634"}}, {"type": "bdi", "start": 38190, "end": 38204, "id": 1243, "features": {}}, {"type": "span", "start": 38204, "end": 38204, "id": 1244, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Camera-Based+Document+Analysis+and+Recognition&rft.atitle=Assistive+Text+Reading+from+Complex+Background+for+Blind+Persons&rft.pages=15-28&rft.date=2012&rft_id=%2F%2Fciteseerx.ist.psu.edu%2Fviewdoc%2Fsummary%3Fdoi%3D10.1.1.668.869%23id-name%3DCiteSeerX&rft_id=info%3Adoi%2F10.1007%2F978-3-642-29364-1_2&rft.isbn=9783642293634&rft.aulast=Yi&rft.aufirst=Chucai&rft.au=Tian%2C+Yingli&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 38204, "end": 38324, "id": 1245, "features": {"id": "cite_note-21"}}, {"type": "span", "start": 38204, "end": 38205, "id": 1246, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 38204, "end": 38205, "id": 1247, "features": {}}, {"type": "a", "start": 38204, "end": 38205, "id": 1248, "features": {"href": "#cite_ref-21"}}, {"type": "span", "start": 38206, "end": 38323, "id": 1249, "features": {"class": "reference-text"}}, {"type": "link", "start": 38206, "end": 38206, "id": 1250, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 38206, "end": 38323, "id": 1251, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 38206, "end": 38277, "id": 1252, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.gyansetu.in/what-is-natural-language-processing/"}}, {"type": "i", "start": 38279, "end": 38288, "id": 1253, "features": {}}, {"type": "span", "start": 38300, "end": 38322, "id": 1254, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 38312, "end": 38322, "id": 1255, "features": {"class": "nowrap"}}, {"type": "span", "start": 38323, "end": 38323, "id": 1256, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=GyanSetu%21&rft.atitle=What+is+Natural+Language+Processing%3F+Intro+to+NLP+in+Machine+Learning&rft.date=2020-12-06&rft_id=https%3A%2F%2Fwww.gyansetu.in%2Fwhat-is-natural-language-processing%2F&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 38324, "end": 38619, "id": 1257, "features": {"id": "cite_note-22"}}, {"type": "span", "start": 38324, "end": 38325, "id": 1258, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 38324, "end": 38325, "id": 1259, "features": {}}, {"type": "a", "start": 38324, "end": 38325, "id": 1260, "features": {"href": "#cite_ref-22"}}, {"type": "span", "start": 38326, "end": 38618, "id": 1261, "features": {"class": "reference-text"}}, {"type": "link", "start": 38326, "end": 38326, "id": 1262, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 38326, "end": 38571, "id": 1263, "features": {"id": "CITEREFKishorjitVidyaNirmalSivaji2012", "class": "citation journal cs1"}}, {"type": "a", "start": 38388, "end": 38422, "id": 1264, "features": {"rel": "nofollow", "class": "external text", "href": "http://aclweb.org/anthology//W/W12/W12-5008.pdf"}}, {"type": "span", "start": 38423, "end": 38428, "id": 1265, "features": {"class": "cs1-format"}}, {"type": "i", "start": 38430, "end": 38526, "id": 1266, "features": {}}, {"type": "span", "start": 38571, "end": 38571, "id": 1267, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Proceedings+of+the+3rd+Workshop+on+South+and+Southeast+Asian+Natural+Language+Processing+%28SANLP%29&rft.atitle=Manipuri+Morpheme+Identification&rft.pages=95-108&rft.date=2012&rft.aulast=Kishorjit&rft.aufirst=N.&rft.au=Vidya%2C+Raj+RK.&rft.au=Nirmal%2C+Y.&rft.au=Sivaji%2C+B.&rft_id=http%3A%2F%2Faclweb.org%2Fanthology%2F%2FW%2FW12%2FW12-5008.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "span", "start": 38571, "end": 38618, "id": 1268, "features": {"class": "cs1-maint citation-comment"}}, {"type": "code", "start": 38572, "end": 38589, "id": 1269, "features": {"class": "cs1-code"}}, {"type": "a", "start": 38574, "end": 38586, "id": 1270, "features": {"href": "/wiki/Template:Cite_journal", "title": "Template:Cite journal"}}, {"type": "a", "start": 38613, "end": 38617, "id": 1271, "features": {"href": "/wiki/Category:CS1_maint:_location", "title": "Category:CS1 maint: location"}}, {"type": "li", "start": 38619, "end": 38794, "id": 1272, "features": {"id": "cite_note-23"}}, {"type": "span", "start": 38619, "end": 38620, "id": 1273, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 38619, "end": 38620, "id": 1274, "features": {}}, {"type": "a", "start": 38619, "end": 38620, "id": 1275, "features": {"href": "#cite_ref-23"}}, {"type": "span", "start": 38621, "end": 38793, "id": 1276, "features": {"class": "reference-text"}}, {"type": "link", "start": 38621, "end": 38621, "id": 1277, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 38621, "end": 38793, "id": 1278, "features": {"id": "CITEREFKleinManning2002", "class": "citation journal cs1"}}, {"type": "a", "start": 38665, "end": 38735, "id": 1279, "features": {"rel": "nofollow", "class": "external text", "href": "http://papers.nips.cc/paper/1945-natural-language-grammar-induction-using-a-constituent-context-model.pdf"}}, {"type": "span", "start": 38736, "end": 38741, "id": 1280, "features": {"class": "cs1-format"}}, {"type": "i", "start": 38743, "end": 38792, "id": 1281, "features": {}}, {"type": "span", "start": 38793, "end": 38793, "id": 1282, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Advances+in+Neural+Information+Processing+Systems&rft.atitle=Natural+language+grammar+induction+using+a+constituent-context+model&rft.date=2002&rft.aulast=Klein&rft.aufirst=Dan&rft.au=Manning%2C+Christopher+D.&rft_id=http%3A%2F%2Fpapers.nips.cc%2Fpaper%2F1945-natural-language-grammar-induction-using-a-constituent-context-model.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 38794, "end": 38884, "id": 1283, "features": {"id": "cite_note-rte:11-24"}}, {"type": "span", "start": 38794, "end": 38795, "id": 1284, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 38794, "end": 38795, "id": 1285, "features": {}}, {"type": "a", "start": 38794, "end": 38795, "id": 1286, "features": {"href": "#cite_ref-rte:11_24-0"}}, {"type": "span", "start": 38796, "end": 38883, "id": 1287, "features": {"class": "reference-text"}}, {"type": "a", "start": 38852, "end": 38883, "id": 1288, "features": {"rel": "nofollow", "class": "external free", "href": "https://tac.nist.gov//2011/RTE/"}}, {"type": "li", "start": 38884, "end": 39116, "id": 1289, "features": {"id": "cite_note-25"}}, {"type": "span", "start": 38884, "end": 38885, "id": 1290, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 38884, "end": 38885, "id": 1291, "features": {}}, {"type": "a", "start": 38884, "end": 38885, "id": 1292, "features": {"href": "#cite_ref-25"}}, {"type": "span", "start": 38886, "end": 39115, "id": 1293, "features": {"class": "reference-text"}}, {"type": "link", "start": 38886, "end": 38886, "id": 1294, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 38886, "end": 39115, "id": 1295, "features": {"id": "CITEREFLippiTorroni2016", "class": "citation journal cs1"}}, {"type": "a", "start": 38929, "end": 38989, "id": 1296, "features": {"rel": "nofollow", "class": "external text", "href": "https://dl.acm.org/doi/10.1145/2850417"}}, {"type": "i", "start": 38991, "end": 39030, "id": 1297, "features": {}}, {"type": "b", "start": 39032, "end": 39034, "id": 1298, "features": {}}, {"type": "a", "start": 39046, "end": 39049, "id": 1299, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 39050, "end": 39065, "id": 1300, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1145%2F2850417"}}, {"type": "a", "start": 39067, "end": 39070, "id": 1301, "features": {"href": "/wiki/Hdl_(identifier)", "class": "mw-redirect", "title": "Hdl (identifier)"}}, {"type": "a", "start": 39071, "end": 39083, "id": 1302, "features": {"rel": "nofollow", "class": "external text", "href": "//hdl.handle.net/11585%2F523460"}}, {"type": "a", "start": 39085, "end": 39089, "id": 1303, "features": {"href": "/wiki/ISSN_(identifier)", "class": "mw-redirect", "title": "ISSN (identifier)"}}, {"type": "a", "start": 39090, "end": 39099, "id": 1304, "features": {"rel": "nofollow", "class": "external text", "href": "//www.worldcat.org/issn/1533-5399"}}, {"type": "a", "start": 39101, "end": 39106, "id": 1305, "features": {"href": "/wiki/S2CID_(identifier)", "class": "mw-redirect", "title": "S2CID (identifier)"}}, {"type": "a", "start": 39107, "end": 39114, "id": 1306, "features": {"rel": "nofollow", "class": "external text", "href": "https://api.semanticscholar.org/CorpusID:9561587"}}, {"type": "span", "start": 39115, "end": 39115, "id": 1307, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=ACM+Transactions+on+Internet+Technology&rft.atitle=Argumentation+Mining%3A+State+of+the+Art+and+Emerging+Trends&rft.volume=16&rft.issue=2&rft.pages=1-25&rft.date=2016-04-20&rft_id=info%3Ahdl%2F11585%2F523460&rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A9561587%23id-name%3DS2CID&rft.issn=1533-5399&rft_id=info%3Adoi%2F10.1145%2F2850417&rft.aulast=Lippi&rft.aufirst=Marco&rft.au=Torroni%2C+Paolo&rft_id=https%3A%2F%2Fdl.acm.org%2Fdoi%2F10.1145%2F2850417&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 39116, "end": 39198, "id": 1308, "features": {"id": "cite_note-26"}}, {"type": "span", "start": 39116, "end": 39117, "id": 1309, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 39116, "end": 39117, "id": 1310, "features": {}}, {"type": "a", "start": 39116, "end": 39117, "id": 1311, "features": {"href": "#cite_ref-26"}}, {"type": "span", "start": 39118, "end": 39197, "id": 1312, "features": {"class": "reference-text"}}, {"type": "link", "start": 39118, "end": 39118, "id": 1313, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 39118, "end": 39197, "id": 1314, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 39118, "end": 39156, "id": 1315, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.i3s.unice.fr/~villata/tutorialIJCAI2016.html"}}, {"type": "i", "start": 39158, "end": 39174, "id": 1316, "features": {}}, {"type": "span", "start": 39174, "end": 39196, "id": 1317, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 39186, "end": 39196, "id": 1318, "features": {"class": "nowrap"}}, {"type": "span", "start": 39197, "end": 39197, "id": 1319, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.i3s.unice.fr&rft.atitle=Argument+Mining+-+IJCAI2016+Tutorial&rft_id=https%3A%2F%2Fwww.i3s.unice.fr%2F~villata%2FtutorialIJCAI2016.html&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 39198, "end": 39290, "id": 1320, "features": {"id": "cite_note-27"}}, {"type": "span", "start": 39198, "end": 39199, "id": 1321, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 39198, "end": 39199, "id": 1322, "features": {}}, {"type": "a", "start": 39198, "end": 39199, "id": 1323, "features": {"href": "#cite_ref-27"}}, {"type": "span", "start": 39200, "end": 39289, "id": 1324, "features": {"class": "reference-text"}}, {"type": "link", "start": 39200, "end": 39200, "id": 1325, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 39200, "end": 39289, "id": 1326, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 39200, "end": 39266, "id": 1327, "features": {"rel": "nofollow", "class": "external text", "href": "http://acl2016tutorial.arg.tech/"}}, {"type": "span", "start": 39266, "end": 39288, "id": 1328, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 39278, "end": 39288, "id": 1329, "features": {"class": "nowrap"}}, {"type": "span", "start": 39289, "end": 39289, "id": 1330, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=unknown&rft.btitle=NLP+Approaches+to+Computational+Argumentation+%E2%80%93+ACL+2016%2C+Berlin&rft_id=http%3A%2F%2Facl2016tutorial.arg.tech%2F&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 39290, "end": 39352, "id": 1331, "features": {"id": "cite_note-28"}}, {"type": "span", "start": 39290, "end": 39291, "id": 1332, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 39290, "end": 39291, "id": 1333, "features": {}}, {"type": "a", "start": 39290, "end": 39291, "id": 1334, "features": {"href": "#cite_ref-28"}}, {"type": "span", "start": 39292, "end": 39351, "id": 1335, "features": {"class": "reference-text"}}, {"type": "link", "start": 39292, "end": 39292, "id": 1336, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 39292, "end": 39351, "id": 1337, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 39292, "end": 39315, "id": 1338, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.ubu.com/historical/racter/index.html"}}, {"type": "i", "start": 39317, "end": 39328, "id": 1339, "features": {}}, {"type": "span", "start": 39328, "end": 39350, "id": 1340, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 39340, "end": 39350, "id": 1341, "features": {"class": "nowrap"}}, {"type": "span", "start": 39351, "end": 39351, "id": 1342, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.ubu.com&rft.atitle=U+B+U+W+E+B+%3A%3A+Racter&rft_id=http%3A%2F%2Fwww.ubu.com%2Fhistorical%2Fracter%2Findex.html&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 39352, "end": 39472, "id": 1343, "features": {"id": "cite_note-29"}}, {"type": "span", "start": 39352, "end": 39353, "id": 1344, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 39352, "end": 39353, "id": 1345, "features": {}}, {"type": "a", "start": 39352, "end": 39353, "id": 1346, "features": {"href": "#cite_ref-29"}}, {"type": "span", "start": 39354, "end": 39471, "id": 1347, "features": {"class": "reference-text"}}, {"type": "link", "start": 39354, "end": 39354, "id": 1348, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 39354, "end": 39471, "id": 1349, "features": {"id": "CITEREFWriter2019", "class": "citation book cs1"}}, {"type": "i", "start": 39375, "end": 39396, "id": 1350, "features": {}}, {"type": "a", "start": 39398, "end": 39401, "id": 1351, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 39402, "end": 39427, "id": 1352, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1007%2F978-3-030-16800-1"}}, {"type": "a", "start": 39429, "end": 39433, "id": 1353, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 39434, "end": 39453, "id": 1354, "features": {"href": "/wiki/Special:BookSources/978-3-030-16799-8", "title": "Special:BookSources/978-3-030-16799-8"}}, {"type": "bdi", "start": 39435, "end": 39453, "id": 1355, "features": {}}, {"type": "a", "start": 39455, "end": 39460, "id": 1356, "features": {"href": "/wiki/S2CID_(identifier)", "class": "mw-redirect", "title": "S2CID (identifier)"}}, {"type": "a", "start": 39461, "end": 39470, "id": 1357, "features": {"rel": "nofollow", "class": "external text", "href": "https://api.semanticscholar.org/CorpusID:155818532"}}, {"type": "span", "start": 39471, "end": 39471, "id": 1358, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Lithium-Ion+Batteries&rft.date=2019&rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A155818532%23id-name%3DS2CID&rft_id=info%3Adoi%2F10.1007%2F978-3-030-16800-1&rft.isbn=978-3-030-16799-8&rft.aulast=Writer&rft.aufirst=Beta&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 39472, "end": 39627, "id": 1359, "features": {"id": "cite_note-30"}}, {"type": "span", "start": 39472, "end": 39473, "id": 1360, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 39472, "end": 39473, "id": 1361, "features": {}}, {"type": "a", "start": 39472, "end": 39473, "id": 1362, "features": {"href": "#cite_ref-30"}}, {"type": "span", "start": 39474, "end": 39626, "id": 1363, "features": {"class": "reference-text"}}, {"type": "link", "start": 39474, "end": 39474, "id": 1364, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 39474, "end": 39626, "id": 1365, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 39474, "end": 39544, "id": 1366, "features": {"rel": "nofollow", "class": "external text", "href": "https://ghostarchive.org/varchive/youtube/20211030/7dtl650D0y0"}}, {"type": "i", "start": 39546, "end": 39561, "id": 1367, "features": {}}, {"type": "a", "start": 39577, "end": 39589, "id": 1368, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.youtube.com/watch?v=7dtl650D0y0"}}, {"type": "span", "start": 39603, "end": 39625, "id": 1369, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 39615, "end": 39625, "id": 1370, "features": {"class": "nowrap"}}, {"type": "span", "start": 39626, "end": 39626, "id": 1371, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.youtube.com&rft.atitle=Document+Understanding+AI+on+Google+Cloud+%28Cloud+Next+%2719%29+-+YouTube&rft_id=https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D7dtl650D0y0&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 39627, "end": 39729, "id": 1372, "features": {"id": "cite_note-31"}}, {"type": "span", "start": 39627, "end": 39628, "id": 1373, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 39627, "end": 39628, "id": 1374, "features": {}}, {"type": "a", "start": 39627, "end": 39628, "id": 1375, "features": {"href": "#cite_ref-31"}}, {"type": "span", "start": 39629, "end": 39728, "id": 1376, "features": {"class": "reference-text"}}, {"type": "link", "start": 39629, "end": 39629, "id": 1377, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 39629, "end": 39728, "id": 1378, "features": {"id": "CITEREFAdministration", "class": "citation web cs1"}}, {"type": "a", "start": 39645, "end": 39683, "id": 1379, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.mq.edu.au/research/research-centres-groups-and-facilities/innovative-technologies/centres/centre-for-language-technology-clt"}}, {"type": "i", "start": 39685, "end": 39705, "id": 1380, "features": {}}, {"type": "span", "start": 39705, "end": 39727, "id": 1381, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 39717, "end": 39727, "id": 1382, "features": {"class": "nowrap"}}, {"type": "span", "start": 39728, "end": 39728, "id": 1383, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=Macquarie+University&rft.atitle=Centre+for+Language+Technology+%28CLT%29&rft.au=Administration&rft_id=https%3A%2F%2Fwww.mq.edu.au%2Fresearch%2Fresearch-centres-groups-and-facilities%2Finnovative-technologies%2Fcentres%2Fcentre-for-language-technology-clt&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 39729, "end": 39819, "id": 1384, "features": {"id": "cite_note-32"}}, {"type": "span", "start": 39729, "end": 39730, "id": 1385, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 39729, "end": 39730, "id": 1386, "features": {}}, {"type": "a", "start": 39729, "end": 39730, "id": 1387, "features": {"href": "#cite_ref-32"}}, {"type": "span", "start": 39731, "end": 39818, "id": 1388, "features": {"class": "reference-text"}}, {"type": "link", "start": 39731, "end": 39731, "id": 1389, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 39731, "end": 39818, "id": 1390, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 39731, "end": 39774, "id": 1391, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.comp.nus.edu.sg/~nlp/conll13st.html"}}, {"type": "i", "start": 39776, "end": 39795, "id": 1392, "features": {}}, {"type": "span", "start": 39795, "end": 39817, "id": 1393, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 39807, "end": 39817, "id": 1394, "features": {"class": "nowrap"}}, {"type": "span", "start": 39818, "end": 39818, "id": 1395, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.comp.nus.edu.sg&rft.atitle=Shared+Task%3A+Grammatical+Error+Correction&rft_id=https%3A%2F%2Fwww.comp.nus.edu.sg%2F~nlp%2Fconll13st.html&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 39819, "end": 39909, "id": 1396, "features": {"id": "cite_note-33"}}, {"type": "span", "start": 39819, "end": 39820, "id": 1397, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 39819, "end": 39820, "id": 1398, "features": {}}, {"type": "a", "start": 39819, "end": 39820, "id": 1399, "features": {"href": "#cite_ref-33"}}, {"type": "span", "start": 39821, "end": 39908, "id": 1400, "features": {"class": "reference-text"}}, {"type": "link", "start": 39821, "end": 39821, "id": 1401, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 39821, "end": 39908, "id": 1402, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 39821, "end": 39864, "id": 1403, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.comp.nus.edu.sg/~nlp/conll14st.html"}}, {"type": "i", "start": 39866, "end": 39885, "id": 1404, "features": {}}, {"type": "span", "start": 39885, "end": 39907, "id": 1405, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 39897, "end": 39907, "id": 1406, "features": {"class": "nowrap"}}, {"type": "span", "start": 39908, "end": 39908, "id": 1407, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.comp.nus.edu.sg&rft.atitle=Shared+Task%3A+Grammatical+Error+Correction&rft_id=https%3A%2F%2Fwww.comp.nus.edu.sg%2F~nlp%2Fconll14st.html&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 39909, "end": 40155, "id": 1408, "features": {"id": "cite_note-34"}}, {"type": "span", "start": 39909, "end": 39910, "id": 1409, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 39909, "end": 39910, "id": 1410, "features": {}}, {"type": "a", "start": 39909, "end": 39910, "id": 1411, "features": {"href": "#cite_ref-34"}}, {"type": "span", "start": 39911, "end": 40154, "id": 1412, "features": {"class": "reference-text"}}, {"type": "link", "start": 39911, "end": 39911, "id": 1413, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 39911, "end": 40154, "id": 1414, "features": {"id": "CITEREFDuanCruz2011", "class": "citation journal cs1"}}, {"type": "a", "start": 39950, "end": 40033, "id": 1415, "features": {"rel": "nofollow", "class": "external text", "href": "https://web.archive.org/web/20111009135952/http://www.ijimt.org/abstract/100-E00187.htm"}}, {"type": "i", "start": 40035, "end": 40097, "id": 1416, "features": {}}, {"type": "b", "start": 40099, "end": 40100, "id": 1417, "features": {}}, {"type": "a", "start": 40127, "end": 40139, "id": 1418, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.ijimt.org/abstract/100-E00187.htm"}}, {"type": "span", "start": 40154, "end": 40154, "id": 1419, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=International+Journal+of+Innovation%2C+Management+and+Technology&rft.atitle=Formalizing+Semantic+of+Natural+Language+through+Conceptualization+from+Existence&rft.volume=2&rft.issue=1&rft.pages=37-42&rft.date=2011&rft.aulast=Duan&rft.aufirst=Yucong&rft.au=Cruz%2C+Christophe&rft_id=http%3A%2F%2Fwww.ijimt.org%2Fabstract%2F100-E00187.htm&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 40155, "end": 40284, "id": 1420, "features": {"id": "cite_note-35"}}, {"type": "span", "start": 40155, "end": 40156, "id": 1421, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 40155, "end": 40156, "id": 1422, "features": {}}, {"type": "a", "start": 40155, "end": 40156, "id": 1423, "features": {"href": "#cite_ref-35"}}, {"type": "span", "start": 40157, "end": 40283, "id": 1424, "features": {"class": "reference-text"}}, {"type": "link", "start": 40157, "end": 40157, "id": 1425, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 40157, "end": 40283, "id": 1426, "features": {"id": "CITEREFRobertson2022", "class": "citation web cs1"}}, {"type": "a", "start": 40186, "end": 40249, "id": 1427, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.theverge.com/2022/4/6/23012123/openai-clip-dalle-2-ai-text-to-image-generator-testing"}}, {"type": "i", "start": 40251, "end": 40260, "id": 1428, "features": {}}, {"type": "span", "start": 40260, "end": 40282, "id": 1429, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 40272, "end": 40282, "id": 1430, "features": {"class": "nowrap"}}, {"type": "span", "start": 40283, "end": 40283, "id": 1431, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=The+Verge&rft.atitle=OpenAI%27s+DALL-E+AI+image+generator+can+now+edit+pictures%2C+too&rft.date=2022-04-06&rft.aulast=Robertson&rft.aufirst=Adi&rft_id=https%3A%2F%2Fwww.theverge.com%2F2022%2F4%2F6%2F23012123%2Fopenai-clip-dalle-2-ai-text-to-image-generator-testing&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 40284, "end": 40376, "id": 1432, "features": {"id": "cite_note-36"}}, {"type": "span", "start": 40284, "end": 40285, "id": 1433, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 40284, "end": 40285, "id": 1434, "features": {}}, {"type": "a", "start": 40284, "end": 40285, "id": 1435, "features": {"href": "#cite_ref-36"}}, {"type": "span", "start": 40286, "end": 40375, "id": 1436, "features": {"class": "reference-text"}}, {"type": "link", "start": 40286, "end": 40286, "id": 1437, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 40286, "end": 40375, "id": 1438, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 40286, "end": 40334, "id": 1439, "features": {"rel": "nofollow", "class": "external text", "href": "https://nlp.stanford.edu/projects/text2scene.shtml"}}, {"type": "i", "start": 40336, "end": 40352, "id": 1440, "features": {}}, {"type": "span", "start": 40352, "end": 40374, "id": 1441, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 40364, "end": 40374, "id": 1442, "features": {"class": "nowrap"}}, {"type": "span", "start": 40375, "end": 40375, "id": 1443, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=nlp.stanford.edu&rft.atitle=The+Stanford+Natural+Language+Processing+Group&rft_id=https%3A%2F%2Fnlp.stanford.edu%2Fprojects%2Ftext2scene.shtml&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 40376, "end": 40716, "id": 1444, "features": {"id": "cite_note-37"}}, {"type": "span", "start": 40376, "end": 40377, "id": 1445, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 40376, "end": 40377, "id": 1446, "features": {}}, {"type": "a", "start": 40376, "end": 40377, "id": 1447, "features": {"href": "#cite_ref-37"}}, {"type": "span", "start": 40378, "end": 40715, "id": 1448, "features": {"class": "reference-text"}}, {"type": "link", "start": 40378, "end": 40378, "id": 1449, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 40378, "end": 40715, "id": 1450, "features": {"id": "CITEREFCoyneSproat2001", "class": "citation journal cs1"}}, {"type": "a", "start": 40420, "end": 40476, "id": 1451, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1145/383259.383316"}}, {"type": "i", "start": 40478, "end": 40567, "id": 1452, "features": {}}, {"type": "a", "start": 40648, "end": 40651, "id": 1453, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 40652, "end": 40673, "id": 1454, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1145%2F383259.383316"}}, {"type": "a", "start": 40675, "end": 40679, "id": 1455, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 40680, "end": 40699, "id": 1456, "features": {"href": "/wiki/Special:BookSources/978-1-58113-374-5", "title": "Special:BookSources/978-1-58113-374-5"}}, {"type": "bdi", "start": 40681, "end": 40699, "id": 1457, "features": {}}, {"type": "a", "start": 40701, "end": 40706, "id": 1458, "features": {"href": "/wiki/S2CID_(identifier)", "class": "mw-redirect", "title": "S2CID (identifier)"}}, {"type": "a", "start": 40707, "end": 40714, "id": 1459, "features": {"rel": "nofollow", "class": "external text", "href": "https://api.semanticscholar.org/CorpusID:3842372"}}, {"type": "span", "start": 40715, "end": 40715, "id": 1460, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Proceedings+of+the+28th+Annual+Conference+on+Computer+Graphics+and+Interactive+Techniques&rft.atitle=WordsEye%3A+an+automatic+text-to-scene+conversion+system&rft.pages=487-496&rft.date=2001-08-01&rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A3842372%23id-name%3DS2CID&rft_id=info%3Adoi%2F10.1145%2F383259.383316&rft.isbn=978-1-58113-374-5&rft.aulast=Coyne&rft.aufirst=Bob&rft.au=Sproat%2C+Richard&rft_id=https%3A%2F%2Fdoi.org%2F10.1145%2F383259.383316&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 40716, "end": 40842, "id": 1461, "features": {"id": "cite_note-38"}}, {"type": "span", "start": 40716, "end": 40717, "id": 1462, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 40716, "end": 40717, "id": 1463, "features": {}}, {"type": "a", "start": 40716, "end": 40717, "id": 1464, "features": {"href": "#cite_ref-38"}}, {"type": "span", "start": 40718, "end": 40841, "id": 1465, "features": {"class": "reference-text"}}, {"type": "link", "start": 40718, "end": 40718, "id": 1466, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 40718, "end": 40841, "id": 1467, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 40718, "end": 40793, "id": 1468, "features": {"rel": "nofollow", "class": "external text", "href": "https://venturebeat.com/ai/google-announces-ai-advances-in-text-to-video-language-translation-more/"}}, {"type": "i", "start": 40795, "end": 40806, "id": 1469, "features": {}}, {"type": "span", "start": 40818, "end": 40840, "id": 1470, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 40830, "end": 40840, "id": 1471, "features": {"class": "nowrap"}}, {"type": "span", "start": 40841, "end": 40841, "id": 1472, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=VentureBeat&rft.atitle=Google+announces+AI+advances+in+text-to-video%2C+language+translation%2C+more&rft.date=2022-11-02&rft_id=https%3A%2F%2Fventurebeat.com%2Fai%2Fgoogle-announces-ai-advances-in-text-to-video-language-translation-more%2F&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 40842, "end": 40972, "id": 1473, "features": {"id": "cite_note-39"}}, {"type": "span", "start": 40842, "end": 40843, "id": 1474, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 40842, "end": 40843, "id": 1475, "features": {}}, {"type": "a", "start": 40842, "end": 40843, "id": 1476, "features": {"href": "#cite_ref-39"}}, {"type": "span", "start": 40844, "end": 40971, "id": 1477, "features": {"class": "reference-text"}}, {"type": "link", "start": 40844, "end": 40844, "id": 1478, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 40844, "end": 40971, "id": 1479, "features": {"id": "CITEREFVincent2022", "class": "citation web cs1"}}, {"type": "a", "start": 40873, "end": 40937, "id": 1480, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.theverge.com/2022/9/29/23378210/meta-text-to-video-ai-generation-make-a-video-model-dall-e"}}, {"type": "i", "start": 40939, "end": 40948, "id": 1481, "features": {}}, {"type": "span", "start": 40948, "end": 40970, "id": 1482, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 40960, "end": 40970, "id": 1483, "features": {"class": "nowrap"}}, {"type": "span", "start": 40971, "end": 40971, "id": 1484, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=The+Verge&rft.atitle=Meta%E2%80%99s+new+text-to-video+AI+generator+is+like+DALL-E+for+video&rft.date=2022-09-29&rft.aulast=Vincent&rft.aufirst=James&rft_id=https%3A%2F%2Fwww.theverge.com%2F2022%2F9%2F29%2F23378210%2Fmeta-text-to-video-ai-generation-make-a-video-model-dall-e&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 40972, "end": 41044, "id": 1485, "features": {"id": "cite_note-40"}}, {"type": "span", "start": 40972, "end": 40973, "id": 1486, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 40972, "end": 40973, "id": 1487, "features": {}}, {"type": "a", "start": 40972, "end": 40973, "id": 1488, "features": {"href": "#cite_ref-40"}}, {"type": "span", "start": 40974, "end": 41043, "id": 1489, "features": {"class": "reference-text"}}, {"type": "link", "start": 40974, "end": 40974, "id": 1490, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 40974, "end": 41043, "id": 1491, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 40974, "end": 41005, "id": 1492, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.conll.org/previous-tasks"}}, {"type": "i", "start": 41007, "end": 41020, "id": 1493, "features": {}}, {"type": "span", "start": 41020, "end": 41042, "id": 1494, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 41032, "end": 41042, "id": 1495, "features": {"class": "nowrap"}}, {"type": "span", "start": 41043, "end": 41043, "id": 1496, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.conll.org&rft.atitle=Previous+shared+tasks+%7C+CoNLL&rft_id=https%3A%2F%2Fwww.conll.org%2Fprevious-tasks&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 41044, "end": 41178, "id": 1497, "features": {"id": "cite_note-41"}}, {"type": "span", "start": 41044, "end": 41045, "id": 1498, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 41044, "end": 41045, "id": 1499, "features": {}}, {"type": "a", "start": 41044, "end": 41045, "id": 1500, "features": {"href": "#cite_ref-41"}}, {"type": "span", "start": 41046, "end": 41177, "id": 1501, "features": {"class": "reference-text"}}, {"type": "link", "start": 41046, "end": 41046, "id": 1502, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 41046, "end": 41177, "id": 1503, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 41046, "end": 41057, "id": 1504, "features": {"rel": "nofollow", "class": "external text", "href": "https://web.archive.org/web/20200715113427/https://www.lexico.com/definition/cognition"}}, {"type": "i", "start": 41059, "end": 41065, "id": 1505, "features": {}}, {"type": "a", "start": 41067, "end": 41090, "id": 1506, "features": {"href": "/wiki/Oxford_University_Press", "title": "Oxford University Press"}}, {"type": "a", "start": 41095, "end": 41109, "id": 1507, "features": {"href": "/wiki/Dictionary.com", "title": "Dictionary.com"}}, {"type": "a", "start": 41125, "end": 41137, "id": 1508, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.lexico.com/definition/cognition"}}, {"type": "span", "start": 41154, "end": 41176, "id": 1509, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 41166, "end": 41171, "id": 1510, "features": {"class": "nowrap"}}, {"type": "span", "start": 41177, "end": 41177, "id": 1511, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=Lexico&rft.atitle=Cognition&rft_id=https%3A%2F%2Fwww.lexico.com%2Fdefinition%2Fcognition&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 41178, "end": 41447, "id": 1512, "features": {"id": "cite_note-42"}}, {"type": "span", "start": 41178, "end": 41179, "id": 1513, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 41178, "end": 41179, "id": 1514, "features": {}}, {"type": "a", "start": 41178, "end": 41179, "id": 1515, "features": {"href": "#cite_ref-42"}}, {"type": "span", "start": 41180, "end": 41446, "id": 1516, "features": {"class": "reference-text"}}, {"type": "link", "start": 41180, "end": 41180, "id": 1517, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 41180, "end": 41446, "id": 1518, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 41180, "end": 41209, "id": 1519, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.aft.org/newspubs/periodicals/ae/summer2002/willingham.cfm"}}, {"type": "i", "start": 41211, "end": 41242, "id": 1520, "features": {}}, {"type": "q", "start": 41259, "end": 41446, "id": 1521, "features": {}}, {"type": "span", "start": 41446, "end": 41446, "id": 1522, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=American+Federation+of+Teachers&rft.atitle=Ask+the+Cognitive+Scientist&rft.date=2014-08-08&rft_id=http%3A%2F%2Fwww.aft.org%2Fnewspubs%2Fperiodicals%2Fae%2Fsummer2002%2Fwillingham.cfm&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 41447, "end": 41586, "id": 1523, "features": {"id": "cite_note-43"}}, {"type": "span", "start": 41447, "end": 41448, "id": 1524, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 41447, "end": 41448, "id": 1525, "features": {}}, {"type": "a", "start": 41447, "end": 41448, "id": 1526, "features": {"href": "#cite_ref-43"}}, {"type": "span", "start": 41449, "end": 41585, "id": 1527, "features": {"class": "reference-text"}}, {"type": "link", "start": 41449, "end": 41449, "id": 1528, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 41449, "end": 41585, "id": 1529, "features": {"id": "CITEREFRobinson2008", "class": "citation book cs1"}}, {"type": "i", "start": 41473, "end": 41538, "id": 1530, "features": {}}, {"type": "a", "start": 41560, "end": 41564, "id": 1531, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 41565, "end": 41584, "id": 1532, "features": {"href": "/wiki/Special:BookSources/978-0-805-85352-0", "title": "Special:BookSources/978-0-805-85352-0"}}, {"type": "bdi", "start": 41566, "end": 41584, "id": 1533, "features": {}}, {"type": "span", "start": 41585, "end": 41585, "id": 1534, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Handbook+of+Cognitive+Linguistics+and+Second+Language+Acquisition&rft.pages=3-8&rft.pub=Routledge&rft.date=2008&rft.isbn=978-0-805-85352-0&rft.aulast=Robinson&rft.aufirst=Peter&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 41586, "end": 41806, "id": 1535, "features": {"id": "cite_note-44"}}, {"type": "span", "start": 41586, "end": 41587, "id": 1536, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 41586, "end": 41587, "id": 1537, "features": {}}, {"type": "a", "start": 41586, "end": 41587, "id": 1538, "features": {"href": "#cite_ref-44"}}, {"type": "span", "start": 41588, "end": 41805, "id": 1539, "features": {"class": "reference-text"}}, {"type": "link", "start": 41588, "end": 41588, "id": 1540, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 41588, "end": 41805, "id": 1541, "features": {"id": "CITEREFLakoff1999", "class": "citation book cs1"}}, {"type": "i", "start": 41611, "end": 41743, "id": 1542, "features": {}}, {"type": "a", "start": 41780, "end": 41784, "id": 1543, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 41785, "end": 41804, "id": 1544, "features": {"href": "/wiki/Special:BookSources/978-0-465-05674-3", "title": "Special:BookSources/978-0-465-05674-3"}}, {"type": "bdi", "start": 41786, "end": 41804, "id": 1545, "features": {}}, {"type": "span", "start": 41805, "end": 41805, "id": 1546, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Philosophy+in+the+Flesh%3A+The+Embodied+Mind+and+Its+Challenge+to+Western+Philosophy%3B+Appendix%3A+The+Neural+Theory+of+Language+Paradigm&rft.pages=569-583&rft.pub=New+York+Basic+Books&rft.date=1999&rft.isbn=978-0-465-05674-3&rft.aulast=Lakoff&rft.aufirst=George&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 41806, "end": 41940, "id": 1547, "features": {"id": "cite_note-45"}}, {"type": "span", "start": 41806, "end": 41807, "id": 1548, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 41806, "end": 41807, "id": 1549, "features": {}}, {"type": "a", "start": 41806, "end": 41807, "id": 1550, "features": {"href": "#cite_ref-45"}}, {"type": "span", "start": 41808, "end": 41939, "id": 1551, "features": {"class": "reference-text"}}, {"type": "link", "start": 41808, "end": 41808, "id": 1552, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 41808, "end": 41939, "id": 1553, "features": {"id": "CITEREFStrauss1999", "class": "citation book cs1"}}, {"type": "i", "start": 41833, "end": 41871, "id": 1554, "features": {}}, {"type": "a", "start": 41914, "end": 41918, "id": 1555, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 41919, "end": 41938, "id": 1556, "features": {"href": "/wiki/Special:BookSources/978-0-521-59541-4", "title": "Special:BookSources/978-0-521-59541-4"}}, {"type": "bdi", "start": 41920, "end": 41938, "id": 1557, "features": {}}, {"type": "span", "start": 41939, "end": 41939, "id": 1558, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=A+Cognitive+Theory+of+Cultural+Meaning&rft.pages=156-164&rft.pub=Cambridge+University+Press&rft.date=1999&rft.isbn=978-0-521-59541-4&rft.aulast=Strauss&rft.aufirst=Claudia&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 41940, "end": 42066, "id": 1559, "features": {"id": "cite_note-46"}}, {"type": "span", "start": 41940, "end": 41941, "id": 1560, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 41940, "end": 41941, "id": 1561, "features": {}}, {"type": "a", "start": 41940, "end": 41941, "id": 1562, "features": {"href": "#cite_ref-46"}}, {"type": "span", "start": 41942, "end": 42065, "id": 1563, "features": {"class": "reference-text"}}, {"type": "link", "start": 41942, "end": 41942, "id": 1564, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 41942, "end": 42065, "id": 1565, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 41942, "end": 41992, "id": 1566, "features": {"rel": "nofollow", "class": "external text", "href": "https://universalconceptualcognitiveannotation.github.io/"}}, {"type": "i", "start": 41994, "end": 42042, "id": 1567, "features": {}}, {"type": "span", "start": 42042, "end": 42064, "id": 1568, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 42054, "end": 42064, "id": 1569, "features": {"class": "nowrap"}}, {"type": "span", "start": 42065, "end": 42065, "id": 1570, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=Universal+Conceptual+Cognitive+Annotation+%28UCCA%29&rft.atitle=Universal+Conceptual+Cognitive+Annotation+%28UCCA%29&rft_id=https%3A%2F%2Funiversalconceptualcognitiveannotation.github.io%2F&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 42066, "end": 42176, "id": 1571, "features": {"id": "cite_note-47"}}, {"type": "span", "start": 42066, "end": 42067, "id": 1572, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 42066, "end": 42067, "id": 1573, "features": {}}, {"type": "a", "start": 42066, "end": 42067, "id": 1574, "features": {"href": "#cite_ref-47"}}, {"type": "span", "start": 42068, "end": 42175, "id": 1575, "features": {"class": "reference-text"}}, {"type": "a", "start": 42112, "end": 42149, "id": 1576, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.redalyc.org/pdf/1345/134549291020.pdf"}}, {"type": "i", "start": 42151, "end": 42160, "id": 1577, "features": {}}, {"type": "li", "start": 42176, "end": 42296, "id": 1578, "features": {"id": "cite_note-48"}}, {"type": "span", "start": 42176, "end": 42177, "id": 1579, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 42176, "end": 42177, "id": 1580, "features": {}}, {"type": "a", "start": 42176, "end": 42177, "id": 1581, "features": {"href": "#cite_ref-48"}}, {"type": "span", "start": 42178, "end": 42295, "id": 1582, "features": {"class": "reference-text"}}, {"type": "link", "start": 42178, "end": 42178, "id": 1583, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 42178, "end": 42295, "id": 1584, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 42178, "end": 42272, "id": 1585, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.fcg-net.org/"}}, {"type": "span", "start": 42272, "end": 42294, "id": 1586, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 42284, "end": 42294, "id": 1587, "features": {"class": "nowrap"}}, {"type": "span", "start": 42295, "end": 42295, "id": 1588, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=unknown&rft.btitle=Fluid+Construction+Grammar+%E2%80%93+A+fully+operational+processing+system+for+construction+grammars&rft_id=https%3A%2F%2Fwww.fcg-net.org%2F&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 42296, "end": 42419, "id": 1589, "features": {"id": "cite_note-49"}}, {"type": "span", "start": 42296, "end": 42297, "id": 1590, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 42296, "end": 42297, "id": 1591, "features": {}}, {"type": "a", "start": 42296, "end": 42297, "id": 1592, "features": {"href": "#cite_ref-49"}}, {"type": "span", "start": 42298, "end": 42418, "id": 1593, "features": {"class": "reference-text"}}, {"type": "link", "start": 42298, "end": 42298, "id": 1594, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 42298, "end": 42418, "id": 1595, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 42298, "end": 42379, "id": 1596, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.aclweb.org/portal/"}}, {"type": "i", "start": 42381, "end": 42395, "id": 1597, "features": {}}, {"type": "span", "start": 42395, "end": 42417, "id": 1598, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 42407, "end": 42417, "id": 1599, "features": {"class": "nowrap"}}, {"type": "span", "start": 42418, "end": 42418, "id": 1600, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.aclweb.org&rft.atitle=ACL+Member+Portal+%7C+The+Association+for+Computational+Linguistics+Member+Portal&rft_id=https%3A%2F%2Fwww.aclweb.org%2Fportal%2F&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 42419, "end": 42475, "id": 1601, "features": {"id": "cite_note-50"}}, {"type": "span", "start": 42419, "end": 42420, "id": 1602, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 42419, "end": 42420, "id": 1603, "features": {}}, {"type": "a", "start": 42419, "end": 42420, "id": 1604, "features": {"href": "#cite_ref-50"}}, {"type": "span", "start": 42421, "end": 42474, "id": 1605, "features": {"class": "reference-text"}}, {"type": "link", "start": 42421, "end": 42421, "id": 1606, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 42421, "end": 42474, "id": 1607, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 42421, "end": 42439, "id": 1608, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.w3.org/Data/demos/chunks/chunks.html"}}, {"type": "i", "start": 42441, "end": 42451, "id": 1609, "features": {}}, {"type": "span", "start": 42451, "end": 42473, "id": 1610, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 42463, "end": 42473, "id": 1611, "features": {"class": "nowrap"}}, {"type": "span", "start": 42474, "end": 42474, "id": 1612, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.w3.org&rft.atitle=Chunks+and+Rules&rft_id=https%3A%2F%2Fwww.w3.org%2FData%2Fdemos%2Fchunks%2Fchunks.html&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 42475, "end": 42773, "id": 1613, "features": {"id": "cite_note-51"}}, {"type": "span", "start": 42475, "end": 42476, "id": 1614, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 42475, "end": 42476, "id": 1615, "features": {}}, {"type": "a", "start": 42475, "end": 42476, "id": 1616, "features": {"href": "#cite_ref-51"}}, {"type": "span", "start": 42477, "end": 42772, "id": 1617, "features": {"class": "reference-text"}}, {"type": "link", "start": 42477, "end": 42477, "id": 1618, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 42477, "end": 42772, "id": 1619, "features": {"id": "CITEREFSocherKarpathyLeManning2014", "class": "citation journal cs1"}}, {"type": "a", "start": 42572, "end": 42655, "id": 1620, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1162%2Ftacl_a_00177"}}, {"type": "i", "start": 42657, "end": 42718, "id": 1621, "features": {}}, {"type": "b", "start": 42720, "end": 42721, "id": 1622, "features": {}}, {"type": "a", "start": 42732, "end": 42735, "id": 1623, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "span", "start": 42736, "end": 42756, "id": 1624, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 42736, "end": 42756, "id": 1625, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1162%2Ftacl_a_00177"}}, {"type": "a", "start": 42758, "end": 42763, "id": 1626, "features": {"href": "/wiki/S2CID_(identifier)", "class": "mw-redirect", "title": "S2CID (identifier)"}}, {"type": "a", "start": 42764, "end": 42771, "id": 1627, "features": {"rel": "nofollow", "class": "external text", "href": "https://api.semanticscholar.org/CorpusID:2317858"}}, {"type": "span", "start": 42772, "end": 42772, "id": 1628, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Transactions+of+the+Association+for+Computational+Linguistics&rft.atitle=Grounded+Compositional+Semantics+for+Finding+and+Describing+Images+with+Sentences&rft.volume=2&rft.pages=207-218&rft.date=2014&rft_id=info%3Adoi%2F10.1162%2Ftacl_a_00177&rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A2317858%23id-name%3DS2CID&rft.aulast=Socher&rft.aufirst=Richard&rft.au=Karpathy%2C+Andrej&rft.au=Le%2C+Quoc+V.&rft.au=Manning%2C+Christopher+D.&rft.au=Ng%2C+Andrew+Y.&rft_id=%2F%2Fdoi.org%2F10.1162%252Ftacl_a_00177&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "h2", "start": 42773, "end": 42793, "id": 1629, "features": {"class": "section-heading", "onclick": "mfTempOpenSection(7)"}}, {"type": "div", "start": 42773, "end": 42773, "id": 1630, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left mw-ui-button mw-ui-quiet"}}, {"type": "span", "start": 42773, "end": 42788, "id": 1631, "features": {"class": "mw-headline", "id": "Further_reading"}}, {"type": "span", "start": 42788, "end": 42792, "id": 1632, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 42788, "end": 42792, "id": 1633, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=20", "title": "Edit section: Further reading", "data-section": "20", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "section", "start": 42793, "end": 44140, "id": 1634, "features": {"class": "mf-section-7 collapsible-block", "id": "mf-section-7"}}, {"type": "div", "start": 42793, "end": 44140, "id": 1635, "features": {"class": "refbegin", "style": ""}}, {"type": "ul", "start": 42793, "end": 44140, "id": 1636, "features": {}}, {"type": "li", "start": 42793, "end": 43038, "id": 1637, "features": {}}, {"type": "link", "start": 42793, "end": 42793, "id": 1638, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "cite", "start": 42793, "end": 43037, "id": 1639, "features": {"id": "CITEREFBates1995", "class": "citation journal cs1"}}, {"type": "a", "start": 42810, "end": 42852, "id": 1640, "features": {"rel": "nofollow", "class": "external text", "href": "//www.ncbi.nlm.nih.gov/pmc/articles/PMC40721"}}, {"type": "i", "start": 42854, "end": 42933, "id": 1641, "features": {}}, {"type": "b", "start": 42935, "end": 42937, "id": 1642, "features": {}}, {"type": "a", "start": 42955, "end": 42962, "id": 1643, "features": {"href": "/wiki/Bibcode_(identifier)", "class": "mw-redirect", "title": "Bibcode (identifier)"}}, {"type": "a", "start": 42963, "end": 42982, "id": 1644, "features": {"rel": "nofollow", "class": "external text", "href": "https://ui.adsabs.harvard.edu/abs/1995PNAS...92.9977B"}}, {"type": "a", "start": 42984, "end": 42987, "id": 1645, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "span", "start": 42988, "end": 43011, "id": 1646, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 42988, "end": 43011, "id": 1647, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1073%2Fpnas.92.22.9977"}}, {"type": "a", "start": 43013, "end": 43016, "id": 1648, "features": {"href": "/wiki/PMC_(identifier)", "class": "mw-redirect", "title": "PMC (identifier)"}}, {"type": "span", "start": 43017, "end": 43022, "id": 1649, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 43017, "end": 43022, "id": 1650, "features": {"rel": "nofollow", "class": "external text", "href": "//www.ncbi.nlm.nih.gov/pmc/articles/PMC40721"}}, {"type": "a", "start": 43024, "end": 43028, "id": 1651, "features": {"href": "/wiki/PMID_(identifier)", "class": "mw-redirect", "title": "PMID (identifier)"}}, {"type": "a", "start": 43029, "end": 43036, "id": 1652, "features": {"rel": "nofollow", "class": "external text", "href": "//pubmed.ncbi.nlm.nih.gov/7479812"}}, {"type": "span", "start": 43037, "end": 43037, "id": 1653, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Proceedings+of+the+National+Academy+of+Sciences+of+the+United+States+of+America&rft.atitle=Models+of+natural+language+understanding&rft.volume=92&rft.issue=22&rft.pages=9977-9982&rft.date=1995&rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC40721%23id-name%3DPMC&rft_id=info%3Apmid%2F7479812&rft_id=info%3Adoi%2F10.1073%2Fpnas.92.22.9977&rft_id=info%3Abibcode%2F1995PNAS...92.9977B&rft.aulast=Bates&rft.aufirst=M&rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC40721&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 43038, "end": 43169, "id": 1654, "features": {}}, {"type": "i", "start": 43088, "end": 43127, "id": 1655, "features": {}}, {"type": "link", "start": 43145, "end": 43145, "id": 1656, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "a", "start": 43145, "end": 43149, "id": 1657, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 43150, "end": 43167, "id": 1658, "features": {"href": "/wiki/Special:BookSources/978-0-596-51649-9", "title": "Special:BookSources/978-0-596-51649-9"}}, {"type": "li", "start": 43169, "end": 43305, "id": 1659, "features": {}}, {"type": "i", "start": 43213, "end": 43243, "id": 1660, "features": {}}, {"type": "link", "start": 43281, "end": 43281, "id": 1661, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "a", "start": 43281, "end": 43285, "id": 1662, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 43286, "end": 43303, "id": 1663, "features": {"href": "/wiki/Special:BookSources/978-0-13-187321-6", "title": "Special:BookSources/978-0-13-187321-6"}}, {"type": "li", "start": 43305, "end": 43469, "id": 1664, "features": {}}, {"type": "i", "start": 43335, "end": 43424, "id": 1665, "features": {}}, {"type": "link", "start": 43448, "end": 43448, "id": 1666, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "a", "start": 43448, "end": 43452, "id": 1667, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 43453, "end": 43467, "id": 1668, "features": {"href": "/wiki/Special:BookSources/978-1848218482", "title": "Special:BookSources/978-1848218482"}}, {"type": "li", "start": 43469, "end": 43641, "id": 1669, "features": {}}, {"type": "i", "start": 43499, "end": 43596, "id": 1670, "features": {}}, {"type": "link", "start": 43620, "end": 43620, "id": 1671, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "a", "start": 43620, "end": 43624, "id": 1672, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 43625, "end": 43639, "id": 1673, "features": {"href": "/wiki/Special:BookSources/978-1848219212", "title": "Special:BookSources/978-1848219212"}}, {"type": "li", "start": 43641, "end": 43861, "id": 1674, "features": {}}, {"type": "i", "start": 43713, "end": 43750, "id": 1675, "features": {}}, {"type": "link", "start": 43780, "end": 43780, "id": 1676, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "a", "start": 43780, "end": 43784, "id": 1677, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 43785, "end": 43802, "id": 1678, "features": {"href": "/wiki/Special:BookSources/978-0-521-86571-5", "title": "Special:BookSources/978-0-521-86571-5"}}, {"type": "a", "start": 43804, "end": 43860, "id": 1679, "features": {"rel": "nofollow", "class": "external text", "href": "http://nlp.stanford.edu/IR-book/"}}, {"type": "li", "start": 43861, "end": 44007, "id": 1680, "features": {}}, {"type": "i", "start": 43912, "end": 43966, "id": 1681, "features": {}}, {"type": "link", "start": 43983, "end": 43983, "id": 1682, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "a", "start": 43983, "end": 43987, "id": 1683, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 43988, "end": 44005, "id": 1684, "features": {"href": "/wiki/Special:BookSources/978-0-262-13360-9", "title": "Special:BookSources/978-0-262-13360-9"}}, {"type": "li", "start": 44007, "end": 44140, "id": 1685, "features": {}}, {"type": "i", "start": 44061, "end": 44097, "id": 1686, "features": {}}, {"type": "link", "start": 44116, "end": 44116, "id": 1687, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r1067248974"}}, {"type": "a", "start": 44116, "end": 44120, "id": 1688, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 44121, "end": 44138, "id": 1689, "features": {"href": "/wiki/Special:BookSources/978-0-387-19557-5", "title": "Special:BookSources/978-0-387-19557-5"}}, {"type": "h2", "start": 44140, "end": 44159, "id": 1690, "features": {"class": "section-heading", "onclick": "mfTempOpenSection(8)"}}, {"type": "div", "start": 44140, "end": 44140, "id": 1691, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left mw-ui-button mw-ui-quiet"}}, {"type": "span", "start": 44140, "end": 44154, "id": 1692, "features": {"class": "mw-headline", "id": "External_links"}}, {"type": "span", "start": 44154, "end": 44158, "id": 1693, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 44154, "end": 44158, "id": 1694, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=21", "title": "Edit section: External links", "data-section": "21", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right mw-ui-button mw-ui-quiet"}}, {"type": "section", "start": 44159, "end": 44246, "id": 1695, "features": {"class": "mf-section-8 collapsible-block", "id": "mf-section-8"}}, {"type": "ul", "start": 44159, "end": 44227, "id": 1696, "features": {}}, {"type": "li", "start": 44159, "end": 44227, "id": 1697, "features": {}}, {"type": "a", "start": 44159, "end": 44160, "id": 1698, "features": {"href": "/wiki/File:Commons-logo.svg", "class": "image"}}, {"type": "noscript", "start": 44159, "end": 44159, "id": 1699, "features": {}}, {"type": "img", "start": 44159, "end": 44159, "id": 1700, "features": {"alt": "", "src": "//upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/12px-Commons-logo.svg.png", "decoding": "async", "width": "12", "height": "16", "class": "noviewer", "data-file-width": "1024", "data-file-height": "1376"}}, {"type": "span", "start": 44159, "end": 44160, "id": 1701, "features": {"class": "lazy-image-placeholder", "style": "width: 12px;height: 16px;", "data-src": "//upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/12px-Commons-logo.svg.png", "data-alt": "", "data-width": "12", "data-height": "16", "data-srcset": "//upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/18px-Commons-logo.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/24px-Commons-logo.svg.png 2x", "data-class": "noviewer"}}, {"type": "a", "start": 44178, "end": 44205, "id": 1702, "features": {"href": "https://commons.wikimedia.org/wiki/Category:Natural_language_processing", "class": "extiw", "title": "commons:Category:Natural language processing"}}, {"type": "div", "start": 44227, "end": 44246, "id": 1703, "features": {"class": "portal-bar noprint metadata noviewer portal-bar-bordered", "role": "navigation", "aria-label": "Portals"}}, {"type": "span", "start": 44227, "end": 44234, "id": 1704, "features": {"class": "portal-bar-header"}}, {"type": "a", "start": 44227, "end": 44233, "id": 1705, "features": {"href": "/wiki/Wikipedia:Contents/Portals", "title": "Wikipedia:Contents/Portals"}}, {"type": "div", "start": 44235, "end": 44246, "id": 1706, "features": {"class": "portal-bar-content"}}, {"type": "span", "start": 44235, "end": 44245, "id": 1707, "features": {"class": "portal-bar-item"}}, {"type": "a", "start": 44235, "end": 44236, "id": 1708, "features": {"href": "/wiki/File:Globe_of_letters.svg", "class": "image"}}, {"type": "noscript", "start": 44235, "end": 44235, "id": 1709, "features": {}}, {"type": "img", "start": 44235, "end": 44235, "id": 1710, "features": {"alt": "icon", "src": "//upload.wikimedia.org/wikipedia/commons/thumb/d/de/Globe_of_letters.svg/19px-Globe_of_letters.svg.png", "decoding": "async", "width": "19", "height": "19", "data-file-width": "512", "data-file-height": "512"}}, {"type": "span", "start": 44235, "end": 44236, "id": 1711, "features": {"class": "lazy-image-placeholder", "style": "width: 19px;height: 19px;", "data-src": "//upload.wikimedia.org/wikipedia/commons/thumb/d/de/Globe_of_letters.svg/19px-Globe_of_letters.svg.png", "data-alt": "icon", "data-width": "19", "data-height": "19", "data-srcset": "//upload.wikimedia.org/wikipedia/commons/thumb/d/de/Globe_of_letters.svg/29px-Globe_of_letters.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/d/de/Globe_of_letters.svg/38px-Globe_of_letters.svg.png 2x"}}, {"type": "a", "start": 44237, "end": 44245, "id": 1712, "features": {"href": "/wiki/Portal:Language", "title": "Portal:Language"}}, {"type": "noscript", "start": 44246, "end": 44246, "id": 1713, "features": {}}, {"type": "img", "start": 44246, "end": 44246, "id": 1714, "features": {"src": "//en.wikipedia.org/wiki/Special:CentralAutoLogin/start?type=1x1&mobile=1", "alt": "", "title": "", "width": "1", "height": "1", "style": "border: none; position: absolute;"}}, {"type": "div", "start": 44246, "end": 44351, "id": 1715, "features": {"class": "printfooter", "data-nosnippet": ""}}, {"type": "a", "start": 44262, "end": 44349, "id": 1716, "features": {"dir": "ltr", "href": "https://en.wikipedia.org/w/index.php?title=Natural_language_processing&oldid=1120972063"}}, {"type": "div", "start": 44351, "end": 44351, "id": 1717, "features": {"class": "post-content", "id": "page-secondary-actions"}}, {"type": "footer", "start": 44351, "end": 44640, "id": 1718, "features": {"class": "mw-footer minerva-footer", "role": "contentinfo"}}, {"type": "a", "start": 44351, "end": 44392, "id": 1719, "features": {"class": "last-modified-bar", "href": "/wiki/Special:History/Natural_language_processing"}}, {"type": "div", "start": 44351, "end": 44392, "id": 1720, "features": {"class": "post-content last-modified-bar__content"}}, {"type": "span", "start": 44351, "end": 44351, "id": 1721, "features": {"class": "last-modified-bar__icon mw-ui-icon mw-ui-icon-mw-ui-icon-small mw-ui-icon-wikimedia-history-base20 "}}, {"type": "span", "start": 44351, "end": 44392, "id": 1722, "features": {"class": "last-modified-bar__text modified-enhancement", "data-user-name": "Jarble", "data-user-gender": "male", "data-timestamp": "1668026394"}}, {"type": "span", "start": 44351, "end": 44391, "id": 1723, "features": {}}, {"type": "span", "start": 44392, "end": 44392, "id": 1724, "features": {"class": "mw-ui-icon mw-ui-icon-small mw-ui-icon-mf-expand-gray mf-mw-ui-icon-rotate-anti-clockwise indicator"}}, {"type": "div", "start": 44392, "end": 44640, "id": 1725, "features": {"class": "post-content footer-content"}}, {"type": "div", "start": 44392, "end": 44392, "id": 1726, "features": {"id": "mw-data-after-content"}}, {"type": "div", "start": 44392, "end": 44392, "id": 1727, "features": {"class": "read-more-container"}}, {"type": "div", "start": 44392, "end": 44392, "id": 1728, "features": {"class": "minerva-footer-logo"}}, {"type": "img", "start": 44392, "end": 44392, "id": 1729, "features": {"src": "/static/images/mobile/copyright/wikipedia-wordmark-en.svg", "alt": "Wikipedia", "width": "120", "height": "18", "style": "width: 7.5em; height: 1.125em;"}}, {"type": "ul", "start": 44392, "end": 44519, "id": 1730, "features": {"id": "footer-info", "class": "footer-info hlist hlist-separated"}}, {"type": "li", "start": 44392, "end": 44455, "id": 1731, "features": {"id": "footer-info-lastmod"}}, {"type": "span", "start": 44447, "end": 44453, "id": 1732, "features": {"class": "anonymous-show"}}, {"type": "li", "start": 44455, "end": 44519, "id": 1733, "features": {"id": "footer-info-copyright"}}, {"type": "a", "start": 44482, "end": 44494, "id": 1734, "features": {"class": "external", "rel": "nofollow", "href": "https://creativecommons.org/licenses/by-sa/3.0/"}}, {"type": "ul", "start": 44519, "end": 44640, "id": 1735, "features": {"id": "footer-places", "class": "footer-places hlist hlist-separated"}}, {"type": "li", "start": 44519, "end": 44534, "id": 1736, "features": {"id": "footer-places-privacy"}}, {"type": "a", "start": 44519, "end": 44533, "id": 1737, "features": {"href": "https://foundation.wikimedia.org/wiki/Privacy_policy"}}, {"type": "li", "start": 44534, "end": 44550, "id": 1738, "features": {"id": "footer-places-about"}}, {"type": "a", "start": 44534, "end": 44549, "id": 1739, "features": {"href": "/wiki/Wikipedia:About"}}, {"type": "li", "start": 44550, "end": 44562, "id": 1740, "features": {"id": "footer-places-disclaimers"}}, {"type": "a", "start": 44550, "end": 44561, "id": 1741, "features": {"href": "/wiki/Wikipedia:General_disclaimer"}}, {"type": "li", "start": 44562, "end": 44580, "id": 1742, "features": {"id": "footer-places-contact"}}, {"type": "a", "start": 44562, "end": 44579, "id": 1743, "features": {"href": "//en.wikipedia.org/wiki/Wikipedia:Contact_us"}}, {"type": "li", "start": 44580, "end": 44593, "id": 1744, "features": {"id": "footer-places-terms-use"}}, {"type": "a", "start": 44580, "end": 44592, "id": 1745, "features": {"href": "//m.wikimediafoundation.org/wiki/Terms_of_Use"}}, {"type": "li", "start": 44593, "end": 44601, "id": 1746, "features": {"id": "footer-places-desktop-toggle"}}, {"type": "a", "start": 44593, "end": 44600, "id": 1747, "features": {"id": "mw-mf-display-toggle", "href": "//en.wikipedia.org/w/index.php?title=Natural_language_processing&mobileaction=toggle_view_desktop", "data-event-name": "switch_to_desktop"}}, {"type": "li", "start": 44601, "end": 44612, "id": 1748, "features": {"id": "footer-places-developers"}}, {"type": "a", "start": 44601, "end": 44611, "id": 1749, "features": {"href": "https://developer.wikimedia.org"}}, {"type": "li", "start": 44612, "end": 44623, "id": 1750, "features": {"id": "footer-places-statslink"}}, {"type": "a", "start": 44612, "end": 44622, "id": 1751, "features": {"href": "https://stats.wikimedia.org/#/en.wikipedia.org"}}, {"type": "li", "start": 44623, "end": 44640, "id": 1752, "features": {"id": "footer-places-cookiestatement"}}, {"type": "a", "start": 44623, "end": 44639, "id": 1753, "features": {"href": "https://foundation.wikimedia.org/wiki/Cookie_statement"}}, {"type": "div", "start": 44640, "end": 44640, "id": 1754, "features": {"class": "mw-notification-area", "data-mw": "interface"}}], "next_annid": 1755}}, "text": "\nNatural language processing - Wikipedia\nOpen main menu\nHome\nRandom\nNearby\nLog in\nSettings\nDonate\nAbout Wikipedia\nDisclaimers\nSearch\nNatural language processing\nArticle\nTalk\nLanguage\nWatch\nEdit\nThis article is about natural language processing done by computers. For the natural language processing done by the human brain, see Language processing in the brain.\nNatural language processing (NLP) is a subfield of linguistics, computer science, and artificial intelligence concerned with the interactions between computers and human language, in particular how to program computers to process and analyze large amounts of natural language data.  The goal is a computer capable of \"understanding\" the contents of documents, including the contextual nuances of the language within them. The technology can then accurately extract information and insights contained in the documents as well as categorize and organize the documents themselves.\n \nAn automated online assistant providing customer service on a web page, an example of an application where natural language processing is a major component.[1]\nChallenges in natural language processing frequently involve speech recognition, natural-language understanding, and natural-language generation.\nContents\n1 History\n1.1 Symbolic NLP (1950s \u2013 early 1990s)\n1.2 Statistical NLP (1990s\u20132010s)\n1.3 Neural NLP (present)\n2 Methods: Rules, statistics, neural networks\n2.1 Statistical methods\n2.2 Neural networks\n3 Common NLP tasks\n3.1 Text and speech processing\n3.2 Morphological analysis\n3.3 Syntactic analysis\n3.4 Lexical semantics (of individual words in context)\n3.5 Relational semantics (semantics of individual sentences)\n3.6 Discourse (semantics beyond individual sentences)\n3.7 Higher-level NLP applications\n4 General tendencies and (possible) future directions\n4.1 Cognition and NLP\n5 See also\n6 References\n7 Further reading\n8 External links\nHistoryEdit\nFurther information: History of natural language processing\nNatural language processing has its roots in the 1950s. Already in 1950, Alan Turing published an article titled \"Computing Machinery and Intelligence\" which proposed what is now called the Turing test as a criterion of intelligence, though at the time that was not articulated as a problem separate from artificial intelligence. The proposed test includes a task that involves the automated interpretation and generation of natural language.\nSymbolic NLP (1950s \u2013 early 1990s)Edit\nThe premise of symbolic NLP is well-summarized by John Searle's Chinese room experiment: Given a collection of rules (e.g., a Chinese phrasebook, with questions and matching answers), the computer emulates natural language understanding (or other NLP tasks) by applying those rules to the data it confronts.\n1950s: The Georgetown experiment in 1954 involved fully automatic translation of more than sixty Russian sentences into English. The authors claimed that within three or five years, machine translation would be a solved problem.[2]  However, real progress was much slower, and after the ALPAC report in 1966, which found that ten-year-long research had failed to fulfill the expectations, funding for machine translation was dramatically reduced.  Little further research in machine translation was conducted until the late 1980s when the first statistical machine translation systems were developed.\n1960s: Some notably successful natural language processing systems developed in the 1960s were SHRDLU, a natural language system working in restricted \"blocks worlds\" with restricted vocabularies, and ELIZA, a simulation of a Rogerian psychotherapist, written by Joseph Weizenbaum between 1964 and 1966.  Using almost no information about human thought or emotion, ELIZA sometimes provided a startlingly human-like interaction. When the \"patient\" exceeded the very small knowledge base, ELIZA might provide a generic response, for example, responding to \"My head hurts\" with \"Why do you say your head hurts?\".\n1970s: During the 1970s, many programmers began to write \"conceptual ontologies\", which structured real-world information into computer-understandable data.  Examples are MARGIE (Schank, 1975), SAM (Cullingford, 1978), PAM (Wilensky, 1978), TaleSpin (Meehan, 1976), QUALM (Lehnert, 1977), Politics (Carbonell, 1979), and Plot Units (Lehnert 1981).  During this time, the first chatterbots were written (e.g., PARRY).\n1980s: The 1980s and early 1990s mark the heyday of symbolic methods in NLP. Focus areas of the time included research on rule-based parsing (e.g., the development of HPSG as a computational operationalization of generative grammar), morphology (e.g., two-level morphology[3]), semantics (e.g., Lesk algorithm), reference (e.g., within Centering Theory[4]) and other areas of natural language understanding (e.g., in the Rhetorical Structure Theory). Other lines of research were continued, e.g., the development of chatterbots with Racter and Jabberwacky. An important development (that eventually led to the statistical turn in the 1990s) was the rising importance of quantitative evaluation in this period.[5]\nStatistical NLP (1990s\u20132010s)Edit\nUp to the 1980s, most natural language processing systems were based on complex sets of hand-written rules.  Starting in the late 1980s, however, there was a revolution in natural language processing with the introduction of machine learning algorithms for language processing.  This was due to both the steady increase in computational power (see Moore's law) and the gradual lessening of the dominance of Chomskyan theories of linguistics (e.g. transformational grammar), whose theoretical underpinnings discouraged the sort of corpus linguistics that underlies the machine-learning approach to language processing.[6]\n1990s: Many of the notable early successes on statistical methods in NLP occurred in the field of machine translation, due especially to work at IBM Research.  These systems were able to take advantage of existing multilingual textual corpora that had been produced by the Parliament of Canada and the European Union as a result of laws calling for the translation of all governmental proceedings into all official languages of the corresponding systems of government.  However, most other systems depended on corpora specifically developed for the tasks implemented by these systems, which was (and often continues to be) a major limitation in the success of these systems. As a result, a great deal of research has gone into methods of more effectively learning from limited amounts of data.\n2000s: With the growth of the web, increasing amounts of raw (unannotated) language data has become available since the mid-1990s. Research has thus increasingly focused on unsupervised and semi-supervised learning algorithms.  Such algorithms can learn from data that has not been hand-annotated with the desired answers or using a combination of annotated and non-annotated data.  Generally, this task is much more difficult than supervised learning, and typically produces less accurate results for a given amount of input data.  However, there is an enormous amount of non-annotated data available (including, among other things, the entire content of the World Wide Web), which can often make up for the inferior results if the algorithm used has a low enough time complexity to be practical.\nNeural NLP (present)Edit\nIn the 2010s, representation learning and deep neural network-style machine learning methods became widespread in natural language processing. That popularity was due partly to a flurry of results showing that such techniques[7][8] can achieve state-of-the-art results in many natural language tasks, e.g., in language modeling[9] and parsing.[10][11] This is increasingly important in medicine and healthcare, where NLP helps analyze notes and text in electronic health records that would otherwise be inaccessible for study when seeking to improve care.[12]\nMethods: Rules, statistics, neural networksEdit\nIn the early days, many language-processing systems were designed by symbolic methods, i.e., the hand-coding of a set of rules, coupled with a dictionary lookup:[13][14] such as by writing grammars or devising heuristic rules for stemming.\nMore recent systems based on machine-learning algorithms have many advantages over hand-produced rules: \nThe learning procedures used during machine learning automatically focus on the most common cases, whereas when writing rules by hand it is often not at all obvious where the effort should be directed.\nAutomatic learning procedures can make use of statistical inference algorithms to produce models that are robust to unfamiliar input (e.g. containing words or structures that have not been seen before) and to erroneous input (e.g. with misspelled words or words accidentally omitted). Generally, handling such input gracefully with handwritten rules, or, more generally, creating systems of handwritten rules that make soft decisions, is extremely difficult, error-prone and time-consuming.\nSystems based on automatically learning the rules can be made more accurate simply by supplying more input data. However, systems based on handwritten rules can only be made more accurate by increasing the complexity of the rules, which is a much more difficult task. In particular, there is a limit to the complexity of systems based on handwritten rules, beyond which the systems become more and more unmanageable. However, creating more data to input to machine-learning systems simply requires a corresponding increase in the number of man-hours worked, generally without significant increases in the complexity of the annotation process.\nDespite the popularity of machine learning in NLP research, symbolic methods are still (2020) commonly used:\nwhen the amount of training data is insufficient to successfully apply machine learning methods, e.g., for the machine translation of low-resource languages such as provided by the Apertium system,\nfor preprocessing in NLP pipelines, e.g., tokenization, or\nfor postprocessing and transforming the output of NLP pipelines, e.g., for knowledge extraction from syntactic parses.\nStatistical methodsEdit\nSince the so-called \"statistical revolution\"[15][16] in the late 1980s and mid-1990s, much natural language processing research has relied heavily on machine learning. The machine-learning paradigm calls instead for using statistical inference to automatically learn such rules through the analysis of large corpora (the plural form of corpus, is a set of documents, possibly with human or computer annotations) of typical real-world examples.\nMany different classes of machine-learning algorithms have been applied to natural-language-processing tasks. These algorithms take as input a large set of \"features\" that are generated from the input data. Increasingly, however, research has focused on statistical models, which make soft, probabilistic decisions based on attaching real-valued weights to each input feature (complex-valued embeddings,[17] and neural networks in general have also been proposed, for e.g. speech[18]). Such models have the advantage that they can express the relative certainty of many different possible answers rather than only one, producing more reliable results when such a model is included as a component of a larger system.\nSome of the earliest-used machine learning algorithms, such as decision trees, produced systems of hard if-then rules similar to existing hand-written rules.  However, part-of-speech tagging introduced the use of hidden Markov models to natural language processing, and increasingly, research has focused on statistical models, which make soft, probabilistic decisions based on attaching real-valued weights to the features making up the input data. The cache language models upon which many speech recognition systems now rely are examples of such statistical models.  Such models are generally more robust when given unfamiliar input, especially input that contains errors (as is very common for real-world data), and produce more reliable results when integrated into a larger system comprising multiple subtasks.\nSince the neural turn, statistical methods in NLP research have been largely replaced by neural networks. However, they continue to be relevant for contexts in which statistical interpretability and transparency is required.\nNeural networksEdit\nFurther information: Artificial neural network\nA major drawback of statistical methods is that they require elaborate feature engineering. Since 2015,[19] the field has thus largely abandoned statistical methods and shifted to neural networks for machine learning. Popular techniques include the use of word embeddings to capture semantic properties of words, and an increase in end-to-end learning of a higher-level task (e.g., question answering) instead of relying on a pipeline of separate intermediate tasks (e.g., part-of-speech tagging and dependency parsing). In some areas, this shift has entailed substantial changes in how NLP systems are designed, such that deep neural network-based approaches may be viewed as a new paradigm distinct from statistical natural language processing. For instance, the term neural machine translation (NMT) emphasizes the fact that deep learning-based approaches to machine translation directly learn sequence-to-sequence transformations, obviating the need for intermediate steps such as word alignment and language modeling that was used in statistical machine translation (SMT).\nCommon NLP tasksEdit\nThe following is a list of some of the most commonly researched tasks in natural language processing. Some of these tasks have direct real-world applications, while others more commonly serve as subtasks that are used to aid in solving larger tasks.\nThough natural language processing tasks are closely intertwined, they can be subdivided into categories for convenience. A coarse division is given below.\nText and speech processingEdit\nOptical character recognition (OCR)\nGiven an image representing printed text, determine the corresponding text.Speech recognition\nGiven a sound clip of a person or people speaking, determine the textual representation of the speech.  This is the opposite of text to speech and is one of the extremely difficult problems colloquially termed \"AI-complete\" (see above).  In natural speech there are hardly any pauses between successive words, and thus speech segmentation is a necessary subtask of speech recognition (see below). In most spoken languages, the sounds representing successive letters blend into each other in a process termed coarticulation, so the conversion of the analog signal to discrete characters can be a very difficult process. Also, given that words in the same language are spoken by people with different accents, the speech recognition software must be able to recognize the wide variety of input as being identical to each other in terms of its textual equivalent.\nSpeech segmentation\nGiven a sound clip of a person or people speaking, separate it into words.  A subtask of speech recognition and typically grouped with it.Text-to-speech\nGiven a text, transform those units and produce a spoken representation. Text-to-speech can be used to aid the visually impaired.[20]Word segmentation (Tokenization)\nSeparate a chunk of continuous text into separate words. For a language like English, this is fairly trivial, since words are usually separated by spaces. However, some written languages like Chinese, Japanese and Thai do not mark word boundaries in such a fashion, and in those languages text segmentation is a significant task requiring knowledge of the vocabulary and morphology of words in the language. Sometimes this process is also used in cases like bag of words (BOW) creation in data mining.\nMorphological analysisEdit\nLemmatization\nThe task of removing inflectional endings only and to return the base dictionary form of a word which is also known as a lemma. Lemmatization is another technique for reducing words to their normalized form. But in this case, the transformation actually uses a dictionary to map words to their actual form.[21]\nMorphological segmentation\nSeparate words into individual morphemes and identify the class of the morphemes. The difficulty of this task depends greatly on the complexity of the morphology (i.e., the structure of words) of the language being considered. English has fairly simple morphology, especially inflectional morphology, and thus it is often possible to ignore this task entirely and simply model all possible forms of a word (e.g., \"open, opens, opened, opening\") as separate words. In languages such as Turkish or Meitei,[22] a highly agglutinated Indian language, however, such an approach is not possible, as each dictionary entry has thousands of possible word forms.\nPart-of-speech tagging\nGiven a sentence, determine the part of speech (POS) for each word. Many words, especially common ones, can serve as multiple parts of speech. For example, \"book\" can be a noun (\"the book on the table\") or verb (\"to book a flight\"); \"set\" can be a noun, verb or adjective; and \"out\" can be any of at least five different parts of speech.Stemming\nThe process of reducing inflected (or sometimes derived) words to a base form (e.g., \"close\" will be the root for \"closed\", \"closing\", \"close\", \"closer\" etc.). Stemming yields similar results as lemmatization, but does so on grounds of rules, not a dictionary.\nSyntactic analysisEdit\nGrammar induction[23]\nGenerate a formal grammar that describes a language's syntax.\nSentence breaking (also known as \"sentence boundary disambiguation\")\nGiven a chunk of text, find the sentence boundaries. Sentence boundaries are often marked by periods or other punctuation marks, but these same characters can serve other purposes (e.g., marking abbreviations).\nParsing\nDetermine the parse tree (grammatical analysis) of a given sentence. The grammar for natural languages is ambiguous and typical sentences have multiple possible analyses: perhaps surprisingly, for a typical sentence there may be thousands of potential parses (most of which will seem completely nonsensical to a human). There are two primary types of parsing: dependency parsing and constituency parsing. Dependency parsing focuses on the relationships between words in a sentence (marking things like primary objects and predicates), whereas constituency parsing focuses on building out the parse tree using a probabilistic context-free grammar (PCFG) (see also stochastic grammar).\nLexical semantics (of individual words in context)Edit\nLexical semantics\nWhat is the computational meaning of individual words in context?\nDistributional semantics\nHow can we learn semantic representations from data?\nNamed entity recognition (NER)\nGiven a stream of text, determine which items in the text map to proper names, such as people or places, and what the type of each such name is (e.g. person, location, organization). Although capitalization can aid in recognizing named entities in languages such as English, this information cannot aid in determining the type of named entity, and in any case, is often inaccurate or insufficient.  For example, the first letter of a sentence is also capitalized, and named entities often span several words, only some of which are capitalized.  Furthermore, many other languages in non-Western scripts (e.g. Chinese or Arabic) do not have any capitalization at all, and even languages with capitalization may not consistently use it to distinguish names. For example, German capitalizes all nouns, regardless of whether they are names, and French and Spanish do not capitalize names that serve as adjectives.Sentiment analysis (see also Multimodal sentiment analysis)\nExtract subjective information usually from a set of documents, often using online reviews to determine \"polarity\" about specific objects. It is especially useful for identifying trends of public opinion in social media, for marketing.\nTerminology extraction\nThe goal of terminology extraction is to automatically extract relevant terms from a given corpus.\nWord-sense disambiguation (WSD)\nMany words have more than one meaning; we have to select the meaning which makes the most sense in context.  For this problem, we are typically given a list of words and associated word senses, e.g. from a dictionary or an online resource such as WordNet.\nEntity linking\nMany words\u2014typically proper names\u2014refer to named entities; here we have to select the entity (a famous individual, a location, a company, etc.) which is referred to in context.\nRelational semantics (semantics of individual sentences)Edit\nRelationship extraction\nGiven a chunk of text, identify the relationships among named entities (e.g. who is married to whom).\nSemantic parsing\nGiven a piece of text (typically a sentence), produce a formal representation of its semantics, either as a graph (e.g., in AMR parsing) or in accordance with a logical formalism (e.g., in DRT parsing). This challenge typically includes aspects of several more elementary NLP tasks from semantics (e.g., semantic role labelling, word-sense disambiguation) and can be extended to include full-fledged discourse analysis (e.g., discourse analysis, coreference; see Natural language understanding below).\nSemantic role labelling (see also implicit semantic role labelling below)\nGiven a single sentence, identify and disambiguate semantic predicates (e.g., verbal frames), then identify and classify the frame elements (semantic roles).\nDiscourse (semantics beyond individual sentences)Edit\nCoreference resolution\nGiven a sentence or larger chunk of text, determine which words (\"mentions\") refer to the same objects (\"entities\"). Anaphora resolution is a specific example of this task, and is specifically concerned with matching up pronouns with the nouns or names to which they refer. The more general task of coreference resolution also includes identifying so-called \"bridging relationships\" involving referring expressions. For example, in a sentence such as \"He entered John's house through the front door\", \"the front door\" is a referring expression and the bridging relationship to be identified is the fact that the door being referred to is the front door of John's house (rather than of some other structure that might also be referred to).\nDiscourse analysis\nThis rubric includes several related tasks.  One task is discourse parsing, i.e., identifying the discourse structure of a connected text, i.e. the nature of the discourse relationships between sentences (e.g. elaboration, explanation, contrast).  Another possible task is recognizing and classifying the speech acts in a chunk of text (e.g. yes-no question, content question, statement, assertion, etc.).Implicit semantic role labelling\nGiven a single sentence, identify and disambiguate semantic predicates (e.g., verbal frames) and their explicit semantic roles in the current sentence (see Semantic role labelling above). Then, identify semantic roles that are not explicitly realized in the current sentence, classify them into arguments that are explicitly realized elsewhere in the text and those that are not specified, and resolve the former against the local text. A closely related task is zero anaphora resolution, i.e., the extension of coreference resolution to pro-drop languages.Recognizing textual entailment\nGiven two text fragments, determine if one being true entails the other, entails the other's negation, or allows the other to be either true or false.[24]Topic segmentation and recognition\nGiven a chunk of text, separate it into segments each of which is devoted to a topic, and identify the topic of the segment.Argument mining\nThe goal of argument mining is the automatic extraction and identification of argumentative structures from natural language text with the aid of computer programs.[25] Such argumentative structures include the premise, conclusions, the argument scheme and the relationship between the main and subsidiary argument, or the main and counter-argument within discourse.[26][27]\nHigher-level NLP applicationsEdit\nAutomatic summarization (text summarization)\nProduce a readable summary of a chunk of text.  Often used to provide summaries of the text of a known type, such as research papers, articles in the financial section of a newspaper.\nBook generation\nNot an NLP task proper but an extension of natural language generation and other NLP tasks is the creation of full-fledged books. The first machine-generated book was created by a rule-based system in 1984 (Racter, The policeman's beard is half-constructed).[28] The first published work by a neural network was published in 2018, 1 the Road, marketed as a novel, contains sixty million words. Both these systems are basically elaborate but non-sensical (semantics-free) language models. The first machine-generated science book was published in 2019 (Beta Writer, Lithium-Ion Batteries, Springer, Cham).[29] Unlike Racter and 1 the Road, this is grounded on factual knowledge and based on text summarization.\nDialogue management\nComputer systems intended to converse with a human.\nDocument AI\nA Document AI platform sits on top of the NLP technology enabling users with no prior experience of artificial intelligence, machine learning or NLP to quickly train a computer to extract the specific data they need from different document types. NLP-powered Document AI enables non-technical teams to quickly access information hidden in documents, for example, lawyers, business analysts and accountants.[30]\nGrammatical error correction\nGrammatical error detection and correction involves a great band-width of problems on all levels of linguistic analysis (phonology/orthography, morphology, syntax, semantics, pragmatics). Grammatical error correction is impactful since it affects hundreds of millions of people that use or acquire English as a second language. It has thus been subject to a number of shared tasks since 2011.[31][32][33] As far as orthography, morphology, syntax and certain aspects of semantics are concerned, and due to the development of powerful neural language models such as GPT-2, this can now (2019) be considered a largely solved problem and is being marketed in various commercial applications.\nMachine translation\nAutomatically translate text from one human language to another.  This is one of the most difficult problems, and is a member of a class of problems colloquially termed \"AI-complete\", i.e. requiring all of the different types of knowledge that humans possess (grammar, semantics, facts about the real world, etc.) to solve properly.\nNatural-language generation (NLG):\nConvert information from computer databases or semantic intents into readable human language.\nNatural-language understanding (NLU)\nConvert chunks of text into more formal representations such as first-order logic structures that are easier for computer programs to manipulate. Natural language understanding involves the identification of the intended semantic from the multiple possible semantics which can be derived from a natural language expression which usually takes the form of organized notations of natural language concepts. Introduction and creation of language metamodel and ontology are efficient however empirical solutions. An explicit formalization of natural language semantics without confusions with implicit assumptions such as closed-world assumption (CWA) vs. open-world assumption, or subjective Yes/No vs. objective True/False is expected for the construction of a basis of semantics formalization.[34]\nQuestion answering\nGiven a human-language question, determine its answer. Typical questions have a specific right answer (such as \"What is the capital of Canada?\"), but sometimes open-ended questions are also considered (such as \"What is the meaning of life?\").\nText-to-image generation\nGiven a description of an image, generate an image that matches the description.[35]\nText-to-scene generation\nGiven a description of a scene, generate a 3D model of the scene.[36][37]\nText-to-video\nGiven a description of a video, generate a video that matches the description.[38][39]\nGeneral tendencies and (possible) future directionsEdit\nBased on long-standing trends in the field, it is possible to extrapolate future directions of NLP. As of 2020, three trends among the topics of the long-standing series of CoNLL Shared Tasks can be observed:[40]\nInterest on increasingly abstract, \"cognitive\" aspects of natural language (1999\u20132001: shallow parsing, 2002\u201303: named entity recognition, 2006\u201309/2017\u201318: dependency syntax, 2004\u201305/2008\u201309 semantic role labelling, 2011\u201312 coreference, 2015\u201316: discourse parsing, 2019: semantic parsing).\nIncreasing interest in multilinguality, and, potentially, multimodality (English since 1999; Spanish, Dutch since 2002; German since 2003; Bulgarian, Danish, Japanese, Portuguese, Slovenian, Swedish, Turkish since 2006; Basque, Catalan, Chinese, Greek, Hungarian, Italian, Turkish since 2007; Czech since 2009; Arabic since 2012; 2017: 40+ languages; 2018: 60+/100+ languages)\nElimination of symbolic representations (rule-based over supervised towards weakly supervised methods, representation learning and end-to-end systems)\nCognition and NLPEdit\nMost higher-level NLP applications involve aspects that emulate intelligent behaviour and apparent comprehension of natural language. More broadly speaking, the technical operationalization of increasingly advanced aspects of cognitive behaviour represents one of the developmental trajectories of NLP (see trends among CoNLL shared tasks above).\nCognition refers to \"the mental action or process of acquiring knowledge and understanding through thought, experience, and the senses.\"[41] Cognitive science is the interdisciplinary, scientific study of the mind and its processes.[42] Cognitive linguistics is an interdisciplinary branch of linguistics, combining knowledge and research from both psychology and linguistics.[43] Especially during the age of symbolic NLP, the area of computational linguistics maintained strong ties with cognitive studies.\nAs an example, George Lakoff offers a methodology to build natural language processing (NLP) algorithms through the perspective of cognitive science, along with the findings of cognitive linguistics,[44] with two defining aspects:\nApply the theory of conceptual metaphor, explained by Lakoff as \"the understanding of one idea, in terms of another\" which provides an idea of the intent of the author.[45] For example, consider the English word big. When used in a comparison (\"That is a big tree\"), the author's intent is to imply that the tree is physically large relative to other trees or the authors experience.  When used metaphorically (\"Tomorrow is a big day\"), the author's intent to imply importance.  The intent behind other usages, like in \"She is a big person\", will remain somewhat ambiguous to a person and a cognitive NLP algorithm alike without additional information.\nAssign relative measures of meaning to a word, phrase, sentence or piece of text based on the information presented before and after the piece of text being analyzed, e.g., by means of a probabilistic context-free grammar (PCFG). The mathematical equation for such algorithms is presented in US patent 9269353\u00a0:\nR\nM\nM\n(\nt\no\nk\ne\nn\nN\n)\n=\nP\nM\nM\n(\nt\no\nk\ne\nn\nN\n)\n\u00d7\n1\n2\nd\n(\n\u2211\ni\n=\n\u2212\nd\nd\n(\n(\nP\nM\nM\n(\nt\no\nk\ne\nn\nN\n\u2212\n1\n)\n\u00d7\nP\nF\n(\nt\no\nk\ne\nn\nN\n,\nt\no\nk\ne\nn\nN\n\u2212\n1\n)\n)\ni\n)\n{\\displaystyle {RMM(token_{N})}={PMM(token_{N})}\\times {\\frac {1}{2d}}\\left(\\sum _{i=-d}^{d}{((PMM(token_{N-1})}\\times {PF(token_{N},token_{N-1}))_{i}}\\right)}\n\u00a0Where,\nRMM, is the Relative Measure of Meaning\ntoken, is any block of text, sentence, phrase or word\nN, is the number of tokens being analyzed\nPMM, is the Probable Measure of Meaning based on a corpora\nd, is the location of the token along the sequence of N-1 tokens\nPF, is the Probability Function specific to a language\nTies with cognitive linguistics are part of the historical heritage of NLP, but they have been less frequently addressed since the statistical turn during the 1990s. Nevertheless, approaches to develop cognitive models towards technically operationalizable frameworks have been pursued in the context of various frameworks, e.g., of cognitive grammar,[46] functional grammar,[47] construction grammar,[48] computational psycholinguistics and cognitive neuroscience (e.g., ACT-R), however, with limited uptake in mainstream NLP (as measured by presence on major conferences[49] of the ACL). More recently, ideas of cognitive NLP have been revived as an approach to achieve explainability, e.g., under the notion of \"cognitive AI\".[50] Likewise, ideas of cognitive NLP are inherent to neural models multimodal NLP (although rarely made explicit).[51]\nSee alsoEdit\n1 the Road\nAutomated essay scoring\nBiomedical text mining\nCompound term processing\nComputational linguistics\nComputer-assisted reviewing\nControlled natural language\nDeep learning\nDeep linguistic processing\nDistributional semantics\nForeign language reading aid\nForeign language writing aid\nInformation extraction\nInformation retrieval\nLanguage and Communication Technologies\nLanguage technology\nLatent semantic indexing\nNative-language identification\nNatural-language programming\nNatural-language understanding\nNatural-language search\nOutline of natural language processing\nQuery expansion\nQuery understanding\nReification (linguistics)\nSpeech processing\nSpoken dialogue systems\nText-proofing\nText simplification\nTransformer (machine learning model)\nTruecasing\nQuestion answering\nWord2vec\nReferencesEdit\n^ Kongthon, Alisa; Sangkeettrakarn, Chatchawal; Kongyoung, Sarawoot; Haruechaiyasak, Choochart (October 27\u201330, 2009). \"Implementing an online help desk system based on conversational agent\". Proceedings of the International Conference on Management of Emergent Digital Eco Systems - MEDES '09. MEDES '09: The International Conference on Management of Emergent Digital EcoSystems. France: ACM. p.\u00a0450. doi:10.1145/1643823.1643908. ISBN\u00a0\n9781605588292\n.\n^ Hutchins, J. (2005). \"The history of machine translation in a nutshell\" (PDF).[self-published source]\n^ Koskenniemi, Kimmo (1983), Two-level morphology: A general computational model of word-form recognition and production (PDF), Department of General Linguistics, University of Helsinki\n^ Joshi, A. K., & Weinstein, S. (1981, August). Control of Inference: Role of Some Aspects of Discourse Structure-Centering. In IJCAI (pp. 385-387).\n^ Guida, G.; Mauri, G. (July 1986). \"Evaluation of natural language processing systems: Issues and approaches\". Proceedings of the IEEE. 74 (7): 1026\u20131035. doi:10.1109/PROC.1986.13580. ISSN\u00a01558-2256. S2CID\u00a030688575.\n^ Chomskyan linguistics encourages the investigation of \"corner cases\" that stress the limits of its theoretical models (comparable to pathological phenomena in mathematics), typically created using thought experiments, rather than the systematic investigation of typical phenomena that occur in real-world data, as is the case in corpus linguistics.  The creation and use of such corpora of real-world data is a fundamental part of machine-learning algorithms for natural language processing.  In addition, theoretical underpinnings of Chomskyan linguistics such as the so-called \"poverty of the stimulus\" argument entail that general learning algorithms, as are typically used in machine learning, cannot be successful in language processing.  As a result, the Chomskyan paradigm discouraged the application of such models to language processing.\n^ Goldberg, Yoav (2016). \"A Primer on Neural Network Models for Natural Language Processing\". Journal of Artificial Intelligence Research. 57: 345\u2013420. arXiv:1807.10854. doi:10.1613/jair.4992. S2CID\u00a08273530.\n^ Goodfellow, Ian; Bengio, Yoshua; Courville, Aaron (2016). Deep Learning. MIT Press.\n^ Jozefowicz, Rafal; Vinyals, Oriol; Schuster, Mike; Shazeer, Noam; Wu, Yonghui (2016). Exploring the Limits of Language Modeling. arXiv:1602.02410. Bibcode:2016arXiv160202410J.\n^ Choe, Do Kook; Charniak, Eugene. \"Parsing as Language Modeling\". Emnlp 2016. Archived from the original on 2018-10-23. Retrieved 2018-10-22.\n^ Vinyals, Oriol;  et\u00a0al. (2014). \"Grammar as a Foreign Language\" (PDF). Nips2015. arXiv:1412.7449. Bibcode:2014arXiv1412.7449V.\n^ Turchin, Alexander; Florez Builes, Luisa F. (2021-03-19). \"Using Natural Language Processing to Measure and Improve Quality of Diabetes Care: A Systematic Review\". Journal of Diabetes Science and Technology. 15 (3): 553\u2013560. doi:10.1177/19322968211000831. ISSN\u00a01932-2968. PMC\u00a08120048. PMID\u00a033736486.\n^ Winograd, Terry (1971). Procedures as a Representation for Data in a Computer Program for Understanding Natural Language (Thesis).\n^ Schank, Roger C.; Abelson, Robert P. (1977). Scripts, Plans, Goals, and Understanding: An Inquiry Into Human Knowledge Structures. Hillsdale: Erlbaum. ISBN\u00a0\n0-470-99033-3\n.\n^ Mark Johnson. How the statistical revolution changes (computational) linguistics. Proceedings of the EACL 2009 Workshop on the Interaction between Linguistics and Computational Linguistics.\n^ Philip Resnik. Four revolutions. Language Log, February 5, 2011.\n^ \"Investigating complex-valued representation in NLP\" (PDF).\n^ Trabelsi, Chiheb; Bilaniuk, Olexa; Zhang, Ying; Serdyuk, Dmitriy; Subramanian, Sandeep; Santos, Jo\u00e3o Felipe; Mehri, Soroush; Rostamzadeh, Negar; Bengio, Yoshua; Pal, Christopher J. (2018-02-25). \"Deep Complex Networks\". arXiv:1705.09792 [cs.NE].\n^ Socher, Richard. \"Deep Learning For NLP-ACL 2012 Tutorial\". www.socher.org. Retrieved 2020-08-17. This was an early Deep Learning tutorial at the ACL 2012 and met with both interest and (at the time) skepticism by most participants. Until then, neural learning was basically rejected because of its lack of statistical interpretability. Until 2015, deep learning had evolved into the major framework of NLP.\n^ Yi, Chucai; Tian, Yingli (2012), \"Assistive Text Reading from Complex Background for Blind Persons\", Camera-Based Document Analysis and Recognition, Springer Berlin Heidelberg, pp.\u00a015\u201328, CiteSeerX\u00a010.1.1.668.869, doi:10.1007/978-3-642-29364-1_2, ISBN\u00a0\n9783642293634\n^ \"What is Natural Language Processing? Intro to NLP in Machine Learning\". GyanSetu!. 2020-12-06. Retrieved 2021-01-09.\n^ Kishorjit, N.; Vidya, Raj RK.; Nirmal, Y.; Sivaji, B. (2012). \"Manipuri Morpheme Identification\" (PDF). Proceedings of the 3rd Workshop on South and Southeast Asian Natural Language Processing (SANLP). COLING 2012, Mumbai, December 2012: 95\u2013108.\n{{cite journal}}\n:  CS1 maint: location (link)\n^ Klein, Dan; Manning, Christopher D. (2002). \"Natural language grammar induction using a constituent-context model\" (PDF). Advances in Neural Information Processing Systems.\n^ PASCAL Recognizing Textual Entailment Challenge (RTE-7) https://tac.nist.gov//2011/RTE/\n^ Lippi, Marco; Torroni, Paolo (2016-04-20). \"Argumentation Mining: State of the Art and Emerging Trends\". ACM Transactions on Internet Technology. 16 (2): 1\u201325. doi:10.1145/2850417. hdl:11585/523460. ISSN\u00a01533-5399. S2CID\u00a09561587.\n^ \"Argument Mining - IJCAI2016 Tutorial\". www.i3s.unice.fr. Retrieved 2021-03-09.\n^ \"NLP Approaches to Computational Argumentation \u2013 ACL 2016, Berlin\". Retrieved 2021-03-09.\n^ \"U B U W E B\u00a0:: Racter\". www.ubu.com. Retrieved 2020-08-17.\n^ Writer, Beta (2019). Lithium-Ion Batteries. doi:10.1007/978-3-030-16800-1. ISBN\u00a0\n978-3-030-16799-8\n. S2CID\u00a0155818532.\n^ \"Document Understanding AI on Google Cloud (Cloud Next '19) - YouTube\". www.youtube.com. Archived from the original on 2021-10-30. Retrieved 2021-01-11.\n^ Administration. \"Centre for Language Technology (CLT)\". Macquarie University. Retrieved 2021-01-11.\n^ \"Shared Task: Grammatical Error Correction\". www.comp.nus.edu.sg. Retrieved 2021-01-11.\n^ \"Shared Task: Grammatical Error Correction\". www.comp.nus.edu.sg. Retrieved 2021-01-11.\n^ Duan, Yucong; Cruz, Christophe (2011). \"Formalizing Semantic of Natural Language through Conceptualization from Existence\". International Journal of Innovation, Management and Technology. 2 (1): 37\u201342. Archived from the original on 2011-10-09.\n^ Robertson, Adi (2022-04-06). \"OpenAI's DALL-E AI image generator can now edit pictures, too\". The Verge. Retrieved 2022-06-07.\n^ \"The Stanford Natural Language Processing Group\". nlp.stanford.edu. Retrieved 2022-06-07.\n^ Coyne, Bob; Sproat, Richard (2001-08-01). \"WordsEye: an automatic text-to-scene conversion system\". Proceedings of the 28th Annual Conference on Computer Graphics and Interactive Techniques. SIGGRAPH '01. New York, NY, USA: Association for Computing Machinery: 487\u2013496. doi:10.1145/383259.383316. ISBN\u00a0\n978-1-58113-374-5\n. S2CID\u00a03842372.\n^ \"Google announces AI advances in text-to-video, language translation, more\". VentureBeat. 2022-11-02. Retrieved 2022-11-09.\n^ Vincent, James (2022-09-29). \"Meta's new text-to-video AI generator is like DALL-E for video\". The Verge. Retrieved 2022-11-09.\n^ \"Previous shared tasks | CoNLL\". www.conll.org. Retrieved 2021-01-11.\n^ \"Cognition\". Lexico. Oxford University Press and Dictionary.com. Archived from the original on July 15, 2020. Retrieved 6 May 2020.\n^ \"Ask the Cognitive Scientist\". American Federation of Teachers. 8 August 2014. Cognitive science is an interdisciplinary field of researchers from Linguistics, psychology, neuroscience, philosophy, computer science, and anthropology that seek to understand the mind.\n^ Robinson, Peter (2008). Handbook of Cognitive Linguistics and Second Language Acquisition. Routledge. pp.\u00a03\u20138. ISBN\u00a0\n978-0-805-85352-0\n.\n^ Lakoff, George (1999). Philosophy in the Flesh: The Embodied Mind and Its Challenge to Western Philosophy; Appendix: The Neural Theory of Language Paradigm. New York Basic Books. pp.\u00a0569\u2013583. ISBN\u00a0\n978-0-465-05674-3\n.\n^ Strauss, Claudia (1999). A Cognitive Theory of Cultural Meaning. Cambridge University Press. pp.\u00a0156\u2013164. ISBN\u00a0\n978-0-521-59541-4\n.\n^ \"Universal Conceptual Cognitive Annotation (UCCA)\". Universal Conceptual Cognitive Annotation (UCCA). Retrieved 2021-01-11.\n^ Rodr\u00edguez, F. C., & Mairal-Us\u00f3n, R. (2016). Building an RRG computational grammar. Onomazein, (34), 86-117.\n^ \"Fluid Construction Grammar \u2013 A fully operational processing system for construction grammars\". Retrieved 2021-01-11.\n^ \"ACL Member Portal | The Association for Computational Linguistics Member Portal\". www.aclweb.org. Retrieved 2021-01-11.\n^ \"Chunks and Rules\". www.w3.org. Retrieved 2021-01-11.\n^ Socher, Richard; Karpathy, Andrej; Le, Quoc V.; Manning, Christopher D.; Ng, Andrew Y. (2014). \"Grounded Compositional Semantics for Finding and Describing Images with Sentences\". Transactions of the Association for Computational Linguistics. 2: 207\u2013218. doi:10.1162/tacl_a_00177. S2CID\u00a02317858.\nFurther readingEdit\nBates, M (1995). \"Models of natural language understanding\". Proceedings of the National Academy of Sciences of the United States of America. 92 (22): 9977\u20139982. Bibcode:1995PNAS...92.9977B. doi:10.1073/pnas.92.22.9977. PMC\u00a040721. PMID\u00a07479812.\nSteven Bird, Ewan Klein, and Edward Loper (2009). Natural Language Processing with Python. O'Reilly Media. ISBN\u00a0978-0-596-51649-9.\nDaniel Jurafsky and James H. Martin (2008). Speech and Language Processing, 2nd edition. Pearson Prentice Hall. ISBN\u00a0978-0-13-187321-6.\nMohamed Zakaria Kurdi (2016). Natural Language Processing and Computational Linguistics: speech, morphology, and syntax, Volume 1. ISTE-Wiley. ISBN\u00a0978-1848218482.\nMohamed Zakaria Kurdi (2017). Natural Language Processing and Computational Linguistics: semantics, discourse, and applications, Volume 2. ISTE-Wiley. ISBN\u00a0978-1848219212.\nChristopher D. Manning, Prabhakar Raghavan, and Hinrich Sch\u00fctze (2008). Introduction to Information Retrieval. Cambridge University Press. ISBN\u00a0978-0-521-86571-5. Official html and pdf versions available without charge.\nChristopher D. Manning and Hinrich Sch\u00fctze (1999). Foundations of Statistical Natural Language Processing. The MIT Press. ISBN\u00a0978-0-262-13360-9.\nDavid M. W. Powers and Christopher C. R. Turk (1989). Machine Learning of Natural Language. Springer-Verlag. ISBN\u00a0978-0-387-19557-5.\nExternal linksEdit\n\u00a0 Media related to Natural language processing at Wikimedia Commons\nPortal:\n\u00a0\u00a0Language\nRetrieved from \"https://en.wikipedia.org/w/index.php?title=Natural_language_processing&oldid=1120972063\"\nLast edited on 9 November 2022, at 20:39\n This page was last edited on 9 November 2022, at 20:39\u00a0(UTC).\nContent is available under CC BY-SA 3.0 unless otherwise noted.\nPrivacy policy\nAbout Wikipedia\nDisclaimers\nContact Wikipedia\nTerms of Use\nDesktop\nDevelopers\nStatistics\nCookie statement\n", "features": {}, "offset_type": "j", "name": ""} ; 
    let COKHYSJMVA_parms = {"presel_set": [], "presel_list": [], "cols4types": {}} ;
    new gatenlpDocView(new gatenlpDocRep(COKHYSJMVA_data, COKHYSJMVA_parms), "COKHYSJMVA-").init();
    </script>
  </div>

</div></div>



The markup present in the original HTML file is converted into annotations in the annotation set with the name "Original markups". For example all the HTML links are present as annotations of type "a" (there are 449 of those), the level 3 headings are present as annotations of type "h3" and so on. 



## Loading and saving using various document formats

GateNlp documents can be loaded from a number of different text representations. When you run
`Document.load(filepath)`, gatenlp tries to automatically determine the format of the document from the file 
extensions, but if that fails, it is possible to explicitly specify the format using the `fmt=` keyword argument 
which can take a memnonic or a mime type specification for the format. 

The following formats are known, the list shows first the memnonic, if one exists, then the mime type, and then 
the description of the format. All the following formats can be loaded and saved:  

* `text`, `text/plain`:  Plain text, extension `.txt`, 
  by default this is expected to be encoded in "UTF-8" but a different encoding
  can be specified using the `encoding=` keyword argument. 
* `text/plain+gzip`: Gzip compressed plain text, same as `text` but gzip compressed.
* `bdocjs`, `json`, `text/bdocjs`: BDOC Json Format, extension `.bdocjs`,  which can be exchanged with Java GATE via the 
  format BDOC plugin (https://gatenlp.github.io/gateplugin-Format_Bdoc/)
* `bdocjsgz`, `jsongz`, `text/bdocjs+gzip`: BDOC Json Format, GZip compressed, extension `.bdocjs.gz`
* `yaml`, `text/bdocym`: BDOC Yaml Format, extension `.bdocym`,  which can be exchanged with Java GATE 
   via the format BDOC plugin. This format allows for serialization of shared nested arrays/maps and exchange
   of these between Java GATE and Python GateNLP. 
* `yamlgz`, `text/bdocym+gzip`: BDOC Yaml Format, GZip compressed, extesion, `.bdocym.gz`
* `msgpack`, `application/msgpack`: BDOC Message Pack format, extension `.bdocmp`. Can be exchanged with Java
   GATE via the format BDOC plugin
   
The following formats can only be loaded:

* `html`, `text/html`: HTML files can be loaded and will be parsed to obtain the text and to create annotations
   that correspond to the HTML markup (these annotations are in annotation set "Original markups"). Note that
   not all HTML can be parsed without problems and this will NOT load the *rendered* form of the HTML page, i.e.
   anything created or influenced by JavaScript code on the page is not loaded. 
* `gatexml`: Java GATE XML format, extension `.xml` can be loaded, but Java-specific data is not supported.
   If e.g. features have Java lists or arrays or similar as a value, the load will fail unless the keyword 
   argument `ignore_unknown_types=True` is specified. 

The following formats can only be  saved:
* `html-ann-viewer`: This creates a HTML file which can be used to visualize the document. The following 
  keyword arguments can be used: `notebook=True` to create a div instead of a complete html document, 
  `offline=True` to include all Javascript code necessary for visualization in the document instead of loading
  it from the internet, `htmlid="somename"` to make all HTML, CSS and Javascript definitions for the generated
  HTML code unique, so that several different pieces of HTML code can be embedded in the same page. 
  
Documents can also be saved and loaded using Python pickle.

Documents can also be convert to and from a Python-only representation using the methods `doc.to_dict()` and `Document.from_dict(thedict)` which can be used to serialize or transfer the document in many other formats. 


```python
# Convert the document to a dictionary representation:
as_dict = doc.to_dict()
as_dict
```




    {'annotation_sets': {'Set1': {'name': 'Set1',
       'annotations': [{'type': 'Word',
         'start': 0,
         'end': 4,
         'id': 0,
         'features': {'what': 'our first annotation'}},
        {'type': 'Word',
         'start': 5,
         'end': 7,
         'id': 1,
         'features': {'what': 'our second annotation'}},
        {'type': 'Sentence',
         'start': 0,
         'end': 24,
         'id': 2,
         'features': {'what': 'our first sentence annotation'}}],
       'next_annid': 3}},
     'text': 'This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like 😽 (a kissing cat),\n👩\u200d🏫 (a woman teacher), 🧬 (DNA), \n🧗 (a person climbing), \n💩 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul 한글 or \nsimplified Hanzi 汉字 or Farsi فارسی which goes from right to left. \n\n\n',
     'features': {'loaded-from': 'https://gatenlp.github.io/python-gatenlp/testdocument1.txt',
      'purpose': 'test document for gatenlp',
      'someotherfeature': 22,
      'andanother': {'what': 'a dict', 'alist': [1, 2, 3, 4, 5]}},
     'offset_type': 'p',
     'name': ''}




```python
# create a copy by creating a new Document from the dictionary representation
doc_copy = Document.from_dict(as_dict)
doc_copy
```




<div><style>#FROTRDNELM-wrapper { color: black !important; }</style>
<div id="FROTRDNELM-wrapper">

<div>
<style>
#FROTRDNELM-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.FROTRDNELM-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.FROTRDNELM-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.FROTRDNELM-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.FROTRDNELM-label {
    margin-bottom: -15px;
    display: block;
}

.FROTRDNELM-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#FROTRDNELM-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.FROTRDNELM-selection {
    margin-bottom: 5px;
}

.FROTRDNELM-featuretable {
    margin-top: 10px;
}

.FROTRDNELM-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.FROTRDNELM-fvalue {
    text-align: left !important;
}
</style>
  <div id="FROTRDNELM-content">
        <div id="FROTRDNELM-popup" style="display: none;">
        </div>
        <div class="FROTRDNELM-row" id="FROTRDNELM-row1" style="min-height:5em;max-height:20em; min-height:5em;">
            <div id="FROTRDNELM-text-wrapper" class="FROTRDNELM-col" style="width:70%;">
                <div class="FROTRDNELM-hdr" id="FROTRDNELM-dochdr"></div>
                <div id="FROTRDNELM-text" style="">
                </div>
            </div>
            <div id="FROTRDNELM-chooser" class="FROTRDNELM-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="FROTRDNELM-row" id="FROTRDNELM-row2" style="min-height:3em;max-height:14em; min-height: 3em;">
            <div id="FROTRDNELM-details" class="FROTRDNELM-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="text/javascript">
    let FROTRDNELM_data = {"annotation_sets": {"Set1": {"name": "detached-from:Set1", "annotations": [{"type": "Word", "start": 0, "end": 4, "id": 0, "features": {"what": "our first annotation"}}, {"type": "Word", "start": 5, "end": 7, "id": 1, "features": {"what": "our second annotation"}}, {"type": "Sentence", "start": 0, "end": 24, "id": 2, "features": {"what": "our first sentence annotation"}}], "next_annid": 3}}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {"loaded-from": "https://gatenlp.github.io/python-gatenlp/testdocument1.txt", "purpose": "test document for gatenlp", "someotherfeature": 22, "andanother": {"what": "a dict", "alist": [1, 2, 3, 4, 5]}}, "offset_type": "j", "name": ""} ; 
    let FROTRDNELM_parms = {"presel_set": [], "presel_list": [], "cols4types": {}} ;
    new gatenlpDocView(new gatenlpDocRep(FROTRDNELM_data, FROTRDNELM_parms), "FROTRDNELM-").init();
    </script>
  </div>

</div></div>




```python
# Save the document in bdocjs format
doc.save("tmpdoc.bdocjs") 

# show what the document looks like 
with open("tmpdoc.bdocjs", "rt") as infp:
    print(infp.read())
```

    {"annotation_sets": {"Set1": {"name": "Set1", "annotations": [{"type": "Word", "start": 0, "end": 4, "id": 0, "features": {"what": "our first annotation"}}, {"type": "Word", "start": 5, "end": 7, "id": 1, "features": {"what": "our second annotation"}}, {"type": "Sentence", "start": 0, "end": 24, "id": 2, "features": {"what": "our first sentence annotation"}}], "next_annid": 3}}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {"loaded-from": "https://gatenlp.github.io/python-gatenlp/testdocument1.txt", "purpose": "test document for gatenlp", "someotherfeature": 22, "andanother": {"what": "a dict", "alist": [1, 2, 3, 4, 5]}}, "offset_type": "p", "name": ""}



```python
# load the document from the saved bdocjs format file
Document.load("tmpdoc.bdocjs")
```




<div><style>#ULHZFWTLFR-wrapper { color: black !important; }</style>
<div id="ULHZFWTLFR-wrapper">

<div>
<style>
#ULHZFWTLFR-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.ULHZFWTLFR-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.ULHZFWTLFR-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.ULHZFWTLFR-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.ULHZFWTLFR-label {
    margin-bottom: -15px;
    display: block;
}

.ULHZFWTLFR-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#ULHZFWTLFR-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.ULHZFWTLFR-selection {
    margin-bottom: 5px;
}

.ULHZFWTLFR-featuretable {
    margin-top: 10px;
}

.ULHZFWTLFR-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.ULHZFWTLFR-fvalue {
    text-align: left !important;
}
</style>
  <div id="ULHZFWTLFR-content">
        <div id="ULHZFWTLFR-popup" style="display: none;">
        </div>
        <div class="ULHZFWTLFR-row" id="ULHZFWTLFR-row1" style="min-height:5em;max-height:20em; min-height:5em;">
            <div id="ULHZFWTLFR-text-wrapper" class="ULHZFWTLFR-col" style="width:70%;">
                <div class="ULHZFWTLFR-hdr" id="ULHZFWTLFR-dochdr"></div>
                <div id="ULHZFWTLFR-text" style="">
                </div>
            </div>
            <div id="ULHZFWTLFR-chooser" class="ULHZFWTLFR-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="ULHZFWTLFR-row" id="ULHZFWTLFR-row2" style="min-height:3em;max-height:14em; min-height: 3em;">
            <div id="ULHZFWTLFR-details" class="ULHZFWTLFR-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="text/javascript">
    let ULHZFWTLFR_data = {"annotation_sets": {"Set1": {"name": "detached-from:Set1", "annotations": [{"type": "Word", "start": 0, "end": 4, "id": 0, "features": {"what": "our first annotation"}}, {"type": "Word", "start": 5, "end": 7, "id": 1, "features": {"what": "our second annotation"}}, {"type": "Sentence", "start": 0, "end": 24, "id": 2, "features": {"what": "our first sentence annotation"}}], "next_annid": 3}}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {"loaded-from": "https://gatenlp.github.io/python-gatenlp/testdocument1.txt", "purpose": "test document for gatenlp", "someotherfeature": 22, "andanother": {"what": "a dict", "alist": [1, 2, 3, 4, 5]}}, "offset_type": "j", "name": ""} ; 
    let ULHZFWTLFR_parms = {"presel_set": [], "presel_list": [], "cols4types": {}} ;
    new gatenlpDocView(new gatenlpDocRep(ULHZFWTLFR_data, ULHZFWTLFR_parms), "ULHZFWTLFR-").init();
    </script>
  </div>

</div></div>




```python
# clean up the document
import os
os.remove("tmpdoc.bdocjs")
```

### Notebook last updated


```python
import gatenlp
print("NB last updated with gatenlp version", gatenlp.__version__)
```

    NB last updated with gatenlp version 1.0.8a1

