# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cvdast']

package_data = \
{'': ['*'],
 'cvdast': ['assets/*',
            'fuzzdb/*',
            'fuzzdb/.git/*',
            'fuzzdb/.git/hooks/*',
            'fuzzdb/.git/info/*',
            'fuzzdb/.git/logs/*',
            'fuzzdb/.git/logs/refs/heads/*',
            'fuzzdb/.git/logs/refs/remotes/origin/*',
            'fuzzdb/.git/objects/pack/*',
            'fuzzdb/.git/refs/heads/*',
            'fuzzdb/.git/refs/remotes/origin/*',
            'fuzzdb/attack/*',
            'fuzzdb/attack/authentication/*',
            'fuzzdb/attack/business-logic/*',
            'fuzzdb/attack/control-chars/*',
            'fuzzdb/attack/disclosure-directory/*',
            'fuzzdb/attack/disclosure-localpaths/unix/*',
            'fuzzdb/attack/disclosure-source/*',
            'fuzzdb/attack/file-upload/*',
            'fuzzdb/attack/file-upload/malicious-images/*',
            'fuzzdb/attack/format-strings/*',
            'fuzzdb/attack/html_js_fuzz/*',
            'fuzzdb/attack/http-protocol/*',
            'fuzzdb/attack/integer-overflow/*',
            'fuzzdb/attack/json/*',
            'fuzzdb/attack/mimetypes/*',
            'fuzzdb/attack/no-sql-injection/*',
            'fuzzdb/attack/os-cmd-execution/*',
            'fuzzdb/attack/os-dir-indexing/*',
            'fuzzdb/attack/path-traversal/*',
            'fuzzdb/attack/redirect/*',
            'fuzzdb/attack/server-side-include/*',
            'fuzzdb/attack/sql-injection/detect/*',
            'fuzzdb/attack/sql-injection/exploit/*',
            'fuzzdb/attack/sql-injection/payloads-sql-blind/*',
            'fuzzdb/attack/string-expansion/*',
            'fuzzdb/attack/unicode/*',
            'fuzzdb/attack/xml/*',
            'fuzzdb/attack/xpath/*',
            'fuzzdb/attack/xss/*',
            'fuzzdb/discovery/URI_SCHEMES/*',
            'fuzzdb/discovery/UserAgent/*',
            'fuzzdb/discovery/WebSocket/*',
            'fuzzdb/discovery/common-methods/*',
            'fuzzdb/discovery/dns/*',
            'fuzzdb/discovery/predictable-filepaths/*',
            'fuzzdb/discovery/predictable-filepaths/backdoors/*',
            'fuzzdb/discovery/predictable-filepaths/cgi/*',
            'fuzzdb/discovery/predictable-filepaths/cms/*',
            'fuzzdb/discovery/predictable-filepaths/filename-dirname-bruteforce/*',
            'fuzzdb/discovery/predictable-filepaths/login-file-locations/*',
            'fuzzdb/discovery/predictable-filepaths/password-file-locations/*',
            'fuzzdb/discovery/predictable-filepaths/php/*',
            'fuzzdb/discovery/predictable-filepaths/webservers-appservers/*',
            'fuzzdb/docs/attack-docs/*',
            'fuzzdb/docs/attack-docs/remote-cmd-exfiltration/*',
            'fuzzdb/docs/attack-docs/sqli/*',
            'fuzzdb/docs/attack-docs/waf-bypass/*',
            'fuzzdb/docs/attack-docs/xss/docs.wasc-scriptmapping/*',
            'fuzzdb/docs/attack-docs/xss/docs.wasc-scriptmapping/images/*',
            'fuzzdb/docs/misc/*',
            'fuzzdb/regex/*',
            'fuzzdb/web-backdoors/*',
            'fuzzdb/web-backdoors/asp/*',
            'fuzzdb/web-backdoors/c/*',
            'fuzzdb/web-backdoors/cfm/*',
            'fuzzdb/web-backdoors/exe/*',
            'fuzzdb/web-backdoors/jsp/*',
            'fuzzdb/web-backdoors/jsp/laudanum/*',
            'fuzzdb/web-backdoors/jsp/laudanum/warfiles/*',
            'fuzzdb/web-backdoors/jsp/laudanum/warfiles/META-INF/*',
            'fuzzdb/web-backdoors/jsp/laudanum/warfiles/WEB-INF/*',
            'fuzzdb/web-backdoors/jsp/win32/*',
            'fuzzdb/web-backdoors/php/*',
            'fuzzdb/web-backdoors/pl-cgi/*',
            'fuzzdb/web-backdoors/servlet/*',
            'fuzzdb/web-backdoors/sh/*',
            'fuzzdb/web-backdoors/wordpress/*',
            'fuzzdb/web-backdoors/wordpress/templates/*',
            'fuzzdb/wordlists-misc/*',
            'fuzzdb/wordlists-user-passwd/*',
            'fuzzdb/wordlists-user-passwd/db2/*',
            'fuzzdb/wordlists-user-passwd/generic-listpairs/*',
            'fuzzdb/wordlists-user-passwd/names/*',
            'fuzzdb/wordlists-user-passwd/oracle/*',
            'fuzzdb/wordlists-user-passwd/passwds/*',
            'fuzzdb/wordlists-user-passwd/postgres/*',
            'fuzzdb/wordlists-user-passwd/tomcat/*',
            'fuzzdb/wordlists-user-passwd/unix-os/*',
            'templates/*',
            'templates/data/*',
            'templates/html/*',
            'wfuzz/.git/*',
            'wfuzz/.git/hooks/*',
            'wfuzz/.git/info/*',
            'wfuzz/.git/logs/*',
            'wfuzz/.git/logs/refs/heads/*',
            'wfuzz/.git/logs/refs/remotes/origin/*',
            'wfuzz/.git/logs/refs/remotes/origin/dependabot/pip/*',
            'wfuzz/.git/objects/2d/*',
            'wfuzz/.git/objects/30/*',
            'wfuzz/.git/objects/33/*',
            'wfuzz/.git/objects/37/*',
            'wfuzz/.git/objects/3b/*',
            'wfuzz/.git/objects/72/*',
            'wfuzz/.git/objects/8d/*',
            'wfuzz/.git/objects/a4/*',
            'wfuzz/.git/objects/ad/*',
            'wfuzz/.git/objects/b0/*',
            'wfuzz/.git/objects/b3/*',
            'wfuzz/.git/objects/c4/*',
            'wfuzz/.git/objects/db/*',
            'wfuzz/.git/objects/e6/*',
            'wfuzz/.git/objects/pack/*',
            'wfuzz/.git/refs/heads/*',
            'wfuzz/.git/refs/remotes/origin/*',
            'wfuzz/.git/refs/remotes/origin/dependabot/pip/*',
            'wfuzz/.git/refs/tags/*',
            'wfuzz/wordlist/general/*',
            'wfuzz/wordlist/injections/*',
            'wfuzz/wordlist/others/*',
            'wfuzz/wordlist/stress/*',
            'wfuzz/wordlist/vulns/*',
            'wfuzz/wordlist/webservices/*']}

install_requires = \
['PyYAML==5.3.1',
 'autopep8==1.5.4',
 'curlify==2.2.1',
 'cvapianalyser==1.42.1',
 'dictor==0.1.7',
 'jinja2',
 'openapispecdiff==1.43.1',
 'pytest-cases==1.16.0',
 'pytest-html',
 'pytest-json==0.4.0',
 'pytest-lazy-fixture==0.6.3',
 'pytest-pytestrail==0.10.5',
 'pytest-rerunfailures==9.0',
 'pytest==5.4.3',
 'requests==2.22.0',
 'tqdm==4.46.1',
 'validators==0.18.0']

entry_points = \
{'console_scripts': ['cvdast = cvdast.CloudvectorDAST:main']}

setup_kwargs = {
    'name': 'cvdast',
    'version': '1.43.22',
    'description': 'To regenerate pytest fixtures and test methods dynamically from OpenAPI spec and Cloudvector APIShark events',
    'long_description': '# cv-dast\n\nCV-DAST is a Python library for regenerating the pytest fixtures and test cases dynamically from Open API Spec and Cloudvector APIShark events \n\nVisit https://www.cloudvector.com/api-shark-free-observability-security-monitoring-tool/#apishark\n\n## Installation\n\nUse the package manager [pip](https://pip.pypa.io/en/stable/) to install foobar.\n\n```bash\npip install cv-dast\n```\n\n## Usage\n\n```python cv-dast \n\n****************************************************************************************************\nCloudVector CommunityEdition - Coverage analysis plugin\n****************************************************************************************************\n\nEnter CommunityEdition(CE) host in format <host>:<port> : x.x.x.x:y\nEnter your CommunityEdition(CE) username : sandeep\nCommunityEdition(CE) password:\nEnter absolute path to Old API SPEC: ../input.json\nEnter absolute path to new API SPEC : ../input1.json \nDo you want to process only diff? (Y/N) : \nEnter absolute path to input parameteres json(press Enter for None):\n```\n\ninstead of giving inputs every single time you can also alternatively create a file called my_cesetup.yaml in the path from where you are running the tool\n\n```yaml \nce_host:\nce_username:\n```\nyou can have multiple such my_cesetup.yaml for different CE setup or different recordings and run them from specific paths for its corresponding reports\n\n## License\n[MIT](https://choosealicense.com/licenses/mit/)',
    'author': 'Bala Kumaran',
    'author_email': 'balak@cloudvector.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
