# coding: utf-8

"""
    FINBOURNE Drive API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.1.406
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lusid_drive.api_client import ApiClient
from lusid_drive.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid_drive.models.lusid_problem_details import LusidProblemDetails
from lusid_drive.models.lusid_validation_problem_details import LusidValidationProblemDetails
from lusid_drive.models.storage_object import StorageObject
from lusid_drive.models.update_file import UpdateFile


class FilesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_file(self, x_lusid_drive_filename, x_lusid_drive_path, content_length, body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] CreateFile: Uploads a file to Lusid Drive. If using an SDK, consider using the UploadAsStreamAsync function for larger files instead.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file(x_lusid_drive_filename, x_lusid_drive_path, content_length, body, async_req=True)
        >>> result = thread.get()

        :param x_lusid_drive_filename: File name. (required)
        :type x_lusid_drive_filename: str
        :param x_lusid_drive_path: File path. (required)
        :type x_lusid_drive_path: str
        :param content_length: The size in bytes of the file to be uploaded (required)
        :type content_length: int
        :param body: (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StorageObject
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_with_http_info(x_lusid_drive_filename, x_lusid_drive_path, content_length, body, **kwargs)  # noqa: E501

    def create_file_with_http_info(self, x_lusid_drive_filename, x_lusid_drive_path, content_length, body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] CreateFile: Uploads a file to Lusid Drive. If using an SDK, consider using the UploadAsStreamAsync function for larger files instead.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_with_http_info(x_lusid_drive_filename, x_lusid_drive_path, content_length, body, async_req=True)
        >>> result = thread.get()

        :param x_lusid_drive_filename: File name. (required)
        :type x_lusid_drive_filename: str
        :param x_lusid_drive_path: File path. (required)
        :type x_lusid_drive_path: str
        :param content_length: The size in bytes of the file to be uploaded (required)
        :type content_length: int
        :param body: (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (StorageObject, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'x_lusid_drive_filename',
            'x_lusid_drive_path',
            'content_length',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'x_lusid_drive_filename' is set
        if self.api_client.client_side_validation and ('x_lusid_drive_filename' not in local_var_params or  # noqa: E501
                                                        local_var_params['x_lusid_drive_filename'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `x_lusid_drive_filename` when calling `create_file`")  # noqa: E501
        # verify the required parameter 'x_lusid_drive_path' is set
        if self.api_client.client_side_validation and ('x_lusid_drive_path' not in local_var_params or  # noqa: E501
                                                        local_var_params['x_lusid_drive_path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `x_lusid_drive_path` when calling `create_file`")  # noqa: E501
        # verify the required parameter 'content_length' is set
        if self.api_client.client_side_validation and ('content_length' not in local_var_params or  # noqa: E501
                                                        local_var_params['content_length'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `content_length` when calling `create_file`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_file`")  # noqa: E501

        if self.api_client.client_side_validation and ('x_lusid_drive_filename' in local_var_params and  # noqa: E501
                                                        len(local_var_params['x_lusid_drive_filename']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `x_lusid_drive_filename` when calling `create_file`, length must be less than or equal to `256`")  # noqa: E501
        if self.api_client.client_side_validation and ('x_lusid_drive_filename' in local_var_params and  # noqa: E501
                                                        len(local_var_params['x_lusid_drive_filename']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `x_lusid_drive_filename` when calling `create_file`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'x_lusid_drive_filename' in local_var_params and not re.search(r'^[A-Za-z0-9_\-\.]+[A-Za-z0-9_\-\. ]*$', local_var_params['x_lusid_drive_filename']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `x_lusid_drive_filename` when calling `create_file`, must conform to the pattern `/^[A-Za-z0-9_\-\.]+[A-Za-z0-9_\-\. ]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('x_lusid_drive_path' in local_var_params and  # noqa: E501
                                                        len(local_var_params['x_lusid_drive_path']) > 512):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `x_lusid_drive_path` when calling `create_file`, length must be less than or equal to `512`")  # noqa: E501
        if self.api_client.client_side_validation and ('x_lusid_drive_path' in local_var_params and  # noqa: E501
                                                        len(local_var_params['x_lusid_drive_path']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `x_lusid_drive_path` when calling `create_file`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'x_lusid_drive_path' in local_var_params and not re.search(r'^[\/a-zA-Z0-9 \-_]+$', local_var_params['x_lusid_drive_path']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `x_lusid_drive_path` when calling `create_file`, must conform to the pattern `/^[\/a-zA-Z0-9 \-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'x_lusid_drive_filename' in local_var_params:
            header_params['x-lusid-drive-filename'] = local_var_params['x_lusid_drive_filename']  # noqa: E501
        if 'x_lusid_drive_path' in local_var_params:
            header_params['x-lusid-drive-path'] = local_var_params['x_lusid_drive_path']  # noqa: E501
        if 'content_length' in local_var_params:
            header_params['Content-Length'] = local_var_params['content_length']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.1.406'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            201: "StorageObject",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_file(self, id, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteFile: Deletes a file from Drive.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file(id, async_req=True)
        >>> result = thread.get()

        :param id: Identifier of the file to be deleted. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_file_with_http_info(id, **kwargs)  # noqa: E501

    def delete_file_with_http_info(self, id, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteFile: Deletes a file from Drive.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Identifier of the file to be deleted. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_file`")  # noqa: E501

        if self.api_client.client_side_validation and ('id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id']) > 40):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `delete_file`, length must be less than or equal to `40`")  # noqa: E501
        if self.api_client.client_side_validation and ('id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id']) < 30):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `delete_file`, length must be greater than or equal to `30`")  # noqa: E501
        if self.api_client.client_side_validation and 'id' in local_var_params and not re.search(r'^[a-zA-Z0-9\-]+$', local_var_params['id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `delete_file`, must conform to the pattern `/^[a-zA-Z0-9\-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.1.406'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/api/files/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def download_file(self, id, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DownloadFile: Download the file from Drive.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_file(id, async_req=True)
        >>> result = thread.get()

        :param id: Identifier of the file to be downloaded. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: file
        """
        kwargs['_return_http_data_only'] = True
        return self.download_file_with_http_info(id, **kwargs)  # noqa: E501

    def download_file_with_http_info(self, id, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DownloadFile: Download the file from Drive.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_file_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Identifier of the file to be downloaded. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (file, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `download_file`")  # noqa: E501

        if self.api_client.client_side_validation and ('id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id']) > 40):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `download_file`, length must be less than or equal to `40`")  # noqa: E501
        if self.api_client.client_side_validation and ('id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id']) < 30):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `download_file`, length must be greater than or equal to `30`")  # noqa: E501
        if self.api_client.client_side_validation and 'id' in local_var_params and not re.search(r'^[a-zA-Z0-9\-]+$', local_var_params['id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `download_file`, must conform to the pattern `/^[a-zA-Z0-9\-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.1.406'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "file",
            410: "LusidValidationProblemDetails",
            423: "LusidValidationProblemDetails",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/files/{id}/contents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_file(self, id, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetFile: Get a file stored in Drive.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file(id, async_req=True)
        >>> result = thread.get()

        :param id: Identifier of the file to be retrieved. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StorageObject
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_with_http_info(id, **kwargs)  # noqa: E501

    def get_file_with_http_info(self, id, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetFile: Get a file stored in Drive.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Identifier of the file to be retrieved. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (StorageObject, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_file`")  # noqa: E501

        if self.api_client.client_side_validation and ('id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id']) > 40):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `get_file`, length must be less than or equal to `40`")  # noqa: E501
        if self.api_client.client_side_validation and ('id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id']) < 30):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `get_file`, length must be greater than or equal to `30`")  # noqa: E501
        if self.api_client.client_side_validation and 'id' in local_var_params and not re.search(r'^[a-zA-Z0-9\-]+$', local_var_params['id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `get_file`, must conform to the pattern `/^[a-zA-Z0-9\-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.1.406'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "StorageObject",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/files/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_file_contents(self, id, content_length, body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpdateFileContents: Updates contents of a file in Drive.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_contents(id, content_length, body, async_req=True)
        >>> result = thread.get()

        :param id: The unique file identifier (required)
        :type id: str
        :param content_length: The size in bytes of the file to be uploaded (required)
        :type content_length: int
        :param body: (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StorageObject
        """
        kwargs['_return_http_data_only'] = True
        return self.update_file_contents_with_http_info(id, content_length, body, **kwargs)  # noqa: E501

    def update_file_contents_with_http_info(self, id, content_length, body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpdateFileContents: Updates contents of a file in Drive.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_contents_with_http_info(id, content_length, body, async_req=True)
        >>> result = thread.get()

        :param id: The unique file identifier (required)
        :type id: str
        :param content_length: The size in bytes of the file to be uploaded (required)
        :type content_length: int
        :param body: (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (StorageObject, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'id',
            'content_length',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file_contents" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_file_contents`")  # noqa: E501
        # verify the required parameter 'content_length' is set
        if self.api_client.client_side_validation and ('content_length' not in local_var_params or  # noqa: E501
                                                        local_var_params['content_length'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `content_length` when calling `update_file_contents`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_file_contents`")  # noqa: E501

        if self.api_client.client_side_validation and ('id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id']) > 40):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `update_file_contents`, length must be less than or equal to `40`")  # noqa: E501
        if self.api_client.client_side_validation and ('id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id']) < 30):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `update_file_contents`, length must be greater than or equal to `30`")  # noqa: E501
        if self.api_client.client_side_validation and 'id' in local_var_params and not re.search(r'^[a-zA-Z0-9\-]+$', local_var_params['id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `update_file_contents`, must conform to the pattern `/^[a-zA-Z0-9\-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_length' in local_var_params:
            header_params['Content-Length'] = local_var_params['content_length']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.1.406'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "StorageObject",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/files/{id}/contents', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_file_metadata(self, id, update_file, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpdateFileMetadata: Updates metadata for a file in Drive.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_metadata(id, update_file, async_req=True)
        >>> result = thread.get()

        :param id: Identifier of the file to be updated (required)
        :type id: str
        :param update_file: Update to be applied to file (required)
        :type update_file: UpdateFile
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StorageObject
        """
        kwargs['_return_http_data_only'] = True
        return self.update_file_metadata_with_http_info(id, update_file, **kwargs)  # noqa: E501

    def update_file_metadata_with_http_info(self, id, update_file, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpdateFileMetadata: Updates metadata for a file in Drive.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_metadata_with_http_info(id, update_file, async_req=True)
        >>> result = thread.get()

        :param id: Identifier of the file to be updated (required)
        :type id: str
        :param update_file: Update to be applied to file (required)
        :type update_file: UpdateFile
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (StorageObject, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'id',
            'update_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_file_metadata`")  # noqa: E501
        # verify the required parameter 'update_file' is set
        if self.api_client.client_side_validation and ('update_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_file` when calling `update_file_metadata`")  # noqa: E501

        if self.api_client.client_side_validation and ('id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id']) > 40):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `update_file_metadata`, length must be less than or equal to `40`")  # noqa: E501
        if self.api_client.client_side_validation and ('id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['id']) < 30):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `update_file_metadata`, length must be greater than or equal to `30`")  # noqa: E501
        if self.api_client.client_side_validation and 'id' in local_var_params and not re.search(r'^[a-zA-Z0-9\-]+$', local_var_params['id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `update_file_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_file' in local_var_params:
            body_params = local_var_params['update_file']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.1.406'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "StorageObject",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/files/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
