"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowsBastion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk_ec2_key_pair_1 = require("cdk-ec2-key-pair");
const security_tag_1 = require("./security-tag");
class WindowsBastion extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const securityTag = props?.securityTag
            ? props.securityTag
            : security_tag_1.DefaultSecurityTag;
        const key = props?.createKeyPair
            ? new cdk_ec2_key_pair_1.KeyPair(this, 'KeyPair', {
                name: `${aws_cdk_lib_1.Stack.of(this).stackName}-${id}-windows-bastion-key`,
                storePublicKey: false,
            })
            : undefined;
        if (key)
            aws_cdk_lib_1.Tags.of(key).add(securityTag.key, securityTag.value);
        this.securityGroup = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'BastionSecurityGroup', {
            vpc: props.vpc,
            allowAllOutbound: true,
        });
        if (props.machineImage &&
            props.machineImage.getImage(this).osType !=
                aws_cdk_lib_1.aws_ec2.OperatingSystemType.WINDOWS)
            throw 'machineImage is not Windows based';
        const machineImage = props.machineImage
            ? props.machineImage
            : aws_cdk_lib_1.aws_ec2.MachineImage.latestWindows(aws_cdk_lib_1.aws_ec2.WindowsVersion.WINDOWS_SERVER_2022_ENGLISH_FULL_BASE);
        const instanceType = props.instanceType
            ? props.instanceType
            : aws_cdk_lib_1.aws_ec2.InstanceType.of(aws_cdk_lib_1.aws_ec2.InstanceClass.T3A, aws_cdk_lib_1.aws_ec2.InstanceSize.LARGE);
        const instanceProps = {
            ...props,
            propagateTagsToVolumeOnCreation: true,
            userDataCausesReplacement: true,
            keyName: key?.keyPairName,
            machineImage,
            instanceType,
        };
        const bastionInstance = new aws_cdk_lib_1.aws_ec2.Instance(this, 'BastionInstance', instanceProps);
        if (props.windowsPackages) {
            const packageUserData = [
                'Write-Output "Waiting before installing packages incase another installer is already running"',
                'Start-Sleep -Seconds 150',
                // Unfortunately Windows Server 2022 doesn't support WinGet yet ...
                // https://github.com/microsoft/winget-cli/issues/1929
                'iwr -UseBasicParsing https://github.com/jedieaston/winget-build/raw/main/Install.ps1 | iex',
                ...props.windowsPackages.map((p) => {
                    return `wingetdev install --silent --accept-source-agreements --accept-package-agreements ${p}`;
                }),
                'wingetdev upgrade --all --silent --accept-source-agreements --accept-package-agreements',
            ].join('\n');
            bastionInstance.addUserData(packageUserData);
        }
        aws_cdk_lib_1.Tags.of(bastionInstance.instance).add(securityTag.key, securityTag.value);
        bastionInstance.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        this.instanceId = bastionInstance.instanceId;
        this.instanceAvailabilityZone = bastionInstance.instanceAvailabilityZone;
        this.instancePrivateDnsName = bastionInstance.instancePrivateDnsName;
        this.instancePrivateIp = bastionInstance.instancePrivateIp;
        this.grantPrincipal = bastionInstance.grantPrincipal;
        this.instancePublicDnsName = bastionInstance.instancePublicDnsName;
        this.instancePublicIp = bastionInstance.instancePublicIp;
        this.connections = bastionInstance.connections;
        this.role = bastionInstance.role;
    }
}
exports.WindowsBastion = WindowsBastion;
_a = JSII_RTTI_SYMBOL_1;
WindowsBastion[_a] = { fqn: "pwed-cdk.bastion.WindowsBastion", version: "0.0.58" };
//# sourceMappingURL=data:application/json;base64,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