"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process = require("child_process");
const crypto = require("crypto");
const fs = require("fs");
const path = require("path");
const process = require("process");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const glob_1 = require("glob");
class StaticSite extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'Bucket', {
            encryption: aws_cdk_lib_1.aws_s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                {
                    transitions: [
                        {
                            storageClass: aws_cdk_lib_1.aws_s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: aws_cdk_lib_1.Duration.days(7),
                        },
                    ],
                },
            ],
        });
        const hostedZone = props.hostedZone
            ? props.hostedZone
            : aws_cdk_lib_1.aws_route53.HostedZone.fromLookup(this, `HostedZone${props.domain}`, {
                domainName: props.domain,
            });
        const alternativeHostedZones = props.alternativeHostedZones
            ? props.alternativeHostedZones
            : props.alternativeDomains
                ? props.alternativeDomains.map((domain) => {
                    return aws_cdk_lib_1.aws_route53.HostedZone.fromLookup(this, `HostedZone${domain}`, {
                        domainName: domain,
                    });
                })
                : undefined;
        let domainValidation = {
            [props.domain]: hostedZone,
        };
        props.alternativeDomains?.map((domain, index) => {
            domainValidation[domain] = alternativeHostedZones[index];
        });
        const certificate = new aws_cdk_lib_1.aws_certificatemanager.Certificate(this, 'Certificate', {
            domainName: props.domain,
            subjectAlternativeNames: props.alternativeDomains,
            validation: aws_cdk_lib_1.aws_certificatemanager.CertificateValidation.fromDnsMultiZone(domainValidation),
        });
        const originAccessIdentity = new aws_cdk_lib_1.aws_cloudfront.OriginAccessIdentity(this, 'OriginAccessIdentity');
        bucket.grantRead(originAccessIdentity);
        this.distribution = new aws_cdk_lib_1.aws_cloudfront.Distribution(this, 'Distribution', {
            defaultBehavior: {
                origin: new aws_cdk_lib_1.aws_cloudfront_origins.S3Origin(bucket, {
                    originAccessIdentity,
                }),
                allowedMethods: aws_cdk_lib_1.aws_cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            },
            domainNames: props.alternativeDomains
                ? [props.domain, ...props.alternativeDomains]
                : [props.domain],
            certificate,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 404,
                    responsePagePath: '/404.html',
                },
            ],
            defaultRootObject: 'index.html',
            httpVersion: aws_cdk_lib_1.aws_cloudfront.HttpVersion.HTTP2_AND_3,
        });
        new aws_cdk_lib_1.aws_route53.ARecord(this, 'AAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
        });
        new aws_cdk_lib_1.aws_route53.AaaaRecord(this, 'AaaaAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
        });
        props.alternativeDomains?.map((domain, index) => {
            new aws_cdk_lib_1.aws_route53.ARecord(this, `AAliasRecord${domain}`, {
                recordName: domain,
                zone: alternativeHostedZones[index],
                target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
            });
            new aws_cdk_lib_1.aws_route53.AaaaRecord(this, `AaaaAliasRecord${domain}`, {
                recordName: domain,
                zone: alternativeHostedZones[index],
                target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
            });
        });
        const hashFile = '/.hashfile';
        let invalidations = [hashFile];
        invalidations.push(...compareRemoteToLocal(props.domain, hashFile, props.path));
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'StaticDeployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(props.path)],
            destinationBucket: bucket,
            distribution: this.distribution,
            distributionPaths: invalidations,
        });
    }
}
exports.StaticSite = StaticSite;
_a = JSII_RTTI_SYMBOL_1;
StaticSite[_a] = { fqn: "pwed-cdk.static_site.StaticSite", version: "0.0.58" };
function getHashes(globPattern, dir) {
    let fh = new Map();
    const gs = glob_1.sync(globPattern, { cwd: dir, nodir: true });
    const pwd = process.cwd();
    process.chdir(dir);
    gs.forEach(function (file) {
        const fileBuffer = fs.readFileSync(file, {});
        const hashSum = crypto.createHash('sha256');
        hashSum.update(fileBuffer);
        const hex = hashSum.digest('hex');
        fh.set(file, hex);
    });
    process.chdir(pwd);
    return fh;
}
function getInvalidations(oldHashes, newHashes) {
    let invalidations = [];
    oldHashes.forEach(function (v, k) {
        if (newHashes.get(k) !== v) {
            invalidations.push(`/${k}`);
        }
    });
    return invalidations;
}
function compareRemoteToLocal(domain, hashFile, localFolder) {
    let oldHashesJSON;
    const newHashes = getHashes('**', localFolder);
    fs.writeFileSync(path.join(localFolder, hashFile), JSON.stringify(Object.fromEntries(newHashes)));
    try {
        oldHashesJSON = child_process
            .execSync(`curl -s https://${domain}/${hashFile}`)
            .toString();
    }
    catch {
        return ['/*'];
    }
    let oldHashes;
    try {
        oldHashes = new Map(Object.entries(JSON.parse(oldHashesJSON)));
    }
    catch (e) {
        return ['/*'];
    }
    return getInvalidations(oldHashes, newHashes);
}
//# sourceMappingURL=data:application/json;base64,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