import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
 *
 * @experimental
 */
export declare class Comprehendmedical extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to describe the properties of a medical entity detection job that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribeEntitiesDetectionV2Job.html
     *
     * @experimental
     */
    toDescribeEntitiesDetectionV2Job(): this;
    /**
     * (experimental) Grants permission to describe the properties of an ICD-10-CM linking job that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribeICD10CMInferenceJob.html
     *
     * @experimental
     */
    toDescribeICD10CMInferenceJob(): this;
    /**
     * (experimental) Grants permission to describe the properties of a PHI entity detection job that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribePHIDetectionJob.html
     *
     * @experimental
     */
    toDescribePHIDetectionJob(): this;
    /**
     * (experimental) Grants permission to describe the properties of an RxNorm linking job that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribeRxNormInferenceJob.html
     *
     * @experimental
     */
    toDescribeRxNormInferenceJob(): this;
    /**
     * (experimental) Grants permission to detect the named medical entities, and their relationships and traits within the given text document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DetectEntitiesV2.html
     *
     * @experimental
     */
    toDetectEntitiesV2(): this;
    /**
     * (experimental) Grants permission to detect the protected health information (PHI) entities within the given text document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DetectPHI.html
     *
     * @experimental
     */
    toDetectPHI(): this;
    /**
     * (experimental) Grants permission to detect the medical condition entities within the given text document and link them to ICD-10-CM codes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_InferICD10CM.html
     *
     * @experimental
     */
    toInferICD10CM(): this;
    /**
     * (experimental) Grants permission to detect the medication entities within the given text document and link them to RxCUI concept identifiers from the National Library of Medicine RxNorm database.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_InferRxNorm.html
     *
     * @experimental
     */
    toInferRxNorm(): this;
    /**
     * (experimental) Grants permission to list the medical entity detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListEntitiesDetectionV2Jobs.html
     *
     * @experimental
     */
    toListEntitiesDetectionV2Jobs(): this;
    /**
     * (experimental) Grants permission to list the ICD-10-CM linking jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListICD10CMInferenceJobs.html
     *
     * @experimental
     */
    toListICD10CMInferenceJobs(): this;
    /**
     * (experimental) Grants permission to list the PHI entity detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListPHIDetectionJobs.html
     *
     * @experimental
     */
    toListPHIDetectionJobs(): this;
    /**
     * (experimental) Grants permission to list the RxNorm linking jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListRxNormInferenceJobs.html
     *
     * @experimental
     */
    toListRxNormInferenceJobs(): this;
    /**
     * (experimental) Grants permission to start an asynchronous medical entity detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartEntitiesDetectionV2Job.html
     *
     * @experimental
     */
    toStartEntitiesDetectionV2Job(): this;
    /**
     * (experimental) Grants permission to start an asynchronous ICD-10-CM linking job for a collection of documents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartICD10CMInferenceJob.html
     *
     * @experimental
     */
    toStartICD10CMInferenceJob(): this;
    /**
     * (experimental) Grants permission to start an asynchronous PHI entity detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartPHIDetectionJob.html
     *
     * @experimental
     */
    toStartPHIDetectionJob(): this;
    /**
     * (experimental) Grants permission to start an asynchronous RxNorm linking job for a collection of documents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartRxNormInferenceJob.html
     *
     * @experimental
     */
    toStartRxNormInferenceJob(): this;
    /**
     * (experimental) Grants permission to stop a medical entity detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopEntitiesDetectionV2Job.html
     *
     * @experimental
     */
    toStopEntitiesDetectionV2Job(): this;
    /**
     * (experimental) Grants permission to stop an ICD-10-CM linking job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopICD10CMInferenceJob.html
     *
     * @experimental
     */
    toStopICD10CMInferenceJob(): this;
    /**
     * (experimental) Grants permission to stop a PHI entity detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopPHIDetectionJob.html
     *
     * @experimental
     */
    toStopPHIDetectionJob(): this;
    /**
     * (experimental) Grants permission to stop an RxNorm linking job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopRxNormInferenceJob.html
     *
     * @experimental
     */
    toStopRxNormInferenceJob(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
