import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [grafana](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedgrafana.html).
 *
 * @experimental
 */
export declare class Grafana extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to upgrade a workspace with a license.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - aws-marketplace:ViewSubscriptions
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toAssociateLicense(): this;
    /**
     * (experimental) Grants permission to create a workspace.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     * - sso:CreateManagedApplicationInstance
     * - sso:DescribeRegisteredRegions
     * - sso:GetSharedSsoConfiguration
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toCreateWorkspace(): this;
    /**
     * (experimental) Grants permission to delete a workspace.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:DeleteManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toDeleteWorkspace(): this;
    /**
     * (experimental) Grants permission to describe a workspace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toDescribeWorkspace(): this;
    /**
     * (experimental) Grants permission to describe authetication providers on a workspace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toDescribeWorkspaceAuthentication(): this;
    /**
     * (experimental) Grants permission to remove a license from a workspace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toDisassociateLicense(): this;
    /**
     * (experimental) Grants permission to list the permissions on a wokspace.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toListPermissions(): this;
    /**
     * (experimental) Grants permission to list workspaces.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toListWorkspaces(): this;
    /**
     * (experimental) Grants permission to modify the permissions on a workspace.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toUpdatePermissions(): this;
    /**
     * (experimental) Grants permission to modify a workspace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toUpdateWorkspace(): this;
    /**
     * (experimental) Grants permission to modify authetication providers on a workspace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     *
     * @experimental
     */
    toUpdateWorkspaceAuthentication(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type workspace to the statement.
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/security-iam.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onWorkspace(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [grafana](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedgrafana.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
