import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [aps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedserviceforprometheus.html).
 *
 * @experimental
 */
export declare class Aps extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to create alerts.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateAlertManagerAlerts
     *
     * @experimental
     */
    toCreateAlertManagerAlerts(): this;
    /**
     * (experimental) Grants permission to create an alert manager definition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateAlertManagerDefinition
     *
     * @experimental
     */
    toCreateAlertManagerDefinition(): this;
    /**
     * (experimental) Grants permission to create a rule groups namespace.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateRuleGroupsNamespace
     *
     * @experimental
     */
    toCreateRuleGroupsNamespace(): this;
    /**
     * (experimental) Grants permission to create a workspace.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateWorkspace
     *
     * @experimental
     */
    toCreateWorkspace(): this;
    /**
     * (experimental) Grants permission to delete an alert manager definition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteAlertManagerDefinition
     *
     * @experimental
     */
    toDeleteAlertManagerDefinition(): this;
    /**
     * (experimental) Grants permission to delete a silence.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteAlertManagerSilence
     *
     * @experimental
     */
    toDeleteAlertManagerSilence(): this;
    /**
     * (experimental) Grants permission to delete a rule groups namespace.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteRuleGroupsNamespace
     *
     * @experimental
     */
    toDeleteRuleGroupsNamespace(): this;
    /**
     * (experimental) Grants permission to delete a workspace.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteWorkspace
     *
     * @experimental
     */
    toDeleteWorkspace(): this;
    /**
     * (experimental) Grants permission to describe an alert manager definition.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DescribeAlertManagerDefinition
     *
     * @experimental
     */
    toDescribeAlertManagerDefinition(): this;
    /**
     * (experimental) Grants permission to describe a rule groups namespace.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DescribeRuleGroupsNamespace
     *
     * @experimental
     */
    toDescribeRuleGroupsNamespace(): this;
    /**
     * (experimental) Grants permission to describe a workspace.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DescribeWorkspace
     *
     * @experimental
     */
    toDescribeWorkspace(): this;
    /**
     * (experimental) Grants permission to get a silence.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetAlertManagerSilence
     *
     * @experimental
     */
    toGetAlertManagerSilence(): this;
    /**
     * (experimental) Grants permission to get current status of an alertmanager.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetAlertManagerStatus
     *
     * @experimental
     */
    toGetAlertManagerStatus(): this;
    /**
     * (experimental) Grants permission to retrieve AMP workspace labels.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetLabels
     *
     * @experimental
     */
    toGetLabels(): this;
    /**
     * (experimental) Grants permission to retrieve the metadata for AMP workspace metrics.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetMetricMetadata
     *
     * @experimental
     */
    toGetMetricMetadata(): this;
    /**
     * (experimental) Grants permission to retrieve AMP workspace time series data.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetSeries
     *
     * @experimental
     */
    toGetSeries(): this;
    /**
     * (experimental) Grants permission to list groups.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerAlertGroups
     *
     * @experimental
     */
    toListAlertManagerAlertGroups(): this;
    /**
     * (experimental) Grants permission to list alerts.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerAlerts
     *
     * @experimental
     */
    toListAlertManagerAlerts(): this;
    /**
     * (experimental) Grants permission to list receivers.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerReceivers
     *
     * @experimental
     */
    toListAlertManagerReceivers(): this;
    /**
     * (experimental) Grants permission to list silences.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerSilences
     *
     * @experimental
     */
    toListAlertManagerSilences(): this;
    /**
     * (experimental) Grants permission to list active alerts.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlerts
     *
     * @experimental
     */
    toListAlerts(): this;
    /**
     * (experimental) Grants permission to list rule groups namespaces.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListRuleGroupsNamespaces
     *
     * @experimental
     */
    toListRuleGroupsNamespaces(): this;
    /**
     * (experimental) Grants permission to list alerting and recording rules.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListRules
     *
     * @experimental
     */
    toListRules(): this;
    /**
     * (experimental) Grants permission to list tags on an AMP resource.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListTagsForResource
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list workspaces.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListWorkspaces
     *
     * @experimental
     */
    toListWorkspaces(): this;
    /**
     * (experimental) Grants permission to update an alert manager definition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-PutAlertManagerDefinition
     *
     * @experimental
     */
    toPutAlertManagerDefinition(): this;
    /**
     * (experimental) Grants permission to create or update a silence.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-PutAlertManagerSilences
     *
     * @experimental
     */
    toPutAlertManagerSilences(): this;
    /**
     * (experimental) Grants permission to update a rule groups namespace.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-PutRuleGroupsNamespace
     *
     * @experimental
     */
    toPutRuleGroupsNamespace(): this;
    /**
     * (experimental) Grants permission to run a query on AMP workspace metrics.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-QueryMetrics
     *
     * @experimental
     */
    toQueryMetrics(): this;
    /**
     * (experimental) Grants permission to perform a remote write operation to initiate the streaming of metrics to AMP workspace.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-RemoteWrite
     *
     * @experimental
     */
    toRemoteWrite(): this;
    /**
     * (experimental) Grants permission to tag an AMP resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-TagResource
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag an AMP resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-UntagResource
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to modify the alias of existing AMP workspace.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-UpdateWorkspaceAlias
     *
     * @experimental
     */
    toUpdateWorkspaceAlias(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type workspace to the statement.
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/security-iam.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkspace(workspaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type rulegroupsnamespace to the statement.
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/security-iam.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param namespace - Identifier for the namespace.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRulegroupsnamespace(workspaceId: string, namespace: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [aps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedserviceforprometheus.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
