import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
 *
 * @experimental
 */
export declare class Mechanicalturk extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) The AcceptQualificationRequest operation grants a Worker's request for a Qualification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html
     *
     * @experimental
     */
    toAcceptQualificationRequest(): this;
    /**
     * (experimental) The ApproveAssignment operation approves the results of a completed assignment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html
     *
     * @experimental
     */
    toApproveAssignment(): this;
    /**
     * (experimental) The AssociateQualificationWithWorker operation gives a Worker a Qualification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html
     *
     * @experimental
     */
    toAssociateQualificationWithWorker(): this;
    /**
     * (experimental) The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html
     *
     * @experimental
     */
    toCreateAdditionalAssignmentsForHIT(): this;
    /**
     * (experimental) The CreateHIT operation creates a new HIT (Human Intelligence Task).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html
     *
     * @experimental
     */
    toCreateHIT(): this;
    /**
     * (experimental) The CreateHITType operation creates a new HIT type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html
     *
     * @experimental
     */
    toCreateHITType(): this;
    /**
     * (experimental) The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html
     *
     * @experimental
     */
    toCreateHITWithHITType(): this;
    /**
     * (experimental) The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html
     *
     * @experimental
     */
    toCreateQualificationType(): this;
    /**
     * (experimental) The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html
     *
     * @experimental
     */
    toCreateWorkerBlock(): this;
    /**
     * (experimental) The DeleteHIT operation disposes of a HIT that is no longer needed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html
     *
     * @experimental
     */
    toDeleteHIT(): this;
    /**
     * (experimental) The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html
     *
     * @experimental
     */
    toDeleteQualificationType(): this;
    /**
     * (experimental) The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html
     *
     * @experimental
     */
    toDeleteWorkerBlock(): this;
    /**
     * (experimental) The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html
     *
     * @experimental
     */
    toDisassociateQualificationFromWorker(): this;
    /**
     * (experimental) The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html
     *
     * @experimental
     */
    toGetAccountBalance(): this;
    /**
     * (experimental) The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html
     *
     * @experimental
     */
    toGetAssignment(): this;
    /**
     * (experimental) The GetFileUploadURL operation generates and returns a temporary URL.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html
     *
     * @experimental
     */
    toGetFileUploadURL(): this;
    /**
     * (experimental) The GetHIT operation retrieves the details of the specified HIT.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html
     *
     * @experimental
     */
    toGetHIT(): this;
    /**
     * (experimental) The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html
     *
     * @experimental
     */
    toGetQualificationScore(): this;
    /**
     * (experimental) The GetQualificationType operation retrieves information about a Qualification type using its ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html
     *
     * @experimental
     */
    toGetQualificationType(): this;
    /**
     * (experimental) The ListAssignmentsForHIT operation retrieves completed assignments for a HIT.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html
     *
     * @experimental
     */
    toListAssignmentsForHIT(): this;
    /**
     * (experimental) The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html
     *
     * @experimental
     */
    toListBonusPayments(): this;
    /**
     * (experimental) The ListHITs operation returns all of a Requester's HITs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html
     *
     * @experimental
     */
    toListHITs(): this;
    /**
     * (experimental) The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html
     *
     * @experimental
     */
    toListHITsForQualificationType(): this;
    /**
     * (experimental) The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html
     *
     * @experimental
     */
    toListQualificationRequests(): this;
    /**
     * (experimental) The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html
     *
     * @experimental
     */
    toListQualificationTypes(): this;
    /**
     * (experimental) The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html
     *
     * @experimental
     */
    toListReviewPolicyResultsForHIT(): this;
    /**
     * (experimental) The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html
     *
     * @experimental
     */
    toListReviewableHITs(): this;
    /**
     * (experimental) The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html
     *
     * @experimental
     */
    toListWorkerBlocks(): this;
    /**
     * (experimental) The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html
     *
     * @experimental
     */
    toListWorkersWithQualificationType(): this;
    /**
     * (experimental) The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html
     *
     * @experimental
     */
    toNotifyWorkers(): this;
    /**
     * (experimental) The RejectAssignment operation rejects the results of a completed assignment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html
     *
     * @experimental
     */
    toRejectAssignment(): this;
    /**
     * (experimental) The RejectQualificationRequest operation rejects a user's request for a Qualification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html
     *
     * @experimental
     */
    toRejectQualificationRequest(): this;
    /**
     * (experimental) The SendBonus operation issues a payment of money from your account to a Worker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html
     *
     * @experimental
     */
    toSendBonus(): this;
    /**
     * (experimental) The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html
     *
     * @experimental
     */
    toSendTestEventNotification(): this;
    /**
     * (experimental) The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html
     *
     * @experimental
     */
    toUpdateExpirationForHIT(): this;
    /**
     * (experimental) The UpdateHITReviewStatus operation toggles the status of a HIT.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html
     *
     * @experimental
     */
    toUpdateHITReviewStatus(): this;
    /**
     * (experimental) The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html
     *
     * @experimental
     */
    toUpdateHITTypeOfHIT(): this;
    /**
     * (experimental) The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html
     *
     * @experimental
     */
    toUpdateNotificationSettings(): this;
    /**
     * (experimental) The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html
     *
     * @experimental
     */
    toUpdateQualificationType(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
