# Contributing

Thank you! :tada:

Thank you for your interest in [`mljar-supervised`](https://github.com/mljar/mljar-supervised) and for willing to contribute! :+1: :smiley:

## How can I contribute? :muscle:

### Reporting Bugs

When creating a new bug report, please make sure to:

- search for existing issues first. If you find a previous report of your issue, please update the existing issue with additional information instead of creating a new one.

- please review the template and guidelines and include as many details as possible.

### Suggest Enhancements

Please try first to see if an issue exists which describes your enhancement. If there is none, please create the new one with a detailed description. Thank you!

### Pull Requests

- Before any contribution, please reach out and discuss what do you want to implement and how (ideally in the created issue).
- For code formatting we use [Black](https://github.com/psf/black).

To run all tests locally:

```
pytest tests
```

To run only tests for the selected file (for example, NN algorithm):
```
pytest tests/tests_algorithms/test_nn.py -vsx
```

I add `vsx` flags to see what's going on.

## Documentation :scroll:

The project documentation is on GitHub at [mljar/docs](https://github.com/mljar/docs) repository. Deployed docs are available at [https://supervised.mljar.com](https://supervised.mljar.com).

## Contributor License Agreement :necktie:

Before merging any pull request with code updates, we'll need each person contributing to the code base to sign a Contributor License Agreement [here](https://forms.gle/au2qhFWjuuvEmKfM8).
