# Generated by Django 3.2.6 on 2021-09-02 22:53

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0075_rbaccontentguard'),
    ]

    operations = [
        migrations.CreateModel(
            name='OstreeCommit',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='ostree_ostreecommit', serialize=False, to='core.content')),
                ('checksum', models.CharField(db_index=True, max_length=64)),
                ('parent_commit', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='ostree_ostreecommit', to='ostree.ostreecommit')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('checksum',)},
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='OstreeDistribution',
            fields=[
                ('distribution_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='ostree_ostreedistribution', serialize=False, to='core.distribution')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.distribution',),
        ),
        migrations.CreateModel(
            name='OstreeRemote',
            fields=[
                ('remote_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='ostree_ostreeremote', serialize=False, to='core.remote')),
                ('depth', models.IntegerField(default=0)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.remote',),
        ),
        migrations.CreateModel(
            name='OstreeRepository',
            fields=[
                ('repository_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='ostree_ostreerepository', serialize=False, to='core.repository')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.repository',),
        ),
        migrations.CreateModel(
            name='OstreeSummary',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='ostree_ostreesummary', serialize=False, to='core.content')),
                ('sha256', models.CharField(db_index=True, max_length=64)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('sha256',)},
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='OstreeConfig',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='ostree_ostreeconfig', serialize=False, to='core.content')),
                ('sha256', models.CharField(db_index=True, max_length=64)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('sha256',)},
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='OstreeRef',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='ostree_ostreeref', serialize=False, to='core.content')),
                ('name', models.CharField(db_index=True, max_length=255)),
                ('commit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='refs_commit', to='ostree.ostreecommit')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('name', 'commit')},
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='OstreeObject',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='ostree_ostreeobject', serialize=False, to='core.content')),
                ('typ', models.IntegerField(choices=[(1, 'Ostree Object Type File'), (2, 'Ostree Object Type Dir Tree'), (3, 'Ostree Object Type Dir Meta'), (4, 'Ostree Object Type Commit'), (5, 'Ostree Object Type Tombstone Commit'), (6, 'Ostree Object Type Commit Meta'), (7, 'Ostree Object Type Payload Link')])),
                ('checksum', models.CharField(db_index=True, max_length=64)),
                ('commit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='object_commit', to='ostree.ostreecommit')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('checksum',)},
            },
            bases=('core.content',),
        ),
    ]
