#DE-VS
Taxonomy for the handling of protectively marked information in MISP with German (DE) Government classification markings (VS).

## Ábout
The classification markings are based on the German "General Administrative Regulation for the physical and organizational protection of classified information (Allgemeine Verwaltungsvorschrift zum materiellen und organisatorischen Schutz von Verschlusssachen (VS-Anweisung - VSA))" of the German Federal Ministry of the Interior. Official handling caveats apply. For this reason all expressions in this taxonomy are in German language.

## Structure
The DE-VS Taxonomy has two predicates:
<dl>
<dt>"Einstufung"</dt>
<dd>This is the official classification marking. Each marking is a single value of this predicate.<dd>

<dt>"Schutzwort"</dt>
<dd>This is the additional code word that can be added to a classification marking. The code words are values of the predicate. 
<dd>As code words can be classified information themselves, there are no code words included in this taxonomy.<dd>
</dl>

##More information
<dl>
<dt>General Administrative Regulation for the physical and organizational protection of classified information (VSA)</dt>
<dd>DE:</dd>
<dd>https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Sicherheitsberatung/VSA_pdf.html</dd>

<dt>VS - Regulations in DE</dt>
<dd>DE:</dd>
<dd>https://www.bsi.bund.de/DE/Themen/Sicherheitsberatung/Geheimschutzberatung/VorschriftenStandards/vorschriften.html</dd>

<dt>Instruction sheet on the Handling of Protectively Marked Information Classified 'VS-NUR FÜR DEN DIENSTGEBRAUCH (RESTRICTED)':</dt>
<dd>EN:</dd>
<dd>https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Sicherheitsberatung/VS-MerkblattEnglisch_pdf.html</dd>
<dd>FR:</dd>
<dd>https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Sicherheitsberatung/VS-MerkblattFranzoesich_pdf.html</dd>
<dd>ES:</dd>
<dd>https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Sicherheitsberatung/VS-MerkblattSpanisch_pdf.html</dd>
<dd>CN:</dd>
<dd>https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Sicherheitsberatung/VS-MerkblattChinesisch_pdf.html</dd>
<dd>PL:</dd>
<dd>https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Sicherheitsberatung/VS-MerkblattPolnisch_pdf.html</dd>
<dd>RU:</dd>
<dd>https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Sicherheitsberatung/VS-MerkblattRussisch_pdf.html</dd>
<dd>IT:</dd>
<dd>https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Sicherheitsberatung/VS-MerkblattItalienisch_pdf.html</dd>
</dl>

##Contact: 
Federal Office for Information Security (BSI)
CERT-Bund
E-Mail: certbund@bsi.bund.de
