# Stealth Malware Taxonomy

## Malware Types

All malware samples should be classified into one of the categories listed in the table below.

<dl>
<dt>Type 0</dt>
<dd>No OS or system compromise. The malware runs as a normal user process using only official API calls.<dd>

<dt>Type I</dt>
<dd>The malware modifies constant sections of the kernel and/or processes such as code sections.<dd>

<dt>Type II</dt>
<dd>The malware does not modify constant sections but only the dynamic sections of the kernel and/or processes such as data sections.<dd>

<dt>Type III</dt>
<dd>The malware does not modify any sections of the kernel and/or processes but influences the system without modifying the OS. For example using hardware virtualization techniques.<dd>
</dl>

# Machine-parsable Stealth Malware Taxonomy

The repository contains a [JSON file including the machine-parsable tags](machinetag.json)
along with their human-readable description. The software can use both
representation on the user-interface and store the tag as machine-parsable.

~~~~
stealth_malware:type="II"
~~~~

Based on:

https://vxheaven.org/lib/pdf/Introducing%20Stealth%20Malware%20Taxonomy.pdf


