"""
torecsys.layers.ctr is a sub model of implementation of layers in click through rate prediction.
"""

from torecsys.layers.ctr.attentional_factorization_machine import AttentionalFactorizationMachineLayer
from torecsys.layers.ctr.bias_encoding import BiasEncodingLayer
from torecsys.layers.ctr.bilinear import BilinearNetworkLayer
from torecsys.layers.ctr.bilinear_interaction import BilinearInteractionLayer
from torecsys.layers.ctr.compose_excitation_network import ComposeExcitationNetworkLayer
from torecsys.layers.ctr.compress_interaction_network import CompressInteractionNetworkLayer
from torecsys.layers.ctr.cross_network import CrossNetworkLayer
from torecsys.layers.ctr.dynamic_routing import DynamicRoutingLayer
from torecsys.layers.ctr.factorization_machine import FactorizationMachineLayer
from torecsys.layers.ctr.field_aware_factorization_machine import FieldAwareFactorizationMachineLayer
from torecsys.layers.ctr.inner_product_network import InnerProductNetworkLayer
from torecsys.layers.ctr.mixture_of_experts import MixtureOfExpertsLayer
from torecsys.layers.ctr.multilayer_perceptron import MultilayerPerceptionLayer
from torecsys.layers.ctr.outer_product_network import OuterProductNetworkLayer
from torecsys.layers.ctr.position_embedding import PositionEmbeddingLayer
from torecsys.layers.ctr.positon_bias_aware_learning_framework import PositionBiasAwareLearningFrameworkLayer
from torecsys.layers.ctr.wide import WideLayer

AFMLayer = AttentionalFactorizationMachineLayer
CENLayer = ComposeExcitationNetworkLayer
CINLayer = CompressInteractionNetworkLayer
DenseLayer = MultilayerPerceptionLayer
DNNLayer = MultilayerPerceptionLayer
FFMLayer = FieldAwareFactorizationMachineLayer
FMLayer = FactorizationMachineLayer
FullyConnectLayer = MultilayerPerceptionLayer
FeedForwardLayer = MultilayerPerceptionLayer
MOELayer = MixtureOfExpertsLayer
PALLayer = PositionBiasAwareLearningFrameworkLayer
SqueezeAndExcitationNetworkLayer = ComposeExcitationNetworkLayer
SENETLayer = SqueezeAndExcitationNetworkLayer
