# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tests', 'unifi_protect_backup']

package_data = \
{'': ['*']}

install_requires = \
['aiorun>=2022.11.1,<2023.0.0',
 'aiosqlite>=0.17.0,<0.18.0',
 'click==8.0.1',
 'pylint[dev]>=2.15.6,<3.0.0',
 'python-dateutil>=2.8.2,<3.0.0',
 'pyunifiprotect>=4.0.11,<5.0.0']

extras_require = \
{'dev': ['tox>=3.20.1,<4.0.0',
         'virtualenv>=20.2.2,<21.0.0',
         'pip>=20.3.1,<21.0.0',
         'twine>=3.3.0,<4.0.0',
         'pre-commit>=2.12.0,<3.0.0',
         'toml>=0.10.2,<0.11.0',
         'bump2version>=1.0.1,<2.0.0',
         'tox-asdf>=0.1.0,<0.2.0',
         'ipdb>=0.13.9,<0.14.0'],
 'test': ['black>=22.10.0,<23.0.0',
          'isort>=5.8.0,<6.0.0',
          'flake8>=3.9.2,<4.0.0',
          'flake8-docstrings>=1.6.0,<2.0.0',
          'mypy>=0.900,<0.901',
          'pytest>=6.2.4,<7.0.0',
          'pytest-cov>=2.12.0,<3.0.0',
          'types-pytz>=2021.3.5,<2022.0.0',
          'types-cryptography>=3.3.18,<4.0.0']}

entry_points = \
{'console_scripts': ['unifi-protect-backup = unifi_protect_backup.cli:main']}

setup_kwargs = {
    'name': 'unifi-protect-backup',
    'version': '0.8.2',
    'description': 'Python tool to backup unifi event clips in realtime.',
    'long_description': "# Unifi Protect Backup\n\n\n[![pypi](https://img.shields.io/pypi/v/unifi-protect-backup.svg)](https://pypi.org/project/unifi-protect-backup/)\n[![python](https://img.shields.io/pypi/pyversions/unifi-protect-backup.svg)](https://pypi.org/project/unifi-protect-backup/)\n[![Build Status](https://github.com/ep1cman/unifi-protect-backup/actions/workflows/dev.yml/badge.svg)](https://github.com/ep1cman/unifi-protect-backup/actions/workflows/dev.yml)\n[![codecov](https://codecov.io/gh/ep1cman/unifi-protect-backup/branch/main/graphs/badge.svg)](https://codecov.io/github/ep1cman/unifi-protect-backup)\n\nA Python based tool for backing up UniFi Protect event clips as they occur.\n\nThe idea for this project came after realising that if something were to happen, e.g. a fire, or a burglary\nthat meant I could no longer access my UDM, all the footage recorded by all my nice expensive UniFi cameras\nwould have been rather pointless. With this tool, all motion and smart detection clips are immediately\nbacked up to off-site storage thanks to [`rclone`](https://rclone.org/), and kept for the configured\nretention period.\n\n* GitHub: <https://github.com/ep1cman/unifi-protect-backup>\n* PyPI: <https://pypi.org/project/unifi-protect-backup/>\n* Free software: MIT\n\n[![Buy me a coffee](https://www.buymeacoffee.com/assets/img/custom_images/black_img.png)](https://www.buymeacoffee.com/ep1cman)\n\n## Features\n\n- Listens to events in real-time via the Unifi Protect websocket API\n- Ensures any previous and/or missed events within the retention period are also backed up\n- Supports uploading to a [wide range of storage systems using `rclone`](https://rclone.org/overview/)\n- Automatic pruning of old clips\n\n## Requirements\n- Python 3.9+\n- Unifi Protect version 1.20 or higher (as per [`pyunifiprotect`](https://github.com/briis/pyunifiprotect))\n- `rclone` installed with at least one remote configured.\n\n## Installation\n\n1. Install `rclone`. Instructions for your platform can be found here: https://rclone.org/install/#quickstart\n2. Configure the `rclone` remote you want to backup to. Instructions can be found here: https://rclone.org/docs/#configure\n3. `pip install unifi-protect-backup`\n4. Optional: Install `ffprobe` so that `unifi-protect-backup` can check the length of the clips it downloads\n\n\n### Account Setup\nIn order to connect to your unifi protect instance, you will first need to setup a local admin account:\n\n* Login to your *Local Portal* on your UniFiOS device, and click on *Users*\n* Open the `Roles` tab and click `Add Role` in the top right.\n* Give the role a name like `unifi protect backup` and give it `Full Management` permissions for the unifi protect app.\n* Now switch to the `User` tab and click `Add User` in the top right, and fill out the form. Specific Fields to pay attention to:\n  * Role: Must be the role created in the last step\n  * Account Type: *Local Access Only*\n* Click *Add* in at the bottom Right.\n* Select the newly created user in the list, and navigate to the `Assignments` tab in the left-hand pane, and ensure all cameras are ticked.\n\n\n## Usage\n\n```\nUsage: unifi-protect-backup [OPTIONS]\n\n  A Python based tool for backing up Unifi Protect event clips as they occur.\n\nOptions:\n  --version                       Show the version and exit.\n  --address TEXT                  Address of Unifi Protect instance\n                                  [required]\n  --port INTEGER                  Port of Unifi Protect instance  [default:\n                                  443]\n  --username TEXT                 Username to login to Unifi Protect instance\n                                  [required]\n  --password TEXT                 Password for Unifi Protect user  [required]\n  --verify-ssl / --no-verify-ssl  Set if you do not have a valid HTTPS\n                                  Certificate for your instance  [default:\n                                  verify-ssl]\n  --rclone-destination TEXT       `rclone` destination path in the format\n                                  {rclone remote}:{path on remote}. E.g.\n                                  `gdrive:/backups/unifi_protect`  [required]\n  --retention TEXT                How long should event clips be backed up\n                                  for. Format as per the `--max-age` argument\n                                  of `rclone`\n                                  (https://rclone.org/filtering/#max-age-don-\n                                  t-transfer-any-file-older-than-this)\n                                  [default: 7d]\n  --rclone-args TEXT              Optional extra arguments to pass to `rclone\n                                  rcat` directly. Common usage for this would\n                                  be to set a bandwidth limit, for example.\n  --detection-types TEXT          A comma separated list of which types of\n                                  detections to backup. Valid options are:\n                                  `motion`, `person`, `vehicle`, `ring`\n                                  [default: motion,person,vehicle,ring]\n  --ignore-camera TEXT            IDs of cameras for which events should not\n                                  be backed up. Use multiple times to ignore\n                                  multiple IDs. If being set as an environment\n                                  variable the IDs should be separated by\n                                  whitespace.\n  --file-structure-format TEXT    A Python format string used to generate the\n                                  file structure/name on the rclone remote.For\n                                  details of the fields available, see the\n                                  projects `README.md` file.  [default: {camer\n                                  a_name}/{event.start:%Y-%m-%d}/{event.end:%Y\n                                  -%m-%dT%H-%M-%S} {detection_type}.mp4]\n  -v, --verbose                   How verbose the logging output should be.\n                                  \n                                      None: Only log info messages created by\n                                      `unifi-protect-backup`, and all warnings\n                                  \n                                      -v: Only log info & debug messages\n                                      created by `unifi-protect-backup`, and\n                                      all warnings\n                                  \n                                      -vv: Log info & debug messages created\n                                      by `unifi-protect-backup`, command\n                                      output, and all warnings\n                                  \n                                      -vvv Log debug messages created by\n                                      `unifi-protect-backup`, command output,\n                                      all info messages, and all warnings\n                                  \n                                      -vvvv: Log debug messages created by\n                                      `unifi-protect-backup` command output,\n                                      all info messages, all warnings, and\n                                      websocket data\n                                  \n                                      -vvvvv: Log websocket data, command\n                                      output, all debug messages, all info\n                                      messages and all warnings  [x>=0]\n  --sqlite_path TEXT              Path to the SQLite database to use/create\n  --help                          Show this message and exit.\n```\n\nThe following environment variables can also be used instead of command line arguments (note, CLI arguments\nalways take priority over environment variables):\n- `UFP_USERNAME`\n- `UFP_PASSWORD`\n- `UFP_ADDRESS`\n- `UFP_PORT`\n- `UFP_SSL_VERIFY`\n- `RCLONE_RETENTION`\n- `RCLONE_DESTINATION`\n- `RCLONE_ARGS`\n- `IGNORE_CAMERAS`\n- `DETECTION_TYPES`\n- `FILE_STRUCTURE_FORMAT`\n- `SQLITE_PATH`\n\n## File path formatting\n\nBy default, the application will save clips in the following structure on the provided rclone remote:\n```\n{camera_name}/{event.start:%Y-%m-%d}/{event.end:%Y-%m-%dT%H-%M-%S} {detection_type}.mp4\n```\nIf you wish for the clips to be structured differently you can do this using the `--file-structure-format`\noption. It uses standard [python format string syntax](https://docs.python.org/3/library/string.html#formatstrings).\n\nThe following fields are provided to the format string:\n  - *event:* The `Event` object as per https://github.com/briis/pyunifiprotect/blob/master/pyunifiprotect/data/nvr.py\n  - *duration_seconds:* The duration of the event in seconds\n  - *detection_type:* A nicely formatted list of the event detection type and the smart detection types (if any)\n  - *camera_name:* The name of the camera that generated this event\n\nYou can optionally format the `event.start`/`event.end` timestamps as per the [`strftime` format](https://docs.python.org/3/library/datetime.html#strftime-strptime-behavior) by appending it after a `:` e.g to get just the date without the time: `{event.start:%Y-%m-%d}`\n\n\n## Docker Container\nYou can run this tool as a container if you prefer with the following command.\nRemember to change the variable to make your setup.\n\n> **Note**\n> As of version 0.8.0, the event database needs to be persisted for the tool to function properly\n> please see the updated commands below\n\n### Backing up locally\nBy default, if no rclone config is provided clips will be backed up to `/data`.\n\n```\ndocker run \\\n  -e UFP_USERNAME='USERNAME' \\\n  -e UFP_PASSWORD='PASSWORD' \\\n  -e UFP_ADDRESS='UNIFI_PROTECT_IP' \\\n  -e UFP_SSL_VERIFY='false' \\\n  -v '/path/to/save/clips':'/data' \\\n  -v '/path/to/save/database':/config/database/ \\\n  ghcr.io/ep1cman/unifi-protect-backup\n```\n\n### Backing up to cloud storage\nIn order to backup to cloud storage you need to provide a `rclone.conf` file.\n\nIf you do not already have a `rclone.conf` file you can create one as follows:\n```\n$ docker run -it --rm -v $PWD:/root/.config/rclone --entrypoint rclone ghcr.io/ep1cman/unifi-protect-backup config\n```\nFollow the interactive configuration proceed, this will create a `rclone.conf`\nfile in your current directory.\n\nFinally, start the container:\n```\ndocker run \\\n  -e UFP_USERNAME='USERNAME' \\\n  -e UFP_PASSWORD='PASSWORD' \\\n  -e UFP_ADDRESS='UNIFI_PROTECT_IP' \\\n  -e UFP_SSL_VERIFY='false' \\\n  -e RCLONE_DESTINATION='my_remote:/unifi_protect_backup' \\\n  -v '/path/to/save/clips':'/data' \\\n  -v `/path/to/rclone.conf':'/config/rclone/rclone.conf' \\\n  -v '/path/to/save/database':/config/database/ \\\n  ghcr.io/ep1cman/unifi-protect-backup\n```\n\n### Debugging\n\nIf you need to debug your rclone setup, you can invoke rclone directly like so:\n\n```\ndocker run \\\n    --rm \\\n    -v /path/to/rclone.conf:/config/rclone/rclone.conf \\\n    -e RCLONE_CONFIG='/config/rclone/rclone.conf' \\\n    --entrypoint rclone \\\n    ghcr.io/ep1cman/unifi-protect-backup \\\n    {rclone subcommand as per: https://rclone.org/docs/#subcommands}\n```\n\nFor example to check that your config file is being read properly and list the configured remotes:\n```\ndocker run \\\n    --rm \\\n    -v /path/to/rclone.conf:/config/rclone/rclone.conf \\\n    -e RCLONE_CONFIG='/config/rclone/rclone.conf' \\\n    --entrypoint rclone \\\n    ghcr.io/ep1cman/unifi-protect-backup \\\n    listremotes\n```\n\n## Credits\n\n- Heavily utilises [`pyunifiprotect`](https://github.com/briis/pyunifiprotect) by [@briis](https://github.com/briis/)\n- All the cloud functionality is provided by [`rclone`](https://rclone.org/)\n- This package was created with [Cookiecutter](https://github.com/audreyr/cookiecutter) and the [waynerv/cookiecutter-pypackage](https://github.com/waynerv/cookiecutter-pypackage) project template.\n",
    'author': 'sebastian.goscik',
    'author_email': 'sebastian@goscik.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ep1cman/unifi-protect-backup',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.9.0,<4.0',
}


setup(**setup_kwargs)
